/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.pm.vmi;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class VMISettleQtyInspectPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(VMISettleQtyInspectPlugin.class);
    private static final String ENTITY_TRANSFERBILL = "pm_transferbill";
    private static final String ENTITY_PURINBILL = "im_purinbill";

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "isintertransaction", "srcbillform", "billentry.id", "billentry.baseqty", "billentry.joinbaseqty", "billentry.settlestatus");
    }

    @Override
    public void beginInspectOperation(InspectOptionInfo inspectOptionInfo) {
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBizDataType(2);
            inspectOptionInfo.setBillEntrySympol(null);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet dataSet) {
        Set<Long> transferBillIds;
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
        Map<String, Map<Long, TransferBillInfo>> groupBySrcBillForm = this.groupBySrcForm(dataSet);
        if (CommonUtils.isNull(groupBySrcBillForm)) {
            return errorInfos;
        }
        Map<String, BillInfo> billInfoMap = this.buildBillInfo(groupBySrcBillForm.keySet());
        BillInfo transferBillMetaInfo = this.getBillInfo(ENTITY_TRANSFERBILL, "billentry");
        if (transferBillMetaInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"VMISettleQtyInspectPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        }
        BillInfo purInMetaInfo = this.getBillInfo(ENTITY_PURINBILL, "billentry");
        List transferTargetBFRows = null;
        if (purInMetaInfo != null && !(transferBillIds = this.getTransferBillIds(groupBySrcBillForm)).isEmpty()) {
            transferTargetBFRows = BFTrackerServiceHelper.loadTargetRowIds((String)ENTITY_TRANSFERBILL, (Long[])transferBillIds.toArray(new Long[0]), (OperateOption)this.getBFTrackerOperateOption());
            errorInfos.addAll(this.checkTargetPurInVirBillQty(groupBySrcBillForm, purInMetaInfo, transferBillMetaInfo, transferTargetBFRows));
        }
        for (Map.Entry<String, Map<Long, TransferBillInfo>> entry : groupBySrcBillForm.entrySet()) {
            String srcEntityNo = entry.getKey();
            Map<Long, TransferBillInfo> pmBillData = entry.getValue();
            BillInfo invBillMetaInfo = billInfoMap.get(srcEntityNo);
            if (StringUtils.isEmpty((String)srcEntityNo) || pmBillData == null || invBillMetaInfo == null) continue;
            errorInfos.addAll(this.checkSrcBillQty(pmBillData, invBillMetaInfo, transferBillMetaInfo));
            errorInfos.addAll(this.checkTargetInvVirBillQty(pmBillData, invBillMetaInfo, transferBillMetaInfo, transferTargetBFRows));
        }
        return errorInfos;
    }

    private Set<Long> getTransferBillIds(Map<String, Map<Long, TransferBillInfo>> groupBySrcBillForm) {
        HashSet<Long> transferBillIds = new HashSet<Long>(10);
        for (Map<Long, TransferBillInfo> entry : groupBySrcBillForm.values()) {
            entry.values().forEach(info -> {
                if ("C".equals(info.getSettleStatus())) {
                    transferBillIds.add(info.getId());
                }
            });
        }
        return transferBillIds;
    }

    private List<OperateErrorInfo> checkSrcBillQty(Map<Long, TransferBillInfo> transferBillInfos, BillInfo srcBillInfo, BillInfo transferBillMetaInfo) {
        HashMap<Long, Long> entryIdAndIdMap = new HashMap<Long, Long>(transferBillInfos.size());
        transferBillInfos.values().forEach(info -> entryIdAndIdMap.put(info.getEntryId(), info.getId()));
        if (entryIdAndIdMap.isEmpty() || srcBillInfo == null || transferBillMetaInfo == null) {
            return new ArrayList<OperateErrorInfo>(10);
        }
        Long srcTableId = srcBillInfo.getTableId();
        Long pmTableId = transferBillMetaInfo.getTableId();
        Set<Long> srcBillIds = this.getSrcBillIds(entryIdAndIdMap, srcBillInfo, transferBillMetaInfo);
        Map<Long, Set<Long>> srcEntryIdAndTarEntryIdMap = this.getEntryMapping(srcTableId, pmTableId, srcBillInfo.getEntityNo(), srcBillIds.toArray(new Long[0]), null);
        Map<Long, BigDecimal> srcBaseQtyMap = this.getBillBaseQty(srcBillInfo.getEntityNo(), srcEntryIdAndTarEntryIdMap.keySet().toArray(new Long[0]));
        Map<Long, BigDecimal> transferBaseQtyMap = this.getTargetBillQty(ENTITY_TRANSFERBILL, srcEntryIdAndTarEntryIdMap);
        Set<Long> errorTransferEntryIds = this.compareBillBaseQty(srcBaseQtyMap, transferBaseQtyMap, srcEntryIdAndTarEntryIdMap, false);
        List<OperateErrorInfo> errorInfos = this.buildErrorInfo(errorTransferEntryIds, transferBillInfos, ResManager.loadKDString((String)"\u7269\u6743\u8f6c\u79fb\u5355\u7f16\u53f7\u4e3a\u3010%1$s\u3011\u7684\u6570\u91cf\u4e0e\u4e0a\u6e38\u6d88\u8017\u5355\u636e\u6570\u91cf\u4e0d\u76f8\u7b49\u3002", (String)"VMISettleQtyInspectPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        return errorInfos;
    }

    private List<OperateErrorInfo> checkTargetInvVirBillQty(Map<Long, TransferBillInfo> pmBillData, BillInfo invBillMetaInfo, BillInfo transferBillMetaInfo, List<BFRow> transferTargetBFRows) {
        HashSet transferBillIds = new HashSet(10);
        HashMap<Long, BigDecimal> tansferEntryidAndSettledQtyMap = new HashMap<Long, BigDecimal>(10);
        pmBillData.values().forEach(info -> {
            if (!info.isInnerDeal() && !"A".equals(info.getSettleStatus())) {
                transferBillIds.add(info.getId());
                tansferEntryidAndSettledQtyMap.put(info.getEntryId(), info.getSettledBaseQty());
            }
        });
        if (transferBillIds.isEmpty()) {
            return new ArrayList<OperateErrorInfo>(10);
        }
        Map<Long, Set<Long>> entryMapping = this.getEntryMapping(transferBillMetaInfo.getTableId(), invBillMetaInfo.getTableId(), invBillMetaInfo.getEntityNo(), transferBillIds.toArray(new Long[0]), transferTargetBFRows);
        Map<Long, BigDecimal> invBillQty = this.getTargetBillQty(invBillMetaInfo.getEntityNo(), entryMapping);
        Set<Long> errorTransferEntryIds = this.compareBillBaseQty(tansferEntryidAndSettledQtyMap, invBillQty, entryMapping, true);
        List<OperateErrorInfo> errorInfos = this.buildErrorInfo(errorTransferEntryIds, pmBillData, ResManager.loadKDString((String)"\u7269\u6743\u8f6c\u79fb\u5355\u7f16\u53f7\u4e3a\u3010%1$s\u3011\u7684\u6570\u91cf\u4e0e\u5e93\u5b58\u865a\u5355\u5355\u636e\u6570\u91cf\u4e0d\u76f8\u7b49\u3002", (String)"VMISettleQtyInspectPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        return errorInfos;
    }

    private List<OperateErrorInfo> checkTargetPurInVirBillQty(Map<String, Map<Long, TransferBillInfo>> allTransferInfo, BillInfo purInMetaInfo, BillInfo transferBillMetaInfo, List<BFRow> transferTargetBFRows) {
        HashMap<Long, BigDecimal> tansferEntryidAndSettledQtyMap = new HashMap<Long, BigDecimal>(10);
        HashMap<Long, TransferBillInfo> pmBillInfos = new HashMap<Long, TransferBillInfo>(10);
        HashSet transferBillIds = new HashSet(10);
        for (Map<Long, TransferBillInfo> entry : allTransferInfo.values()) {
            pmBillInfos.putAll(entry);
            entry.values().forEach(info -> {
                if ("C".equals(info.getSettleStatus())) {
                    transferBillIds.add(info.getId());
                    tansferEntryidAndSettledQtyMap.put(info.getEntryId(), info.getSettledBaseQty());
                }
            });
        }
        Map<Long, Set<Long>> entryMapping = this.getEntryMapping(transferBillMetaInfo.getTableId(), purInMetaInfo.getTableId(), purInMetaInfo.getEntityNo(), transferBillIds.toArray(new Long[0]), transferTargetBFRows);
        Map<Long, BigDecimal> purInBillQty = this.getTargetBillQty(purInMetaInfo.getEntityNo(), entryMapping);
        Set<Long> errorTransferEntryIds = this.compareBillBaseQty(tansferEntryidAndSettledQtyMap, purInBillQty, entryMapping, true);
        List<OperateErrorInfo> errorInfos = this.buildErrorInfo(errorTransferEntryIds, pmBillInfos, ResManager.loadKDString((String)"\u7269\u6743\u8f6c\u79fb\u5355\u7f16\u53f7\u4e3a\u3010%1$s\u3011\u7684\u6570\u91cf\u4e0e\u5165\u5e93\u865a\u5355\u5355\u636e\u6570\u91cf\u4e0d\u76f8\u7b49\u3002", (String)"VMISettleQtyInspectPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        return errorInfos;
    }

    private List<OperateErrorInfo> buildErrorInfo(Set<Long> errorTransferEntryIds, Map<Long, TransferBillInfo> transferBillInfo, String msg) {
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>(10);
        if (errorTransferEntryIds != null && !errorTransferEntryIds.isEmpty()) {
            HashMap errorIdAndNo = new HashMap(10);
            errorTransferEntryIds.forEach(entryId -> {
                TransferBillInfo billInfo = (TransferBillInfo)transferBillInfo.get(entryId);
                if (billInfo != null) {
                    errorIdAndNo.put(billInfo.getId(), billInfo.getBillNo());
                }
            });
            for (Map.Entry entry : errorIdAndNo.entrySet()) {
                Long id = (Long)entry.getKey();
                String billNo = (String)entry.getValue();
                errorInfos.add(this.getExpMsg(this.getClass().getName(), String.format(msg, billNo), id, id, billNo));
            }
        }
        return errorInfos;
    }

    private Map<Long, Set<Long>> getEntryMapping(Long srcTableId, Long pmTableId, String entityNo, Long[] ids, List<BFRow> bfRows) {
        HashMap<Long, Set<Long>> srcEntryIdAndTarEntryIdMap = new HashMap<Long, Set<Long>>(10);
        if (bfRows == null) {
            bfRows = BFTrackerServiceHelper.loadTargetRowIds((String)entityNo, (Long[])ids, (OperateOption)this.getBFTrackerOperateOption());
        }
        for (BFRow row : bfRows) {
            BFRowId id = row.getId();
            BFRowId sId = row.getSId();
            Long tTableId = id.getTableId();
            Long sTableId = sId.getTableId();
            Long sEntryId = sId.getEntryId();
            Long tEntryId = id.getEntryId();
            if (srcTableId.compareTo(sTableId) != 0 || tTableId.compareTo(pmTableId) != 0) continue;
            srcEntryIdAndTarEntryIdMap.computeIfAbsent(sEntryId, k -> new HashSet()).add(tEntryId);
        }
        return srcEntryIdAndTarEntryIdMap;
    }

    private Set<Long> compareBillBaseQty(Map<Long, BigDecimal> srcBaseQtyMap, Map<Long, BigDecimal> tarEntryQtyMap, Map<Long, Set<Long>> srcEntryIdAndTarEntryIdMap, boolean srcIsTransferBill) {
        HashSet<Long> errorEntryIds = new HashSet<Long>(10);
        for (Map.Entry<Long, Set<Long>> entry : srcEntryIdAndTarEntryIdMap.entrySet()) {
            Long srcEntryId = entry.getKey();
            Set<Long> tarEntryIds = entry.getValue();
            BigDecimal srcBaseQty = srcBaseQtyMap.get(srcEntryId) == null ? BigDecimal.ZERO : srcBaseQtyMap.get(srcEntryId);
            BigDecimal targetSumQty = BigDecimal.ZERO;
            if (tarEntryIds != null && !tarEntryIds.isEmpty()) {
                for (Long tarEntryId : tarEntryIds) {
                    BigDecimal targetBaseQty = tarEntryQtyMap.get(tarEntryId);
                    if (targetBaseQty == null) continue;
                    targetSumQty = targetSumQty.add(targetBaseQty);
                }
            }
            if (tarEntryIds == null || srcBaseQty.compareTo(targetSumQty) == 0) continue;
            if (srcIsTransferBill) {
                errorEntryIds.add(srcEntryId);
                continue;
            }
            errorEntryIds.addAll(tarEntryIds);
        }
        return errorEntryIds;
    }

    private Map<Long, BigDecimal> getTargetBillQty(String entityNo, Map<Long, Set<Long>> srcEntryIdAndTarEntryIdMap) {
        if (srcEntryIdAndTarEntryIdMap == null || srcEntryIdAndTarEntryIdMap.isEmpty()) {
            return new HashMap<Long, BigDecimal>(10);
        }
        ArrayList entryIds = new ArrayList(srcEntryIdAndTarEntryIdMap.size());
        srcEntryIdAndTarEntryIdMap.values().forEach(ids -> {
            if (ids != null && !ids.isEmpty()) {
                entryIds.addAll(ids);
            }
        });
        return this.getBillBaseQty(entityNo, entryIds.toArray(new Long[0]));
    }

    private Map<Long, BigDecimal> getBillBaseQty(String entity, Long[] entryIds) {
        if (entity == null || entryIds == null || entryIds.length < 1) {
            return new HashMap<Long, BigDecimal>(10);
        }
        HashMap<Long, BigDecimal> baseQtyMap = new HashMap<Long, BigDecimal>(entryIds.length);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)"billentry.id,billentry.baseqty", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", (Object)entryIds)}, null);){
            dataSet.forEach(row -> baseQtyMap.put(row.getLong("billentry.id"), row.getBigDecimal("billentry.baseqty")));
        }
        return baseQtyMap;
    }

    private Set<Long> getSrcBillIds(Map<Long, Long> entryIdAndIdMap, BillInfo billInfo, BillInfo transferBillMetaInfo) {
        HashSet<Long> srcBillIds = new HashSet<Long>(10);
        List bfRows = BFTrackerServiceHelper.loadSourceRowIds((String)transferBillMetaInfo.getEntityNo(), (String)"billentry", (Long[])entryIdAndIdMap.values().toArray(new Long[0]), (Long[])entryIdAndIdMap.keySet().toArray(new Long[0]), (OperateOption)this.getBFTrackerOperateOption());
        Long srcTableId = billInfo.getTableId();
        bfRows.forEach(row -> {
            BFRowId sId = row.getSId();
            Long tableId = sId.getTableId();
            if (tableId != null && srcTableId != null && tableId.compareTo(srcTableId) == 0) {
                srcBillIds.add(sId.getBillId());
            }
        });
        return srcBillIds;
    }

    private Map<String, Map<Long, TransferBillInfo>> groupBySrcForm(DataSet dataSet) {
        HashMap<String, Map<Long, TransferBillInfo>> groupBySrcBillForm = new HashMap<String, Map<Long, TransferBillInfo>>(10);
        for (Row row : dataSet) {
            String srcbillform = row.getString("srcbillform");
            if (StringUtils.isEmpty((String)srcbillform)) continue;
            HashMap<Long, TransferBillInfo> transerBillInfos = (HashMap<Long, TransferBillInfo>)groupBySrcBillForm.get(srcbillform);
            if (transerBillInfos == null) {
                transerBillInfos = new HashMap<Long, TransferBillInfo>(10);
            }
            Boolean isinnerdeal = row.getBoolean("isintertransaction");
            String billNo = row.getString("billno");
            String settleStatus = row.getString("billentry.settlestatus");
            Long id = row.getLong("id");
            Long entryId = row.getLong("billentry.id");
            BigDecimal baseQty = row.getBigDecimal("billentry.baseqty");
            BigDecimal settledBaseQty = row.getBigDecimal("billentry.joinbaseqty");
            boolean isInnerFlag = isinnerdeal == null ? false : isinnerdeal;
            transerBillInfos.put(entryId, new TransferBillInfo(id, entryId, billNo, isInnerFlag, baseQty, settledBaseQty, settleStatus));
            groupBySrcBillForm.put(srcbillform, transerBillInfos);
        }
        return groupBySrcBillForm;
    }

    private Map<String, BillInfo> buildBillInfo(Set<String> srcEntityNos) {
        if (srcEntityNos == null || srcEntityNos.isEmpty()) {
            return new HashMap<String, BillInfo>(5);
        }
        HashMap<String, BillInfo> result = new HashMap<String, BillInfo>(5);
        ArrayList<String> entitys = new ArrayList<String>(srcEntityNos);
        for (String srcEntityNo : entitys) {
            BillInfo billInfo = this.getBillInfo(srcEntityNo, "billentry");
            if (billInfo == null) continue;
            result.put(srcEntityNo, billInfo);
        }
        return result;
    }

    private BillInfo getBillInfo(String entity, String entryEntity) {
        if (StringUtils.isEmpty((String)entity) || StringUtils.isEmpty((String)entryEntity)) {
            return null;
        }
        TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((String)entity, (String)entryEntity);
        if (tableDefine == null) {
            return null;
        }
        Long tableId = tableDefine.getTableId();
        return new BillInfo(tableId, entity);
    }

    private OperateOption getBFTrackerOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("botp_track_only_dirt_link", Boolean.TRUE.toString());
        return option;
    }

    static class BillInfo {
        private Long tableId;
        private String entityNo;

        public BillInfo(Long tableId, String entityNo) {
            this.tableId = tableId;
            this.entityNo = entityNo;
        }

        public Long getTableId() {
            return this.tableId;
        }

        public String getEntityNo() {
            return this.entityNo;
        }
    }

    static class TransferBillInfo {
        private Long id;
        private Long entryId;
        private String billNo;
        private String settleStatus;
        private boolean isInnerDeal;
        private BigDecimal baseQty;
        private BigDecimal settledBaseQty;

        public TransferBillInfo(Long id, Long entryId, String billNo, boolean isInnerDeal, BigDecimal baseQty, BigDecimal settledBaseQty, String settleStatus) {
            this.id = id;
            this.entryId = entryId;
            this.billNo = billNo;
            this.isInnerDeal = isInnerDeal;
            this.baseQty = baseQty;
            this.settledBaseQty = settledBaseQty;
            this.settleStatus = settleStatus;
        }

        public Long getId() {
            return this.id;
        }

        public Long getEntryId() {
            return this.entryId;
        }

        public void setEntryId(Long entryId) {
            this.entryId = entryId;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public void setBillNo(String billNo) {
            this.billNo = billNo;
        }

        public boolean isInnerDeal() {
            return this.isInnerDeal;
        }

        public BigDecimal getBaseQty() {
            return this.baseQty;
        }

        public void setBaseQty(BigDecimal baseQty) {
            this.baseQty = baseQty;
        }

        public BigDecimal getSettledBaseQty() {
            return this.settledBaseQty;
        }

        public String getSettleStatus() {
            return this.settleStatus;
        }
    }
}

