/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.sm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class SalMaterialKitInfoCheckPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(SalMaterialKitInfoCheckPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "masterid", "masterid.number", "masterid.suite", "status", "pricemodel", "kittransfermodel", "kitreturnmodel", "kitstructctl");
    }

    @Override
    public void onPrepareInspectUnitQFilter(List<QFilter> inspectUnitQFilter) {
        inspectUnitQFilter.add(new QFilter("status", "!=", (Object)"A"));
    }

    @Override
    public void beginInspectOperation(InspectOptionInfo inspectOptionInfo) {
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>();
        for (Row row : args) {
            String materialNumber = row.getString("masterid.number");
            Boolean isSuite = row.getBoolean("masterid.suite");
            String priceModel = row.getString("pricemodel");
            String kitTransferModel = row.getString("kittransfermodel");
            String kitReturnModel = row.getString("kitreturnmodel");
            String kitStructCtl = row.getString("kitstructctl");
            if ((!isSuite.booleanValue() || !StringUtils.isBlank((CharSequence)priceModel) && !StringUtils.isBlank((CharSequence)kitTransferModel) && !StringUtils.isBlank((CharSequence)kitReturnModel) && !StringUtils.isBlank((CharSequence)kitStructCtl)) && (isSuite.booleanValue() || !StringUtils.isNotBlank((CharSequence)priceModel) && !StringUtils.isNotBlank((CharSequence)kitTransferModel) && !StringUtils.isNotBlank((CharSequence)kitReturnModel) && !StringUtils.isNotBlank((CharSequence)kitStructCtl))) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u7269\u6599\u4e3b\u6570\u636e\u201c\u5957\u4ef6\u201d\u53c2\u6570\uff0c\u4e0e\u7269\u6599\u9500\u552e\u4fe1\u606f\u201c\u5b9a\u4ef7\u65b9\u5f0f\u3001\u5957\u4ef6\u53d1\u8d27\u65b9\u5f0f\u3001\u5957\u4ef6\u9000\u8d27\u65b9\u5f0f\u3001\u5355\u636e\u5957\u4ef6\u7ed3\u6784\u63a7\u5236\u201d\u8bbe\u7f6e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u60a8\u6838\u5b9e\u3002", (String)"SalMaterialKitInfoCheckPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), materialNumber);
            errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), null, materialNumber));
        }
        return errorInfo;
    }
}

