/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.sm;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.business.helper.MaterialHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.FixedDataInfo;

public class SalOrderConfirmAmountPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(SalOrderConfirmAmountPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "billentry.id", "billentry.seq", "billentry.material", "billentry.unit", "billentry.baseunit", "billentry.confirmqty", "billentry.confirmbaseqty", "billentry.confirmamount");
        this.getInspectOptionInfo().setBizDataType(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet saleOrderBill) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(16);
        try {
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
            QFilter corebilltypeFilter = new QFilter("entry.e_corebilltype", "=", (Object)"sm_salorder");
            DataSet revcfmbill = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ar_revcfmbill", (String)"entry.e_corebillid as corebillid ,entry.e_corebillentryid as corebillentryid ,entry.e_confirmqty as confirmqty,entry.e_confirmamt as confirmamt ", (QFilter[])new QFilter[]{statusFilter, corebilltypeFilter}, null);
            revcfmbill = revcfmbill.groupBy(new String[]{"corebillid", "corebillentryid"}).sum("confirmamt").finish();
            saleOrderBill = saleOrderBill.join(revcfmbill, JoinType.INNER).on("id", "corebillid").on("billentry.id", "corebillentryid").select(new String[]{"id", "billno", "billentry.id as entryid", "billentry.seq as seq", "billentry.confirmamount as confirmamount", "confirmamt"}).finish().where("confirmamount!=confirmamt");
            for (Row row : saleOrderBill) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u7d2f\u8ba1\u786e\u8ba4\u91d1\u989d\u548c\u6536\u5165\u786e\u8ba4\u5355\u7d2f\u8ba1\u786e\u8ba4\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"salOrderConfirmAmountPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), row.get("billno"), row.get("seq"));
                errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.get("id"), row.get("entryid"), (String)row.get("billno")));
            }
        }
        finally {
            saleOrderBill.close();
        }
        return errorInfo;
    }

    @Override
    public String fixedBizData(DynamicObject[] bizData) {
        String resultStr;
        if (bizData == null || bizData.length == 0) {
            return null;
        }
        FixedDataInfo fixedDataInfo = new FixedDataInfo(RequestContext.get().getCurrUserId(), FORMATTER.format(LocalDateTime.now()));
        ArrayList<FixedDataInfo> fixedDataInfoList = new ArrayList<FixedDataInfo>(16);
        HashMap<Object, DynamicObject> salOrderEntrymap = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject bill : Arrays.asList(bizData)) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                salOrderEntrymap.put(entry.getPkValue(), entry);
            }
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter corebilltypeFilter = new QFilter("entry.e_corebilltype", "=", (Object)"sm_salorder");
        QFilter idFilter = new QFilter("entry.e_corebillentryid", "in", salOrderEntrymap.keySet());
        try {
            DynamicObject[] revcfmbills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"entry.e_corebillid, entry.e_corebillno,entry.e_corebillentryid,entry.e_material,entry.e_measureunit ,entry.e_confirmqty,entry.e_confirmamt ", (QFilter[])new QFilter[]{statusFilter, corebilltypeFilter, idFilter}, null);
            HashMap revcfmMap = new HashMap(16);
            for (DynamicObject revcfmbill : revcfmbills) {
                DynamicObjectCollection entrys = revcfmbill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entrys) {
                    List<HashMap<String, Object>> revcfmList;
                    Long entryId = entry.getLong("e_corebillentryid");
                    if (!salOrderEntrymap.containsKey(entryId)) continue;
                    HashMap<String, Object> revcfm = new HashMap<String, Object>(16);
                    revcfm.put("corebillid", entry.getLong("e_corebillid"));
                    revcfm.put("corebillno", entry.getString("e_corebillno"));
                    revcfm.put("measureunit", entry.getDynamicObject("e_measureunit"));
                    revcfm.put("confirmqty", entry.getBigDecimal("e_confirmqty"));
                    revcfm.put("confirmamt", entry.getBigDecimal("e_confirmamt"));
                    revcfm.put("material", entry.getDynamicObject("e_material"));
                    if (revcfmMap.get(entryId) != null) {
                        revcfmList = (List)revcfmMap.get(entry.getLong("e_corebillentryid"));
                        revcfmList.add(revcfm);
                    } else {
                        revcfmList = new ArrayList<HashMap<String, Object>>(8);
                        revcfmList.add(revcfm);
                        revcfmMap.put(entryId, revcfmList);
                    }
                    logger.info("1:" + revcfm);
                }
            }
            for (Map.Entry row : revcfmMap.entrySet()) {
                DynamicObject entry = (DynamicObject)salOrderEntrymap.get(row.getKey());
                if (entry == null) continue;
                boolean isUnitSame = true;
                Long corebillid = (Long)((Map)((List)row.getValue()).get(0)).get("corebillid");
                String corebillno = (String)((Map)((List)row.getValue()).get(0)).get("corebillno");
                BigDecimal qty = new BigDecimal(0);
                BigDecimal baseQty = new BigDecimal(0);
                BigDecimal amount = new BigDecimal(0);
                Long materialId = (Long)entry.getDynamicObject("material").getDynamicObject("masterid").getPkValue();
                Long unit = 0L;
                for (Iterator map2 : (List)row.getValue()) {
                    DynamicObject revcfmUnit = (DynamicObject)map2.get("measureunit");
                    if (unit.equals(0L)) {
                        unit = (Long)revcfmUnit.getPkValue();
                    } else if (!unit.equals(revcfmUnit.getPkValue())) {
                        isUnitSame = false;
                    }
                    logger.info("2:" + (BigDecimal)map2.get("confirmamt"));
                    amount = amount.add((BigDecimal)map2.get("confirmamt"));
                }
                logger.info("3:" + amount);
                if (isUnitSame) {
                    Map map;
                    Iterator map2;
                    Object muConv = null;
                    if (unit.equals(entry.getDynamicObject("unit").getPkValue())) {
                        logger.info("4:");
                        muConv = MaterialHelper.getMUConv((Long)materialId, (DynamicObject)entry.getDynamicObject("unit"), (DynamicObject)entry.getDynamicObject("baseunit"), (boolean)true);
                        map2 = ((List)row.getValue()).iterator();
                        while (map2.hasNext()) {
                            map = (Map)map2.next();
                            qty = qty.add((BigDecimal)map.get("confirmqty"));
                            logger.info("4:" + qty);
                        }
                        baseQty = qty.multiply((BigDecimal)muConv);
                        logger.info("4.1:" + baseQty);
                    } else {
                        logger.info("5:");
                        map2 = ((List)row.getValue()).iterator();
                        while (map2.hasNext()) {
                            map = (Map)map2.next();
                            if (muConv == null) {
                                muConv = MaterialHelper.getMUConv((Long)materialId, (DynamicObject)((DynamicObject)map.get("measureunit")), (DynamicObject)entry.getDynamicObject("baseunit"), (boolean)true);
                            }
                            baseQty = baseQty.add(((BigDecimal)map.get("confirmqty")).multiply((BigDecimal)muConv));
                            logger.info("5:" + baseQty);
                        }
                        muConv = MaterialHelper.getMUConv((Long)materialId, (DynamicObject)entry.getDynamicObject("baseunit"), (DynamicObject)entry.getDynamicObject("unit"), (boolean)true);
                        qty = baseQty.multiply((BigDecimal)muConv);
                        logger.info("5.1:" + qty);
                    }
                } else {
                    logger.info("6:");
                    for (Iterator map2 : (List)row.getValue()) {
                        BigDecimal muConv = MaterialHelper.getMUConv((Long)materialId, (DynamicObject)((DynamicObject)map2.get("measureunit")), (DynamicObject)entry.getDynamicObject("baseunit"), (boolean)true);
                        baseQty = baseQty.add(((BigDecimal)map2.get("confirmqty")).multiply(muConv));
                        logger.info("6:" + baseQty);
                    }
                    BigDecimal salMuConv = MaterialHelper.getMUConv((Long)materialId, (DynamicObject)entry.getDynamicObject("baseunit"), (DynamicObject)entry.getDynamicObject("unit"), (boolean)true);
                    qty = baseQty.multiply(salMuConv);
                    logger.info("6.1:" + qty);
                }
                String entryStr = "seq:" + entry.get("seq") + " | entryId: " + entry.getPkValue() + " | before_qty:" + entry.get("confirmqty") + " |after_qty:" + qty + " |before_amount:" + entry.get("confirmamount") + " |after_amount:" + amount;
                logger.info(entryStr);
                entry.set("confirmbaseqty", (Object)baseQty);
                entry.set("confirmqty", (Object)qty);
                entry.set("confirmamount", (Object)amount);
                fixedDataInfoList.add(new FixedDataInfo(corebillid, corebillno, entryStr));
            }
            fixedDataInfo.setFixedDataInfoList(fixedDataInfoList);
            ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>(200);
            for (int i = 0; i < bizData.length; ++i) {
                datas.add(bizData[i]);
                if (datas.size() != 200) continue;
                SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
                datas.clear();
                Thread.sleep(1000L);
            }
            if (datas.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])bizData);
            }
            resultStr = SerializationUtils.toJsonString((Object)fixedDataInfo);
        }
        catch (Throwable e) {
            resultStr = e.toString() + ":" + Arrays.toString(e.getStackTrace());
            logger.error(fixedDataInfo.toString());
        }
        return resultStr;
    }
}

