/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.sm;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class SalOrderExchangeRatePlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(SalOrderExchangeRatePlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "currency", "settlecurrency", "exchangerate", "billentry.id", "billentry.seq", "billentry.amount", "billentry.curamount", "billentry.taxamount", "billentry.curtaxamount", "billentry.amountandtax", "billentry.curamountandtax");
    }

    @Override
    public void beginInspectOperation(InspectOptionInfo inspectOptionInfo) {
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>();
        for (Row row : args) {
            BigDecimal curAmountAndTax;
            BigDecimal multiplyAmountAndTax;
            BigDecimal amountAndTax;
            BigDecimal curTaxAmount;
            BigDecimal taxAmount;
            BigDecimal curAmount;
            String billNo = row.getString("billno");
            Long currency = row.getLong("currency");
            Long settleCurrency = row.getLong("settlecurrency");
            if (currency == 0L || !settleCurrency.equals(currency)) continue;
            BigDecimal exchangeRate = row.getBigDecimal("exchangerate");
            if (BigDecimal.ZERO.compareTo(exchangeRate) == 0 || BigDecimal.ONE.compareTo(exchangeRate) != 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"PurOrderExchangeRatePlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, ResManager.loadKDString((String)"\u6c47\u7387\u6570\u636e\u5f02\u5e38\u3002", (String)"PurOrderExchangeRatePlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong("id"), billNo));
                continue;
            }
            BigDecimal amount = row.getBigDecimal("billentry.amount");
            if (amount == null) continue;
            BigDecimal multiplyAmount = amount.multiply(exchangeRate);
            if (multiplyAmount.compareTo(curAmount = row.getBigDecimal("billentry.curamount")) != 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5355\u636e\u4f53\u884c\u53f7\uff1a%2$s\u91d1\u989d\u5230\u91d1\u989d\u672c\u4f4d\u5e01\u5b58\u5728\u6c47\u7387\u5f02\u5e38\u3002", (String)"PurOrderExchangeRatePlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("billentry.seq"));
                errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong("billentry.id"), billNo));
            }
            if ((taxAmount = row.getBigDecimal("billentry.taxamount")) == null) continue;
            BigDecimal multiplyTaxAmount = taxAmount.multiply(exchangeRate);
            if (multiplyTaxAmount.compareTo(curTaxAmount = row.getBigDecimal("billentry.curtaxamount")) != 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5355\u636e\u4f53\u884c\u53f7\uff1a%2$s\u7a0e\u989d\u5230\u7a0e\u989d\u672c\u4f4d\u5e01\u5b58\u5728\u6c47\u7387\u5f02\u5e38\u3002", (String)"PurOrderExchangeRatePlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("billentry.seq"));
                errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong("billentry.id"), billNo));
            }
            if ((amountAndTax = row.getBigDecimal("billentry.amountandtax")) == null || (multiplyAmountAndTax = amountAndTax.multiply(exchangeRate)).compareTo(curAmountAndTax = row.getBigDecimal("billentry.curamountandtax")) == 0) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5355\u636e\u4f53\u884c\u53f7\uff1a%2$s\u4ef7\u7a0e\u5408\u8ba1\u5230\u4ef7\u7a0e\u5408\u8ba1\u672c\u4f4d\u5e01\u5b58\u5728\u6c47\u7387\u5f02\u5e38\u3002", (String)"PurOrderExchangeRatePlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("billentry.seq"));
            errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, row.getLong("id"), row.getLong("billentry.id"), billNo));
        }
        return errorInfo;
    }
}

