/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.sm;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.inspect.common.ArWriteBackScmcHelper;

public class SalOrderHeadRecAmountPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(SalOrderHeadRecAmountPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "customer", "customer.internal_company internal_company", "prereceiptamount", "receiptamount", "billentry.id entryid", "billentry.seq entryseq", "billentry.entrysettleorg entrysettleorg", "recplanentry.id planentryid", "recplanentry.seq planentryseq", "recplanentry.r_recsettleorg plansettleorg");
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        List<OperateErrorInfo> errorInfo;
        try {
            HashMap<Long, Map<String, Object>> salOrderBillHeadDataMap = new HashMap<Long, Map<String, Object>>(16);
            List<Map<String, Object>> wbResult = this.getWbData(args, salOrderBillHeadDataMap);
            logger.info("\u9500\u552e\u8ba2\u5355\u7684\u53cd\u5199\u5b57\u6bb5\u7684\u503c\u96c6\u5408salOrderBillHeadDataMap:" + salOrderBillHeadDataMap);
            errorInfo = this.checkErrorData(wbResult, salOrderBillHeadDataMap);
        }
        catch (Exception e) {
            String expMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
            logger.error("\u51fa\u73b0\u4e86\u5f02\u5e38:{}", (Object)expMsg);
            throw new KDBizException(expMsg);
        }
        return errorInfo;
    }

    @Override
    public List<FixLogInfo> fixMainDataSet(DataSet args) {
        HashMap<Long, Map<String, Object>> salOrderBillHeadDataMap = new HashMap<Long, Map<String, Object>>(16);
        List<Map<String, Object>> wbResult = this.getWbData(args, salOrderBillHeadDataMap);
        logger.info("\u9500\u552e\u8ba2\u5355\u7684\u53cd\u5199\u5b57\u6bb5\u7684\u503c\u96c6\u5408salOrderBillHeadDataMap:" + salOrderBillHeadDataMap);
        List<FixLogInfo> expMsg = this.fixBizDataBySql(wbResult, salOrderBillHeadDataMap);
        return expMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getWbData(DataSet args, Map<Long, Map<String, Object>> salOrderBillHeadDataMap) {
        DataSet entryDataSet = null;
        DataSet planDataSet = null;
        try {
            Long company;
            boolean internal_company;
            HashMap<String, Constable> param;
            entryDataSet = args.copy().select(new String[]{"id", "billno", "customer", "internal_company", "prereceiptamount", "receiptamount", "entryid", "entryseq", "entrysettleorg"}).distinct();
            planDataSet = args.select(new String[]{"id", "billno", "customer", "internal_company", "prereceiptamount", "receiptamount", "planentryid", "planentryseq", "plansettleorg"}).distinct();
            ArrayList<Map<String, Object>> planParamList = new ArrayList<Map<String, Object>>(16);
            ArrayList<Map<String, Object>> entryParamList = new ArrayList<Map<String, Object>>(16);
            if (args == null) {
                ArrayList<Map<String, Object>> arrayList = planParamList;
                return arrayList;
            }
            for (Row row : planDataSet) {
                param = new HashMap<String, Constable>(16);
                param.put("mainbillid", row.getLong("id"));
                param.put("asstid", row.getLong("customer"));
                internal_company = false;
                company = row.getLong("internal_company");
                if (company != null && company != 0L) {
                    internal_company = true;
                }
                param.put("internal_company", Boolean.valueOf(internal_company));
                param.put("mainbillentryid", row.getLong("planentryid"));
                param.put("settleorgid", row.getLong("plansettleorg"));
                planParamList.add(param);
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("billno", row.getString("billno"));
                map.put("id", row.getLong("id"));
                map.put("preRecAmount", row.getBigDecimal("prereceiptamount"));
                map.put("recAmount", row.getBigDecimal("receiptamount"));
                if (salOrderBillHeadDataMap.get(row.getLong("id")) != null) continue;
                salOrderBillHeadDataMap.put(row.getLong("id"), map);
            }
            for (Row row : entryDataSet) {
                param = new HashMap(16);
                param.put("mainbillid", row.getLong("id"));
                param.put("asstid", row.getLong("customer"));
                internal_company = false;
                company = row.getLong("internal_company");
                if (company != null && company != 0L) {
                    internal_company = true;
                }
                param.put("internal_company", Boolean.valueOf(internal_company));
                param.put("mainbillentryid", row.getLong("entryid"));
                param.put("settleorgid", row.getLong("entrysettleorg"));
                entryParamList.add(param);
            }
            entryParamList.addAll(planParamList);
            logger.info("\u8c03\u7528\u6536\u6b3e\u53cd\u5199\u63a5\u53e3\u65b9\u6cd5\u53c2\u6570entryParamList:" + entryParamList);
            List<Map<String, Object>> wbResult = ArWriteBackScmcHelper.writeBackHeadRecAmt(entryParamList);
            logger.info("\u8c03\u7528\u6536\u6b3e\u53cd\u5199\u63a5\u53e3\u65b9\u6cd5\u8fd4\u56de\u503cwbResult:" + wbResult);
            List<Map<String, Object>> list = wbResult;
            return list;
        }
        finally {
            if (entryDataSet != null) {
                entryDataSet.close();
            }
            if (planDataSet != null) {
                planDataSet.close();
            }
        }
    }

    private List<OperateErrorInfo> checkErrorData(List<Map<String, Object>> wbResult, Map<Long, Map<String, Object>> salOrderBillHeadDataMap) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(16);
        if (wbResult != null && wbResult.size() > 0) {
            for (Map<String, Object> resultMap : wbResult) {
                Long mainbillid = (Long)resultMap.get("mainbillid");
                BigDecimal wbPreRecAmount = (BigDecimal)resultMap.get("prereceiptallamount");
                BigDecimal wbRecAmount = (BigDecimal)resultMap.get("receiptallamount");
                String billno = "";
                String msg = "";
                boolean isError = false;
                Map<String, Object> soMap = salOrderBillHeadDataMap.get(mainbillid);
                if (soMap != null) {
                    String errorMsg;
                    billno = (String)soMap.get("billno");
                    BigDecimal preRecAmount = (BigDecimal)soMap.get("preRecAmount");
                    BigDecimal recAmount = (BigDecimal)soMap.get("recAmount");
                    if (wbPreRecAmount == null || wbRecAmount == null || preRecAmount == null || recAmount == null) continue;
                    if (preRecAmount.compareTo(wbPreRecAmount) != 0) {
                        isError = true;
                        errorMsg = String.format(ResManager.loadKDString((String)"\u5df2\u9884\u6536\u91d1\u989d\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5df2\u9884\u6536\u91d1\u989d\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"SalOrderHeadRecAmountPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), preRecAmount, wbPreRecAmount);
                        msg = msg + errorMsg;
                    }
                    if (recAmount.compareTo(wbRecAmount) != 0) {
                        isError = true;
                        errorMsg = String.format(ResManager.loadKDString((String)"\u5df2\u6536\u91d1\u989d\uff1a%1$s\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5df2\u6536\u91d1\u989d\uff1a%2$s\u4e0d\u4e00\u81f4\u3002", (String)"SalOrderHeadRecAmountPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), recAmount, wbRecAmount);
                        msg = msg + errorMsg;
                    }
                }
                if (!isError) continue;
                errorInfo.add(this.getExpMsg(this.getClass().getName(), msg, mainbillid, mainbillid, billno));
            }
        }
        return errorInfo;
    }

    private List<FixLogInfo> fixBizDataBySql(List<Map<String, Object>> wbResult, Map<Long, Map<String, Object>> salOrderBillHeadDataMap) {
        ArrayList<FixLogInfo> fixLogCol = new ArrayList<FixLogInfo>(16);
        ArrayList<Object[]> parameterHeadList = new ArrayList<Object[]>();
        if (wbResult != null && wbResult.size() > 0) {
            for (Map<String, Object> resultMap : wbResult) {
                Object[] parameter = new Object[]{resultMap.get("prereceiptallamount"), resultMap.get("receiptallamount"), resultMap.get("mainbillid")};
                parameterHeadList.add(parameter);
                Map<String, Object> soMap = salOrderBillHeadDataMap.get(parameter[2]);
                fixLogCol.add(new FixLogInfo((Long)resultMap.get("mainbillid"), (String)soMap.get("billno"), null, null, "prereceiptamount", ResManager.loadKDString((String)"\u5df2\u9884\u6536\u91d1\u989d", (String)"SalOrderHeadRecAmountPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soMap.get("preRecAmount").toString(), parameter[0].toString()));
                fixLogCol.add(new FixLogInfo((Long)resultMap.get("mainbillid"), (String)soMap.get("billno"), null, null, "receiptamount", ResManager.loadKDString((String)"\u5df2\u6536\u91d1\u989d", (String)"SalOrderHeadRecAmountPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soMap.get("recAmount").toString(), parameter[1].toString()));
            }
            String updateHeadSql = "update t_sm_salorder set fprereceiptamount=? , freceiptamount=?  where fid =?";
            this.updateData(updateHeadSql, parameterHeadList);
        }
        return fixLogCol;
    }

    private void updateData(String updateEntrySql, List<Object[]> parameterList) {
        int updateDataNum = parameterList.size();
        if (updateDataNum > 0 && !CommonUtils.isNull((Object)updateEntrySql)) {
            if (updateDataNum > 1000) {
                List<List<Object[]>> partition = DmfSchemeExecuteHelper.partition(parameterList, 1000);
                partition.forEach(row -> DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateEntrySql, (List)row));
            } else {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateEntrySql, parameterList);
            }
        }
    }
}

