/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.sm;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.inspect.common.ArWriteBackScmcHelper;

public class SalOrderPlanRecAmountPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(SalOrderPlanRecAmountPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "customer", "customer.internal_company internal_company", "prereceiptamount", "receiptamount", "recplanentry.id planentryid", "recplanentry.seq planentryseq", "recplanentry.r_recamount recamount", "recplanentry.r_remainamount remainamount", "recplanentry.r_unremainamount unremainamount", "recplanentry.r_recsettleorg plansettleorg");
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("recplanentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        List<OperateErrorInfo> errorInfo;
        try {
            HashMap<Long, Map<String, Object>> salOrderBillEntryDataMap = new HashMap<Long, Map<String, Object>>(16);
            List<Map<String, Object>> wbResult = this.getWbData(args, salOrderBillEntryDataMap);
            logger.info("\u9500\u552e\u8ba2\u5355\u7684\u53cd\u5199\u5b57\u6bb5\u7684\u503c\u96c6\u5408salOrderBillEntryDataMap:" + salOrderBillEntryDataMap);
            errorInfo = this.checkErrorData(wbResult, salOrderBillEntryDataMap);
        }
        catch (Exception e) {
            String expMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
            logger.error("\u51fa\u73b0\u4e86\u5f02\u5e38:{}", (Object)expMsg);
            throw new KDBizException(expMsg);
        }
        return errorInfo;
    }

    @Override
    public List<FixLogInfo> fixDataSet(DataSet args) {
        HashMap<Long, Map<String, Object>> salOrderBillEntryDataMap = new HashMap<Long, Map<String, Object>>(16);
        List<Map<String, Object>> wbResult = this.getWbData(args, salOrderBillEntryDataMap);
        logger.info("\u9500\u552e\u8ba2\u5355\u7684\u53cd\u5199\u5b57\u6bb5\u7684\u503c\u96c6\u5408salOrderBillEntryDataMap:" + salOrderBillEntryDataMap);
        List<FixLogInfo> expMsg = this.fixBizDataBySql(wbResult, salOrderBillEntryDataMap);
        return expMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getWbData(DataSet args, Map<Long, Map<String, Object>> salOrderBillEntryDataMap) {
        try (DataSet planDataSet = null;){
            planDataSet = args.select(new String[]{"id", "billno", "customer", "internal_company", "prereceiptamount", "receiptamount", "planentryid", "planentryseq", "recamount", "remainamount", "unremainamount", "plansettleorg"}).distinct();
            ArrayList<Map<String, Object>> planParamList = new ArrayList<Map<String, Object>>(16);
            if (args == null) {
                ArrayList<Map<String, Object>> arrayList = planParamList;
                return arrayList;
            }
            for (Row row : planDataSet) {
                HashMap<String, Constable> param = new HashMap<String, Constable>(16);
                param.put("mainbillid", row.getLong("id"));
                param.put("asstid", row.getLong("customer"));
                boolean internal_company = false;
                Long company = row.getLong("internal_company");
                if (company != null && company != 0L) {
                    internal_company = true;
                }
                param.put("internal_company", Boolean.valueOf(internal_company));
                param.put("mainbillentryid", row.getLong("planentryid"));
                param.put("settleorgid", row.getLong("plansettleorg"));
                planParamList.add(param);
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("billno", row.getString("billno"));
                map.put("id", row.getLong("id"));
                map.put("entryid", row.getLong("planentryid"));
                map.put("seq", row.getInteger("planentryseq"));
                map.put("entryRecAmount", row.getBigDecimal("recamount"));
                map.put("remainAmount", row.getBigDecimal("remainamount"));
                map.put("unRemainAmount", row.getBigDecimal("unremainamount"));
                if (row.getLong("planentryid") == null || Long.valueOf(0L).equals(row.getLong("planentryid"))) continue;
                salOrderBillEntryDataMap.put(row.getLong("planentryid"), map);
            }
            logger.info("\u8c03\u7528\u6536\u6b3e\u53cd\u5199\u63a5\u53e3\u65b9\u6cd5\u53c2\u6570planParamList:" + planParamList);
            List<Map<String, Object>> wbEntryResult = ArWriteBackScmcHelper.writeBackPlanRecAmt(planParamList);
            logger.info("\u8c03\u7528\u6536\u6b3e\u53cd\u5199\u63a5\u53e3\u65b9\u6cd5\u8fd4\u56de\u503cwbEntryResult:" + wbEntryResult);
            List<Map<String, Object>> list = wbEntryResult;
            return list;
        }
    }

    private List<OperateErrorInfo> checkErrorData(List<Map<String, Object>> wbResult, Map<Long, Map<String, Object>> salOrderBillEntryDataMap) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(16);
        if (wbResult != null && wbResult.size() > 0) {
            for (Map<String, Object> resultMap : wbResult) {
                Map<String, Object> soMap;
                Long mainbillid = (Long)resultMap.get("mainbillid");
                Long mainbillentryid = (Long)resultMap.get("mainbillentryid");
                BigDecimal wbEntryRecAmount = (BigDecimal)resultMap.get("recamount");
                BigDecimal wbRemainAmount = (BigDecimal)resultMap.get("joinrecamount");
                String billno = "";
                String msg = "";
                boolean isError = false;
                if (mainbillentryid != null && (soMap = salOrderBillEntryDataMap.get(mainbillentryid)) != null) {
                    String errorMsg;
                    billno = (String)soMap.get("billno");
                    BigDecimal entryRecAmount = (BigDecimal)soMap.get("entryRecAmount");
                    BigDecimal remainAmount = (BigDecimal)soMap.get("remainAmount");
                    if (entryRecAmount == null || remainAmount == null || wbEntryRecAmount == null || wbRemainAmount == null) continue;
                    if (entryRecAmount.compareTo(wbEntryRecAmount) != 0) {
                        isError = true;
                        errorMsg = String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7b2c%1$s\u884c\u5df2\u6536\u91d1\u989d\uff1a%2$s\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5df2\u6536\u91d1\u989d\uff1a%3$s\u4e0d\u4e00\u81f4\u3002", (String)"SalOrderPlanRecAmountPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soMap.get("seq"), entryRecAmount, wbEntryRecAmount);
                        msg = msg + errorMsg;
                    }
                    if (remainAmount.compareTo(wbRemainAmount) != 0) {
                        isError = true;
                        errorMsg = String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7b2c%1$s\u884c\u5173\u8054\u6536\u6b3e\u91d1\u989d\uff1a%2$s\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5173\u8054\u6536\u6b3e\u91d1\u989d\uff1a%3$s\u4e0d\u4e00\u81f4\u3002", (String)"SalOrderPlanRecAmountPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soMap.get("seq"), remainAmount, wbRemainAmount);
                        msg = msg + errorMsg;
                    }
                }
                if (!isError) continue;
                errorInfo.add(this.getExpMsg(this.getClass().getName(), msg, mainbillid, mainbillentryid, billno));
            }
        }
        return errorInfo;
    }

    private List<FixLogInfo> fixBizDataBySql(List<Map<String, Object>> wbResult, Map<Long, Map<String, Object>> salOrderBillEntryDataMap) {
        ArrayList<FixLogInfo> fixLogCol = new ArrayList<FixLogInfo>(16);
        ArrayList<Object[]> parameterEntryList = new ArrayList<Object[]>();
        if (wbResult != null && wbResult.size() > 0) {
            for (Map<String, Object> resultMap : wbResult) {
                Object[] parameter = new Object[]{resultMap.get("recamount"), resultMap.get("joinrecamount"), resultMap.get("joinrecamount"), resultMap.get("mainbillentryid"), resultMap.get("mainbillid")};
                parameterEntryList.add(parameter);
                Map<String, Object> soMap = salOrderBillEntryDataMap.get(parameter[3]);
                fixLogCol.add(new FixLogInfo((Long)resultMap.get("mainbillid"), (String)soMap.get("billno"), (Integer)soMap.get("seq"), (Long)resultMap.get("mainbillentryid"), "r_recamount", ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212.\u5df2\u6536\u91d1\u989d", (String)"SalOrderPlanRecAmountPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soMap.get("entryRecAmount").toString(), parameter[0].toString()));
                fixLogCol.add(new FixLogInfo((Long)resultMap.get("mainbillid"), (String)soMap.get("billno"), (Integer)soMap.get("seq"), (Long)resultMap.get("mainbillentryid"), "r_remainamount", ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212.\u5173\u8054\u6536\u6b3e\u91d1\u989d", (String)"SalOrderPlanRecAmountPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), soMap.get("remainAmount").toString(), parameter[1].toString()));
            }
            String updateEntrySql = "update t_sm_salorderrpentry set frecamount=? , fremainamount=?, funremainamount=frecadvanceamount-? where fentryid=? and fid=?";
            this.updateData(updateEntrySql, parameterEntryList);
        }
        return fixLogCol;
    }

    private void updateData(String updateEntrySql, List<Object[]> parameterList) {
        int updateDataNum = parameterList.size();
        if (updateDataNum > 0 && !CommonUtils.isNull((Object)updateEntrySql)) {
            if (updateDataNum > 1000) {
                List<List<Object[]>> partition = DmfSchemeExecuteHelper.partition(parameterList, 1000);
                partition.forEach(row -> DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateEntrySql, (List)row));
            } else {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateEntrySql, parameterList);
            }
        }
    }
}

