/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.opplugin;

import java.util.Collections;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.mpscmm.msbd.datamanage.opplugin.InspectPlanRunValidator;

public class DmfInspectPlanRunOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(DmfInspectPlanRunOp.class);
    public static final String SINGLE_TASK_CLASSNAME = "kd.mpscmm.msbd.algox.mservice.InspectSingleTaskServiceImpl";
    public static final String BROADCAST_TASK_CLASSNAME = "kd.mpscmm.msbd.algox.mservice.InspectBroadcastTaskServiceImpl";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "inspectjob", "msgreceiver", "areajson_tag");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InspectPlanRunValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject plan : e.getDataEntities()) {
            Long inspectPlanId = (Long)plan.getPkValue();
            String planNumber = plan.getString("number");
            DynamicObject msgReceiver = plan.getDynamicObject("msgreceiver");
            Long msgReceiverId = msgReceiver == null ? Long.valueOf(0L) : (Long)msgReceiver.getPkValue();
            DynamicObject inspectJob = plan.getDynamicObject("inspectjob");
            Long inspectJobId = (Long)inspectJob.getPkValue();
            String number = inspectJob.getString("number");
            String name = inspectJob.getLocaleString("name").getLocaleValue();
            JobInfo jobInfo = this.createJobInfo(inspectPlanId, inspectJobId, msgReceiverId, number, name);
            String runMode = inspectJob.getString("runmode");
            if ("0".equals(runMode)) {
                jobInfo.setRouteMode(RouteMode.RAMDOM);
                jobInfo.setTaskClassname(SINGLE_TASK_CLASSNAME);
            }
            if ("1".equals(runMode)) {
                jobInfo.setRouteMode(RouteMode.SHARDINGBROADCAST);
                jobInfo.setTaskClassname(BROADCAST_TASK_CLASSNAME);
            }
            String dispatchResult = ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
            logger.info("\u5de1\u68c0\u8ba1\u5212\u7f16\u7801\uff1a{}\u4e0b\u7684\u5de1\u68c0\u4efb\u52a1\uff1a{}\u6267\u884c\u7ed3\u679c\u662f\uff1a{}", new Object[]{planNumber, number, dispatchResult});
        }
    }

    private JobInfo createJobInfo(Long inspectPlanId, Long inspectJobId, Long msgReceiverId, String number, String name) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("msbd");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setJobPrincipal(RequestContext.get().getCurrUserId());
        jobInfo.setNumber(number);
        jobInfo.setName(name);
        jobInfo.setId(Uuid16.create().toString());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("inspectPlanId", inspectPlanId);
        params.put("inspectJobId", inspectJobId);
        params.put("number", number);
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        return jobInfo;
    }
}

