/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.assigncfg.business.cache;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class AssignCfgCache {
    public static List<DynamicObject> loadAssignCfgByTriggerField(String entityNumber, String fieldName) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        IDataEntityProperty iDataEntityProperty = mainEntityType.findProperty(fieldName);
        if (null == iDataEntityProperty) {
            return Collections.emptyList();
        }
        StringJoiner stringJoiner = new StringJoiner(".");
        ArrayDeque<String> prefixStack = new ArrayDeque<String>(2);
        prefixStack.add(fieldName);
        for (Object entityType = iDataEntityProperty.getParent(); entityType != null; entityType = entityType.getParent()) {
            if (!(entityType instanceof EntryType) && !(entityType instanceof SubEntryType)) continue;
            prefixStack.addFirst(entityType.getName());
        }
        for (String prefix : prefixStack) {
            stringJoiner.add(prefix);
        }
        String triggerFieldKey = stringJoiner.toString();
        return AssignCfgCache.loadAssignCfgMap(entityNumber, "A", triggerFieldKey);
    }

    public static List<DynamicObject> loadAssignCfgByOp(String entityNumber, String opCode) {
        return AssignCfgCache.loadAssignCfgMap(entityNumber, "B", opCode);
    }

    private static List<DynamicObject> loadAssignCfgMap(String entityNumber, String triggerType, String triggerActionKey) {
        QFilter qFilter = new QFilter("tgtentity", "=", (Object)entityNumber);
        qFilter.and("triggertype", "=", (Object)triggerType);
        qFilter.and("tgttriggeractionkey", "=", (Object)triggerActionKey);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"msmod_assigncfg", (QFilter[])qFilter.toArray());
        if (MapUtils.isEmpty((Map)dynamicObjectMap)) {
            return Collections.emptyList();
        }
        return dynamicObjectMap.values().stream().sorted(Comparator.comparingLong(item1 -> (Long)item1.getPkValue())).collect(Collectors.toList());
    }

    public static boolean hasAssignCfg(String entityNumber, String propName) {
        List<DynamicObject> list = AssignCfgCache.loadAssignCfgByTriggerField(entityNumber, propName);
        return CollectionUtils.isNotEmpty(list);
    }
}

