/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.assigncfg.business.filter;

import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.ExprFuncCreator;
import kd.bos.entity.function.FunctionManage;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.UDFunction;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.assigncfg.common.utils.DymUtils;
import org.apache.commons.lang3.StringUtils;

public class FormulaFilter {
    public static final boolean filter(String entityNumber, DynamicObject entryObj, String filterFormula) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return false;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        return FormulaFilter.filter(mainEntityType, entryObj, filterFormula);
    }

    public static boolean filter(MainEntityType mainEntityType, DynamicObject entryObj, String filterFormula) {
        if (StringUtils.isBlank((CharSequence)filterFormula)) {
            return true;
        }
        String entryName = entryObj.getDataEntityType().getName();
        RowDataModel rowDataModel = new RowDataModel(entryName, mainEntityType);
        rowDataModel.setRowContext(entryObj);
        ExpressionParameter expressionParameter = new ExpressionParameter(filterFormula, rowDataModel);
        Set vars = expressionParameter.getBOSExpression().getVars();
        HashMap<String, Object> params = new HashMap<String, Object>(vars.size());
        for (String var : vars) {
            Object val = DymUtils.getPropValue(mainEntityType, entryObj, var);
            if (val instanceof Object[] && ((Object[])val).length != 0) {
                val = ((Object[])val)[0];
            }
            if (val instanceof OrmLocaleValue) {
                val = ((OrmLocaleValue)val).getLocaleValue();
            } else if (val instanceof DynamicObject) {
                val = ((DynamicObject)val).getPkValue();
            }
            params.put(var, val);
        }
        Set funcs = expressionParameter.getBOSExpression().getFuncs();
        BOSUDFunction[] functions = ExprFuncCreator.createUDFunctions((Set)funcs, (FunctionManage)FunctionManage.get(), (ExpressionContext)new BOSExpressionContext(rowDataModel));
        return (Boolean)FormulaEngine.execExcelFormula((String)filterFormula, params, (UDFunction[])functions);
    }
}

