/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.assigncfg.business.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.assigncfg.business.cache.AssignCfgCache;
import kd.mpscmm.msbd.assigncfg.business.filter.ApplyOrgFilter;
import kd.mpscmm.msbd.assigncfg.business.filter.FormulaFilter;
import kd.mpscmm.msbd.assigncfg.business.match.QFilterMatcher;
import kd.mpscmm.msbd.assigncfg.common.utils.DymUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class AssignCfgHelper {
    private static final Log log = LogFactory.getLog(AssignCfgHelper.class);

    public static Map<DynamicObject, Map<String, Object>> triggerByField(String entityNumber, DynamicObject trgEntity, String triggerField) {
        HashMap<DynamicObject, Map<String, Object>> resultMap = new HashMap<DynamicObject, Map<String, Object>>();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        HashMap<String, List<String>> cache = new HashMap<String, List<String>>();
        List<DynamicObject> assignCfgList = AssignCfgHelper.loadAssignCfg(entityNumber, trgEntity, triggerField, "A");
        for (DynamicObject assignCfg : assignCfgList) {
            String assignEntryNum = DymUtils.parseEntryNumber(entityNumber, assignCfg, true);
            List<String> typeStack = (List<String>)cache.get(assignEntryNum);
            if (typeStack == null) {
                typeStack = DymUtils.getEntryStack(entityNumber, assignEntryNum);
                cache.put(assignEntryNum, typeStack);
            }
            DynamicObjectCollection collection = AssignCfgHelper.generateCollection(entityNumber, trgEntity, typeStack);
            for (DynamicObject dynamicObject : collection) {
                Map<String, Object> assignMap = AssignCfgHelper.generateAssignMap(mainEntityType, dynamicObject, assignCfg);
                if (!MapUtils.isNotEmpty(assignMap)) continue;
                Map<String, Object> map = (Map<String, Object>)resultMap.get(dynamicObject);
                if (map == null) {
                    map = assignMap;
                } else {
                    map.putAll(assignMap);
                }
                resultMap.put(dynamicObject, map);
            }
        }
        return resultMap;
    }

    private static Map<String, Object> generateAssignMap(MainEntityType mainEntityType, DynamicObject tgtEntity, DynamicObject assignCfg) {
        String assignCfgNumber = assignCfg.getString("number");
        if (!FormulaFilter.filter(mainEntityType, tgtEntity, assignCfg.getString("tgtfilterformula_tag"))) {
            return Collections.emptyMap();
        }
        DynamicObject srcEntityCfg = assignCfg.getDynamicObject("srcentity");
        String srcEntityNumber = srcEntityCfg.getString("number");
        if (StringUtils.isBlank((CharSequence)srcEntityNumber)) {
            return Collections.emptyMap();
        }
        QFilter qFilter = QFilterMatcher.generateQFilter(tgtEntity, assignCfg);
        DynamicObjectCollection assignEntries = assignCfg.getDynamicObjectCollection("assignentry");
        String srcEntryName = DymUtils.parseEntryNumber(srcEntityNumber, assignCfg, false);
        DynamicObjectCollection srcCollection = QFilterMatcher.match(srcEntityNumber, qFilter, srcEntryName);
        if (CollectionUtils.isEmpty((Collection)srcCollection)) {
            return Collections.emptyMap();
        }
        String srcFormula = assignCfg.getString("srcfilterformula_tag");
        DynamicObject srcEntity = null;
        for (DynamicObject dynamicObject : srcCollection) {
            if (!FormulaFilter.filter(srcEntityNumber, dynamicObject, srcFormula)) continue;
            srcEntity = dynamicObject;
            break;
        }
        if (null == srcEntity) {
            return Collections.emptyMap();
        }
        return AssignCfgHelper.assignMapping(MetadataServiceHelper.getDataEntityType((String)srcEntityNumber), srcEntity, assignEntries);
    }

    public static boolean hasAssignCfg(String entityNumber, String propName) {
        return AssignCfgCache.hasAssignCfg(entityNumber, propName);
    }

    private static Map<String, Object> assignMapping(MainEntityType srcMetaType, DynamicObject srcEntity, DynamicObjectCollection assignEntries) {
        HashMap<String, Object> assignMap = new HashMap<String, Object>(assignEntries.size());
        IDataEntityType entryType = srcEntity.getDataEntityType();
        RowDataModel rowDataModel = new RowDataModel(entryType.getName(), srcMetaType);
        rowDataModel.setRowContext(srcEntity);
        for (DynamicObject assignEntry : assignEntries) {
            String srcField = assignEntry.getString("srcassignfieldkey");
            String tgtField = assignEntry.getString("tgtassignfieldkey");
            Object value = DymUtils.getPropValue(rowDataModel, srcField);
            if (value instanceof DynamicObject) {
                String nameFieldKey;
                BasedataEntityType basedataEntityType = (BasedataEntityType)((DynamicObject)value).getDataEntityType();
                DynamicObject newDym = BusinessDataServiceHelper.newDynamicObject((String)((DynamicObject)value).getDataEntityType().getName());
                newDym.set("id", ((DynamicObject)value).getPkValue());
                String numberFieldKey = basedataEntityType.getNumberProperty();
                if (StringUtils.isNotBlank((CharSequence)numberFieldKey)) {
                    newDym.set(numberFieldKey, (Object)((DynamicObject)value).getString(numberFieldKey));
                }
                if (StringUtils.isNotBlank((CharSequence)(nameFieldKey = basedataEntityType.getNameProperty()))) {
                    newDym.set(nameFieldKey, (Object)((DynamicObject)value).getString(nameFieldKey));
                }
                value = newDym;
            }
            assignMap.put(tgtField, value);
        }
        return assignMap;
    }

    public static void triggerByOperation(String entityNumber, DynamicObject[] bills, String opKey) {
        List<DynamicObject> allAssignCfgList = AssignCfgCache.loadAssignCfgByOp(entityNumber, opKey);
        if (ObjectUtils.isEmpty(allAssignCfgList)) {
            return;
        }
        HashMap<String, List<String>> cache = new HashMap<String, List<String>>();
        MainEntityType mainEntityType = (MainEntityType)bills[0].getDataEntityType();
        for (DynamicObject bill : bills) {
            List<DynamicObject> assignCfgList = ApplyOrgFilter.filterByApplyOrg(entityNumber, bill, allAssignCfgList);
            for (DynamicObject assignCfg : assignCfgList) {
                String entryNumber = DymUtils.parseEntryNumber(entityNumber, assignCfg, true);
                List<String> stack = (List<String>)cache.get(entryNumber);
                if (stack == null) {
                    stack = DymUtils.getEntryStack(entityNumber, entryNumber);
                    cache.put(entryNumber, stack);
                }
                DynamicObjectCollection entryCollection = AssignCfgHelper.generateCollection(entityNumber, bill, stack);
                for (DynamicObject entryObj : entryCollection) {
                    Map<String, Object> assignMap = AssignCfgHelper.generateAssignMap(mainEntityType, entryObj, assignCfg);
                    if (!ObjectUtils.isNotEmpty(assignMap)) continue;
                    if (StringUtils.isBlank((CharSequence)entryNumber)) {
                        entryNumber = entityNumber;
                    }
                    RowDataModel rowDataModel = new RowDataModel(entryNumber, mainEntityType);
                    rowDataModel.setRowContext(entryObj);
                    for (Map.Entry<String, Object> entry : assignMap.entrySet()) {
                        DymUtils.setPropValue(rowDataModel, entryObj, entry.getKey(), entry.getValue());
                    }
                }
            }
        }
    }

    private static DynamicObjectCollection generateCollection(String entityNumber, DynamicObject dym, List<String> typeStack) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        if (null == dym) {
            return collection;
        }
        if (CollectionUtils.isEmpty(typeStack)) {
            collection.add((Object)dym);
            return collection;
        }
        String dymTypeName = dym.getDataEntityType().getName();
        DynamicObjectCollection todoCollection = new DynamicObjectCollection();
        todoCollection.add((Object)dym);
        for (int index = 0; index < typeStack.size(); ++index) {
            String subTypeName;
            String typeName = typeStack.get(index);
            if (!dymTypeName.equals(typeName) || index + 1 == typeStack.size()) continue;
            dymTypeName = subTypeName = typeStack.get(index + 1);
            DynamicObjectCollection newTodoCollection = new DynamicObjectCollection();
            for (DynamicObject todoDym : todoCollection) {
                newTodoCollection.addAll((Collection)todoDym.getDynamicObjectCollection(subTypeName));
            }
            todoCollection = newTodoCollection;
        }
        collection = todoCollection;
        return collection;
    }

    private static List<DynamicObject> loadAssignCfg(String entityNumber, DynamicObject trgEntity, String triggerActionKey, String triggerType) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || null == trgEntity || StringUtils.isBlank((CharSequence)triggerActionKey)) {
            return Collections.emptyList();
        }
        List<DynamicObject> assignCfgList = "A".equals(triggerType) ? AssignCfgCache.loadAssignCfgByTriggerField(entityNumber, triggerActionKey) : AssignCfgCache.loadAssignCfgByOp(entityNumber, triggerActionKey);
        if (CollectionUtils.isEmpty(assignCfgList = ApplyOrgFilter.filterByApplyOrg(entityNumber, trgEntity, assignCfgList))) {
            return Collections.emptyList();
        }
        return assignCfgList;
    }
}

