/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.serviceflow.business.clearploy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.serviceflow.business.clearploy.AbstractUnifyLogClearPloy;
import kd.mpscmm.msbd.serviceflow.business.service.UnifyLogClearPloyContext;
import kd.mpscmm.msbd.serviceflow.common.info.TransformLogInfo;
import kd.mpscmm.msbd.serviceflow.common.info.TransformMsInfo;

public class UnifyLogOtherClearPloy
extends AbstractUnifyLogClearPloy {
    public UnifyLogOtherClearPloy(UnifyLogClearPloyContext unifyLogClearContext) {
        super(unifyLogClearContext);
    }

    @Override
    public void exeClearPloy(List<TransformLogInfo> transformLogInfoList) {
        boolean flag;
        UnifyLogClearPloyContext unifyInfo = this.getUnifyLogClearContext();
        String cleanFilterStr = unifyInfo.getCleanFilterStr();
        if (StringUtils.isBlank((CharSequence)cleanFilterStr)) {
            return;
        }
        ArrayList<QFilter> filter = new ArrayList<QFilter>(16);
        List<QFilter> cleanFilterList = this.getCleanFilter();
        if (cleanFilterList != null) {
            filter.addAll(cleanFilterList);
        }
        if (flag = this.checkFieldIsExist("appid")) {
            QFilter appFilter = new QFilter("appid", "=", (Object)unifyInfo.getAppNumber());
            filter.add(appFilter);
        }
        String logEntity = unifyInfo.getLogEntity();
        ArrayList<Object> deletePkIdList = new ArrayList<Object>(16);
        Collection<TransformMsInfo> transformInfoList = this.unifyLogClearContext.getTransformInfoList();
        if (transformInfoList == null || transformInfoList.size() <= 0) {
            try (DataSet ids = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)logEntity, (String)"id", (QFilter[])filter.toArray(new QFilter[0]), null);){
                ids.forEach(value -> deletePkIdList.add(value.getLong("id")));
            }
        }
        Set msKeyList = transformLogInfoList.stream().map(v -> v.getMsKey()).collect(Collectors.toSet());
        QFilter msKeyFilterList = new QFilter("classname", "in", msKeyList);
        filter.add(msKeyFilterList);
        try (DataSet cleanList = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)logEntity, (String)"id, classname", (QFilter[])filter.toArray(new QFilter[0]), null);){
            DataSet deleteIdList = cleanList.copy();
            Object object = null;
            try {
                for (Row row : deleteIdList) {
                    deletePkIdList.add(row.getLong("id"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (deleteIdList != null) {
                    if (object != null) {
                        try {
                            deleteIdList.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        deleteIdList.close();
                    }
                }
            }
            DataSet ids = cleanList.groupBy(new String[]{"classname"}).count("id").finish();
            for (Row row : ids) {
                String className = row.getString("classname");
                List transformLogInfo = transformLogInfoList.stream().filter(v -> className.equals(v.getMsKey())).collect(Collectors.toList());
                if (transformLogInfo == null || transformLogInfo.size() <= 0) continue;
                TransformLogInfo logInfo = (TransformLogInfo)transformLogInfo.get(0);
                Integer cleanNum = logInfo.getCleanNum();
                Integer idCount = row.getInteger("id");
                if (idCount <= 0) continue;
                cleanNum = cleanNum + idCount;
                List<String> cleanDetailList = logInfo.getCleanDetailList();
                cleanDetailList.add(String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u6e05\u7406\u89c4\u5219,\u672c\u6b21\u6e05\u7406\u6570\u636e\uff08%d \u6761\uff09", (String)"UnifyLogOtherClearPloy_0", (String)"mpscmm-msbd-serviceflow", (Object[])new Object[0]), idCount));
                logInfo.setCleanNum(cleanNum);
            }
        }
        this.deleteLogPkId(deletePkIdList);
    }
}

