/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.serviceflow.business.logfactory;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kd.mpscmm.msbd.serviceflow.business.log.LogService;
import kd.mpscmm.msbd.serviceflow.business.logfactory.DefaultLogTrackFactory;
import kd.mpscmm.msbd.serviceflow.business.logfactory.LogTrackConfig;

public abstract class LogTrackFactory {
    private static final AtomicReference<LogTrackFactory> INSTANCE = new AtomicReference();
    private static LogTrackFactory factory = LogTrackFactory.getDefaultFactory();

    private static final LogTrackFactory getDefaultFactory() {
        LogTrackFactory instance = INSTANCE.get();
        if (instance != null) {
            return instance;
        }
        INSTANCE.compareAndSet(null, new DefaultLogTrackFactory());
        return INSTANCE.get();
    }

    public static LogService getLog(Class<?> classValue, String appId) {
        return factory.getLogService(classValue, appId);
    }

    public abstract LogService getLogService(Class<?> var1, String var2);

    public static LogService getLog(Class<?> clazz) {
        String appIdFromConfig = LogTrackFactory.getAppIdFromConfig(clazz);
        return factory.getLogService(clazz, appIdFromConfig);
    }

    public static String getAppIdFromConfig(Class<?> classValue) {
        if (classValue == null) {
            return null;
        }
        String name = classValue.getName();
        Set<String> allAppId = LogTrackConfig.getAllAppId();
        String appId = null;
        for (String configAppId : allAppId) {
            String match = ".".concat(configAppId).concat(".");
            if (!name.contains(match)) continue;
            appId = configAppId;
            break;
        }
        if (appId == null) {
            return null;
        }
        return appId;
    }
}

