/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.serviceflow.business.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.common.utils.AppCacheUtils;

public class UnifyLogController {
    public static <T> List<List<T>> partition(List<T> originalList, int batchSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(16);
        if (originalList == null) {
            return result;
        }
        int remainder = originalList.size() % batchSize;
        int number = originalList.size() / batchSize;
        for (int i = 0; i < number; ++i) {
            List<T> value = originalList.subList(i * batchSize, (i + 1) * batchSize);
            result.add(value);
        }
        if (remainder > 0) {
            result.add(originalList.subList(number * batchSize, originalList.size()));
        }
        return result;
    }

    public static String getLogEntityTableName(String logEntity) {
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)logEntity, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        String entityId = formMeta.getEntityId();
        EntityMetadata entityMetaData = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List entityList = entityMetaData.getEntitys();
        String tableName = ((Entity)entityList.get(0)).getTableName();
        return tableName;
    }

    public static boolean checkEnableLogging(String appNumber, String msKey) {
        String appId = UnifyLogController.getAppId(appNumber);
        QFilter filter = new QFilter("app", "=", (Object)appId);
        filter.and("entry.mskey", "=", (Object)msKey);
        String cacheKey = String.format("%s$$%s", appNumber, msKey);
        String value = (String)AppCacheUtils.get((String)cacheKey, String.class);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        boolean flag = QueryServiceHelper.exists((String)"msbd_logmanage", (QFilter[])filter.toArray());
        AppCacheUtils.put((String)cacheKey, (Object)String.valueOf(flag));
        return flag;
    }

    public static String getAppId(String appNumber) {
        QFilter filter = new QFilter("number", "=", (Object)appNumber);
        DynamicObject entity = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (String)"id", (QFilter[])filter.toArray());
        String appId = (String)entity.getPkValue();
        return appId;
    }

    public static Map<String, String> getAppIdAppNumber(Set<String> appIdSet) {
        HashMap<String, String> appIdNumber = new HashMap<String, String>(16);
        QFilter filter = new QFilter("id", "in", appIdSet);
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)"TrackLogController_01", (String)"bos_devportal_bizapp", (String)"id,number", (QFilter[])filter.toArray(), null);){
            rows.forEach(row -> appIdNumber.put(row.getString("id"), row.getString("number")));
        }
        return appIdNumber;
    }
}

