/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.serviceflow.formplugin;

import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.lang.Lang;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class UnifyLogManageListPlugin
extends AbstractListPlugin {
    public static final String LOG_CLEAN_SERVICE = "kd.mpscmm.msbd.serviceflow.business.service.UnifyLogClearService";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate operate = (FormOperate)e.getSource();
        if ("clean".equals(operate.getOperateKey())) {
            JobInfo jobInfo = this.getJobInfo();
            ListSelectedRowCollection listData = e.getListSelectedData();
            Set primaryKeyValueSet = listData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            HashMap<String, String> parameter = new HashMap<String, String>(16);
            parameter.put("primaryKeyValueStr", SerializationUtils.toJsonString(primaryKeyValueSet));
            jobInfo.setParams(parameter);
            ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
        }
    }

    private JobInfo getJobInfo() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("msbd");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setJobPrincipal(RequestContext.get().getCurrUserId());
        jobInfo.setNumber("UnifyLog.UnifyLogClearService");
        jobInfo.setName("UnifyLog.UnifyLogClearService");
        jobInfo.setId(Uuid16.create().toString());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRouteMode(RouteMode.RAMDOM);
        jobInfo.setTaskClassname(LOG_CLEAN_SERVICE);
        jobInfo.setRunByLang(Lang.get());
        return jobInfo;
    }
}

