/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.business.helper.FetchPriceHelper;
import kd.mpscmm.msbd.business.helper.SysParamHelper;

public class SCMCBillConvertQuotePlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(SCMCBillConvertQuotePlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        BillEntityType tgtMainType = this.getTgtMainType();
        String appId = tgtMainType.getAppId();
        HashMap<Long, Boolean> paramCache = new HashMap<Long, Boolean>();
        HashMap<Long, List<DynamicObject>> orgToBills = new HashMap<Long, List<DynamicObject>>();
        log.info(this.getLogMsg("\u4e0b\u63a8\u81ea\u52a8\u53d6\u4ef7\u5f00\u59cb"));
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObject org = (DynamicObject)bill.get(this.getQuoteOrgField());
            if (org == null) continue;
            paramCache.computeIfAbsent((Long)org.getPkValue(), key -> {
                Object param = null;
                if ("sm".equals(appId)) {
                    log.info(this.getLogMsg("\u9500\u552e"));
                    param = SysParamHelper.getSysParam4sm((Long)org.getPkValue(), "isautoquote");
                }
                if ("pm".equals(appId)) {
                    log.info(this.getLogMsg("\u91c7\u8d2d"));
                    param = SysParamHelper.getSysParam4pm((Long)org.getPkValue(), "isautoquote");
                }
                if (param == null) {
                    log.info(this.getLogMsg("PARAM is NULL"));
                    param = Boolean.TRUE;
                }
                return (Boolean)param;
            });
            boolean isAutoQuote = (Boolean)paramCache.get(org.getPkValue());
            if (!isAutoQuote) {
                log.info(this.getLogMsg("end"));
                continue;
            }
            log.info(this.getLogMsg("\u771f\u6b63\u5f00\u59cb\u81ea\u52a8\u4e0b\u63a8\u53d6\u4ef7"));
            List billList = orgToBills.computeIfAbsent((Long)org.getPkValue(), key -> new ArrayList());
            billList.add(bill);
        }
        FetchPriceHelper.updateBillPriceInfo(orgToBills, tgtMainType.getName(), new HashMap<String, Object>());
        log.info(this.getLogMsg("\u4e0b\u63a8\u81ea\u52a8\u53d6\u4ef7\u7ed3\u675f"));
    }

    protected String getQuoteOrgField() {
        String orgProperty = this.getTgtMainType().getMainOrg();
        if (("im".equals(this.getTgtMainType().getAppId()) || "pm_requirapplybill".equals(this.getTgtMainType().getName())) && this.getTgtMainType().getAllFields().containsKey("bizorg")) {
            orgProperty = "bizorg";
        }
        return orgProperty;
    }

    private String getLogMsg(String msg) {
        return "quote=" + msg;
    }
}

