/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.mpscmm.msbd.business.helper.CurrencyHelper;
import kd.mpscmm.msbd.common.enums.ChangeTypeEnum;
import kd.mpscmm.msbd.common.enums.DiscountTypeEnum;
import kd.mpscmm.msbd.common.pojo.BillAmountInfo;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;

public class BillAmountHelper {
    private static final String DEFAULT_CHANGE_TYPE = "entrychangetype";
    private static final String DEFAULT_BILL_ENTRY = "billentry";

    public static Map<String, BigDecimal> calcTotalAmount(DynamicObject bill) {
        return BillAmountHelper.calcTotalAmount(bill, DEFAULT_CHANGE_TYPE);
    }

    public static Map<String, BigDecimal> calcTotalAmount(DynamicObject bill, String changeTypeField) {
        HashMap<String, String> fieldMapping = new HashMap<String, String>(8);
        fieldMapping.put("totalamount", "amount");
        fieldMapping.put("totaltaxamount", "taxamount");
        fieldMapping.put("totalallamount", "amountandtax");
        fieldMapping.put("curtotalamount", "curamount");
        fieldMapping.put("curtotalallamount", "curamountandtax");
        return BillAmountHelper.calcTotalAmount(bill, fieldMapping, changeTypeField);
    }

    public static Map<String, BigDecimal> calcTotalAmount(DynamicObject bill, Map<String, String> fieldMapping) {
        return BillAmountHelper.calcTotalAmount(bill, fieldMapping, DEFAULT_CHANGE_TYPE);
    }

    public static Map<String, BigDecimal> calcTotalAmount(DynamicObject bill, Map<String, String> fieldMapping, String changeTypeField) {
        HashMap<String, BigDecimal> calcResult = new HashMap<String, BigDecimal>(8);
        DynamicObjectType billType = bill.getDynamicObjectType();
        Map<String, String> filteredMapping = BillAmountHelper.mappingFilter(billType, fieldMapping);
        if (filteredMapping.isEmpty()) {
            return calcResult;
        }
        for (String headField : filteredMapping.keySet()) {
            calcResult.put(headField, BigDecimal.ZERO);
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection(DEFAULT_BILL_ENTRY);
        if (entry == null || entry.isEmpty()) {
            return calcResult;
        }
        DynamicObjectType entryType = ((DynamicObject)entry.get(0)).getDynamicObjectType();
        Map<String, DynamicProperty> entryFieldProperties = BillAmountHelper.getEntryFieldProperties(entryType, filteredMapping);
        if (entryFieldProperties.isEmpty()) {
            return calcResult;
        }
        DynamicProperty changeTypeProp = entryType.getProperty(changeTypeField);
        for (DynamicObject row : entry) {
            if (changeTypeProp != null && ChangeTypeEnum.isCancel((String)changeTypeProp.getValueFast((Object)row))) continue;
            for (Map.Entry<String, DynamicProperty> propertyEntry : entryFieldProperties.entrySet()) {
                String headKey = propertyEntry.getKey();
                calcResult.put(headKey, ((BigDecimal)calcResult.get(headKey)).add(BigDecimalUtil.getNotNull(propertyEntry.getValue().getValueFast((Object)row))));
            }
        }
        return calcResult;
    }

    public static Map<String, Object> calAmount(BillAmountInfo amountInfo) {
        return BillAmountHelper.calAmount(amountInfo, Boolean.FALSE);
    }

    public static Map<String, Object> calAmount(BillAmountInfo amountInfo, Boolean isCalDiscountRate) {
        Map<Object, Object> result = new HashMap(16);
        boolean inputamount = amountInfo.isInputamount();
        result = inputamount ? BillAmountHelper.calAmount4Amount(amountInfo, isCalDiscountRate) : BillAmountHelper.calAmount4Qty(amountInfo, isCalDiscountRate);
        return result;
    }

    private static Map<String, Object> calAmount4Qty(BillAmountInfo amountInfo, Boolean isCalDiscountRate) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        boolean isTax = amountInfo.isTax();
        BigDecimal qty = amountInfo.getQty();
        BigDecimal price = amountInfo.getPrice();
        BigDecimal priceAndTax = amountInfo.getPriceAndTax();
        BigDecimal taxRate = BigDecimalUtil.div100(amountInfo.getTaxRate());
        String discountType = amountInfo.getDiscountType();
        BigDecimal discountRate = amountInfo.getDiscountRate();
        int settleAmtPrecision = amountInfo.getSettleAmtPrecision();
        BigDecimal exChangeRate = amountInfo.getExChangeRate();
        BigDecimal amount = BigDecimalUtil.ZERO;
        BigDecimal taxAmount = BigDecimalUtil.ZERO;
        BigDecimal discountAmount = BigDecimalUtil.ZERO;
        BigDecimal amountAndTax = BigDecimalUtil.ZERO;
        BigDecimal curAmount = BigDecimalUtil.ZERO;
        BigDecimal curAmountAndTax = BigDecimalUtil.ZERO;
        BigDecimal curTaxAmount = BigDecimal.ZERO;
        if (isCalDiscountRate == null) {
            isCalDiscountRate = Boolean.FALSE;
        }
        if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
            discountRate = BigDecimal.ZERO;
            discountAmount = amountInfo.getDiscountAmount();
        }
        if (BigDecimalUtil.isNotBlank(qty)) {
            BigDecimal dividedDiscountRate;
            if (isTax && BigDecimalUtil.isNotBlank(priceAndTax)) {
                price = priceAndTax.divide(BigDecimalUtil.ONE.add(taxRate), 10, RoundingMode.HALF_UP);
                if (StringUtils.isBlank((CharSequence)discountType) || discountType.equals(DiscountTypeEnum.NULL.getValue())) {
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    if (BigDecimalUtil.isBlank(discountRate)) {
                        amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    } else {
                        dividedDiscountRate = BigDecimalUtil.div100(discountRate);
                        discountAmount = qty.multiply(priceAndTax).multiply(dividedDiscountRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                        amountAndTax = BigDecimalUtil.ONE.compareTo(dividedDiscountRate) == 0 ? qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    }
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && !isCalDiscountRate.booleanValue()) {
                    if (BigDecimalUtil.isBlank(discountRate)) {
                        amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    } else {
                        discountAmount = qty.multiply(discountRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                        amountAndTax = priceAndTax.compareTo(discountRate) == 0 ? qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    }
                } else if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
                    if (BigDecimalUtil.isBlank(discountAmount)) {
                        amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    } else {
                        discountAmount = discountAmount.setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                        discountRate = discountAmount.divide(qty, 10, RoundingMode.HALF_UP);
                        amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                        amountAndTax = amountAndTax.subtract(discountAmount);
                    }
                }
                taxAmount = amountAndTax.divide(BigDecimalUtil.ONE.add(taxRate), 10, RoundingMode.HALF_UP).multiply(taxRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                amount = amountAndTax.subtract(taxAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            } else if (!isTax && BigDecimalUtil.isNotBlank(price)) {
                priceAndTax = price.multiply(BigDecimalUtil.ONE.add(taxRate)).setScale(10, RoundingMode.HALF_UP);
                if (StringUtils.isBlank((CharSequence)discountType) || discountType.equals(DiscountTypeEnum.NULL.getValue())) {
                    amount = qty.multiply(price).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    if (BigDecimalUtil.isBlank(discountRate)) {
                        amount = qty.multiply(price).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    } else {
                        dividedDiscountRate = BigDecimalUtil.div100(discountRate);
                        discountAmount = qty.multiply(priceAndTax).multiply(dividedDiscountRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                        amount = qty.multiply(price).multiply(BigDecimalUtil.ONE.subtract(dividedDiscountRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    }
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && !isCalDiscountRate.booleanValue()) {
                    if (BigDecimalUtil.isBlank(discountRate)) {
                        amount = qty.multiply(price).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    } else {
                        discountAmount = qty.multiply(discountRate).multiply(BigDecimalUtil.ONE.add(taxRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                        amount = qty.multiply(price.subtract(discountRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    }
                } else if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
                    if (BigDecimalUtil.isBlank(discountAmount)) {
                        amount = qty.multiply(price).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    } else {
                        discountAmount = discountAmount.setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                        discountRate = discountAmount.divide(qty, 10, RoundingMode.HALF_UP).divide(BigDecimalUtil.ONE.add(taxRate), 10, RoundingMode.HALF_UP);
                        amount = qty.multiply(price.subtract(discountRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    }
                }
                taxAmount = amount.multiply(taxRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                amountAndTax = amount.add(taxAmount);
                amountAndTax = amountAndTax.setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            } else {
                priceAndTax = BigDecimalUtil.ZERO;
                price = BigDecimalUtil.ZERO;
            }
        } else if (isTax && BigDecimalUtil.isNotBlank(priceAndTax)) {
            priceAndTax = priceAndTax.setScale(10, RoundingMode.HALF_UP);
            price = priceAndTax.divide(BigDecimalUtil.ONE.add(taxRate), 10, RoundingMode.HALF_UP);
        } else if (!isTax && BigDecimalUtil.isNotBlank(price)) {
            price = price.setScale(10, RoundingMode.HALF_UP);
            priceAndTax = price.multiply(BigDecimalUtil.ONE.add(taxRate)).setScale(10, RoundingMode.HALF_UP);
        } else {
            priceAndTax = BigDecimalUtil.ZERO;
            price = BigDecimalUtil.ZERO;
        }
        if (!BigDecimalUtil.isZero(exChangeRate)) {
            int currencyAmtPrecision = amountInfo.getCurrencyAmtPrecision();
            boolean indirectRate = amountInfo.getIndirectExRate();
            curTaxAmount = CurrencyHelper.convert(taxAmount, exChangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
            if (isTax) {
                curAmountAndTax = CurrencyHelper.convert(amountAndTax, exChangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
                curAmount = curAmountAndTax.subtract(curTaxAmount);
            } else {
                curAmount = CurrencyHelper.convert(amount, exChangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
                curAmountAndTax = curAmount.add(curTaxAmount);
            }
        }
        result.put(amountInfo.getProperytMappingName("PRICE"), price);
        result.put(amountInfo.getProperytMappingName("PRICEANDTAX"), priceAndTax);
        result.put(amountInfo.getProperytMappingName("AMOUNT"), amount);
        result.put(amountInfo.getProperytMappingName("DISCOUNTAMOUNT"), discountAmount);
        result.put(amountInfo.getProperytMappingName("DISCOUNTRATE"), discountRate);
        result.put(amountInfo.getProperytMappingName("TAXAMOUNT"), taxAmount);
        result.put(amountInfo.getProperytMappingName("AMOUNTANDTAX"), amountAndTax);
        result.put(amountInfo.getProperytMappingName("CURAMOUNT"), curAmount);
        result.put(amountInfo.getProperytMappingName("CURTAXAMOUNT"), curTaxAmount);
        result.put(amountInfo.getProperytMappingName("CURAMOUNTANDTAX"), curAmountAndTax);
        return result;
    }

    private static Map<String, Object> calAmount4Amount(BillAmountInfo amountInfo, Boolean isCalDiscountRate) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        boolean isTax = amountInfo.isTax();
        BigDecimal qty = amountInfo.getQty();
        BigDecimal price = amountInfo.getPrice();
        BigDecimal priceAndTax = amountInfo.getPriceAndTax();
        BigDecimal taxRate = BigDecimalUtil.div100(amountInfo.getTaxRate());
        String discountType = amountInfo.getDiscountType();
        BigDecimal discountRate = amountInfo.getDiscountRate();
        int settleAmtPrecision = amountInfo.getSettleAmtPrecision();
        BigDecimal exChangeRate = amountInfo.getExChangeRate();
        BigDecimal amount = amountInfo.getAmount();
        BigDecimal taxAmount = amountInfo.getTaxAmount();
        BigDecimal discountAmount = amountInfo.getDiscountAmount();
        if (isCalDiscountRate == null) {
            isCalDiscountRate = Boolean.FALSE;
        }
        if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
            discountRate = BigDecimal.ZERO;
        }
        BigDecimal amountAndTax = amountInfo.getAmountAndTax();
        BigDecimal curAmount = BigDecimalUtil.ZERO;
        BigDecimal curTaxAmount = BigDecimal.ZERO;
        BigDecimal curAmountAndTax = BigDecimalUtil.ZERO;
        if (BigDecimalUtil.isNotBlank(qty)) {
            BigDecimal dividedDiscountRate;
            if (isTax && amountAndTax != null) {
                amountAndTax = amountAndTax.setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                taxAmount = amountAndTax.divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.HALF_UP).multiply(taxRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                amount = amountAndTax.subtract(taxAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                if (StringUtils.isBlank((CharSequence)discountType) || discountType.equals(DiscountTypeEnum.NULL.getValue())) {
                    priceAndTax = amountAndTax.divide(qty, 10, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    if (BigDecimalUtil.isBlank(discountRate)) {
                        priceAndTax = amountAndTax.divide(qty, 10, RoundingMode.HALF_UP);
                    } else {
                        dividedDiscountRate = BigDecimalUtil.div100(discountRate);
                        priceAndTax = BigDecimalUtil.equals(dividedDiscountRate, BigDecimal.ONE) ? BigDecimal.ZERO : amountAndTax.divide(qty, 10, RoundingMode.HALF_UP).divide(BigDecimal.ONE.subtract(dividedDiscountRate), 10, RoundingMode.HALF_UP);
                        discountAmount = priceAndTax.multiply(qty).multiply(dividedDiscountRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    }
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && !isCalDiscountRate.booleanValue()) {
                    if (BigDecimalUtil.isBlank(discountRate)) {
                        priceAndTax = amountAndTax.divide(qty, 10, RoundingMode.HALF_UP);
                    } else {
                        priceAndTax = amountAndTax.divide(qty, 10, RoundingMode.HALF_UP).add(discountRate);
                        discountAmount = discountRate.multiply(qty).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    }
                } else if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
                    if (BigDecimalUtil.isBlank(discountAmount)) {
                        priceAndTax = amountAndTax.divide(qty, 10, RoundingMode.HALF_UP);
                    } else {
                        discountRate = discountAmount.divide(qty, 10, RoundingMode.HALF_UP);
                        priceAndTax = amountAndTax.add(discountAmount).divide(qty, 10, RoundingMode.HALF_UP);
                    }
                }
                price = priceAndTax.divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.HALF_UP);
            } else if (!isTax && amount != null) {
                amount = amount.setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                taxAmount = amount.multiply(taxRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                amountAndTax = amount.add(taxAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                if (StringUtils.isBlank((CharSequence)discountType) || discountType.equals(DiscountTypeEnum.NULL.getValue())) {
                    price = amount.divide(qty, 10, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    if (BigDecimalUtil.isBlank(discountRate)) {
                        price = amount.divide(qty, 10, RoundingMode.HALF_UP);
                    } else {
                        dividedDiscountRate = BigDecimalUtil.div100(discountRate);
                        price = BigDecimalUtil.equals(dividedDiscountRate, BigDecimal.ONE) ? BigDecimal.ZERO : amount.divide(qty, 10, RoundingMode.HALF_UP).divide(BigDecimal.ONE.subtract(dividedDiscountRate), 10, RoundingMode.HALF_UP);
                        discountAmount = priceAndTax.multiply(qty).multiply(dividedDiscountRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    }
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && !isCalDiscountRate.booleanValue()) {
                    if (BigDecimalUtil.isBlank(discountRate)) {
                        price = amount.divide(qty, 10, RoundingMode.HALF_UP);
                    } else {
                        price = amount.divide(qty, 10, RoundingMode.HALF_UP).add(discountRate);
                        discountAmount = discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    }
                } else if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
                    if (BigDecimalUtil.isBlank(discountAmount)) {
                        price = amount.divide(qty, 10, RoundingMode.HALF_UP);
                    } else {
                        discountRate = discountAmount.divide(qty, 10, RoundingMode.HALF_UP).divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.HALF_UP);
                        price = amount.divide(qty, 10, RoundingMode.HALF_UP).add(discountRate);
                    }
                }
                priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate)).setScale(10, RoundingMode.HALF_UP);
            }
        } else {
            price = BigDecimal.ZERO;
            priceAndTax = BigDecimal.ZERO;
        }
        if (!BigDecimalUtil.isZero(exChangeRate)) {
            int currencyAmtPrecision = amountInfo.getCurrencyAmtPrecision();
            boolean indirectRate = amountInfo.getIndirectExRate();
            curTaxAmount = CurrencyHelper.convert(taxAmount, exChangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
            if (isTax) {
                curAmountAndTax = CurrencyHelper.convert(amountAndTax, exChangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
                curAmount = curAmountAndTax.subtract(curTaxAmount);
            } else {
                curAmount = CurrencyHelper.convert(amount, exChangeRate, indirectRate, currencyAmtPrecision, RoundingMode.HALF_UP);
                curAmountAndTax = curAmount.add(curTaxAmount);
            }
        }
        result.put(amountInfo.getProperytMappingName("PRICE"), price);
        result.put(amountInfo.getProperytMappingName("PRICEANDTAX"), priceAndTax);
        result.put(amountInfo.getProperytMappingName("AMOUNT"), amount);
        result.put(amountInfo.getProperytMappingName("DISCOUNTAMOUNT"), discountAmount);
        result.put(amountInfo.getProperytMappingName("DISCOUNTRATE"), discountRate);
        result.put(amountInfo.getProperytMappingName("TAXAMOUNT"), taxAmount);
        result.put(amountInfo.getProperytMappingName("AMOUNTANDTAX"), amountAndTax);
        result.put(amountInfo.getProperytMappingName("CURAMOUNT"), curAmount);
        result.put(amountInfo.getProperytMappingName("CURTAXAMOUNT"), curTaxAmount);
        result.put(amountInfo.getProperytMappingName("CURAMOUNTANDTAX"), curAmountAndTax);
        return result;
    }

    private static Map<String, String> mappingFilter(DynamicObjectType billType, Map<String, String> fieldMapping) {
        HashMap<String, String> filteredMapping = new HashMap<String, String>(8);
        for (Map.Entry<String, String> entry : fieldMapping.entrySet()) {
            String key = entry.getKey();
            if (billType.getProperty(key) == null) continue;
            filteredMapping.put(key, entry.getValue());
        }
        return filteredMapping;
    }

    private static Map<String, DynamicProperty> getEntryFieldProperties(DynamicObjectType entryType, Map<String, String> filteredMapping) {
        HashMap<String, DynamicProperty> entryFieldProperties = new HashMap<String, DynamicProperty>(8);
        for (Map.Entry<String, String> entry : filteredMapping.entrySet()) {
            DynamicProperty property = entryType.getProperty(entry.getValue());
            if (property == null) continue;
            entryFieldProperties.put(entry.getKey(), property);
        }
        return entryFieldProperties;
    }
}

