/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.param.ParameterWriter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BizGenerateParamHelper {
    private static final Log log = LogFactory.getLog(BizGenerateParamHelper.class);

    public static boolean exists(String entity, QFilter qf, Long orgID) {
        MainEntityType billForm;
        try {
            billForm = EntityMetadataCache.getDataEntityType((String)entity);
        }
        catch (KDException e) {
            log.error(e.getMessage());
            return false;
        }
        try {
            if (billForm != null) {
                String alias = billForm.getAlias();
                if (StringUtils.isNotEmpty((String)alias)) {
                    QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
                    if (orgID != null && !orgID.equals(0L) && StringUtils.isNotEmpty((String)billForm.getMainOrg())) {
                        qFilter.and(new QFilter(billForm.getMainOrg(), "=", (Object)orgID));
                    }
                    if (qf != null) {
                        qFilter.and(qf);
                    }
                    if (qFilter.toString().equals(QFilter.of((String)"1=1", (Object[])new Object[0]).toString())) {
                        StringBuilder sql = new StringBuilder("SELECT COUNT(FID) NUM FROM ").append(billForm.getAlias());
                        boolean result = (Boolean)DB.query((DBRoute)DBRoute.of((String)billForm.getDBRouteKey()), (String)sql.toString(), resultSet -> {
                            int num = 0;
                            while (resultSet.next()) {
                                num = resultSet.getInt("NUM");
                            }
                            if (num > 0) {
                                return true;
                            }
                            return false;
                        });
                        return result;
                    }
                    return QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{qFilter});
                }
                return false;
            }
            return false;
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            return false;
        }
    }

    public static void updateBillParam(String billForm, String param, Object value) {
        DynamicObject paramObject = ParameterReader.getBillParameter((String)billForm);
        paramObject.set(param, value);
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(paramObject.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(true);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        String jsonString = jser.serializeToString((Object)paramObject, null);
        ParameterWriter.saveBillParameter((String)billForm, (String)jsonString);
    }
}

