/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.common.context.CommonContext;

public class FetchPriceHelper {
    private static String HEAD_FLAG = "header";
    private static String ENTRY_FLAG = "entry";
    private static String RESULT_FLAG = "result";
    public static final String SPLIT = "\\.";
    private static final String QUOTE_RESULT_SEPARATOR = "\\$\\$";
    private static final String RESULT_SPLIT = "$$";
    private static final String ISCOVER_KEY = "iscover";
    private static final String PRICE_POSITION = "priceposition";
    private static final String SCHEMEENTRY = "schemeentry";
    private static final Log LOGGER = LogFactory.getLog(FetchPriceHelper.class);

    public static Map<Long, Map<String, Object>> fetchPriceConditonKey(Set<Long> orgIds, String entityType) {
        LOGGER.info("fetchquotekey start==" + TimeServiceHelper.now());
        HashMap quoteParam = new HashMap(16);
        Map priceMapKey = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"QuoteService", (String)"queryMapKeyIgnoreExp", (Object[])new Object[]{orgIds.toArray(new Long[orgIds.size()]), entityType, quoteParam});
        LOGGER.info("fetchquotekey end==" + TimeServiceHelper.now());
        return priceMapKey;
    }

    public static Map<Long, Map<String, Object>> fetchPriceConditonKey(Set<Long> orgIds, String entityType, boolean includeExpInfo) {
        Map<Long, Map<String, Object>> priceMapKey = FetchPriceHelper.fetchPriceConditonKey(orgIds, entityType);
        if (includeExpInfo) {
            return priceMapKey;
        }
        ArrayList removeKey = new ArrayList(priceMapKey.size());
        priceMapKey.forEach((k, v) -> {
            if (v.get("success") == null || Boolean.FALSE.equals(v.get("success"))) {
                removeKey.add(k);
            }
        });
        removeKey.forEach(rk -> {
            Map cfr_ignored_0 = (Map)priceMapKey.remove(rk);
        });
        LOGGER.info("priceMapKey.size()==" + priceMapKey.size());
        if (priceMapKey.size() == 0) {
            return null;
        }
        return priceMapKey;
    }

    public static Map<Long, List<Map<String, Object>>> buildMap4Entry(Map<Long, Map<String, Object>> priceMapKey, Map<Long, List<DynamicObject>> billMap) {
        HashMap<Long, List<Map<String, Object>>> propertiesMap = new HashMap<Long, List<Map<String, Object>>>();
        priceMapKey.forEach((k, v) -> {
            ArrayList parasList = new ArrayList();
            List bills = (List)billMap.get(k);
            String entryName = "";
            List entryKeys = (List)v.get(ENTRY_FLAG);
            if (entryKeys != null && entryKeys.size() > 0) {
                String[] fields = ((String)entryKeys.get(0)).split(SPLIT);
                entryName = fields[0];
            }
            for (int i = 0; bills != null && i < bills.size(); ++i) {
                DynamicObject bill = (DynamicObject)bills.get(i);
                HashMap headMap = new HashMap();
                if (v.get(HEAD_FLAG) != null) {
                    List headKeys = (List)v.get(HEAD_FLAG);
                    FetchPriceHelper.genPKValue(bill);
                    headKeys.forEach(l -> headMap.put(l, FetchPriceHelper.getValue(l.split(SPLIT), 0, bill)));
                }
                if (StringUtils.isNotEmpty((String)entryName)) {
                    DynamicObjectCollection col = bill.getDynamicObjectCollection(entryName);
                    if (col != null && col.size() > 0) {
                        for (int j = 0; col != null && j < col.size(); ++j) {
                            HashMap map = new HashMap();
                            DynamicObject entryInfo = (DynamicObject)col.get(j);
                            FetchPriceHelper.genPKValue(entryInfo);
                            entryKeys.forEach(l -> map.put(l, FetchPriceHelper.getValue(l.split(SPLIT), 1, entryInfo)));
                            map.putAll(headMap);
                            parasList.add(map);
                        }
                        continue;
                    }
                    parasList.add(headMap);
                    continue;
                }
                parasList.add(headMap);
            }
            propertiesMap.put((Long)k, parasList);
        });
        return propertiesMap;
    }

    public static Map<Long, Map<String, Object>> fetchPrice(String entityType, Map<Long, List<Map<String, Object>>> propertiesMap, Map<String, Object> quoteOtherParam) {
        LOGGER.info("fetchPrice start==" + TimeServiceHelper.now());
        Map priceMapObj = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"QuoteService", (String)"quoteByMapIgnoreExpWithParam", (Object[])new Object[]{propertiesMap, entityType, quoteOtherParam});
        LOGGER.info("fetchPrice end==" + TimeServiceHelper.now());
        return priceMapObj;
    }

    public static Map<Long, Map<String, Object>> integrationFetchPrice(Map<Long, List<DynamicObject>> billMap, String entityType, Map<String, Object> quoteOtherParam) {
        Set<Long> orgIds = billMap.keySet();
        Map<Long, Map<String, Object>> priceMapKey = FetchPriceHelper.fetchPriceConditonKey(orgIds, entityType, false);
        if (priceMapKey == null) {
            return null;
        }
        Map<Long, List<Map<String, Object>>> propertiesMap = FetchPriceHelper.buildMap4Entry(priceMapKey, billMap);
        Map<Long, Map<String, Object>> result = FetchPriceHelper.fetchPrice(entityType, propertiesMap, quoteOtherParam);
        return result;
    }

    public static Map<Long, Map<String, Object>> updateBillPriceInfo(Map<Long, List<DynamicObject>> billMap, String entityType, Map<String, Object> quoteOtherParam) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>();
        billMap.forEach((org, bills) -> {
            Map<Long, Map<String, Object>> subResult = FetchPriceHelper.autoQuote(org, bills.toArray(new DynamicObject[bills.size()]), entityType, quoteOtherParam);
            result.putAll(subResult);
        });
        return result;
    }

    private static Map<Long, Map<String, Object>> autoQuote(Long orgID, DynamicObject[] bills, String entityType, Map<String, Object> quoteOtherParam) {
        List resultFileds = null;
        LOGGER.info(FetchPriceHelper.getLogMsg("\u771f\u6b63\u5f00\u59cb\u81ea\u52a8\u53d6\u4ef7"));
        HashSet<Long> orgIDSet = new HashSet<Long>(1);
        orgIDSet.add(orgID);
        Map<Long, Map<String, Object>> priceMapKey = FetchPriceHelper.fetchPriceConditonKey(orgIDSet, entityType);
        if (priceMapKey != null && priceMapKey.get(orgID) != null && priceMapKey.get(orgID).get(RESULT_FLAG) != null) {
            resultFileds = (List)priceMapKey.get(orgID).get(RESULT_FLAG);
        }
        if (resultFileds == null) {
            return priceMapKey;
        }
        LOGGER.info(FetchPriceHelper.getLogMsg("\u83b7\u53d6\u4e86\u952e\u503c"));
        List<String> priceFileds = FetchPriceHelper.checkPostion(resultFileds);
        if (priceFileds == null || priceFileds.size() == 0) {
            LOGGER.info(FetchPriceHelper.getLogMsg("\u53d6\u4ef7\u670d\u52a1\u7ed3\u679c\u5b57\u6bb5\u5e76\u4e0d\u5b58\u5728"));
            return priceMapKey;
        }
        HashMap<Long, DynamicObject> pkToBill = new HashMap<Long, DynamicObject>(bills.length);
        HashMap<Long, DynamicObject> pkToBillEntry = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, List<Integer>> entryQuoteRows = new HashMap<Long, List<Integer>>(bills.length);
        HashMap<Long, Boolean> headQuote = new HashMap<Long, Boolean>(bills.length);
        for (DynamicObject bill : bills) {
            Long pk = FetchPriceHelper.setBillPkValue(bill, pkToBillEntry);
            pkToBill.put(pk, bill);
            if (HEAD_FLAG.equals(FetchPriceHelper.getCommonContextParam(PRICE_POSITION))) {
                headQuote.put(pk, FetchPriceHelper.isHeadQuote(bill, priceFileds));
            }
            if (!ENTRY_FLAG.equals(FetchPriceHelper.getCommonContextParam(PRICE_POSITION))) continue;
            List<Integer> seqs = FetchPriceHelper.getEntryQuoteRows(bill, priceFileds);
            entryQuoteRows.put(pk, seqs);
        }
        LOGGER.info(FetchPriceHelper.getLogMsg("\u5f00\u59cb\u53d6\u4ef7"));
        HashMap<Long, List<DynamicObject>> billMap = new HashMap<Long, List<DynamicObject>>();
        billMap.put(orgID, Arrays.asList(bills));
        Map<Long, List<Map<String, Object>>> propertiesMap = FetchPriceHelper.buildMap4Entry(priceMapKey, billMap);
        HashMap<String, Object> quoteParam = new HashMap<String, Object>();
        quoteParam.put("auto", "1");
        Map<Long, Map<String, Object>> priceTotalMap = FetchPriceHelper.fetchPrice(entityType, propertiesMap, quoteParam);
        Map<String, Object> priceMap = priceTotalMap.get(orgID);
        if (priceMap == null || priceMap != null && Boolean.FALSE.equals(priceMap.get("success"))) {
            LOGGER.info("orgid=" + orgID + " " + FetchPriceHelper.getLogMsg("\u53d6\u4ef7\u5f02\u5e38"));
            return priceTotalMap;
        }
        LOGGER.info(FetchPriceHelper.getLogMsg("\u586b\u5145\u4ef7\u683c"));
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityType);
        Map allFields = mainEntityType.getAllFields();
        if (StringUtils.isNotEmpty((String)FetchPriceHelper.getCommonContextParam(SCHEMEENTRY))) {
            priceMap.forEach((k, v) -> {
                String[] fileds = k.split(QUOTE_RESULT_SEPARATOR);
                if (fileds.length == 2) {
                    DynamicObject bill;
                    Long billID = Long.valueOf(fileds[0]);
                    String resultField = fileds[1];
                    IDataEntityProperty filedProperty = (IDataEntityProperty)allFields.get(resultField);
                    if (pkToBill.get(billID) != null && (bill = (DynamicObject)pkToBill.get(billID)).get(resultField) == null) {
                        FetchPriceHelper.setPriceValue(filedProperty, bill, resultField, v, mainEntityType);
                    }
                } else if (fileds.length == 4) {
                    Long billID = Long.valueOf(fileds[0]);
                    Long billEntryID = Long.valueOf(fileds[1]);
                    int seq = Integer.parseInt(fileds[2]);
                    String resultField = fileds[3];
                    IDataEntityProperty filedProperty = (IDataEntityProperty)allFields.get(resultField);
                    boolean setting = false;
                    if (!ISCOVER_KEY.equals(resultField)) {
                        String iscover_Key = fileds[0] + RESULT_SPLIT + fileds[1] + RESULT_SPLIT + fileds[2] + RESULT_SPLIT + ISCOVER_KEY;
                        Object iscover_value = priceMap.get(iscover_Key);
                        if (iscover_value == null || !"B".equals(iscover_value.toString())) {
                            if (entryQuoteRows.get(billID) != null && ((List)entryQuoteRows.get(billID)).contains(seq)) {
                                setting = true;
                            }
                        } else {
                            setting = true;
                        }
                    }
                    if (setting && pkToBillEntry.get(billEntryID) != null) {
                        DynamicObject entryInfo = (DynamicObject)pkToBillEntry.get(billEntryID);
                        FetchPriceHelper.setPriceValue(filedProperty, entryInfo, resultField, v, mainEntityType);
                    }
                }
            });
        } else {
            priceMap.forEach((k, v) -> {
                String[] fileds = k.split(QUOTE_RESULT_SEPARATOR);
                if (fileds.length == 2) {
                    Long billID = Long.valueOf(fileds[0]);
                    String resultField = fileds[1];
                    boolean setting = false;
                    if (!ISCOVER_KEY.equals(resultField)) {
                        String iscover_Key = fileds[0] + RESULT_SPLIT + ISCOVER_KEY;
                        Object iscover_value = priceMap.get(iscover_Key);
                        if (iscover_value == null || !"B".equals(iscover_value.toString())) {
                            if (pkToBill.get(billID) != null && headQuote.size() > 0 && ((Boolean)headQuote.get(billID)).booleanValue()) {
                                DynamicObject bill = (DynamicObject)pkToBill.get(billID);
                                if (bill.get(resultField) == null) {
                                    setting = true;
                                } else if (bill.get(resultField) instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)bill.get(resultField)) == 0) {
                                    setting = true;
                                }
                            }
                        } else {
                            setting = true;
                        }
                        IDataEntityProperty filedProperty = (IDataEntityProperty)allFields.get(resultField);
                        if (setting && pkToBill.get(billID) != null && headQuote.size() > 0 && ((Boolean)headQuote.get(billID)).booleanValue()) {
                            DynamicObject bill = (DynamicObject)pkToBill.get(billID);
                            FetchPriceHelper.setPriceValue(filedProperty, bill, resultField, v, mainEntityType);
                        }
                    }
                }
            });
        }
        return priceTotalMap;
    }

    private static List<String> checkPostion(List<String> resultFileds) {
        ArrayList resultTotalFields = new ArrayList();
        resultFileds.forEach(p -> {
            if (p != null && !resultTotalFields.contains(p)) {
                resultTotalFields.add(p);
            }
        });
        ArrayList<String> priceTotalFields = new ArrayList<String>();
        if (resultTotalFields.size() > 0) {
            String resultFields = (String)resultTotalFields.get(0);
            boolean isHead = false;
            if (resultFields.split(SPLIT).length == 1) {
                FetchPriceHelper.putCommonContextParam(PRICE_POSITION, HEAD_FLAG);
                isHead = true;
            } else {
                FetchPriceHelper.putCommonContextParam(PRICE_POSITION, ENTRY_FLAG);
            }
            if (isHead) {
                priceTotalFields = resultTotalFields;
            } else {
                for (int i = 0; i < resultTotalFields.size(); ++i) {
                    String r = (String)resultTotalFields.get(i);
                    String[] resultField = r.split(SPLIT);
                    priceTotalFields.add(resultField[resultField.length - 1]);
                    FetchPriceHelper.putCommonContextParam(SCHEMEENTRY, resultField[resultField.length - 2]);
                }
            }
        }
        return priceTotalFields;
    }

    private static boolean isHeadQuote(DynamicObject curObj, List<String> priceFileds) {
        boolean needQuote = true;
        for (String filed : priceFileds) {
            if (!(curObj.get(filed) instanceof BigDecimal) || ((BigDecimal)curObj.get(filed)).compareTo(BigDecimal.ZERO) == 0) continue;
            needQuote = false;
            break;
        }
        return needQuote;
    }

    private static List<Integer> getEntryQuoteRows(DynamicObject bill, List<String> priceFileds) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(FetchPriceHelper.getCommonContextParam(SCHEMEENTRY));
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (DynamicObject entryInfo : entrys) {
            for (String filed : priceFileds) {
                if (entryInfo.get(filed) instanceof BigDecimal && ((BigDecimal)entryInfo.get(filed)).compareTo(BigDecimal.ZERO) != 0) break;
                rows.add(entryInfo.getInt("seq"));
            }
        }
        return rows;
    }

    private static void setPriceValue(IDataEntityProperty filedProperty, DynamicObject entryInfo, String resultField, Object v, MainEntityType mainEntityType) {
        if (filedProperty instanceof BasedataProp) {
            FetchPriceHelper.setBaseDataFiled(entryInfo, resultField, v, (EntityType)mainEntityType);
        } else {
            entryInfo.set(resultField, v);
        }
    }

    private static void setBaseDataFiled(DynamicObject curObj, String filed, Object value, EntityType tgtMainType) {
        BasedataProp prop = (BasedataProp)tgtMainType.findProperty(filed);
        EntityType entityType = (EntityType)prop.getComplexType();
        DynamicObject object = new DynamicObject((DynamicObjectType)entityType);
        object.set("id", value);
        curObj.set(filed, (Object)object);
    }

    private static Long setBillPkValue(DynamicObject bill, Map<Long, DynamicObject> pkToBillEntry) {
        Long pk = FetchPriceHelper.genPKValue(bill);
        if (StringUtils.isNotEmpty((String)FetchPriceHelper.getCommonContextParam(SCHEMEENTRY))) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(FetchPriceHelper.getCommonContextParam(SCHEMEENTRY));
            for (DynamicObject entryInfo : entrys) {
                Long entryPK = FetchPriceHelper.genPKValue(entryInfo);
                pkToBillEntry.put(entryPK, entryInfo);
            }
        }
        return pk;
    }

    private static Long genPKValue(DynamicObject curObj) {
        if (curObj.getPkValue() == null || Long.valueOf("0").equals(curObj.getPkValue())) {
            curObj.set("id", (Object)DBServiceHelper.genGlobalLongId());
            return (Long)curObj.get("id");
        }
        return (Long)curObj.getPkValue();
    }

    private static String getLogMsg(String msg) {
        return "quote=" + msg;
    }

    private static Object getValue(String[] dividePropertys, int startIndex, DynamicObject source) {
        if (startIndex < dividePropertys.length) {
            try {
                if (startIndex == dividePropertys.length - 1) {
                    if (source.get(dividePropertys[startIndex]) instanceof DynamicObject) {
                        return ((DynamicObject)source.get(dividePropertys[startIndex])).getPkValue();
                    }
                    return source.get(dividePropertys[startIndex]);
                }
                source = source.getDynamicObject(dividePropertys[startIndex]);
                return FetchPriceHelper.getValue(dividePropertys, ++startIndex, source);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static String getCommonContextParam(String key) {
        CommonContext commonContext = CommonContext.get();
        Map<String, String> ProperytMapping = commonContext.getProperytMapping();
        return ProperytMapping.get(key);
    }

    private static void putCommonContextParam(String key, String value) {
        CommonContext commonContext = CommonContext.get();
        Map<String, String> ProperytMapping = commonContext.getProperytMapping();
        ProperytMapping.put(key, value);
    }
}

