/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.BaseDataHelper;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class OperatorHelper {
    public static boolean checkOperatorByOrgAndUser(String appId, String orgViewConst, String OperatorGrpType, Long orgId, Long userID) {
        long currUserID = Long.parseLong(RequestContext.get().getUserId());
        Boolean operatorgroupisolate = (Boolean)SysParamHelper.getSysParam(appId, orgViewConst, orgId, "foperatorgroupisolate");
        if (operatorgroupisolate.booleanValue() && currUserID != userID) {
            return false;
        }
        return !CommonUtils.isNull(OperatorHelper.getOperatorByOrgAndUser(orgId, OperatorGrpType, userID));
    }

    public static boolean checkOperatorGrpByOrgAndUser(String appId, String orgViewConst, String OperatorGrpType, Long orgId, Long operatorGrpID, Long userID) {
        long currUserID = Long.parseLong(RequestContext.get().getUserId());
        Boolean operatorgroupisolate = (Boolean)SysParamHelper.getSysParam(appId, orgViewConst, orgId, "foperatorgroupisolate");
        return operatorgroupisolate == false || currUserID == userID;
    }

    public static List<Long> getAllOperatorGrps(String appId, String orgViewConst, String OperatorGrpType, Long orgId) {
        RequestContext requestContext = RequestContext.get();
        long userID = Long.parseLong(requestContext.getUserId());
        return OperatorHelper.getAllOperatorGrps(appId, orgViewConst, OperatorGrpType, orgId, userID);
    }

    public static List<Long> getAllOperatorGrps(String appId, String orgViewConst, String OperatorGrpType, Long orgId, Long userID) {
        Boolean operatorgroupisolate = (Boolean)SysParamHelper.getSysParam(appId, orgViewConst, orgId, "foperatorgroupisolate");
        List<Long> operatorGrps = null;
        if (operatorgroupisolate.booleanValue()) {
            OperatorHelper.getOperatorGrpByOrgAndUser(orgId, OperatorGrpType, userID);
        } else {
            OperatorHelper.getOperatorGrpByOrg(orgId, OperatorGrpType);
        }
        return operatorGrps;
    }

    public static QFilter getAllOperatorGrpQFilter(String appId, String orgViewConst, String OperatorGrpType, List<Long> orgIds) {
        RequestContext requestContext = RequestContext.get();
        long userID = Long.parseLong(requestContext.getUserId());
        return OperatorHelper.getAllOperatorGrpQFilter(appId, orgViewConst, OperatorGrpType, orgIds, userID);
    }

    public static QFilter getAllOperatorGrpQFilter(String appId, String orgViewConst, String OperatorGrpType, List<Long> orgIds, Long userID) {
        if (CommonUtils.isNull(orgIds)) {
            return null;
        }
        QFilter qf = null;
        for (Long orgId : orgIds) {
            Boolean operatorgroupisolate = (Boolean)SysParamHelper.getSysParam(appId, orgViewConst, orgId, "foperatorgroupisolate");
            QFilter temp = null;
            temp = operatorgroupisolate != false ? QFilter.of((String)"org = ? and operatorgroup in (?)", (Object[])new Object[]{orgId, OperatorHelper.getOperatorGrpByOrgAndUser(orgId, OperatorGrpType, userID)}) : QFilter.of((String)"org = ? and operatorgroup in (?)", (Object[])new Object[]{orgId, OperatorHelper.getOperatorGrpByOrg(orgId, OperatorGrpType)});
            if (qf == null) {
                qf = temp;
                continue;
            }
            qf.or(temp);
        }
        return qf;
    }

    public static List<Long> getOperatorGrpByOrgAndUser(Long orgId, String OperatorGrpType, Long userID) {
        List<Long> operatorGrpList = new ArrayList<Long>();
        QFilter qf1 = BaseDataHelper.getBaseDataFilterByOrg("bd_operatorgroup", orgId, true);
        QFilter qf2 = new QFilter("operatorid", "=", (Object)userID);
        QFilter qf3 = new QFilter("opergrptype", "=", (Object)OperatorGrpType);
        QFilter qf4 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (String)"id,operatorgrpid", (QFilter[])new QFilter[]{qf1, qf2, qf3, qf4});
        if (!CommonUtils.isNull(map)) {
            operatorGrpList = map.values().stream().map(dym -> dym.getLong("operatorgrpid")).collect(Collectors.toList());
        }
        return operatorGrpList;
    }

    public static List<Long> getOperatorGrpByOrg(Long orgId, String OperatorGrpType) {
        List<Long> operatorGrpList = new ArrayList<Long>();
        QFilter qf1 = BaseDataHelper.getBaseDataFilterByOrg("bd_operatorgroup", orgId, true);
        QFilter qf2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpType);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{qf1, qf2});
        if (!CommonUtils.isNull(map)) {
            operatorGrpList = map.values().stream().map(dym -> dym.getLong("id")).collect(Collectors.toList());
        }
        return operatorGrpList;
    }

    public static List<Long> getOperatorByOrgAndUser(Long orgId, String OperatorGrpType, Long userID) {
        List<Long> operatorGroupList = OperatorHelper.getOperatorGrpByOrg(orgId, OperatorGrpType);
        List<Long> operatorList = new ArrayList<Long>();
        QFilter qf1 = new QFilter("operatorgrpid", "in", operatorGroupList);
        QFilter qf2 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
        QFilter qf3 = new QFilter("operatorid", "=", (Object)userID);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        if (!CommonUtils.isNull(map)) {
            operatorList = map.values().stream().map(dym -> dym.getLong("id")).collect(Collectors.toList());
        }
        return operatorList;
    }
}

