/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class OrgHelper {
    public static Map<String, Object> getCompanyByOrg(Long orgId, Boolean isBizUnit, Boolean isSerrchUpward) {
        Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)isBizUnit, (Boolean)isSerrchUpward);
        return map;
    }

    public static Long getToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        Long toOrgId = OrgUnitServiceHelper.getToOrg((String)fromOrgType, (String)toOrgType, (Long)fromOrgId, (boolean)isIncludeFromOrgSelf);
        return toOrgId;
    }

    public static List<Long> getAllToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        List toOrgIds = OrgUnitServiceHelper.getAllToOrg((String)fromOrgType, (String)toOrgType, (Long)fromOrgId, (boolean)isIncludeFromOrgSelf);
        return toOrgIds;
    }

    public static boolean checkHasPermissionOrg(String entityName, String orgViewType, Long orgId, Long userID) {
        List<Long> orgs = OrgHelper.getHasPermissionOrgs(entityName, orgViewType, userID);
        if (orgs == null) {
            return false;
        }
        return orgs.contains(orgId);
    }

    public static List<Long> getHasPermissionOrgs(String entityName, String orgViewType, Long userID) {
        List hasPermissionOrgs;
        if (CommonUtils.isNull(userID)) {
            userID = UserServiceHelper.getCurrentUserId();
        }
        if (CommonUtils.isNull(hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType))) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    public static Long getDefaultOrg(String entityName, String orgViewType, Long userID) {
        long orgId = RequestContext.get().getOrgId();
        List<Long> orgs = OrgHelper.getHasPermissionOrgs(entityName, orgViewType, userID);
        if (orgs == null) {
            return null;
        }
        if (orgs.contains(orgId)) {
            return orgId;
        }
        return orgs.get(0);
    }

    public static Map<String, Object> getOrgRelation(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        if (orgId == null) {
            return null;
        }
        OrgRelationParam orgRelationParam = OrgHelper.buildOrgRelationParam(orgId, fromViewType, toViewType, getDirectOrgType);
        Map orgRelation = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)orgRelationParam);
        return orgRelation;
    }

    public static List<Long> getOrgRelationIncludeSelf(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        if (orgId == null) {
            return null;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(8);
        OrgRelationParam orgRelationParam = OrgHelper.buildOrgRelationParam(orgId, fromViewType, toViewType, getDirectOrgType);
        Map orgRelation = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)orgRelationParam);
        if (orgRelation != null) {
            orgIds.addAll((List)orgRelation.get("orgId"));
        }
        String targetViewType = null;
        if ("toorg".equals(getDirectOrgType)) {
            targetViewType = toViewType;
        }
        if ("fromorg".equals(getDirectOrgType)) {
            targetViewType = fromViewType;
        }
        if (orgIds.size() > 0 && OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)targetViewType)) {
            orgIds.add(orgId);
        }
        return orgIds;
    }

    private static OrgRelationParam buildOrgRelationParam(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setFromViewType(fromViewType);
        param.setToViewType(toViewType);
        param.setDirectViewType(getDirectOrgType);
        return param;
    }

    public static Long getDefaultDepartment(Long userID) {
        Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
        return deptID;
    }

    public static DynamicObject getDefaultDepartmentObject(Long userID) {
        Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
        DynamicObject dept = BusinessDataServiceHelper.loadSingleFromCache((Object)deptID, (String)"bos_org");
        return dept;
    }

    public static DynamicObject getDefaultDepartmentObject() {
        Long userId = UserServiceHelper.getCurrentUserId();
        if (userId != null && !userId.equals(0L)) {
            return OrgHelper.getDefaultDepartmentObject(userId);
        }
        return null;
    }

    public static boolean checkDepartment(Long orgId, Long userID, Long deptId) {
        if (orgId == null) {
            return false;
        }
        List<Long> deptIDs = OrgHelper.getAllDefaultDepartment(orgId, userID);
        return deptIDs != null && deptIDs.contains(deptId) && OrgHelper.checkDepartmentIsfreeze(deptId) == false;
    }

    public static List<Long> getAllDefaultDepartment(Long orgId, Long userID) {
        List<Long> deptIDs = OrgHelper.getAllToOrg("15", "01", orgId, true);
        if (deptIDs != null && userID != null) {
            Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
            deptIDs.add(deptID);
        }
        return deptIDs;
    }

    public static Boolean checkDepartmentIsfreeze(Long deptId) {
        if (deptId == null) {
            return Boolean.FALSE;
        }
        Boolean result = Boolean.FALSE;
        QFilter idQFilter = new QFilter("org", "=", (Object)deptId);
        QFilter isFreezeQFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter viewQFilter = new QFilter("view", "=", (Object)1);
        DynamicObject dept = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"id,org,isfreeze", (QFilter[])new QFilter[]{idQFilter, isFreezeQFilter, viewQFilter});
        if (dept == null) {
            result = Boolean.TRUE;
        }
        return result;
    }

    public static Long getSettleOrg(Long orgId) {
        Map<String, Object> map;
        Long settleOrgId = null;
        if (orgId != null && (map = OrgHelper.getCompanyByOrg(orgId, Boolean.FALSE, Boolean.TRUE)) != null && map.get("id") != null) {
            settleOrgId = (Long)map.get("id");
            return settleOrgId;
        }
        return settleOrgId;
    }

    public static Long getSettleOrg(Long orgId, IPageCache pageCache) {
        if (orgId != null) {
            String settleOrgValue = pageCache.get(orgId + "settleorg");
            if (StringUtils.isNotBlank((CharSequence)settleOrgValue)) {
                return Long.valueOf(settleOrgValue);
            }
            Map<String, Object> map = OrgHelper.getCompanyByOrg(orgId, Boolean.FALSE, Boolean.TRUE);
            if (map != null && map.get("id") != null) {
                Long settleOrgId = (Long)map.get("id");
                pageCache.put(orgId + "settleorg", settleOrgId.toString());
                return settleOrgId;
            }
        }
        return null;
    }

    public static Long getOrgForFormDefValue(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        if (orgId == null) {
            return null;
        }
        OrgRelationParam orgRelationParam = OrgHelper.buildOrgRelationParam(orgId, fromViewType, toViewType, getDirectOrgType);
        Long defaultOrgId = OrgUnitServiceHelper.getOrgForFormDefValue((OrgRelationParam)orgRelationParam);
        return defaultOrgId;
    }

    public static DynamicObject getOrgForFormDefObjValue(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        if (orgId == null) {
            return null;
        }
        OrgRelationParam orgRelationParam = OrgHelper.buildOrgRelationParam(orgId, fromViewType, toViewType, getDirectOrgType);
        Long defaultOrgId = OrgUnitServiceHelper.getOrgForFormDefValue((OrgRelationParam)orgRelationParam);
        if (defaultOrgId != null && !defaultOrgId.equals(0L)) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)defaultOrgId, (String)"bos_org");
        }
        return null;
    }
}

