/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kd.bos.entity.tree.TreeNode;

public class TreeNodeHelper {
    public static TreeNode findNodeDFS(TreeNode root, String targetText) {
        TreeNode child;
        if (root == null || targetText == null) {
            return null;
        }
        if (root.getText() != null && root.getText().contains(targetText)) {
            return root;
        }
        TreeNode result = null;
        Iterator iterator = root.getChildren().iterator();
        while (iterator.hasNext() && (result = TreeNodeHelper.findNodeDFS(child = (TreeNode)iterator.next(), targetText)) == null) {
        }
        return result;
    }

    public static TreeNode findNodeBFS(TreeNode root, String targetText) {
        if (root == null || targetText == null) {
            return null;
        }
        LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
        queue.offer(root);
        while (!queue.isEmpty()) {
            TreeNode curr = (TreeNode)queue.poll();
            if (curr.getText() != null && curr.getText().contains(targetText)) {
                return curr;
            }
            if (curr.getChildren() == null) continue;
            for (TreeNode child : curr.getChildren()) {
                queue.offer(child);
            }
        }
        return null;
    }

    public static List<TreeNode> findNodesByText(TreeNode node, String targetText) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        if (node == null) {
            return result;
        }
        if (node.getText().contains(targetText)) {
            result.add(node);
        }
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                result.addAll(TreeNodeHelper.findNodesByText(child, targetText));
            }
        }
        return result;
    }

    public static List<TreeNode> getLeafNodes(TreeNode root) {
        ArrayList<TreeNode> leafNodes = new ArrayList<TreeNode>();
        if (root == null) {
            return leafNodes;
        }
        if (root.getChildren() == null) {
            leafNodes.add(root);
        } else {
            for (TreeNode child : root.getChildren()) {
                leafNodes.addAll(TreeNodeHelper.getLeafNodes(child));
            }
        }
        return leafNodes;
    }

    public static List<TreeNode> getAllNodes(TreeNode root) {
        ArrayList<TreeNode> allNodes = new ArrayList<TreeNode>();
        if (root == null) {
            return allNodes;
        }
        allNodes.add(root);
        if (root.getChildren() != null) {
            for (TreeNode child : root.getChildren()) {
                allNodes.addAll(TreeNodeHelper.getAllNodes(child));
            }
        }
        return allNodes;
    }
}

