/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.helper.botp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.botp.PluginCallImpl;
import kd.mpscmm.msbd.business.helper.botp.SOAmountInfo;
import kd.sdk.scmc.sm.extpoint.IAmountCalculateCasePlugin;

public class SalOrderDefValueHelper {
    private static final Log log = LogFactory.getLog(SalOrderDefValueHelper.class);
    private static final String SM_BILLTYPEPARAMETER = "sm_billtypeparam";
    private static final String APPID = "/JJVQ13HQZAJ";
    private Map<Long, DynamicObject> stockOrgMap = new HashMap<Long, DynamicObject>(10);
    private Map<Long, DynamicObject> settleOrgMap = new HashMap<Long, DynamicObject>(10);
    private Map<Long, DynamicObject> ownerMap = new HashMap<Long, DynamicObject>(10);
    private Map<String, DynamicObject> cacheDymMap = new HashMap<String, DynamicObject>(10);
    private static final String ENTRY_ID = "entrynum";
    private static final String TOTALALLAMOUNT = "totalallamount";
    private static final String BIZTIME = "biztime";
    private static final String AMOUNTCONDITION = "amountcondition";
    private static final String ISPAYRATE = "ispayrate";
    private static final String SETTLECURRENCY = "settlecurrency";
    private static final String ENTRY_ITEMNAME = "itemname";
    private static final String ENTRY_AMOUNT = "amount";
    private static final String ENTRY_RATE = "rate";
    private static final String ENTRY_ISPREPAY = "isprepay";
    private static final String ENTRY_AMOUNTDATE = "amountdate";
    private static final String CHANGETYPE = "changetype";
    private static final String PLANTYPE = "plantype";
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static String BASECURRRENCY = "baseCurrencyID";
    private static String EXRATETABLE = "exchangeRateTableID";
    private static String EXRATETABLE_DT = "bd_exratetable";
    private static String CURRENCY_DT = "bd_currency";

    private SalOrderDefValueHelper() {
    }

    public static List<DynamicObject> batchSetSalOrdeDefValue(List<DynamicObject> bills, Boolean isProcessOtherCustome, Boolean isCaculateAmount) {
        if (bills == null || bills.isEmpty()) {
            return bills;
        }
        SalOrderDefValueHelper helper = new SalOrderDefValueHelper();
        return helper.batchSetDefValue(bills, isProcessOtherCustome, isCaculateAmount);
    }

    private List<DynamicObject> batchSetDefValue(List<DynamicObject> bills, Boolean isProcessOtherCustome, Boolean isCaculateAmount) {
        for (DynamicObject bill : bills) {
            DynamicObject billType;
            if (bill == null || (billType = bill.getDynamicObject("billtype")) == null) continue;
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject bizType = bill.getDynamicObject("biztype");
            if (bizType == null) {
                bizType = this.getDefaultBizTypeObject("sm_salorder", (Long)billType.getPkValue(), SM_BILLTYPEPARAMETER);
                bill.set("biztype", (Object)bizType);
            }
            this.setDefaultCustomerValue(bill, "customer");
            this.processCustomer(bill, isProcessOtherCustome);
            this.setDefaultOperatorGroup(bill);
            this.setDefaultDept(bill);
            DynamicObjectCollection entrycols = bill.getDynamicObjectCollection("billentry");
            if (entrycols.size() > 0) {
                this.setLineTypeDefaultValue(entrycols, bizType);
                for (int i = 0; i < entrycols.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entrycols.get(i);
                    DynamicObject material = entry.getDynamicObject("material");
                    if (material != null) {
                        DynamicObject masterMaterial = entry.getDynamicObject("materialmasterid");
                        if (masterMaterial == null && material != null && (masterMaterial = material.getDynamicObject("masterid")) != null) {
                            entry.set("materialmasterid", (Object)masterMaterial);
                        }
                        if (entry.get("productline") == null) {
                            entry.set("productline", (Object)material.getDynamicObject("masterid").getDynamicObject("productline"));
                        }
                    }
                    this.processBotpOrg(org, entry);
                    if (entry.getBigDecimal("baseqty") == null || entry.getBigDecimal("auxqty") == null || BigDecimal.ZERO.compareTo(entry.getBigDecimal("baseqty")) == 0 || BigDecimal.ZERO.compareTo(entry.getBigDecimal("auxqty")) == 0) {
                        this.calcBaseQtyAndAuxQty(bill, i);
                    }
                    if (!kd.bos.util.StringUtils.isEmpty((String)entry.getString("discounttype"))) continue;
                    entry.set("discounttype", (Object)"NULL");
                }
                this.calculateDeliverUpAndDownQty(bill);
                this.processControlDay(bill);
                this.calcMinOrderBaseQty(bill);
            }
            if (isCaculateAmount.booleanValue()) {
                this.processAmount4BotpConvert(bill);
            }
            this.changeAmountConditionForDynamicObject(this.getParaMap(), bill);
        }
        return bills;
    }

    private DynamicObject loadSingleFromCache(Object pkId, String entityNo) {
        String key;
        DynamicObject dymObj;
        if (this.isNull(entityNo) || this.isNull(pkId)) {
            return null;
        }
        if (this.cacheDymMap == null) {
            this.cacheDymMap = new HashMap<String, DynamicObject>(8);
        }
        if ((dymObj = this.cacheDymMap.get(key = entityNo.concat("_").concat(pkId.toString()))) == null) {
            DynamicObject dym = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)entityNo);
            this.cacheDymMap.put(key, dym);
            return dym;
        }
        return dymObj;
    }

    private Map getParaMap() {
        HashMap<String, String> paraMap = new HashMap<String, String>(32);
        paraMap.put("appid", APPID);
        paraMap.put("viewtype", "03");
        paraMap.put(ENTRY_ID, "recplanentry");
        paraMap.put(TOTALALLAMOUNT, TOTALALLAMOUNT);
        paraMap.put(BIZTIME, "bizdate");
        paraMap.put(AMOUNTCONDITION, "reccondition");
        paraMap.put(ISPAYRATE, ISPAYRATE);
        paraMap.put(SETTLECURRENCY, SETTLECURRENCY);
        paraMap.put(ENTRY_ITEMNAME, "r_itemname");
        paraMap.put(ENTRY_AMOUNT, "r_recadvanceamount");
        paraMap.put(ENTRY_RATE, "r_recadvancerate");
        paraMap.put(ENTRY_ISPREPAY, "r_needrecadvance");
        paraMap.put(ENTRY_AMOUNTDATE, "r_duedate");
        paraMap.put(CHANGETYPE, "recentrychangetype");
        paraMap.put(PLANTYPE, "sales");
        return paraMap;
    }

    private void processCustomer(DynamicObject obj, Boolean isProcessOtherCustome) {
        Long linkmanpk;
        DynamicObject linkman;
        String address = obj.getString("address");
        DynamicObject customer = obj.getDynamicObject("customer");
        if (customer == null) {
            return;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)address)) {
            obj.set("address", (Object)this.getAddress(customer));
        }
        DynamicObject customerSettleCurrency = customer.getDynamicObject("settlementcyid");
        Object settlecurrency = obj.get(SETTLECURRENCY);
        if (settlecurrency == null && customerSettleCurrency != null) {
            obj.set(SETTLECURRENCY, (Object)customerSettleCurrency);
        }
        if ((linkman = obj.getDynamicObject("linkman")) == null && (linkmanpk = this.getLinkman(customer)) != null) {
            DynamicObject lmDy = this.loadSingleFromCache(linkmanpk, "bd_customerlinkman");
            obj.set("linkman", (Object)lmDy);
        }
        if (obj.getDynamicObject("reccondition") == null) {
            DynamicObject reccondition = customer.getDynamicObject("receivingcondid");
            if (reccondition != null) {
                reccondition = this.loadSingleFromCache(reccondition.getPkValue(), "bd_reccondition");
                obj.set("reccondition", (Object)reccondition);
            } else {
                obj.set("reccondition", null);
            }
        }
        if (isProcessOtherCustome.booleanValue()) {
            if (obj.get("payingcustomer") == null) {
                obj.set("payingcustomer", (Object)this.getCustomerValueOriginal(customer, "paymentcustomerid"));
            }
            if (obj.get("settlecustomer") == null) {
                obj.set("settlecustomer", (Object)this.getCustomerValueOriginal(customer, "invoicecustomerid"));
            }
            DynamicObject recCustomer = obj.getDynamicObject("reccustomer");
            if (customer != null && recCustomer == null) {
                DynamicObject recLinkman = null;
                String recAddress = null;
                if (customer.getDynamicObject("delivercustomerid") == null || customer.getLong("id") == customer.getDynamicObject("delivercustomerid").getLong("id")) {
                    recCustomer = this.getCustomerValueOriginal(customer, "delivercustomerid");
                    if (recCustomer != null) {
                        Long linkmanpk2 = this.getLinkman(recCustomer);
                        if (linkmanpk2 != null) {
                            recLinkman = this.loadSingleFromCache(linkmanpk2, "bd_customerlinkman");
                        }
                        recAddress = this.getAddress(recCustomer);
                    }
                } else {
                    recCustomer = this.getCustomerValueOriginal(customer, "delivercustomerid");
                    if (recCustomer != null) {
                        Long linkmanpk3 = this.getLinkman(recCustomer = this.loadSingleFromCache(recCustomer.getPkValue(), "bd_customer"));
                        if (linkmanpk3 != null) {
                            recLinkman = this.loadSingleFromCache(linkmanpk3, "bd_customerlinkman");
                        }
                        recAddress = this.getAddress(recCustomer);
                    }
                }
                if (obj.get("reccustomer") == null) {
                    obj.set("reccustomer", (Object)recCustomer);
                }
                if (obj.get("reclinkman") == null) {
                    obj.set("reclinkman", (Object)recLinkman);
                }
                if (kd.bos.util.StringUtils.isEmpty((String)obj.getString("receiveaddress"))) {
                    obj.set("receiveaddress", (Object)recAddress);
                }
            }
        }
    }

    private DynamicObject getCustomerValueOriginal(DynamicObject customer, String otherCustomer) {
        if (customer == null) {
            return null;
        }
        DynamicObject dynamicObject = customer.getDynamicObject(otherCustomer);
        if (dynamicObject != null) {
            return dynamicObject;
        }
        return null;
    }

    private void setLineTypeDefaultValue(DynamicObjectCollection entrycols, DynamicObject bizType) {
        if (bizType == null) {
            return;
        }
        Long lineTypeID = this.getDefaultLineType((Long)bizType.getPkValue());
        if (lineTypeID == null) {
            return;
        }
        DynamicObject lineType = this.loadSingleFromCache(lineTypeID, "bd_linetype");
        if (lineType != null) {
            entrycols.forEach(entry -> {
                if (entry.get("linetype") == null) {
                    entry.set("linetype", (Object)lineType);
                }
            });
        }
    }

    private void processControlDay(DynamicObject bill) {
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : billentry) {
            boolean isControlDay;
            DynamicObject material = entry.getDynamicObject("material");
            if (material == null) continue;
            int receiveDayUp = entry.getInt("deliveradvdays");
            int receiveDayDown = entry.getInt("deliverdelaydays");
            if (receiveDayUp != 0 || receiveDayDown != 0 || !(isControlDay = material.getBoolean("iscontrolday"))) continue;
            receiveDayUp = material.getInt("deliveradvdays");
            receiveDayDown = material.getInt("deliverdelaydays");
            entry.set("deliveradvdays", (Object)receiveDayUp);
            entry.set("deliverdelaydays", (Object)receiveDayDown);
            entry.set("iscontrolday", (Object)isControlDay);
        }
    }

    private void setDefaultOperatorGroup(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject operator = bill.getDynamicObject("operator");
        DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
        long userId = UserServiceHelper.getCurrentUserId();
        if (0L == userId) {
            return;
        }
        if (operator == null) {
            Map<String, DynamicObject> operatorAndGroup = this.getDefaultOperatorAndGroupByOrg((Long)org.getPkValue(), userId, "XSZ");
            if (!operatorAndGroup.isEmpty()) {
                bill.set("operator", (Object)operatorAndGroup.get("operator"));
                if (operatorGroup == null) {
                    bill.set("operatorgroup", (Object)operatorAndGroup.get("operatorgroup"));
                }
            }
        } else if (operatorGroup == null) {
            operatorGroup = this.loadSingleFromCache(operator.get("operatorgrpid"), "bd_operatorgroup");
            bill.set("operatorgroup", (Object)operatorGroup);
        }
    }

    private void setDefaultDept(DynamicObject bill) {
        DynamicObject user;
        DynamicObject dept = bill.getDynamicObject("dept");
        DynamicObject operator = bill.getDynamicObject("operator");
        if (dept == null && operator != null && (user = operator.getDynamicObject("operatorid")) != null) {
            Long deptID = UserServiceHelper.getUserMainOrgId((long)((Long)user.getPkValue()));
            dept = this.loadSingleFromCache(deptID, "bos_org");
            bill.set("dept", (Object)dept);
        }
    }

    private boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        if (o instanceof StringBuffer && ((StringBuffer)o).length() == 0) {
            return true;
        }
        if (o instanceof List && ((List)o).isEmpty()) {
            return true;
        }
        if (o instanceof Collection && ((Collection)o).isEmpty()) {
            return true;
        }
        if (o instanceof Object[] && ((Object[])o).length == 0) {
            return true;
        }
        return o instanceof Map && ((Map)o).size() == 0;
    }

    private DynamicObject getDefaultBizTypeObject(String formId, Long billTypeId, String paramFormId) {
        List<DynamicObject> enableList;
        if (this.isNull(formId) || this.isNull(billTypeId) || this.isNull(paramFormId)) {
            return null;
        }
        Object bizTypes = this.getBillTypeParameter(formId, billTypeId, paramFormId, "entryentity");
        ArrayList<DynamicObject> bizTypeList = new ArrayList<DynamicObject>();
        if (!this.isNull(bizTypes) && bizTypes instanceof DynamicObjectCollection) {
            ((DynamicObjectCollection)bizTypes).stream().forEach(dym -> {
                if (dym.getBoolean("isdefault")) {
                    bizTypeList.add(dym.getDynamicObject("biztypenumber"));
                }
            });
        }
        return (enableList = this.getEnableBaseDataObjects("bd_biztype", bizTypeList)).size() > 0 ? enableList.get(0) : null;
    }

    private List<DynamicObject> getEnableBaseDataObjects(String entityNo, List<DynamicObject> dyms) {
        List pks = dyms.stream().map(dym -> (Long)dym.getPkValue()).collect(Collectors.toList());
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter pkFilter = new QFilter("id", "in", pks);
        ArrayList<DynamicObject> baseDatas = new ArrayList<DynamicObject>(16);
        Map enableBaseDatas = BusinessDataServiceHelper.loadFromCache((String)entityNo, (QFilter[])new QFilter[]{enableFilter, pkFilter});
        if (enableBaseDatas != null) {
            enableBaseDatas.values().forEach(value -> baseDatas.add((DynamicObject)value));
        }
        return baseDatas;
    }

    private Long getDefaultLineType(Long bizTypeId) {
        Optional<DynamicObject> optionalLineType;
        if (this.isNull(bizTypeId)) {
            return null;
        }
        Long lineTypeId = null;
        DynamicObject bizType = this.loadSingleFromCache(bizTypeId, "bd_biztype");
        if (!this.isNull(bizType) && !this.isNull(bizType.getDynamicObjectCollection("linetypeentry")) && (optionalLineType = bizType.getDynamicObjectCollection("linetypeentry").stream().filter(dym -> dym.getBoolean("isdefault")).findFirst()).isPresent()) {
            lineTypeId = optionalLineType.get().getLong("linetypeid.id");
            List<Long> linetype = this.getEnableBaseDataIds("bd_linetype", Collections.singletonList(lineTypeId));
            lineTypeId = linetype.size() > 0 ? linetype.get(0) : null;
        }
        return lineTypeId;
    }

    private List<Long> getEnableBaseDataIds(String entityNo, List<Long> pks) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter pkFilter = new QFilter("id", "in", pks);
        ArrayList<Long> baseIDs = new ArrayList<Long>(16);
        Map enableBaseDatas = BusinessDataServiceHelper.loadFromCache((String)entityNo, (QFilter[])new QFilter[]{enableFilter, pkFilter});
        if (enableBaseDatas != null) {
            enableBaseDatas.keySet().forEach(id -> baseIDs.add((Long)id));
        }
        return baseIDs;
    }

    private Object getBillTypeParameter(String formId, long billTypeId, String paramFormId, String propertyName) {
        if (this.isNull(formId) || this.isNull(billTypeId) || this.isNull(paramFormId) || this.isNull(propertyName)) {
            return null;
        }
        DynamicObject billTypeParam = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)paramFormId, (long)billTypeId);
        if (!this.isNull(billTypeParam)) {
            return billTypeParam.get(propertyName);
        }
        return null;
    }

    private void setDefaultCustomerValue(DynamicObject bill, String roleType) {
        if (bill == null) {
            return;
        }
        IDataEntityType dataEntityType = bill.getDataEntityType();
        boolean existSettletype = this.isExistField(dataEntityType, "settletype");
        boolean existCusSup = this.isExistField(dataEntityType, roleType);
        if (existSettletype && existCusSup && bill.getDynamicObject("settletype") == null) {
            DynamicObject role = bill.getDynamicObject(roleType);
            QFilter isdefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
            QFilter isenable = new QFilter("enable", "=", (Object)"1");
            QFilter filter = isdefault.and(isenable);
            DynamicObject defaultSettlementType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (QFilter[])new QFilter[]{filter});
            if (role != null) {
                DynamicObject settlementtypeid = role.getDynamicObject("settlementtypeid");
                if (settlementtypeid == null) {
                    bill.set("settletype", (Object)defaultSettlementType);
                } else {
                    bill.set("settletype", (Object)settlementtypeid);
                }
            } else if (defaultSettlementType != null) {
                bill.set("settletype", (Object)defaultSettlementType);
            }
        }
    }

    private boolean isExistField(IDataEntityType entityType, String fieldName) {
        if (entityType == null) {
            return false;
        }
        boolean isExist = false;
        IDataEntityProperty dataEntiryProperty = ((EntityType)entityType).findProperty(fieldName);
        if (dataEntiryProperty != null) {
            isExist = true;
        }
        return isExist;
    }

    private Map<String, DynamicObject> getDefaultOperatorAndGroupByOrg(Long orgId, Long userId, String operatorGrpType) {
        QFilter qFilter04;
        QFilter qFilter03;
        QFilter qFilter02;
        Map<Object, DynamicObject> operatorGroupDynamicObjectMap = this.getOperatorGroupDynamicObjectMap(orgId, operatorGrpType);
        HashMap<String, DynamicObject> defaultOperatorAndGroup = new HashMap<String, DynamicObject>(4);
        if (operatorGroupDynamicObjectMap == null || operatorGroupDynamicObjectMap.size() == 0) {
            return defaultOperatorAndGroup;
        }
        QFilter qFilter01 = new QFilter("operatorgrpid", "in", operatorGroupDynamicObjectMap.keySet());
        Map operatorMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype,invalid", (QFilter[])new QFilter[]{qFilter01, qFilter02 = new QFilter("opergrptype", "=", (Object)operatorGrpType), qFilter03 = new QFilter("operatorid", "=", (Object)userId), qFilter04 = new QFilter("invalid", "=", (Object)Boolean.FALSE)});
        if (operatorMap != null && !operatorMap.isEmpty()) {
            for (DynamicObject operator : operatorMap.values()) {
                if (operator == null) continue;
                defaultOperatorAndGroup.put("operator", operator);
                defaultOperatorAndGroup.put("operatorgroup", operatorGroupDynamicObjectMap.get(operator.get("operatorgrpid")));
                break;
            }
        }
        return defaultOperatorAndGroup;
    }

    private Map<Object, DynamicObject> getOperatorGroupDynamicObjectMap(Long orgId, String operatorGrpType) {
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)operatorGrpType);
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
    }

    private String getAddress(DynamicObject customer) {
        if (customer == null) {
            return "";
        }
        QFilter id1 = new QFilter("customerid", "in", (Object)customer.getPkValue().toString());
        QFilter id2 = new QFilter("invalid", "=", (Object)"0");
        Map bd_address = BusinessDataServiceHelper.loadFromCache((String)"bd_address", (QFilter[])new QFilter[]{id1.and(id2)});
        String validAddress = "";
        if (bd_address.size() > 0) {
            for (Map.Entry entry : bd_address.entrySet()) {
                DynamicObject add = (DynamicObject)entry.getValue();
                boolean isDefault = add.getBoolean("default");
                if (isDefault) {
                    return add.getString("detailaddress");
                }
                if (!"".equalsIgnoreCase(validAddress)) continue;
                validAddress = add.getString("detailaddress");
            }
        }
        return validAddress;
    }

    private Long getLinkman(DynamicObject customer) {
        if (customer == null) {
            return null;
        }
        DynamicObject customerLinkMans = this.loadSingleFromCache(customer.getPkValue(), "bd_customer");
        if (customerLinkMans == null) {
            return null;
        }
        DynamicObjectCollection linkmans = customerLinkMans.getDynamicObjectCollection("entry_linkman");
        Long customerLinkmanId = null;
        for (DynamicObject linkman : linkmans) {
            boolean isDefault = linkman.getBoolean("isdefault_linkman");
            boolean invalid = linkman.getBoolean("invalid");
            if (isDefault && !invalid) {
                return (Long)linkman.getPkValue();
            }
            if (customerLinkmanId != null || invalid) continue;
            customerLinkmanId = (Long)linkman.getPkValue();
        }
        return customerLinkmanId;
    }

    private void processBotpOrg(DynamicObject org, DynamicObject entry) {
        DynamicObject stockOrg;
        if (org == null) {
            return;
        }
        if (entry.get("e_stockorg") == null) {
            stockOrg = this.stockOrgMap.get((Long)org.getPkValue());
            if (stockOrg == null) {
                Long stockOrgPK = this.getOrgDefaultValue((Long)org.getPkValue(), "03", "05", "toorg");
                if (stockOrgPK != 0L) {
                    stockOrg = this.loadSingleFromCache(stockOrgPK, "bos_org");
                    entry.set("e_stockorg", (Object)stockOrg);
                    this.stockOrgMap.put((Long)org.getPkValue(), stockOrg);
                }
            } else {
                entry.set("e_stockorg", (Object)stockOrg);
            }
        }
        if (entry.get("entrysettleorg") == null) {
            DynamicObject settleOrg = this.settleOrgMap.get((Long)org.getPkValue());
            if (settleOrg == null) {
                Long settleOrgPK = this.getOrgDefaultValue((Long)org.getPkValue(), "03", "10", "toorg");
                if (settleOrgPK != 0L) {
                    settleOrg = this.loadSingleFromCache(settleOrgPK, "bos_org");
                    entry.set("entrysettleorg", (Object)settleOrg);
                    this.settleOrgMap.put((Long)org.getPkValue(), settleOrg);
                }
            } else {
                entry.set("entrysettleorg", (Object)settleOrg);
            }
        }
        if (entry.get("owner") == null && (stockOrg = entry.getDynamicObject("e_stockorg")) != null) {
            if (this.ownerMap.get((Long)stockOrg.getPkValue()) != null) {
                entry.set("owner", (Object)this.ownerMap.get((Long)stockOrg.getPkValue()));
            } else {
                Long ownerPK = this.getOwnerDefaultValue((Long)org.getPkValue(), (Long)stockOrg.getPkValue());
                if (ownerPK != 0L) {
                    DynamicObject owner = this.loadSingleFromCache(ownerPK, "bos_org");
                    entry.set("owner", (Object)owner);
                    this.ownerMap.putIfAbsent((Long)stockOrg.getPkValue(), owner);
                }
            }
        }
    }

    private Long getOrgDefaultValue(Long org, String fromViewType, String toViewType, String directViewType) {
        OrgRelationParam param = null;
        if (org == null) {
            return 0L;
        }
        param = this.getOrgRelationParam(org, fromViewType, toViewType, directViewType);
        return OrgUnitServiceHelper.getOrgForFormDefValue((OrgRelationParam)param);
    }

    private OrgRelationParam getOrgRelationParam(Long org, String fromViewType, String toViewType, String directViewType) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(org.longValue());
        param.setFromViewType(fromViewType);
        param.setToViewType(toViewType);
        if ("fromorg".equals(directViewType)) {
            param.setDirectViewType("fromorg");
        } else if ("toorg".equals(directViewType)) {
            param.setDirectViewType("toorg");
        }
        return param;
    }

    private Long getOrgRelationDefaultValue(Long org, String fromViewType, String toViewType, String directViewType) {
        Map<String, Object> allToOrg = this.getOrgRelationMap(org, fromViewType, toViewType, directViewType);
        if (allToOrg != null) {
            List detailList = (List)allToOrg.get("data");
            for (Map detailMap : detailList) {
                Boolean isDefault = (Boolean)detailMap.get("isDefault");
                if (!isDefault.booleanValue()) continue;
                return (Long)detailMap.get("orgId");
            }
        }
        return 0L;
    }

    private Map<String, Object> getOrgRelationMap(Long org, String fromViewType, String toViewType, String directViewType) {
        OrgRelationParam param = null;
        if (org == null) {
            return null;
        }
        param = this.getOrgRelationParam(org, fromViewType, toViewType, directViewType);
        return OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
    }

    private Long getOwnerDefaultValue(Long OrgId, Long stockOrgId) {
        Long accountingOrg = this.getAcccountOrg4Org(OrgId);
        Map<String, Object> allToOrg = this.getOrgRelationMap(stockOrgId, "10", "05", "fromorg");
        if (allToOrg != null && !allToOrg.isEmpty()) {
            List orgIds = (List)allToOrg.get("orgId");
            if (orgIds.contains(accountingOrg)) {
                return accountingOrg;
            }
            List detailList = (List)allToOrg.get("data");
            for (Map detailMap : detailList) {
                Boolean isDefault = (Boolean)detailMap.get("isDefault");
                if (!isDefault.booleanValue()) continue;
                return (Long)detailMap.get("orgId");
            }
        }
        return 0L;
    }

    private Long getAcccountOrg4Org(Long OrgId) {
        if (OrgId == null) {
            return 0L;
        }
        Long acccountOrgPK = 0L;
        Map<String, Object> orgMap = this.getCompanyByOrg(OrgId, Boolean.FALSE, Boolean.TRUE);
        if (!this.isNull(orgMap)) {
            acccountOrgPK = (Long)orgMap.get("id");
        }
        return acccountOrgPK;
    }

    private Map<String, Object> getCompanyByOrg(Long orgId, Boolean isBizUnit, Boolean isSerrchUpward) {
        Map OrgMap = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)isBizUnit, (Boolean)isSerrchUpward);
        return OrgMap;
    }

    private void changeAmountConditionForDynamicObject(Map<String, String> properytMapping, DynamicObject bill) {
        if (bill == null) {
            return;
        }
        String entryNoKey = properytMapping.get(ENTRY_ID);
        String amountConditionKey = properytMapping.get(AMOUNTCONDITION);
        String itemNameKey = properytMapping.get(ENTRY_ITEMNAME);
        String isPrePayKey = properytMapping.get(ENTRY_ISPREPAY);
        String rateKey = properytMapping.get(ENTRY_RATE);
        String amountKey = properytMapping.get(ENTRY_AMOUNT);
        String amountDateKey = properytMapping.get(ENTRY_AMOUNTDATE);
        DynamicObjectCollection amountPlanEntrys = bill.getDynamicObjectCollection(entryNoKey);
        if (amountPlanEntrys != null && !amountPlanEntrys.isEmpty()) {
            this.calAmountPlanForDynamicObject(properytMapping, bill);
            return;
        }
        DynamicObject amountCondition = (DynamicObject)bill.get(amountConditionKey);
        if (amountCondition == null) {
            return;
        }
        List<Map<String, Object>> amountConditinoEntryInfos = this.getAmountConditinoEntryInfo(properytMapping, bill);
        if (amountConditinoEntryInfos == null || amountConditinoEntryInfos.size() == 0 || amountPlanEntrys == null) {
            return;
        }
        for (Map<String, Object> amountConditionEntry : amountConditinoEntryInfos) {
            DynamicObject amountPlanentry = amountPlanEntrys.addNew();
            amountPlanentry.set(itemNameKey, amountConditionEntry.get(ENTRY_ITEMNAME));
            amountPlanentry.set(isPrePayKey, amountConditionEntry.get("ispre"));
            amountPlanentry.set(rateKey, amountConditionEntry.get(ENTRY_RATE));
            amountPlanentry.set(amountKey, amountConditionEntry.get(ENTRY_AMOUNT));
            Date date = (Date)amountConditionEntry.get("date");
            if (date == null) continue;
            amountPlanentry.set(amountDateKey, (Object)date);
        }
        this.calAmountPlanForDynamicObject(properytMapping, bill);
    }

    private void calAmountPlanForDynamicObject(Map<String, String> properytMapping, DynamicObject bill) {
        DynamicObject currency;
        int precision;
        if (bill == null) {
            return;
        }
        if (properytMapping == null || properytMapping.isEmpty()) {
            return;
        }
        String amountPlanEntryKey = properytMapping.get(ENTRY_ID);
        String amountKey = properytMapping.get(ENTRY_AMOUNT);
        String rateKey = properytMapping.get(ENTRY_RATE);
        String settleCurrencyKey = properytMapping.get(SETTLECURRENCY);
        String isPayRateKey = properytMapping.get(ISPAYRATE);
        String changeTypeKey = properytMapping.get(CHANGETYPE);
        String totalAmountAndTaxKey = properytMapping.get(TOTALALLAMOUNT);
        DynamicObjectCollection amountPlanEntry = bill.getDynamicObjectCollection(amountPlanEntryKey);
        if (amountPlanEntry == null || amountPlanEntry.isEmpty()) {
            return;
        }
        boolean isPayRate = bill.getBoolean(isPayRateKey);
        BigDecimal totalAllAmount = bill.getBigDecimal(totalAmountAndTaxKey);
        if (totalAllAmount == null) {
            totalAllAmount = BigDecimal.ZERO;
        }
        int n = precision = (currency = bill.getDynamicObject(settleCurrencyKey)) == null ? 10 : currency.getInt("amtprecision");
        if (isPayRate) {
            BigDecimal rateTotal = BigDecimal.ZERO;
            for (DynamicObject entry : amountPlanEntry) {
                BigDecimal rate = entry.getBigDecimal(rateKey);
                String changeType = entry.getString(changeTypeKey);
                if ("C".equals(changeType) || rate == null) continue;
                rateTotal = rateTotal.add(rate);
            }
            BigDecimal amountTotal = BigDecimal.ZERO;
            for (int i = 0; i < amountPlanEntry.size(); ++i) {
                DynamicObject entry = (DynamicObject)amountPlanEntry.get(i);
                BigDecimal rate = entry.getBigDecimal(rateKey);
                String changeType = entry.getString(changeTypeKey);
                if ("C".equals(changeType)) continue;
                BigDecimal amount = rate == null || BigDecimal.ZERO.compareTo(rate) == 0 ? BigDecimal.ZERO : (i == amountPlanEntry.size() - 1 && rateTotal.compareTo(HUNDRED) == 0 ? totalAllAmount.subtract(amountTotal) : totalAllAmount.multiply(rate).divide(HUNDRED, precision, RoundingMode.HALF_UP));
                amountTotal = amountTotal.add(amount);
                entry.set(amountKey, (Object)amount);
            }
        } else {
            BigDecimal amountTotal = BigDecimal.ZERO;
            for (DynamicObject entry : amountPlanEntry) {
                BigDecimal amount = entry.getBigDecimal(amountKey);
                String changeType = entry.getString(changeTypeKey);
                if ("C".equals(changeType) || amount == null) continue;
                amount = amount.setScale(precision, RoundingMode.HALF_UP);
                amountTotal = amountTotal.add(amount);
            }
            BigDecimal rateTotal = BigDecimal.ZERO;
            for (int i = 0; i < amountPlanEntry.size(); ++i) {
                BigDecimal rate;
                DynamicObject entry = (DynamicObject)amountPlanEntry.get(i);
                BigDecimal amount = entry.getBigDecimal(amountKey);
                String changeType = entry.getString(changeTypeKey);
                if ("C".equals(changeType)) continue;
                if (amount == null || totalAllAmount.compareTo(BigDecimal.ZERO) == 0 || BigDecimal.ZERO.compareTo(amount) == 0) {
                    rate = BigDecimal.ZERO;
                } else if (i == amountPlanEntry.size() - 1 && amountTotal.compareTo(totalAllAmount) == 0) {
                    rate = HUNDRED.subtract(rateTotal);
                } else {
                    amount = amount.setScale(precision, RoundingMode.HALF_UP);
                    rate = amount.multiply(HUNDRED).divide(totalAllAmount, 2, RoundingMode.HALF_UP);
                }
                rateTotal = rateTotal.add(rate);
                entry.set(rateKey, (Object)rate);
                entry.set(amountKey, (Object)amount);
            }
        }
    }

    private List<Map<String, Object>> getAmountConditinoEntryInfo(Map<String, String> properytMapping, DynamicObject bill) {
        if (bill == null) {
            return null;
        }
        String amountConditionKey = properytMapping.get(AMOUNTCONDITION);
        String totalAmountAndTaxKey = properytMapping.get(TOTALALLAMOUNT);
        String bizTimeKey = properytMapping.get(BIZTIME);
        String planType = properytMapping.get(PLANTYPE);
        String isPayRateKey = properytMapping.get(ISPAYRATE);
        List<Map<String, Object>> amountConditionEntrys = new ArrayList<Map<String, Object>>(10);
        DynamicObject amountCondition = bill.getDynamicObject(amountConditionKey);
        if (amountCondition == null) {
            return null;
        }
        Long amountConditionId = (Long)amountCondition.getPkValue();
        if ("purchase".equals(planType)) {
            BigDecimal totalAllAmount = bill.getBigDecimal(totalAmountAndTaxKey);
            Date bizTime = (Date)bill.get(bizTimeKey);
            amountCondition = this.loadSingleFromCache(amountConditionId, "bd_paycondition");
            if (amountCondition == null) {
                return null;
            }
            amountConditionEntrys = (List)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"PayConditionService", (String)"getPayPlanData", (Object[])new Object[]{amountConditionId, bizTime, null, null, null, totalAllAmount});
            if (amountConditionEntrys == null || amountConditionEntrys.size() == 0) {
                return null;
            }
            HashSet<Long> itemNamePks = new HashSet<Long>();
            for (Map<String, Object> oneEntry : amountConditionEntrys) {
                if (oneEntry.get(ENTRY_ITEMNAME) == null) continue;
                itemNamePks.add((Long)oneEntry.get(ENTRY_ITEMNAME));
            }
            Map itemNameMap = new HashMap(16);
            if (itemNamePks.size() != 0) {
                itemNameMap = BusinessDataServiceHelper.loadFromCache((String)"bos_assistantdata_detail", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)itemNamePks.toArray())});
            }
            for (Map map : amountConditionEntrys) {
                Date date = (Date)map.get("date");
                Long itemname = (Long)map.get(ENTRY_ITEMNAME);
                if (date == null) {
                    date = bizTime;
                    map.put("date", date);
                }
                if (itemname == null) continue;
                map.put(ENTRY_ITEMNAME, itemNameMap.get(itemname));
            }
        } else if ("sales".equals(planType)) {
            amountCondition = this.loadSingleFromCache(amountConditionId, "bd_reccondition");
            if (amountCondition == null) {
                return null;
            }
            DynamicObjectCollection entitys = amountCondition.getDynamicObjectCollection("entry");
            String basis = amountCondition.getString("basis");
            if (entitys == null || entitys.size() == 0) {
                return null;
            }
            for (int i = 0; i < entitys.size(); ++i) {
                DynamicObject row = (DynamicObject)entitys.get(i);
                HashMap<String, Comparable<Boolean>> map = new HashMap<String, Comparable<Boolean>>();
                DynamicObject dynamicObject = (DynamicObject)row.get(ENTRY_ITEMNAME);
                boolean ispre = row.getBoolean("ispre");
                map.put("ispre", Boolean.valueOf(ispre));
                map.put(ENTRY_ITEMNAME, (Comparable<Boolean>)(dynamicObject == null ? null : dynamicObject));
                if ("B".equals(basis)) {
                    BigDecimal amount = row.getBigDecimal(ENTRY_AMOUNT);
                    map.put(ENTRY_AMOUNT, amount);
                    map.put(ENTRY_RATE, BigDecimal.ZERO);
                } else {
                    BigDecimal rate = row.getBigDecimal(ENTRY_RATE);
                    map.put(ENTRY_RATE, rate);
                    map.put(ENTRY_AMOUNT, BigDecimal.ZERO);
                }
                amountConditionEntrys.add(map);
            }
        }
        bill.set(isPayRateKey, (Object)(!"B".equals(amountCondition.get("basis")) ? 1 : 0));
        return amountConditionEntrys;
    }

    private boolean calcBaseQtyAndAuxQty(DynamicObject bill, int rowIndex) {
        if (bill == null) {
            return false;
        }
        DynamicObjectCollection colls = bill.getDynamicObjectCollection("billentry");
        if (colls.size() == 0) {
            return false;
        }
        DynamicObject entryInfo = (DynamicObject)colls.get(rowIndex);
        if (entryInfo == null) {
            return false;
        }
        BigDecimal qty = entryInfo.getBigDecimal("qty");
        BigDecimal baseQty = entryInfo.getBigDecimal("baseqty");
        if (qty == null || baseQty == null) {
            return false;
        }
        BigDecimal originQty = new BigDecimal(baseQty.toString());
        DynamicObject unit = entryInfo.getDynamicObject("unit");
        if (unit != null) {
            int precision = unit.getInt("precision");
            int precisionaccount = this.getRoundMode(unit);
            qty = qty.setScale(precision, precisionaccount);
            entryInfo.set("qty", (Object)qty);
            DynamicObject baseUnit = entryInfo.getDynamicObject("baseunit");
            if (baseUnit != null) {
                String unitConvertDir;
                DynamicObject material = entryInfo.getDynamicObject("material");
                if (material == null) {
                    return true;
                }
                DynamicObject masterMaterial = material.getDynamicObject("masterid");
                baseQty = BigDecimal.ZERO;
                if (qty.compareTo(BigDecimal.ZERO) != 0) {
                    baseQty = this.getDesQtyConv(masterMaterial, unit, qty, baseUnit);
                }
                entryInfo.set("baseqty", (Object)baseQty);
                DynamicObject auxptyUnit = entryInfo.getDynamicObject("auxunit");
                if (auxptyUnit != null && ("A".equals(unitConvertDir = masterMaterial.getString("unitconvertdir")) || "C".equals(unitConvertDir))) {
                    BigDecimal auxQty = BigDecimal.ZERO;
                    if (baseQty.compareTo(BigDecimal.ZERO) != 0) {
                        auxQty = this.getDesQtyConv(masterMaterial, baseUnit, baseQty, auxptyUnit);
                    }
                    entryInfo.set("auxqty", (Object)auxQty);
                }
            }
        }
        if (originQty.compareTo(baseQty) != 0) {
            return true;
        }
        return originQty.compareTo(BigDecimal.ZERO) == 0 && qty.compareTo(BigDecimal.ZERO) == 0 && baseQty.compareTo(BigDecimal.ZERO) == 0;
    }

    private int getRoundMode(DynamicObject unit) {
        if (unit == null) {
            return 4;
        }
        String precisionaccount = unit.getString("precisionaccount");
        int baseUnitPrecisionType = 4;
        if ("2".equals(precisionaccount)) {
            baseUnitPrecisionType = 1;
        } else if ("3".equals(precisionaccount)) {
            baseUnitPrecisionType = 0;
        }
        return baseUnitPrecisionType;
    }

    private BigDecimal getDesQtyConv(DynamicObject matMasterID, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (matMasterID != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                return srcQty;
            }
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)matMasterID.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("denominator") != 0) {
                int precision = desUnit.getInt("precision");
                return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, this.getRoundMode(desUnit));
            }
        }
        return BigDecimal.ZERO;
    }

    private void calculateDeliverUpAndDownQty(DynamicObject bill) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            DynamicObject material = entry.getDynamicObject("material");
            if (material == null) continue;
            Boolean iscontrolqty = material.getBoolean("iscontrolqty");
            entry.set("iscontrolqty", (Object)iscontrolqty);
            BigDecimal deliverrateup = BigDecimal.ZERO;
            BigDecimal deliverratedown = BigDecimal.ZERO;
            if (iscontrolqty.booleanValue()) {
                deliverrateup = material.getBigDecimal("dlivrateceiling");
                deliverratedown = material.getBigDecimal("dlivratefloor");
                entry.set("deliverrateup", (Object)deliverrateup);
                entry.set("deliverratedown", (Object)deliverratedown);
            }
            BigDecimal qty = entry.getBigDecimal("qty");
            BigDecimal baseQty = entry.getBigDecimal("baseqty");
            DynamicObject baseUnit = entry.getDynamicObject("baseunit");
            DynamicObject unit = entry.getDynamicObject("unit");
            if (unit == null || baseUnit == null || qty == null || baseQty == null || deliverrateup == null || deliverratedown == null) continue;
            int precision = unit.getInt("precision");
            int precisionaccount = this.getRoundMode(unit);
            int basePrecision = baseUnit.getInt("precision");
            int basePrecisionaccount = this.getRoundMode(baseUnit);
            BigDecimal deliverqtyup = qty.multiply(new BigDecimal(100).add(deliverrateup)).divide(new BigDecimal(100), precision, precisionaccount);
            BigDecimal deliverbaseqtyup = baseQty.multiply(new BigDecimal(100).add(deliverrateup)).divide(new BigDecimal(100), basePrecision, basePrecisionaccount);
            BigDecimal deliverqtydown = qty.multiply(new BigDecimal(100).subtract(deliverratedown)).divide(new BigDecimal(100), precision, precisionaccount);
            BigDecimal deliverbaseqtydown = baseQty.multiply(new BigDecimal(100).subtract(deliverratedown)).divide(new BigDecimal(100), basePrecision, basePrecisionaccount);
            entry.set("deliverqtyup", (Object)deliverqtyup);
            entry.set("deliverbaseqtyup", (Object)deliverbaseqtyup);
            entry.set("deliverqtydown", (Object)deliverqtydown);
            entry.set("deliverbaseqtydown", (Object)deliverbaseqtydown);
        }
    }

    private void calcMinOrderBaseQty(DynamicObject bill) {
        if (bill == null) {
            return;
        }
        DynamicObjectCollection entryInfos = bill.getDynamicObjectCollection("billentry");
        if (!entryInfos.isEmpty()) {
            for (int i = 0; i < entryInfos.size(); ++i) {
                DynamicObject entryInfo = (DynamicObject)entryInfos.get(i);
                BigDecimal minOrderBaseQty = BigDecimal.ZERO;
                DynamicObject masterMat = entryInfo.getDynamicObject("material.masterid");
                BigDecimal minOrderQty = entryInfo.getBigDecimal("material.minorderqty");
                DynamicObject salesUnit = entryInfo.getDynamicObject("material.salesunit");
                DynamicObject baseUnit = entryInfo.getDynamicObject("baseunit");
                if (masterMat != null && baseUnit != null && salesUnit != null && minOrderQty != null && BigDecimal.ZERO.compareTo(minOrderQty) != 0) {
                    minOrderBaseQty = this.getDesQtyConv(masterMat, salesUnit, minOrderQty, baseUnit);
                }
                entryInfo.set("minorderbaseqty", (Object)minOrderBaseQty);
            }
        }
    }

    private BigDecimal processAmount4BotpConvert(DynamicObject bill) {
        if (bill == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal exChangeRate = bill.getBigDecimal("exchangerate");
        DynamicObject settleCurrency = bill.getDynamicObject(SETTLECURRENCY);
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject exRateTable = bill.getDynamicObject("exratetable");
        String exchangeType = bill.getString("exchangetype");
        DynamicObject org = bill.getDynamicObject("org");
        Date bizTime = bill.getDate("exratedate");
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            if (currency == null) {
                currency = this.getCurrency(orgId);
                bill.set("currency", (Object)currency);
            }
            if (settleCurrency == null) {
                settleCurrency = currency;
                bill.set(SETTLECURRENCY, (Object)settleCurrency);
            }
            if (exRateTable == null) {
                exRateTable = this.getExRateTable(orgId);
                bill.set("exratetable", (Object)exRateTable);
            }
        }
        if (currency != null && exRateTable != null && settleCurrency != null) {
            BigDecimal exRate = null;
            if (StringUtils.isEmpty((CharSequence)exchangeType)) {
                Map<String, Object> exRateMap = this.getExchangeRateMap((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exRateTable.getPkValue(), bizTime);
                exRate = (BigDecimal)exRateMap.get("exchangeRate");
                Boolean quoteType = (Boolean)exRateMap.get("quoteType");
                exchangeType = quoteType != null && quoteType == false ? "0" : "1";
                bill.set("exchangetype", (Object)exchangeType);
            }
            if (SalOrderDefValueHelper.isBlank(exChangeRate)) {
                exChangeRate = exRate != null ? exRate : this.getExRate((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exRateTable.getPkValue(), bizTime, exchangeType);
                bill.set("exchangerate", (Object)exChangeRate);
            }
        }
        this.calculateAmount4WholeBill(bill);
        return bill.getBigDecimal(TOTALALLAMOUNT);
    }

    private static boolean isBlank(BigDecimal num) {
        return num == null ? true : SalOrderDefValueHelper.isZero(num);
    }

    private static boolean isZero(BigDecimal num) {
        return SalOrderDefValueHelper.equals(num, BigDecimal.ZERO);
    }

    private static boolean equals(BigDecimal num1, BigDecimal num2) {
        if (num1 == null && num2 == null) {
            return true;
        }
        if (num1 != null && num2 != null) {
            return num1.compareTo(num2) == 0;
        }
        return false;
    }

    private void calculateAmount4WholeBill(DynamicObject bill) {
        if (bill == null) {
            return;
        }
        BigDecimal totalAllAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal curTotalAllAmount = BigDecimal.ZERO;
        BigDecimal curTotalAmount = BigDecimal.ZERO;
        DynamicObjectCollection colls = bill.getDynamicObjectCollection("billentry");
        if (colls == null || colls.size() == 0) {
            return;
        }
        for (int i = 0; i < colls.size(); ++i) {
            DynamicObject entryInfo = (DynamicObject)colls.get(i);
            SOAmountInfo amountInfo = this.initAmountInfo(bill, i);
            amountInfo = this.getAmount(amountInfo);
            BigDecimal amountAndTax = amountInfo.getAmountAndTax();
            BigDecimal taxAmout = amountInfo.getTaxAmount();
            BigDecimal amount = amountInfo.getAmount();
            BigDecimal curAmountAndTax = amountInfo.getCurAmountAndTax();
            BigDecimal curAmount = amountInfo.getCurAmount();
            BigDecimal curTaxAmount = amountInfo.getCurTaxAmount();
            BigDecimal discountAmount = amountInfo.getDiscountAmount();
            BigDecimal discountRate = amountInfo.getDiscountRate();
            BigDecimal price = amountInfo.getPrice();
            BigDecimal priceAndTax = amountInfo.getPriceAndTax();
            entryInfo.set("price", (Object)price);
            entryInfo.set("priceandtax", (Object)priceAndTax);
            entryInfo.set("discountamount", (Object)discountAmount);
            entryInfo.set("discountrate", (Object)discountRate);
            entryInfo.set(ENTRY_AMOUNT, (Object)amount);
            entryInfo.set("amountandtax", (Object)amountAndTax);
            entryInfo.set("taxamount", (Object)taxAmout);
            entryInfo.set("curamountandtax", (Object)curAmountAndTax);
            entryInfo.set("curamount", (Object)curAmount);
            entryInfo.set("curtaxamount", (Object)curTaxAmount);
            totalAllAmount = totalAllAmount.add(amountAndTax);
            totalAmount = totalAmount.add(amount);
            totalTaxAmount = totalTaxAmount.add(taxAmout);
            curTotalAllAmount = curTotalAllAmount.add(curAmountAndTax);
            curTotalAmount = curTotalAmount.add(curAmount);
        }
        bill.set(TOTALALLAMOUNT, (Object)totalAllAmount);
        bill.set("totalamount", (Object)totalAmount);
        bill.set("totaltaxamount", (Object)totalTaxAmount);
        bill.set("curtotalallamount", (Object)curTotalAllAmount);
        bill.set("curtotalamount", (Object)curTotalAmount);
    }

    private SOAmountInfo initAmountInfo(DynamicObject bill, int rowIndex) {
        DynamicObjectCollection collsInit = bill.getDynamicObjectCollection("billentry");
        DynamicObject entryInfoInit = (DynamicObject)collsInit.get(rowIndex);
        boolean isTax = bill.getBoolean("istax");
        DynamicObject currency = bill.getDynamicObject("currency");
        int currencyAmtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
        DynamicObject settleCurrency = bill.getDynamicObject(SETTLECURRENCY);
        int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
        BigDecimal exChangeRate = bill.getBigDecimal("exchangerate");
        BigDecimal qty = entryInfoInit.getBigDecimal("qty");
        BigDecimal price = entryInfoInit.getBigDecimal("price");
        BigDecimal priceAndTax = entryInfoInit.getBigDecimal("priceandtax");
        BigDecimal taxRate = entryInfoInit.getBigDecimal("taxrate");
        String discountType = entryInfoInit.getString("discounttype");
        BigDecimal discountRate = entryInfoInit.getBigDecimal("discountrate");
        BigDecimal discountAmount = entryInfoInit.getBigDecimal("discountamount");
        String exchangeType = bill.getString("exchangetype");
        SOAmountInfo amountInfo = new SOAmountInfo(bill.getDataEntityType().getName(), entryInfoInit);
        amountInfo.setTax(isTax);
        amountInfo.setQty(qty);
        amountInfo.setPrice(price);
        amountInfo.setPriceAndTax(priceAndTax);
        amountInfo.setTaxRate(taxRate);
        amountInfo.setDiscountType(discountType);
        amountInfo.setDiscountRate(discountRate);
        amountInfo.setDiscountAmount(discountAmount);
        amountInfo.setExChangeRate(exChangeRate);
        amountInfo.setSettleAmtPrecision(settleAmtPrecision);
        amountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
        amountInfo.setExchangeType(exchangeType);
        return amountInfo;
    }

    private SOAmountInfo getAmount(SOAmountInfo amountInfo) {
        BigDecimal HUNDRED = new BigDecimal("100");
        BigDecimal ONE = BigDecimal.ONE;
        BigDecimal ZERO = BigDecimal.ZERO;
        String entityName = amountInfo.getEntityName();
        boolean isTax = amountInfo.isTax();
        BigDecimal qty = amountInfo.getQty();
        BigDecimal price = amountInfo.getPrice();
        BigDecimal priceAndTax = amountInfo.getPriceAndTax();
        BigDecimal taxRate = amountInfo.getTaxRate().divide(HUNDRED);
        String discountType = amountInfo.getDiscountType();
        BigDecimal discountRate = amountInfo.getDiscountRate();
        int settleAmtPrecision = amountInfo.getSettleAmtPrecision();
        int settlePricePrecision = amountInfo.getSettlePricePrecision();
        int currencyAmtPrecision = amountInfo.getCurrencyAmtPrecision();
        BigDecimal exChangeRate = amountInfo.getExChangeRate();
        String exchangeType = amountInfo.getExchangeType();
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal amountAndTax = BigDecimal.ZERO;
        if (qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal dividedDiscountRate;
            if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                price = priceAndTax.divide(ONE.add(taxRate), settlePricePrecision, 4);
                if (StringUtils.isBlank((CharSequence)discountType) || "NULL".equals(discountType) || discountRate == null || discountRate.compareTo(ZERO) == 0) {
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                } else if ("A".equals(discountType)) {
                    dividedDiscountRate = discountRate.divide(HUNDRED);
                    discountAmount = qty.multiply(priceAndTax).multiply(dividedDiscountRate).setScale(settleAmtPrecision, 4);
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                    amountAndTax = amountAndTax.subtract(discountAmount);
                } else if ("B".equals(discountType) || "C".equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).setScale(settleAmtPrecision, 4);
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                    amountAndTax = amountAndTax.subtract(discountAmount);
                }
                taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(settleAmtPrecision, 4);
                amount = amountAndTax.subtract(taxAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            } else if (!isTax && price != null && price.compareTo(ZERO) != 0) {
                priceAndTax = price.multiply(ONE.add(taxRate)).setScale(settlePricePrecision, 4);
                if (StringUtils.isBlank((CharSequence)discountType) || "NULL".equals(discountType) || discountRate == null || discountRate.compareTo(ZERO) == 0) {
                    amount = qty.multiply(price).setScale(settleAmtPrecision, 4);
                } else if ("A".equals(discountType)) {
                    dividedDiscountRate = discountRate.divide(HUNDRED);
                    discountAmount = qty.multiply(priceAndTax).multiply(dividedDiscountRate).setScale(settleAmtPrecision, 4);
                    amount = qty.multiply(price).multiply(ONE.subtract(dividedDiscountRate)).setScale(settleAmtPrecision, 4);
                } else if ("B".equals(discountType) || "C".equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).multiply(ONE.add(taxRate)).setScale(settleAmtPrecision, 4);
                    amount = qty.multiply(price.subtract(discountRate)).setScale(settleAmtPrecision, 4);
                }
                taxAmount = amount.multiply(taxRate).setScale(settleAmtPrecision, 4);
                amountAndTax = amount.add(taxAmount);
                amountAndTax = amountAndTax.setScale(settleAmtPrecision, 4);
            } else {
                priceAndTax = ZERO;
                price = ZERO;
            }
        } else if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
            priceAndTax = priceAndTax.setScale(settlePricePrecision, 4);
            price = priceAndTax.divide(ONE.add(taxRate), settlePricePrecision, 4);
        } else if (!isTax && price != null && price.compareTo(ZERO) != 0) {
            price = price.setScale(settlePricePrecision, 4);
            priceAndTax = price.multiply(ONE.add(taxRate)).setScale(settlePricePrecision, 4);
        } else {
            priceAndTax = ZERO;
            price = ZERO;
        }
        amountInfo.setPrice(price);
        amountInfo.setPriceAndTax(priceAndTax);
        amountInfo.setAmount(amount);
        amountInfo.setDiscountAmount(discountAmount);
        amountInfo.setDiscountRate(discountRate);
        amountInfo.setTaxAmount(taxAmount);
        amountInfo.setAmountAndTax(amountAndTax);
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IAmountCalculateCasePlugin.class, (String)"SCMC_SM_BILL_CALCULTEAMOUNTANDTAX", null);
            List fieldSets = pluginProxy.callReplace(p -> p.beforeCalculte(entityName));
            HashSet selectFields = new HashSet();
            if (fieldSets != null && fieldSets.size() > 0) {
                for (Set fiedsSet : fieldSets) {
                    selectFields.addAll(fiedsSet);
                }
            }
            MainEntityType billtype = EntityMetadataCache.getDataEntityType((String)entityName);
            Map<String, Object> amountMap = amountInfo.convertMap();
            if (selectFields.size() > 0) {
                selectFields.forEach(f -> {
                    if (!amountMap.containsKey(f) && billtype.getAllFields().containsKey(f) && ((IDataEntityProperty)billtype.getAllFields().get(f)).getParent() != null) {
                        if ("billentry".equals(((IDataEntityProperty)billtype.getAllFields().get(f)).getParent().getName())) {
                            amountMap.put((String)f, amountInfo.getEntryInfo().get(f));
                        } else if (entityName.equals(((IDataEntityProperty)billtype.getAllFields().get(f)).getParent().getName())) {
                            amountMap.put((String)f, ((DynamicObject)amountInfo.getEntryInfo().getParent()).get(f));
                        }
                    }
                });
            } else {
                log.info("call beforeCalculte's result is null");
            }
            PluginCallImpl pci = new PluginCallImpl(amountAndTax, entityName, amountMap);
            List amountSet = pluginProxy.callReplace(pci);
            if (amountSet != null && amountSet.size() > 0) {
                amountAndTax = (BigDecimal)amountSet.get(amountSet.size() - 1);
            }
            if (amountAndTax.compareTo(amountInfo.getAmountAndTax()) != 0) {
                taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(settleAmtPrecision, 4);
                amount = amountAndTax.subtract(taxAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                amountInfo.setAmount(amount);
                amountInfo.setTaxAmount(taxAmount);
                amountInfo.setAmountAndTax(amountAndTax);
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u5ba2\u6237\u5316\u573a\u666f[%1$s]\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u5316\u63d2\u4ef6\u3002", (String)"BillTplHelper_0", (String)"scmc-sm-business", (Object[])new Object[0]);
            msg = String.format(msg, "SCMC_SM_BILL_CALCULTEAMOUNTANDTAX");
            String msgTotal = msg + e.getMessage();
            log.info(msgTotal);
            throw new KDBizException(msgTotal);
        }
        if (exChangeRate != null && exChangeRate.compareTo(ZERO) != 0 && (amountAndTax.compareTo(ZERO) != 0 || taxAmount.compareTo(ZERO) != 0 || amount.compareTo(ZERO) != 0)) {
            BigDecimal curAmount = ZERO;
            BigDecimal curTaxAmount = ZERO;
            BigDecimal curAmountAndTax = ZERO;
            curTaxAmount = this.getCurAmountByRate(taxAmount, exChangeRate, currencyAmtPrecision, exchangeType);
            if (isTax) {
                curAmountAndTax = this.getCurAmountByRate(amountAndTax, exChangeRate, currencyAmtPrecision, exchangeType);
                curAmount = curAmountAndTax.subtract(curTaxAmount);
            } else {
                curAmount = this.getCurAmountByRate(amount, exChangeRate, currencyAmtPrecision, exchangeType);
                curAmountAndTax = curAmount.add(curTaxAmount);
            }
            amountInfo.setCurAmount(curAmount);
            amountInfo.setCurTaxAmount(curTaxAmount);
            amountInfo.setCurAmountAndTax(curAmountAndTax);
        }
        return amountInfo;
    }

    private DynamicObject getCurrency(Long orgId) {
        Long currencyId;
        Map<String, Long> map;
        if (orgId != 0L && (map = this.getCurrencyAndExRateTable(orgId)) != null && (currencyId = map.get(BASECURRRENCY)) != null && currencyId != 0L) {
            return this.loadSingleFromCache(currencyId, CURRENCY_DT);
        }
        return null;
    }

    private Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map mapOrg;
        if (orgId != null && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && mapOrg.get("id") != null) {
            log.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u9700\u6c42\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\uff1a" + mapOrg);
            Map map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")));
            if (map != null && map.size() != 0) {
                log.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u6838\u7b97\u4e3b\u4f53\u7684\u672c\u4f4d\u5e01\u548c\u6c47\u7387\u8868\uff1a" + map);
                return map;
            }
        }
        return null;
    }

    private DynamicObject getExRateTable(Long orgId) {
        Map<String, Long> map;
        if (orgId != null && (map = this.getCurrencyAndExRateTable(orgId)) != null) {
            return this.loadSingleFromCache(map.get(EXRATETABLE), EXRATETABLE_DT);
        }
        return null;
    }

    private Map<String, Object> getExchangeRateMap(Long settleCurrency, Long currency, Long exRateTable, Date bizTime) {
        if (settleCurrency == null || currency == null || exRateTable == null) {
            return new HashMap<String, Object>(8);
        }
        return BaseDataServiceHelper.getExchangeRateMap((Long)settleCurrency, (Long)currency, (Long)exRateTable, (Date)bizTime);
    }

    private BigDecimal getExRate(Long srcCurId, Long tarCurId, Long exRateTableId, Date date, String exchangeType) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId == null || tarCurId == null || exRateTableId == null || date == null || exchangeType == null) {
            return exchangeRate;
        }
        if (srcCurId.equals(tarCurId)) {
            exchangeRate = BigDecimal.ONE;
        } else {
            boolean isIndirect = false;
            if ("1".equals(exchangeType)) {
                isIndirect = true;
            }
            exchangeRate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)srcCurId, (Long)tarCurId, (Long)exRateTableId, (Date)date, (boolean)isIndirect);
        }
        return exchangeRate;
    }

    private BigDecimal getCurAmountByRate(BigDecimal amount, BigDecimal exChangeRate, int currencyPrecision, String exChangeType) {
        BigDecimal curAmount = BigDecimal.ZERO;
        if (amount == null) {
            return curAmount;
        }
        if (exChangeRate == null || exChangeRate.compareTo(BigDecimal.ZERO) == 0) {
            return curAmount;
        }
        curAmount = exChangeType != null && "1".equals(exChangeType) ? amount.divide(exChangeRate, currencyPrecision, RoundingMode.HALF_UP) : amount.multiply(exChangeRate).setScale(currencyPrecision, RoundingMode.HALF_UP);
        return curAmount;
    }
}

