/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.upgrade;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BillTypeParameterUpgrade4SqlService
implements IUpgradeService {
    private static Log log = LogFactory.getLog(BillTypeParameterUpgrade4SqlService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult doUpdate(UpgradeResult result, String appId, String billTypeParamNo, Map<Long, Long[]> preinsdata) {
        List<String> formIds = BillTypeParameterUpgrade4SqlService.getBillFormIDByAppId(appId);
        DBRoute sysRoute = new DBRoute("sys");
        ArrayList<Object[]> sqlParam = new ArrayList<Object[]>(16);
        try (DataSet billTypeDataSet = null;){
            SqlBuilder sqlBuilder1 = new SqlBuilder();
            sqlBuilder1.append("select a.fformid,a.fbilltypeid,a.fdata,b.fnumber,b.fid", new Object[0]).append("from t_bas_billtypeparameter a left join T_BAS_BILLTYPE b on a.fbilltypeid = b.fid where ", new Object[0]).appendIn("a.fformid", formIds.toArray());
            billTypeDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (SqlBuilder)sqlBuilder1);
            for (Object row : billTypeDataSet) {
                Long defaultBizTypeId;
                ArrayList<Long> preBizTypes;
                if (row == null || row.get("fdata") == null) continue;
                Long billTypeId = row.getLong("fid");
                ArrayList<Long> bizTypeEntrys = new ArrayList<Long>(16);
                List<Object> list = preBizTypes = preinsdata != null && preinsdata.get(billTypeId) != null ? Arrays.asList((Object[])preinsdata.get(billTypeId)) : new ArrayList<Long>(16);
                if (preBizTypes != null && preBizTypes.size() != 0) {
                    bizTypeEntrys.addAll(preBizTypes);
                }
                Long l = defaultBizTypeId = preBizTypes != null && preBizTypes.size() > 0 ? (Long)preBizTypes.get(0) : null;
                String data = row.getString("fdata");
                JSONObject jsonObject = JSONObject.parseObject((String)data);
                if (jsonObject == null || jsonObject.getJSONArray("entryentity") != null && jsonObject.getJSONArray("entryentity").size() != 0) continue;
                JSONObject bizType = jsonObject.getJSONObject("biztype");
                if (bizType != null && bizType.get((Object)"id") != null) {
                    Long bizTypeId = bizType.getLong("id");
                    if (!bizTypeEntrys.contains(bizTypeId)) {
                        bizTypeEntrys.add(bizTypeId);
                    }
                    defaultBizTypeId = bizTypeId;
                }
                String convertBillTypeParamToJson = this.convertBillTypeParamToJson(jsonObject, bizTypeEntrys, defaultBizTypeId, preBizTypes);
                Object[] param = new Object[]{convertBillTypeParamToJson, billTypeId};
                sqlParam.add(param);
            }
            try {
                Object row;
                TXHandle handle = TX.requiresNew();
                row = null;
                try {
                    DB.executeBatch((DBRoute)sysRoute, (String)"update t_bas_billtypeparameter set fdata = ? where fbilltypeid = ?", sqlParam);
                }
                catch (Throwable throwable) {
                    row = throwable;
                    throw throwable;
                }
                finally {
                    if (handle != null) {
                        if (row != null) {
                            try {
                                handle.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)row).addSuppressed(throwable);
                            }
                        } else {
                            handle.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                result.setSuccess(false);
                String message1 = "database execution failed,errorInfo" + e.getMessage();
                result.setErrorInfo(message1);
                result.setLog(message1);
                log.error(message1);
            }
            finally {
                if (billTypeDataSet != null) {
                    billTypeDataSet.close();
                }
            }
        }
        return result;
    }

    private String convertBillTypeParamToJson(JSONObject jsonObject, List<Long> bizTypeEntrys, Long defaultBizTypeId, List<Long> preBizTypes) {
        Map loadFromCache;
        JSONObject json;
        JSONObject jSONObject = json = jsonObject != null ? jsonObject.clone() : new JSONObject();
        if (bizTypeEntrys != null && bizTypeEntrys.size() > 0 && !(loadFromCache = BusinessDataServiceHelper.loadFromCache((Object[])bizTypeEntrys.toArray(), (String)"bd_biztype")).isEmpty()) {
            ArrayList bizTypeList = new ArrayList(16);
            int seq = 1;
            for (Map.Entry map : loadFromCache.entrySet()) {
                if (map != null && map.getKey() != null && map.getValue() != null) {
                    Long key = (Long)map.getKey();
                    DynamicObject value = (DynamicObject)map.getValue();
                    HashMap<String, Object> bizTypeEntryMap = new HashMap<String, Object>(16);
                    HashMap<String, Object> bizTypeMap = new HashMap<String, Object>(16);
                    bizTypeMap.put("id", value.get("id"));
                    bizTypeMap.put("masterid", value.get("masterid"));
                    bizTypeMap.put("number", value.get("number"));
                    bizTypeMap.put("ispreset", value.get("ispreset"));
                    bizTypeMap.put("_Type_", "bd_biztype");
                    DynamicObjectCollection multiLanguageText = value.getDynamicObjectCollection("multilanguagetext");
                    if (multiLanguageText != null && multiLanguageText.size() > 0) {
                        ArrayList textList = new ArrayList(256);
                        for (DynamicObject text : multiLanguageText) {
                            Object pkid = text.get("pkid");
                            Object localeid = text.get("localeid");
                            Object name = text.get("name");
                            Object description = text.get("description");
                            HashMap<String, Object> tmp = new HashMap<String, Object>(16);
                            tmp.put("_Type_", "locale");
                            tmp.put("pkid", pkid);
                            tmp.put("name", name);
                            tmp.put("description", description);
                            tmp.put("localeid", localeid);
                            textList.add(tmp);
                        }
                        bizTypeMap.put("multilanguagetext", textList);
                        bizTypeMap.put("name", value.get("name"));
                    }
                    bizTypeEntryMap.put("_Type_", "entryentity");
                    bizTypeEntryMap.put("biztypenumber", bizTypeMap);
                    bizTypeEntryMap.put("biztypenumber_id", key);
                    bizTypeEntryMap.put("id", 0);
                    if (key.equals(defaultBizTypeId)) {
                        bizTypeEntryMap.put("isdefault", Boolean.TRUE);
                    }
                    if (preBizTypes.contains(key)) {
                        bizTypeEntryMap.put("ispreset", Boolean.TRUE);
                    }
                    bizTypeEntryMap.put("seq", seq);
                    bizTypeList.add(bizTypeEntryMap);
                    ++seq;
                }
                json.put("entryentity", bizTypeList);
            }
        }
        return json.toJSONString();
    }

    private static List<String> getBillFormIDByAppId(String appId) {
        HashSet<String> entityIDSet = new HashSet<String>();
        String modeltype = "BillFormModel";
        DynamicObject[] entitys = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("bizappid", "=", (Object)appId), new QFilter("modeltype", "=", (Object)modeltype)});
        if (entitys != null && entitys.length > 0) {
            for (DynamicObject entity : entitys) {
                String number = entity.getString("number");
                if (!StringUtils.isNotEmpty((CharSequence)number)) continue;
                entityIDSet.add(entity.getString("number"));
            }
        }
        return new ArrayList<String>(entityIDSet);
    }
}

