/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.business.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class LineTypeUpgradeMicroService
implements IUpgradeService {
    protected static final Log logger = LogFactory.getLog(LineTypeUpgradeMicroService.class);
    private static final int batchSizeNum = 1000;
    private static final Long BIZTYPE_MATPUR = 422857170485263360L;
    private static final Long LINETYPE_EXPENSEITEM = 1194156052984154112L;
    private static final Long ATTRIBUTE_EXPENSEITEM = 1194030308689758208L;
    private static final Long ATTRIBUTE_COST = 1194029878949760000L;

    public UpgradeResult doUpdate(DBRoute dbRoute, UpgradeResult result, String entityNo, String entryNo, String materialFieldKey, String bizTypeKey, String t_lineType, String billId, String isForceUpataFlag) {
        if (dbRoute == null || result == null || StringUtils.isBlank((CharSequence)entityNo) || StringUtils.isBlank((CharSequence)entryNo) || StringUtils.isBlank((CharSequence)materialFieldKey) || StringUtils.isBlank((CharSequence)bizTypeKey) || StringUtils.isBlank((CharSequence)t_lineType) || StringUtils.isBlank((CharSequence)isForceUpataFlag)) {
            throw new KDBizException("LineTypeUpgradeService execution failed,Please check and try again.");
        }
        String serviceName = entityNo + this.getClass().getName();
        logger.info(serviceName + " \u6267\u884c\u670d\u52a1\u5165\u53c2\uff1aDBRoute " + dbRoute + " UpgradeResult " + result + " entityNo " + entityNo + " entryNo " + entryNo + " materialFieldKey " + materialFieldKey + " bizTypeKey " + bizTypeKey + " t_lineType " + t_lineType + " billIds " + billId + " isForceUpataFlag " + isForceUpataFlag);
        Map<Long, BizTypeParameter> bizTypeParameterMap = this.buildBizTypeParam(serviceName);
        boolean isForceUpdate = false;
        if (StringUtils.isNotBlank((CharSequence)isForceUpataFlag)) {
            isForceUpdate = Boolean.parseBoolean(isForceUpataFlag.toLowerCase());
        }
        Long id = null;
        if (StringUtils.isNotBlank((CharSequence)billId) && !"null".equals(billId)) {
            id = Long.parseLong(billId);
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (isForceUpdate && id != null) {
            isForceUpdate = true;
            filters.add(new QFilter("id", "=", (Object)id));
        } else {
            isForceUpdate = false;
            filters.add(new QFilter(entryNo + ".linetype", "=", (Object)0L));
        }
        String selectFields = this.getSelectField(bizTypeKey, entryNo, materialFieldKey);
        HashMap<Long, Map<String, Long>> entryIDAndBizTypeMatID = new HashMap<Long, Map<String, Long>>(16);
        HashSet<Long> materialMasteridSet = new HashSet<Long>(16);
        DataSet billEntryRows = QueryServiceHelper.queryDataSet((String)(serviceName + "queryBillInfo"), (String)entityNo, (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        int rowCount = 0;
        for (Row row : billEntryRows) {
            ++rowCount;
            Long material = row.getLong("material");
            Long entryid = row.getLong("entryid");
            Long bizType = row.getLong(bizTypeKey);
            HashMap<String, Long> map = new HashMap<String, Long>(5);
            map.put("material", material);
            map.put("biztype", bizType);
            entryIDAndBizTypeMatID.put(entryid, map);
            materialMasteridSet.add(material);
            if (rowCount < 1000) continue;
            List<Object[]> entryIdAndLineTypeID = this.getEntryIdAndLineTypeID(entityNo, serviceName, entryIDAndBizTypeMatID, materialMasteridSet, bizTypeParameterMap);
            if (entryIdAndLineTypeID.size() > 0) {
                result = this.updateBillLineType(isForceUpdate, result, t_lineType, entryIdAndLineTypeID);
            }
            if (!result.isSuccess()) {
                return result;
            }
            entryIdAndLineTypeID.clear();
            entryIDAndBizTypeMatID.clear();
            materialMasteridSet.clear();
            rowCount = 0;
        }
        if (rowCount > 0) {
            List<Object[]> entryIdAndLineTypeID = this.getEntryIdAndLineTypeID(entityNo, serviceName, entryIDAndBizTypeMatID, materialMasteridSet, bizTypeParameterMap);
            if (entryIdAndLineTypeID.size() > 0) {
                result = this.updateBillLineType(isForceUpdate, result, t_lineType, entryIdAndLineTypeID);
            }
            entryIdAndLineTypeID.clear();
            entryIDAndBizTypeMatID.clear();
            materialMasteridSet.clear();
        }
        return result;
    }

    private String getSelectField(String bizTypeKey, String entryNo, String materialFieldKey) {
        StringBuilder sb = new StringBuilder();
        sb.append(bizTypeKey).append(',');
        sb.append(entryNo).append('.').append(materialFieldKey).append(" as material,");
        sb.append(entryNo).append(".id as entryid,");
        sb.append(entryNo).append(".linetype").append(" as linetype");
        return sb.toString();
    }

    private UpgradeResult updateBillLineType(boolean isForceUpdate, UpgradeResult result, String t_lineType, List<Object[]> paramList) {
        StringBuilder sql_update = null;
        sql_update = isForceUpdate ? new StringBuilder(" UPDATE ").append(t_lineType).append(" SET FLINETYPEID =?").append(" WHERE FENTRYID =? ") : new StringBuilder(" UPDATE ").append(t_lineType).append(" SET FLINETYPEID =?").append(" WHERE FENTRYID =? AND FLINETYPEID = 0");
        try (TXHandle h = TX.required((String)this.getClass().getName());){
            try {
                DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql_update.toString(), paramList);
                paramList.clear();
            }
            catch (Throwable e) {
                h.markRollback();
                result.setSuccess(false);
                String err = "database execution failed,errorInfo" + e.getMessage();
                result.setErrorInfo(err);
                result.setLog("database execution failed,errorMsgInfo" + e.getMessage());
                logger.error(err);
                UpgradeResult upgradeResult = result;
                if (h != null) {
                    if (var7_7 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
        }
        return result;
    }

    private List<Object[]> getEntryIdAndLineTypeID(String entityNo, String serviceName, Map<Long, Map<String, Long>> entryIDAndBizTypeMatID, Set<Long> materialMasteridSet, Map<Long, BizTypeParameter> bizTypeParameterMap) {
        ArrayListValuedHashMap materialIDAndattributeID = new ArrayListValuedHashMap(16);
        QFilter pkFilter = new QFilter("id", "in", materialMasteridSet);
        Map bd_material = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,serviceattribute.fbasedataid_id as materialserviceattribute", (QFilter[])new QFilter[]{pkFilter});
        for (Map.Entry oneMaterial : bd_material.entrySet()) {
            DynamicObject materialInfo = (DynamicObject)oneMaterial.getValue();
            Long id = (Long)oneMaterial.getKey();
            DynamicObjectCollection serviceattribute = materialInfo.getDynamicObjectCollection("serviceattribute");
            for (DynamicObject attri : serviceattribute) {
                Object pkValue = ((DynamicObject)attri.get("fbasedataid")).getPkValue();
                materialIDAndattributeID.put((Object)id, pkValue);
            }
        }
        materialMasteridSet.clear();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Map<String, Long>> entry : entryIDAndBizTypeMatID.entrySet()) {
            Long lineTypeId;
            Collection attributes;
            Long entryId = entry.getKey();
            Map<String, Long> map = entry.getValue();
            Long biztype = map.get("biztype");
            Long material = map.get("material");
            BizTypeParameter bizTypeParameter = bizTypeParameterMap.get(biztype);
            if (bizTypeParameter == null || (attributes = materialIDAndattributeID.get((Object)material)) == null || attributes.size() < 1 || (lineTypeId = this.getLineTypeID(entityNo, biztype, attributes, bizTypeParameter)) == null) continue;
            ArrayList<Long> param = new ArrayList<Long>(5);
            param.add(lineTypeId);
            param.add(entryId);
            paramList.add(param.toArray());
        }
        return paramList;
    }

    private Long getLineTypeID(String entityNo, Long biztype, Collection<Object> attributes, BizTypeParameter bizTypeParameter) {
        Map<Long, HashSet<Long>> attrAndLineTypeMap;
        Long lineType;
        if (attributes == null) {
            return null;
        }
        Long defAttr = bizTypeParameter.getDefaultAttr();
        Long specialLineType = this.specialDeal(entityNo, biztype, defAttr, lineType = bizTypeParameter.getDefaultLineType(), attrAndLineTypeMap = bizTypeParameter.getAttrAndLineTypeMap(), attributes);
        if (specialLineType != null) {
            return specialLineType;
        }
        if (attributes.size() == 1) {
            Long attributeId = (Long)attributes.iterator().next();
            if (attributeId != null && attributeId.equals(defAttr)) {
                return lineType;
            }
            HashSet<Long> lineTypeIds = attrAndLineTypeMap.get(attributeId);
            if (lineTypeIds != null && lineTypeIds.size() == 1) {
                return lineTypeIds.iterator().next();
            }
        } else if (attributes.contains(defAttr)) {
            return lineType;
        }
        return null;
    }

    protected Long specialDeal(String entityNo, Long biztype, Long defAttr, Long deflineType, Map<Long, HashSet<Long>> attrAndLineTypeMap, Collection<Object> attributes) {
        if (("pm_purapplybill".equals(entityNo) || "pm_purorderbill".equals(entityNo) || "pm_xpurorderbill".equals(entityNo)) && BIZTYPE_MATPUR.equals(biztype)) {
            if ((ATTRIBUTE_COST.equals(defAttr) || ATTRIBUTE_EXPENSEITEM.equals(defAttr)) && (attributes.contains(ATTRIBUTE_COST) || attributes.contains(ATTRIBUTE_EXPENSEITEM))) {
                return LINETYPE_EXPENSEITEM;
            }
            if (attributes != null && attributes.size() == 1 && (attributes.contains(ATTRIBUTE_COST) || attributes.contains(ATTRIBUTE_EXPENSEITEM))) {
                return LINETYPE_EXPENSEITEM;
            }
        }
        return null;
    }

    private Map<Long, BizTypeParameter> buildBizTypeParam(String serviceName) {
        HashMap<Long, BizTypeParameter> allBizTypeInfo = new HashMap<Long, BizTypeParameter>(16);
        QFilter isControlQtyFilter = new QFilter("controlcriterion", "=", (Object)"0");
        DataSet lineTypeInfo = QueryServiceHelper.queryDataSet((String)(serviceName + "queryBizType"), (String)"bd_linetype", (String)"id as linetypeid,serviceattribute,ispreset", (QFilter[])new QFilter[]{isControlQtyFilter}, null);
        DataSet bizTypeInfo = QueryServiceHelper.queryDataSet((String)(serviceName + "queryLineType"), (String)"bd_biztype", (String)"id as biztypeid,linetypeentry.linetypeid as linetypeid,linetypeentry.isdefault as isdefault", null, null);
        DataSet dataSet = bizTypeInfo.leftJoin(lineTypeInfo).on("linetypeid", "linetypeid").select(new String[]{"linetypeid", "serviceattribute"}, new String[]{"biztypeid", "isdefault"}).finish();
        for (Row row : dataSet) {
            Long linetypeid = row.getLong("linetypeid");
            Long biztypeid = row.getLong("biztypeid");
            Long serviceattribute = row.getLong("serviceattribute");
            Boolean isdefault = row.getBoolean("isdefault");
            if (linetypeid == null || biztypeid == null || serviceattribute == null || isdefault == null) continue;
            BizTypeParameter bizTypeParameter = (BizTypeParameter)allBizTypeInfo.get(biztypeid);
            if (bizTypeParameter == null) {
                bizTypeParameter = new BizTypeParameter();
                if (isdefault.booleanValue()) {
                    bizTypeParameter.setDefaultLineType(linetypeid);
                    bizTypeParameter.setDefaultAttr(serviceattribute);
                }
                HashMap<Long, HashSet<Long>> map = new HashMap<Long, HashSet<Long>>(16);
                HashSet<Long> lineTypeIDs = new HashSet<Long>(5);
                lineTypeIDs.add(linetypeid);
                map.put(serviceattribute, lineTypeIDs);
                bizTypeParameter.setAttrAndLineTypeMap(map);
            } else {
                if (isdefault.booleanValue() && (bizTypeParameter.getDefaultAttr() == null || bizTypeParameter.getDefaultLineType() == null)) {
                    bizTypeParameter.setDefaultLineType(linetypeid);
                    bizTypeParameter.setDefaultAttr(serviceattribute);
                }
                HashSet<Long> lineTypeIds = null;
                Map<Long, HashSet<Long>> attrAndLineTypeMap = bizTypeParameter.getAttrAndLineTypeMap();
                if (attrAndLineTypeMap != null) {
                    lineTypeIds = attrAndLineTypeMap.get(serviceattribute);
                    if (lineTypeIds == null) {
                        lineTypeIds = new HashSet(5);
                    }
                    lineTypeIds.add(linetypeid);
                } else {
                    attrAndLineTypeMap = new HashMap<Long, HashSet<Long>>(16);
                    lineTypeIds = new HashSet(5);
                    lineTypeIds.add(linetypeid);
                }
                attrAndLineTypeMap.put(serviceattribute, lineTypeIds);
                bizTypeParameter.setAttrAndLineTypeMap(attrAndLineTypeMap);
            }
            allBizTypeInfo.put(biztypeid, bizTypeParameter);
        }
        logger.info(((Object)allBizTypeInfo).toString());
        return allBizTypeInfo;
    }

    public String doUpdateByMaterial(String entityNo, String entryNo, String masterMaterialFieldKey, String lineTypeKey, String billno, String materialno, String lineTypeNo) {
        if (StringUtils.isBlank((CharSequence)entityNo) || StringUtils.isBlank((CharSequence)entryNo) || StringUtils.isBlank((CharSequence)masterMaterialFieldKey) || StringUtils.isBlank((CharSequence)lineTypeNo) || StringUtils.isBlank((CharSequence)billno) || StringUtils.isBlank((CharSequence)materialno)) {
            throw new KDBizException("LineTypeUpgradeService doUpdateByMaterial execution failed,Please check param and try again.");
        }
        logger.info(" \u6267\u884c\u670d\u52a1\u5165\u53c2\uff1aentityNo " + entityNo + " entryNo " + entryNo + " masterMaterialFieldKey " + masterMaterialFieldKey + " lineTypeKey " + lineTypeKey + " billno " + billno + " materialno " + materialno + " lineTypeNo " + lineTypeNo);
        QFilter lineTypeNoFilter = new QFilter("number", "=", (Object)lineTypeNo);
        DynamicObject lineType = null;
        DynamicObject[] lineTypes = BusinessDataServiceHelper.load((String)"bd_linetype", (String)"id", (QFilter[])new QFilter[]{lineTypeNoFilter});
        if (lineTypes == null || lineTypes.length == 0 || lineTypes.length > 1) {
            throw new KDBizException("LineTypeUpgradeService doUpdateByMaterial execution failed,linetype is not unique or exist.");
        }
        lineType = lineTypes[0];
        QFilter billNoFilter = new QFilter("billno", "=", (Object)billno);
        StringBuilder selectProperties = new StringBuilder();
        int index = masterMaterialFieldKey.lastIndexOf(46);
        if (index != -1) {
            String materialKey = masterMaterialFieldKey.substring(0, index);
            selectProperties.append(entryNo).append('.').append(materialKey).append(',');
        }
        selectProperties.append(entryNo).append(',').append(entryNo).append('.').append(masterMaterialFieldKey).append(',').append(entryNo).append('.').append(lineTypeKey);
        DynamicObject[] billFromDBs = BusinessDataServiceHelper.load((String)entityNo, (String)selectProperties.toString(), (QFilter[])new QFilter[]{billNoFilter});
        if (billFromDBs == null || billFromDBs.length == 0) {
            throw new KDBizException("LineTypeUpgradeService doUpdateByMaterial execution failed,billinfo is not exist.");
        }
        ArrayList<DynamicObject> updataBills = new ArrayList<DynamicObject>();
        int billCount = 0;
        int entryCount = 0;
        for (DynamicObject bill : billFromDBs) {
            boolean updateFlag = false;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryNo);
            for (DynamicObject row : entrys) {
                DynamicObject material = row.getDynamicObject(masterMaterialFieldKey);
                if (material == null || !materialno.equals(material.get("number"))) continue;
                row.set(lineTypeKey, (Object)lineType);
                ++entryCount;
                updateFlag = true;
            }
            if (!updateFlag) continue;
            ++billCount;
            updataBills.add(bill);
        }
        SaveServiceHelper.update((DynamicObject[])updataBills.toArray(new DynamicObject[0]));
        return "LineTypeUpgradeService doUpdateByMaterial execution success , billCount :" + billCount + " ,entryCount :" + entryCount;
    }

    static class BizTypeParameter {
        private Long defaultAttr;
        private Long defaultLineType;
        private Map<Long, HashSet<Long>> attrAndLineTypeMap;

        BizTypeParameter() {
        }

        public Long getDefaultAttr() {
            return this.defaultAttr;
        }

        public Long getDefaultLineType() {
            return this.defaultLineType;
        }

        public Map<Long, HashSet<Long>> getAttrAndLineTypeMap() {
            return this.attrAndLineTypeMap;
        }

        public void setDefaultAttr(Long defaultAttr) {
            this.defaultAttr = defaultAttr;
        }

        public void setDefaultLineType(Long defaultLineType) {
            this.defaultLineType = defaultLineType;
        }

        public void setAttrAndLineTypeMap(Map<Long, HashSet<Long>> attrAndLineTypeMap) {
            this.attrAndLineTypeMap = attrAndLineTypeMap;
        }

        public String toString() {
            return "BizTypeParameter{defaultAttr=" + this.defaultAttr + ", defaultLineType=" + this.defaultLineType + ", attrAndLineTypeMap=" + this.attrAndLineTypeMap + '}';
        }
    }
}

