/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.common.utils;

import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.FunctionManage;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.user.UserService;

public class ConditionHelper {
    public static CRCondition parseCondtion(String condition) {
        return (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
    }

    public static QFilter getQFiltersFromConditon(String billType, CRCondition filterCondition) {
        FilterBuilder filter = ConditionHelper.buildFilter(billType, filterCondition);
        if (filter == null) {
            return null;
        }
        return filter.getQFilter();
    }

    public static BOSExpression getExpressionFromCondtion(String billType, CRCondition filterCondition) {
        FilterBuilder filter = ConditionHelper.buildFilter(billType, filterCondition);
        if (filter == null) {
            return null;
        }
        String[] filterStrings = filter.buildFilterScript();
        return new BOSExpression(filterStrings[0]);
    }

    public static BOSUDFunction[] createUdFunctions(BOSExpression function, ExpressionContext expContext) {
        if (function == null) {
            return null;
        }
        Set funcs = function.getFuncs();
        if (funcs.isEmpty()) {
            return new BOSUDFunction[0];
        }
        FunctionManage funcLib = FunctionManage.get();
        ArrayList<BOSUDFunction> instances = new ArrayList<BOSUDFunction>(16);
        for (String funcName : funcs) {
            if (!funcLib.getFuncMap().containsKey(funcName)) continue;
            BOSUDFunction instance = ((BOSUDFunction)funcLib.getFuncMap().get(funcName)).getInstance(expContext);
            instances.add(instance);
        }
        return instances.toArray(new BOSUDFunction[0]);
    }

    public static FilterBuilder buildFilter(String billType, CRCondition filterCondition) {
        FilterCondition condition = filterCondition.getFilterCondition();
        if (condition == null) {
            return null;
        }
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billType), condition);
        UserService userService = new UserService();
        filterBuilder.setUserService((IUserService)userService);
        filterBuilder.buildFilter(false);
        return filterBuilder;
    }

    private static boolean checkHighCondition(MainEntityType type, String preCondition, final DynamicObject dynamicObject) {
        ExpressionContext context = new ExpressionContext(){

            public Boolean tryGetValue(String s, OutValue<Object> outValue) {
                Object o = dynamicObject.get(s);
                if (o == null) {
                    return Boolean.FALSE;
                }
                outValue.set(o);
                return Boolean.TRUE;
            }
        };
        return (Boolean)CalcExprParser.getExpressionValue((String)preCondition, (ExpressionContext)context, (FunctionManage)FunctionManage.get());
    }
}

