/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.common.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import kd.bos.dataentity.utils.ObjectUtils;

public class DateUtils {
    private static final LocalTime ENDOFDAY = LocalTime.of(23, 59, 59);

    public static Date getEndOfDay(Date date) {
        if (!ObjectUtils.isEmpty((Object)date)) {
            LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
            LocalDateTime endOfDay = localDateTime.with(ENDOFDAY);
            return Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    public static Date getStartOfDay(Date date) {
        if (!ObjectUtils.isEmpty((Object)date)) {
            LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
            LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
            return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }
}

