/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.common.pojo.AnalysisEntitySqlInfo;
import kd.mpscmm.msbd.common.pojo.ZipParameter;

public class EntitySqlTools {
    private static final Log logger = LogFactory.getLog(EntitySqlTools.class);
    private static final String CHARSET_UTF8 = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportMetaPresetSql(IFormView formView, String sqlSelect) {
        ListSelectedRowCollection rows = ((IListView)formView).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c06\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"EntitySqlTools_0", (String)"mpscmm-msbd-common", (Object[])new Object[0]));
            return;
        }
        ArrayList<Map<String, Object>> dataInfo = new ArrayList<Map<String, Object>>(16);
        HashSet<String> keySet = new HashSet<String>(16);
        for (ListSelectedRow listSelectedRow : rows) {
            String billId = listSelectedRow.getPrimaryKeyValue().toString();
            if (!keySet.add(billId)) continue;
            HashMap<String, Object> mapCaseInfo = new HashMap<String, Object>(16);
            mapCaseInfo.put("caseid", billId);
            String number = listSelectedRow.getNumber();
            if (number != null) {
                mapCaseInfo.put("casenumber", number);
            } else {
                String string = listSelectedRow.getBillNo();
                if (string != null) {
                    mapCaseInfo.put("casenumber", string);
                } else {
                    mapCaseInfo.put("casenumber", UUID.randomUUID());
                }
            }
            dataInfo.add(mapCaseInfo);
        }
        String entityId = ((IListView)formView).getBillFormId();
        String zipName = EntitySqlTools.getZipName(dataInfo, false);
        File zipFile = new File(zipName);
        try {
            ArrayList<ZipParameter> lstParam = new ArrayList<ZipParameter>(16);
            for (Map throwable : dataInfo) {
                String caseId = (String)throwable.get("caseid");
                String caseNumber = (String)throwable.get("casenumber");
                Map<String, Object> returnMap = EntitySqlTools.expInspectSql(caseId, entityId, sqlSelect);
                if (returnMap == null) {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u65f6\uff0c\u51fa\u73b0\u4e86\u5f02\u5e38\u3002", (String)"EntitySqlTools_1", (String)"mpscmm-msbd-common", (Object[])new Object[0]));
                    return;
                }
                for (Map.Entry<String, Object> entry : returnMap.entrySet()) {
                    if (!"sql".equals(entry.getKey())) continue;
                    String fileName = EntitySqlTools.getInspectunitSqlName(entityId, caseNumber);
                    String unitTestSql = (String)entry.getValue();
                    ByteArrayInputStream sql = new ByteArrayInputStream(unitTestSql.getBytes(StandardCharsets.UTF_8));
                    ZipParameter param = new ZipParameter();
                    param.isfile = true;
                    param.name = fileName;
                    param.stream = sql;
                    lstParam.add(param);
                }
            }
            EntitySqlTools.zipStreams(lstParam, zipFile);
        }
        catch (Exception e) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a", (String)"EntitySqlTools_2", (String)"mpscmm-msbd-common", (Object[])new Object[0]).concat(e.getMessage()));
            return;
        }
        try {
            FileInputStream zipFileInputStream = new FileInputStream(zipFile);
            Object object = null;
            try {
                String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipName, (InputStream)zipFileInputStream, 5);
                zipFileInputStream.close();
                formView.download(string);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (zipFileInputStream != null) {
                    if (object != null) {
                        try {
                            zipFileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        zipFileInputStream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            formView.showErrorNotification(e.getMessage());
        }
        finally {
            zipFile.delete();
        }
    }

    public static Map<String, Object> expInspectSql(String unitId, String entityId, String sqlSelect) {
        AnalysisEntitySqlInfo analysisEntitySqlInfo = AnalysisEntitySqlInfo.getInstance(entityId, unitId, sqlSelect);
        Map<String, Object> sqlInfo = analysisEntitySqlInfo.analysisMetaSqlInfo();
        if (sqlInfo.isEmpty()) {
            return null;
        }
        return sqlInfo;
    }

    public static void zipStreams(List<ZipParameter> lstParam, File zipFile) throws IOException {
        if (lstParam != null) {
            if (zipFile.exists()) {
                for (ZipParameter param : lstParam) {
                    EntitySqlTools.zip(zipFile, param);
                }
            } else {
                try (FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
                     ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)fileOutputStream, Charset.forName(CHARSET_UTF8));
                     BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);){
                    for (ZipParameter param : lstParam) {
                        EntitySqlTools.zipStream(param, zipOutStream, bufferOutStream);
                    }
                    bufferOutStream.close();
                    zipOutStream.close();
                }
            }
        }
    }

    private static void zipStream(ZipParameter param, ZipOutputStream zipOutStream, BufferedOutputStream bufferOutStream) throws IOException {
        String direct = param.direct;
        String path = StringUtils.isNotBlank((CharSequence)direct) ? direct + File.separator + param.name : param.name;
        ZipEntry entry = new ZipEntry(path);
        zipOutStream.putNextEntry(entry);
        BufferedInputStream bufferInputStream = new BufferedInputStream(param.stream);
        EntitySqlTools.write(bufferInputStream, bufferOutStream);
        zipOutStream.closeEntry();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zip(File zipFile, ZipParameter sourceParam) throws IOException {
        if (zipFile.exists()) {
            File tempFile = new File(zipFile.getCanonicalPath() + ".tmp");
            try (FileOutputStream zipOutFileStream = new FileOutputStream(tempFile);
                 ZipFile zipOutFile = new ZipFile(zipFile);){
                boolean bRet;
                ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)zipOutFileStream, StandardCharsets.UTF_8);
                BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);
                Enumeration<? extends ZipEntry> entries = zipOutFile.entries();
                int THRESHOLD_ENTRIES = 1000;
                int THRESHOLD_SIZE = 500000000;
                double THRESHOLD_RATIO = 10.0;
                int totalSizeArchive = 0;
                int totalEntryArchive = 0;
                while (entries.hasMoreElements()) {
                    ZipEntry ze = entries.nextElement();
                    BufferedInputStream in = new BufferedInputStream(zipOutFile.getInputStream(ze));
                    zipOutStream.putNextEntry(ze);
                    ++totalEntryArchive;
                    int nBytes = -1;
                    byte[] buffer = new byte[2048];
                    int totalSizeEntry = 0;
                    while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                        if (ze.isDirectory()) continue;
                        bufferOutStream.write(buffer, 0, nBytes);
                        totalSizeEntry += nBytes;
                        totalSizeArchive += nBytes;
                        double compressionRatio = (long)totalSizeEntry / ze.getCompressedSize();
                        if (!(compressionRatio > THRESHOLD_RATIO)) continue;
                        break;
                    }
                    if (totalSizeArchive > THRESHOLD_SIZE || totalEntryArchive > THRESHOLD_ENTRIES) break;
                    ((InputStream)in).close();
                    bufferOutStream.flush();
                    zipOutStream.closeEntry();
                }
                ZipEntry entry = new ZipEntry(sourceParam.name);
                zipOutStream.putNextEntry(entry);
                BufferedInputStream bufferInputStream = new BufferedInputStream(sourceParam.stream);
                EntitySqlTools.write(bufferInputStream, bufferOutStream);
                bufferOutStream.close();
                zipOutStream.close();
                boolean flag = zipFile.delete();
                if (!flag || (bRet = tempFile.renameTo(zipFile))) return;
                logger.error("zip\u91cd\u547d\u540d\u5931\u8d25");
                return;
            }
        }
        try (FileOutputStream zipOutFileStream = new FileOutputStream(zipFile);){
            ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)zipOutFileStream, Charset.forName(CHARSET_UTF8));
            BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);
            ZipEntry entry = new ZipEntry(sourceParam.name);
            zipOutStream.putNextEntry(entry);
            BufferedInputStream bufferInputStream = new BufferedInputStream(sourceParam.stream);
            EntitySqlTools.write(bufferInputStream, bufferOutStream);
            bufferOutStream.close();
            zipOutStream.close();
            return;
        }
    }

    private static void write(InputStream inputStream, OutputStream outStream) throws IOException {
        byte[] data = new byte[4096];
        int length = 0;
        while ((length = inputStream.read(data)) != -1) {
            outStream.write(data, 0, length);
        }
        outStream.flush();
        inputStream.close();
    }

    public static String getInspectunitSqlName(String entityId, String number) {
        return entityId + "_" + number + "_pre_ins.sql";
    }

    public static String getZipName(List<Map<String, Object>> lstMapCaseInfo, boolean bWithUUID) {
        String zipName = "";
        zipName = lstMapCaseInfo.size() <= 1 ? (String)lstMapCaseInfo.get(0).get("casenumber") : "preinsdata";
        if (bWithUUID) {
            zipName = zipName + "_" + UUID.randomUUID();
        }
        zipName = zipName + ".zip";
        return zipName;
    }
}

