/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.business.helper.FetchPriceHelper;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.business.service.AbstractMServiceAsyncHandler;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;

public class AbstractAutoQuotePlugin
extends AbstractBillPlugIn
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(AbstractAutoQuotePlugin.class);
    private static final String LISTEN_KEY = "AUTO_QUOTE_LISTEN";
    private static final String SEPARATOR = ",";
    private static final String QUOTE_FACTOR_NAME = "plat_quotefactor";
    private static final String QUOTE_FACTOR_PROPERTIES = "id,quotebill,status,enable,entryentity.quotefactornumber";
    private static final String PROGRESS_START_KEY = "PROGRESS_START";
    private static final String PROGRESS_START = "start";
    private static final String PRICE_MAP_KEY = "PRICE_MAP";
    private static final String QUOTE_RESULT_CACHE_KEY = "QUOTE_RESULT";
    private static final String QUOTE_RESULT_SEPARATOR = "\\$\\$";
    private static final String INVALID_POLLING_NUM_KEY = "INVALID_POLLING_NUM";
    private static final int INVALID_POLLING_MAX_NUM = 60;
    private static final String ORG_ID_KEY = "orgId";
    private static final String BILL_ID_KEY = "billId";
    private static final String HEAD_IS_COVER_KEY = "headIsCover";
    private static final String QUOTE_ENTRY_MAP_KEY = "entryMap";
    private static final String QUOTE_HEAD_MAP_KEY = "headMap";
    private static final String ENTRY_IS_COVER_KEY = "entryIsCover";
    private static final String STOP_CHANGE_KEY = "stopChange";
    private static final String STOP_CHANGE = "true";
    private final Set<String> specialListenFields = this.initSpecialListenFields();
    private Set<String> listenFields;
    private Map<Long, Map<String, Object>> priceMapKey;
    private final AbstractMServiceAsyncHandler asyncQuoteHandler = new AbstractMServiceAsyncHandler(){

        @Override
        public String getResultCacheKey() {
            return AbstractAutoQuotePlugin.QUOTE_RESULT_CACHE_KEY;
        }

        @Override
        public String serviceResult2PageCache(Object mServiceResult) {
            Map result = (Map)mServiceResult;
            if (result.isEmpty()) {
                return null;
            }
            HashMap<String, Object> pageCacheMap = new HashMap<String, Object>(8);
            String orgId = null;
            String billId = null;
            String isCover = "A";
            HashMap entryMap = new HashMap();
            HashMap<String, String> entryIsCoverMap = new HashMap<String, String>();
            HashMap headMap = new HashMap();
            for (Map.Entry entry : result.entrySet()) {
                Map value = (Map)entry.getValue();
                if (value == null) continue;
                orgId = ((Long)entry.getKey()).toString();
                for (Map.Entry subEntry : value.entrySet()) {
                    String key = (String)subEntry.getKey();
                    String[] split = key.split(AbstractAutoQuotePlugin.QUOTE_RESULT_SEPARATOR);
                    if (split.length == 4) {
                        billId = split[0];
                        String entryId = split[1];
                        String field = split[3];
                        if ("iscover".equals(field)) {
                            entryIsCoverMap.put(entryId, (String)subEntry.getValue());
                            continue;
                        }
                        HashMap fieldMap = (HashMap)entryMap.get(entryId);
                        if (fieldMap == null) {
                            fieldMap = new HashMap();
                        }
                        fieldMap.put(field, subEntry.getValue());
                        entryMap.put(entryId, fieldMap);
                        continue;
                    }
                    if (split.length != 2) continue;
                    billId = split[0];
                    String field = split[1];
                    if ("iscover".equals(field)) {
                        isCover = (String)subEntry.getValue();
                        continue;
                    }
                    headMap.put(field, subEntry.getValue());
                }
            }
            if (orgId == null || billId == null || entryMap.isEmpty() && headMap.isEmpty()) {
                return null;
            }
            pageCacheMap.put(AbstractAutoQuotePlugin.ORG_ID_KEY, orgId);
            pageCacheMap.put(AbstractAutoQuotePlugin.BILL_ID_KEY, billId);
            pageCacheMap.put(AbstractAutoQuotePlugin.HEAD_IS_COVER_KEY, isCover);
            pageCacheMap.put(AbstractAutoQuotePlugin.QUOTE_ENTRY_MAP_KEY, entryMap);
            pageCacheMap.put(AbstractAutoQuotePlugin.QUOTE_HEAD_MAP_KEY, headMap);
            pageCacheMap.put(AbstractAutoQuotePlugin.ENTRY_IS_COVER_KEY, entryIsCoverMap);
            return SerializationUtils.toJsonString(pageCacheMap);
        }

        @Override
        public Object invokeService() {
            return AbstractAutoQuotePlugin.this.quote();
        }

        @Override
        public void dualException(Exception mServiceException) {
        }
    };

    public void registerListener(EventObject e) {
        ProgressBar progressBar = this.getProgressBar();
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        if (this.canEditStatus() || !this.cancelAutoQuote()) {
            this.initAutoQuoteListenField();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String stopChange = this.getPageCache().get(STOP_CHANGE_KEY);
        if (STOP_CHANGE.equals(stopChange)) {
            return;
        }
        if (this.cancelAutoQuote()) {
            return;
        }
        Set<String> listenFieldSet = this.getListenFieldsFromCache();
        if (listenFieldSet == null) {
            return;
        }
        if (listenFieldSet.isEmpty() && this.specialListenFields.isEmpty()) {
            return;
        }
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (!(this.specialListenFields.contains(name) || !this.isChangeNull(e.getChangeSet()) && listenFieldSet.contains(name))) {
            return;
        }
        if (this.isFieldsInvalid(null)) {
            return;
        }
        this.addPkValue();
        if (!this.isOnProgress() && !this.startProgress()) {
            return;
        }
        this.asyncQuoteHandler.propertyChanged(e, this.getPageCache());
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar source = (ProgressBar)progressEvent.getSource();
        if (!source.getKey().equals(this.getProgressBarKey())) {
            return;
        }
        if (!this.canEditStatus() || this.cancelAutoQuote()) {
            this.stopProgress();
            return;
        }
        String quoteResult = this.getAutoQuoteResult();
        if (!StringUtils.isEmpty((CharSequence)quoteResult)) {
            long startTime = System.currentTimeMillis();
            this.putCache(INVALID_POLLING_NUM_KEY, "0");
            if (this.updateView(quoteResult) && this.isCloseListener()) {
                this.afterUpdateView();
                log.info("\u3010\u81ea\u52a8\u53d6\u4ef7\u3011\u5237\u65b0\u9875\u9762\u5b8c\u6210\uff0cpageId=" + this.getPageCache().getPageId() + "\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime));
            }
        } else {
            String invalidNumStr = this.getCache(INVALID_POLLING_NUM_KEY);
            int newInvalidNum = 1;
            if (invalidNumStr != null && (newInvalidNum = Integer.parseInt(invalidNumStr) + 1) >= this.getInvalidPollingMaxNum()) {
                this.stopProgress();
                return;
            }
            this.putCache(INVALID_POLLING_NUM_KEY, String.valueOf(newInvalidNum));
        }
    }

    public void putCache(String key, String value) {
        IPageCache pageCache = this.getPageCache();
        if (pageCache != null) {
            pageCache.put(key, value);
        }
    }

    public String getCache(String key) {
        IPageCache pageCache = this.getPageCache();
        if (pageCache == null) {
            return null;
        }
        return pageCache.get(key);
    }

    public void removeCache(String key) {
        IPageCache pageCache = this.getPageCache();
        if (pageCache == null) {
            return;
        }
        pageCache.remove(key);
    }

    protected String getMainOrgKey() {
        return null;
    }

    protected String getQuoteBillEntryNumber() {
        return null;
    }

    protected boolean isAutoQuote() {
        String quoteOrgProperty = this.getMainOrgKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue(quoteOrgProperty);
        if (org == null) {
            return false;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getQuoteBillNumber());
        if ("sm".equals(dataEntityType.getAppId())) {
            Boolean isautoquote = (Boolean)SysParamHelper.getSysParam4sm((Long)org.getPkValue(), "isautoquote");
            if (isautoquote == null) {
                return false;
            }
            return isautoquote;
        }
        if ("pm".equals(dataEntityType.getAppId())) {
            Boolean isautoquote = (Boolean)SysParamHelper.getSysParam4pm((Long)org.getPkValue(), "isautoquote");
            if (isautoquote == null) {
                return false;
            }
            return isautoquote;
        }
        return true;
    }

    protected boolean isCloseListener() {
        return false;
    }

    protected String getQuoteBillNumber() {
        String name = this.getModel().getDataEntityType().getName();
        return name;
    }

    protected void addSpecialListenFields(Set<String> specialListenKeys) {
    }

    protected boolean cancelAutoQuote() {
        return false;
    }

    protected void afterUpdateView() {
    }

    protected String getProgressBarKey() {
        return "autoquotebar";
    }

    private void initAutoQuoteListenField() {
        if (this.isAutoQuote()) {
            if (this.listenFields == null && this.getCache(LISTEN_KEY) == null) {
                this.cacheListenFields();
            }
        } else {
            this.listenFields = null;
            this.removeCache(LISTEN_KEY);
        }
    }

    private boolean isLongBlank(Long rowId) {
        return rowId == null || 0L == rowId;
    }

    private boolean isChangeNull(ChangeData[] changeSet) {
        for (ChangeData data : changeSet) {
            Object newValue = data.getNewValue();
            if (!this.isFieldBlank(newValue)) continue;
            return true;
        }
        return false;
    }

    private Object quote() {
        Map<Long, List<DynamicObject>> param = this.getQuoteParam(true);
        if (param.isEmpty()) {
            return null;
        }
        Map<Long, Map<String, Object>> priceMapKeyFromCache = this.getPriceMapKeyFromCache(param.keySet());
        if (priceMapKeyFromCache == null) {
            log.info("\u3010\u81ea\u52a8\u53d6\u4ef7\u3011\u53d6\u4ef7\u670d\u52a1queryMapKeyIgnoreExp\u83b7\u53d6\u6570\u636e\u5931\u8d25");
            return null;
        }
        Map<Long, List<Map<String, Object>>> propertiesMap = FetchPriceHelper.buildMap4Entry(priceMapKeyFromCache, param);
        HashMap<String, Object> quoteParam = new HashMap<String, Object>(2);
        quoteParam.put("auto", "1");
        return FetchPriceHelper.fetchPrice(this.getQuoteBillNumber(), propertiesMap, quoteParam);
    }

    private void addPkValue() {
        DynamicObjectCollection entry;
        String entryNumber;
        long startTime = System.currentTimeMillis();
        boolean noBillId = false;
        ArrayList<DynamicObject> todoEntryList = new ArrayList<DynamicObject>();
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity(true);
        Long billId = (Long)bill.getPkValue();
        if (this.isLongBlank(billId)) {
            noBillId = true;
        }
        if (!StringUtils.isEmpty((CharSequence)(entryNumber = this.getQuoteBillEntryNumber())) && (entry = bill.getDynamicObjectCollection(entryNumber)) != null) {
            for (DynamicObject row : entry) {
                Long entryId = (Long)row.getPkValue();
                if (!this.isLongBlank(entryId)) continue;
                todoEntryList.add(row);
            }
        }
        int idCount = todoEntryList.size();
        if (noBillId) {
            ++idCount;
        }
        if (idCount == 0) {
            return;
        }
        long[] longIds = DBServiceHelper.genLongIds(null, (int)idCount);
        int startIndex = 0;
        if (noBillId) {
            model.setValue("id", (Object)longIds[0]);
            startIndex = 1;
        }
        for (int i = 0; i < todoEntryList.size(); ++i) {
            DynamicObject row = (DynamicObject)todoEntryList.get(i);
            row.set("id", (Object)longIds[i + startIndex]);
        }
        log.info("\u3010\u81ea\u52a8\u53d6\u4ef7\u3011pageId=" + this.getPageCache().getPageId() + "\uff0c\u8865\u5145ID\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime));
    }

    protected Map<Long, List<DynamicObject>> getQuoteParam(boolean isNeedClone) {
        DynamicObject bill;
        IDataModel model = this.getModel();
        DynamicObject cloneBill = bill = model.getDataEntity(true);
        if (isNeedClone) {
            cloneBill = (DynamicObject)OrmUtils.clone((IDataEntityBase)bill, (boolean)true, (boolean)false);
        }
        if (this.isFieldsInvalid(cloneBill)) {
            log.info("\u3010\u81ea\u52a8\u53d6\u4ef7\u3011\u5f02\u6b65\u7ebf\u7a0b\u5b57\u6bb5\u5b8c\u5907\u6027\u6821\u9a8c\u4e0d\u901a\u8fc7");
            return Collections.emptyMap();
        }
        HashMap<Long, List<DynamicObject>> param = new HashMap<Long, List<DynamicObject>>(4);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(1);
        list.add(cloneBill);
        DynamicObject org = cloneBill.getDynamicObject(this.getMainOrgKey());
        if (org == null) {
            log.info("\u3010\u81ea\u52a8\u53d6\u4ef7\u3011\u83b7\u53d6\u53d6\u4ef7\u7ec4\u7ec7\u5931\u8d25");
            return Collections.emptyMap();
        }
        param.put((Long)org.getPkValue(), list);
        return param;
    }

    protected Map<Long, Map<String, Object>> getPriceMapKeyFromCache(Set<Long> orgIds) {
        if (this.priceMapKey != null) {
            return this.priceMapKey;
        }
        String priceMapStr = this.getCache(PRICE_MAP_KEY);
        if (priceMapStr != null) {
            Map temp = (Map)SerializationUtils.fromJsonString((String)priceMapStr, Map.class);
            this.priceMapKey = new HashMap<Long, Map<String, Object>>(temp.size() << 1);
            for (Map.Entry mapEntry : temp.entrySet()) {
                this.priceMapKey.put(Long.parseLong((String)mapEntry.getKey()), (Map<String, Object>)mapEntry.getValue());
            }
            return this.priceMapKey;
        }
        Map<Long, Map<String, Object>> map = FetchPriceHelper.fetchPriceConditonKey(orgIds, this.getQuoteBillNumber());
        if (map == null) {
            return null;
        }
        this.putCache(PRICE_MAP_KEY, SerializationUtils.toJsonString(map));
        this.priceMapKey = map;
        return this.priceMapKey;
    }

    private String getAutoQuoteResult() {
        return this.asyncQuoteHandler.getResultFromCache(this.getPageCache());
    }

    private boolean updateView(String quoteResult) {
        Map quoteHeadMap;
        log.info("\u83b7\u53d6\u81ea\u52a8\u53d6\u4ef7\u670d\u52a1\u6570\u636e\uff0cpageId=" + this.getPageCache().getPageId() + "\uff0cquoteResult=" + quoteResult);
        IDataModel model = this.getModel();
        Map result = (Map)SerializationUtils.fromJsonString((String)quoteResult, Map.class);
        DynamicObject org = (DynamicObject)model.getValue(this.getMainOrgKey());
        if (org == null) {
            return false;
        }
        Long orgId = (Long)org.getPkValue();
        String quoteOrgId = (String)result.get(ORG_ID_KEY);
        if (!orgId.toString().equals(quoteOrgId)) {
            return false;
        }
        String quoteBillId = (String)result.get(BILL_ID_KEY);
        DynamicObject bill = model.getDataEntity(true);
        Long billId = (Long)bill.getPkValue();
        if (billId == null || !billId.toString().equals(quoteBillId)) {
            return false;
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection(this.getQuoteBillEntryNumber());
        if (entry == null) {
            return false;
        }
        boolean headIsCover = "B".equals(result.get(HEAD_IS_COVER_KEY));
        boolean isUpdate = false;
        if (this.isCloseListener()) {
            this.putCache(STOP_CHANGE_KEY, STOP_CHANGE);
        }
        if ((quoteHeadMap = (Map)result.get(QUOTE_HEAD_MAP_KEY)) != null) {
            for (Map.Entry quoteHeadField : quoteHeadMap.entrySet()) {
                String key = (String)quoteHeadField.getKey();
                Object oldValue = model.getValue(key);
                if (!headIsCover && !this.isFieldBlank(oldValue)) continue;
                Object newValue = quoteHeadField.getValue();
                if (oldValue instanceof DynamicObject && this.isZero(newValue)) {
                    newValue = null;
                }
                model.setValue(key, newValue);
                isUpdate = true;
            }
        }
        Map quoteEntryMap = (Map)result.get(QUOTE_ENTRY_MAP_KEY);
        Map entryIsCoverMap = (Map)result.get(ENTRY_IS_COVER_KEY);
        if (quoteEntryMap != null && !quoteEntryMap.isEmpty()) {
            for (int i = 0; i < entry.size(); ++i) {
                Map quoteFieldMap;
                DynamicObject row = (DynamicObject)entry.get(i);
                Long rowId = (Long)row.getPkValue();
                if (this.isLongBlank(rowId) || (quoteFieldMap = (Map)quoteEntryMap.get(rowId.toString())) == null) continue;
                boolean rowIsCover = "B".equals(entryIsCoverMap.get(rowId.toString()));
                for (Map.Entry quoteEntryField : quoteFieldMap.entrySet()) {
                    String key = (String)quoteEntryField.getKey();
                    Object oldValue = model.getValue(key, i);
                    if (!rowIsCover && !this.isFieldBlank(oldValue)) continue;
                    Object newValue = quoteEntryField.getValue();
                    if (oldValue instanceof DynamicObject && this.isZero(newValue)) {
                        newValue = null;
                    }
                    model.setValue(key, newValue, i);
                    isUpdate = true;
                }
            }
        }
        if (this.isCloseListener()) {
            this.removeCache(STOP_CHANGE_KEY);
        }
        log.info("\u81ea\u52a8\u53d6\u4ef7\u670d\u52a1\u9875\u9762\u5237\u65b0\u5b8c\u6210\u3002");
        return isUpdate;
    }

    private boolean isZero(Object newValue) {
        if (newValue instanceof Integer) {
            return 0 == (Integer)newValue;
        }
        if (newValue instanceof Long) {
            return 0L == (Long)newValue;
        }
        if (newValue instanceof BigDecimal) {
            return BigDecimalUtil.isZero((BigDecimal)newValue);
        }
        return false;
    }

    private void stopProgress() {
        this.removeCache(PROGRESS_START_KEY);
        this.removeCache(INVALID_POLLING_NUM_KEY);
        this.getProgressBar().stop();
    }

    private boolean startProgress() {
        ProgressBar progressBar = this.getProgressBar();
        if (progressBar == null) {
            return false;
        }
        this.putCache(PROGRESS_START_KEY, PROGRESS_START);
        this.putCache(INVALID_POLLING_NUM_KEY, "0");
        progressBar.start();
        return true;
    }

    private boolean isOnProgress() {
        return PROGRESS_START.equals(this.getCache(PROGRESS_START_KEY));
    }

    private boolean isFieldsInvalid(DynamicObject bill) {
        if (this.listenFields == null) {
            return false;
        }
        IDataModel model = this.getModel();
        if (bill == null) {
            bill = model.getDataEntity(true);
        }
        for (String field : this.listenFields) {
            DynamicObjectCollection entry;
            IDataEntityProperty property = model.getProperty(field);
            IDataEntityType parent = property.getParent();
            if (parent instanceof BillEntityType) {
                if (!this.isFieldBlank(bill.get(field))) continue;
                return true;
            }
            if (!(parent instanceof EntryType) || (entry = bill.getDynamicObjectCollection(parent.getName())) == null) continue;
            for (DynamicObject row : entry) {
                if (!this.isFieldBlank(row.get(field))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFieldBlank(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return StringUtils.isBlank((Object)value);
        }
        if (value instanceof BigDecimal) {
            return BigDecimalUtil.isZero((BigDecimal)value);
        }
        if (value instanceof Long) {
            return this.isLongBlank((Long)value);
        }
        return false;
    }

    private Set<String> getListenFieldsFromCache() {
        if (this.listenFields != null) {
            return this.listenFields;
        }
        String listenFieldStr = this.getCache(LISTEN_KEY);
        if (StringUtils.isEmpty((CharSequence)listenFieldStr)) {
            return null;
        }
        String[] listenFieldArray = listenFieldStr.split(SEPARATOR);
        this.listenFields = new HashSet<String>(Arrays.asList(listenFieldArray));
        return this.listenFields;
    }

    private void cacheListenFields() {
        String listenFieldStr = this.queryListenFields();
        if (StringUtils.isEmpty((CharSequence)listenFieldStr)) {
            return;
        }
        log.info("\u3010\u81ea\u52a8\u53d6\u4ef7\u3011\u9875\u9762\u521d\u59cb\u5316\u7f13\u5b58\u76d1\u542c\u5b57\u6bb5\uff1a" + listenFieldStr);
        this.putCache(LISTEN_KEY, listenFieldStr);
    }

    private Set<String> initSpecialListenFields() {
        HashSet<String> fields = new HashSet<String>();
        this.addSpecialListenFields(fields);
        return fields;
    }

    private String queryListenFields() {
        QFilter qFilter = new QFilter("quotebill", "=", (Object)this.getQuoteBillNumber());
        qFilter.and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
        StringJoiner listenFiledJoiner = new StringJoiner(SEPARATOR, "", "");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)QUOTE_FACTOR_NAME, (String)QUOTE_FACTOR_PROPERTIES, (QFilter[])qFilter.toArray(), null);){
            for (Row row : dataSet) {
                String listenFiledKey = row.getString("entryentity.quotefactornumber");
                if (StringUtils.isEmpty((CharSequence)listenFiledKey)) continue;
                listenFiledJoiner.add(listenFiledKey);
            }
        }
        return listenFiledJoiner.toString();
    }

    private boolean canEditStatus() {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = billShowParameter.getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            return false;
        }
        BillOperationStatus billStatus = billShowParameter.getBillStatus();
        return BillOperationStatus.ADDNEW.equals((Object)billStatus) || BillOperationStatus.EDIT.equals((Object)billStatus);
    }

    private ProgressBar getProgressBar() {
        return (ProgressBar)this.getControl(this.getProgressBarKey());
    }

    private int getInvalidPollingMaxNum() {
        return 60;
    }
}

