/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.mpscmm.msbd.common.pojo.MethodParameter;

public class CustomParameterPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"parmvalue", "btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object customParameter = this.getView().getFormShowParameter().getCustomParam("customparameter");
        IDataModel model = this.getModel();
        if (customParameter == null || !(customParameter instanceof List)) {
            return;
        }
        List customParameterList = (List)customParameter;
        customParameterList.forEach(methodParameter -> {
            int rowId = model.createNewEntryRow("entryentity");
            model.setValue("parmname", methodParameter.get("name"), rowId);
            model.setValue("parmtype", methodParameter.get("type"), rowId);
            model.setValue("parmvalue", methodParameter.get("val"), rowId);
            model.setValue("description", methodParameter.get("description"), rowId);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("parmvalue".equals(key)) {
            String parmtype = (String)this.getModel().getValue("parmtype");
            if (!"jsonarray".equals(parmtype)) {
                return;
            }
            FormShowParameter jsonParameter = new FormShowParameter();
            jsonParameter.getOpenStyle().setShowType(ShowType.Modal);
            jsonParameter.setFormId("msbd_customjson");
            jsonParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "customjson"));
            jsonParameter.setHasRight(true);
            String parmValue = (String)this.getModel().getValue("parmvalue");
            if (!"".equals(parmValue)) {
                jsonParameter.setCustomParam("jsonparameter", JSONObject.parseObject((String)parmValue, Map.class));
            }
            this.getView().showForm(jsonParameter);
        } else if ("btnok".equals(key)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            List entryList = entryEntity.stream().map(row -> new MethodParameter(row.getString("parmname"), row.getString("parmtype"), row.getString("parmvalue"), row.getString("description"))).collect(Collectors.toList());
            this.getView().returnDataToParent(entryList);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (!"customjson".equals(actionId)) {
            return;
        }
        Map result = (Map)evt.getReturnData();
        if (result == null || result.size() <= 0) {
            return;
        }
        this.getModel().setValue("parmvalue", (Object)SerializationUtils.toJsonString((Object)result));
    }
}

