/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.formplugin;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.formplugin.AbstractAutoQuotePlugin;

public class DefaultAutoQuotePlugin
extends AbstractAutoQuotePlugin {
    private static final Log log = LogFactory.getLog(DefaultAutoQuotePlugin.class);
    private static String ENTRY_FLAG = "entry";
    public static final String SPLIT = "\\.";
    private static final String ENTRYNAME_KEY = "ENTRYNAME";

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        this.getPageCache().put("cancelAutoQuote", "stop");
    }

    @Override
    protected String getMainOrgKey() {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getQuoteBillNumber());
        String orgProperty = dataEntityType.getMainOrg();
        if ("im".equals(dataEntityType.getAppId()) || "pm_requirapplybill".equals(dataEntityType.getName())) {
            if (dataEntityType.getAllFields().containsKey("bizorg")) {
                orgProperty = "bizorg";
            }
        } else if ("pm_vmisettle".equals(dataEntityType.getName()) && dataEntityType.getAllFields().containsKey("org")) {
            orgProperty = "org";
        }
        return orgProperty;
    }

    @Override
    protected String getQuoteBillEntryNumber() {
        String entryName = this.getCache(ENTRYNAME_KEY);
        if (StringUtils.isNotEmpty((String)entryName)) {
            return entryName;
        }
        Map<Long, List<DynamicObject>> param = this.getQuoteParam(false);
        if (param.isEmpty()) {
            return null;
        }
        Map<Long, Map<String, Object>> priceMapKeyFromCache = this.getPriceMapKeyFromCache(param.keySet());
        if (priceMapKeyFromCache == null) {
            log.info("\u3010\u81ea\u52a8\u53d6\u4ef7\u3011\u53d6\u4ef7\u670d\u52a1queryMapKeyIgnoreExp\u83b7\u53d6\u6570\u636e\u5931\u8d25");
            return null;
        }
        Set<Map.Entry<Long, Map<String, Object>>> t = priceMapKeyFromCache.entrySet();
        for (Map.Entry<Long, Map<String, Object>> entry : t) {
            Map<String, Object> keyResult = entry.getValue();
            List entryKeys = (List)keyResult.get(ENTRY_FLAG);
            if (entryKeys == null || entryKeys.size() <= 0) continue;
            String[] fields = ((String)entryKeys.get(0)).split(SPLIT);
            entryName = fields[0];
            break;
        }
        if (StringUtils.isNotEmpty((String)entryName)) {
            this.putCache(ENTRYNAME_KEY, entryName);
            return entryName;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getQuoteBillNumber());
        if (dataEntityType.getAllEntities().containsKey("billentry")) {
            return "billentry";
        }
        return null;
    }
}

