/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.opplugin;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.business.helper.BillTypeHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class BillTypeCoreValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull(preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("billtype");
        preparePropertys.add("biztype");
        preparePropertys.add("linetype");
        preparePropertys.add("material");
        preparePropertys.add("materialmasterid");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        switch (this.getOperateKey()) {
            case "submit": 
            case "save": 
            case "audit": {
                for (ExtendedDataEntity dataEntitie : this.getDataEntities()) {
                    DynamicObject bill = dataEntitie.getDataEntity();
                    String formId = bill.getDataEntityType().getName();
                    DynamicObject billtype = bill.getDynamicObject("billtype");
                    DynamicObject biztype = bill.getDynamicObject("biztype");
                    DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
                    if (CommonUtils.isNull(biztype) || CommonUtils.isNull(billtype) || CommonUtils.isNull(biztype)) continue;
                    if (!BillTypeHelper.checkBillType(formId, billtype.getLong("id"))) {
                        this.addMessage(dataEntitie, ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0e\u5355\u636e\u5b9e\u4f53\u4e0d\u4e00\u81f4\u3002", (String)"BillTypeCoreValidator_0", (String)"mpscmm-msbd-common", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (CommonUtils.isNull(billentry)) continue;
                    int row = 0;
                    for (DynamicObject entry : billentry) {
                        ++row;
                        DynamicObject linetype = entry.getDynamicObject("linetype");
                        if (CommonUtils.isNull(linetype) || BizTypeHelper.checkLineTypeInBizType(linetype.getLong("id"), biztype.getLong("id"))) continue;
                        String tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u201c\u884c\u7c7b\u578b\u201d\u4e0d\u662f\u5f53\u524d\u5355\u636e\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u5173\u8054\u7684\u884c\u7c7b\u578b\u3002", (String)"BillTypeCoreValidator_1", (String)"mpscmm-msbd-common", (Object[])new Object[0]), row);
                        this.addMessage(dataEntitie, tipMsg, ErrorLevel.Error);
                    }
                }
                break;
            }
        }
    }
}

