/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.opplugin.integration;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.business.helper.BillQuantityHelper;
import kd.mpscmm.msbd.business.helper.CurrencyHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;

public class PmSmBillIntegrationSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PmSmBillIntegrationSaveOp.class);
    private static String FORMAT = "0.0000000000";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("exratetable");
        e.getFieldKeys().add("billentry.taxrate");
        e.getFieldKeys().add("billentry.taxrateid");
        e.getFieldKeys().add("billentry.unit");
        e.getFieldKeys().add("billentry.baseunit");
        e.getFieldKeys().add("billentry.qty");
        e.getFieldKeys().add("billentry.baseqty");
        if ("sm_salorder".equals(this.billEntityType.getName())) {
            List<String> fields = Arrays.asList("bizdate", "deliverrateup", "deliverratedown", "iscontrolqty", "deliverqtyup", "deliverqtydown", "deliverbaseqtyup", "deliverbaseqtydown", "remainbackqty", "remainbasebackqty", "backqty", "basebackqty", "purjoinqty", "basepurjoinqty", "purqty", "basepurqty");
            fields.forEach(f -> e.getFieldKeys().add(f));
            e.getFieldKeys().add("material.minorderqty");
            e.getFieldKeys().add("material.masterid");
            e.getFieldKeys().add("material.salesunit");
            e.getFieldKeys().add("billentry.minorderbaseqty");
        } else if ("pm_purorderbill".equals(this.billEntityType.getName())) {
            List<String> fields = Arrays.asList("biztime", "receiverateup", "receiveratedown", "iscontrolqty", "receiveqtyup", "receiveqtydown", "receivebaseqtyup", "receivebaseqtydown", "invretqty", "invretbaseqty", "returnqty", "returnbaseqty");
            fields.forEach(f -> e.getFieldKeys().add(f));
        } else if ("conm_purcontract".equals(this.billEntityType.getName())) {
            List<String> fields = Arrays.asList("joinorderqty", "joinorderbaseqty", "orderqty", "orderbaseqty");
            fields.forEach(f -> e.getFieldKeys().add(f));
        } else if ("conm_salcontract".equals(this.billEntityType.getName())) {
            List<String> fields = Arrays.asList("joinorderqty", "joinorderbaseqty", "orderqty", "orderbaseqty");
            fields.forEach(f -> e.getFieldKeys().add(f));
        } else if ("pm_purrefundapplybill".equals(this.billEntityType.getName())) {
            List<String> fields = Arrays.asList("joinqty", "joinbaseqty");
            fields.forEach(f -> e.getFieldKeys().add(f));
        } else if ("sctm_scpo".equals(this.billEntityType.getName())) {
            List<String> fields = Arrays.asList("biztime", "receiverateup", "receiveratedown", "iscontrolqty", "receiveqtyup", "receiveqtydown", "receivebaseqtyup", "receivebaseqtydown");
            fields.forEach(f -> e.getFieldKeys().add(f));
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        if (bills != null && bills.length > 0) {
            this.initExchangeRateInfo(bills);
            this.initTaxRate(bills);
            if ("sm_salorder".equals(this.billEntityType.getName())) {
                for (DynamicObject bill : bills) {
                    DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
                    for (DynamicObject entryInfo : billentry) {
                        BigDecimal receiveRateUp = entryInfo.getBigDecimal("deliverrateup");
                        BigDecimal receiveRateDown = entryInfo.getBigDecimal("deliverratedown");
                        BigDecimal qty = entryInfo.getBigDecimal("qty");
                        BigDecimal baseQty = entryInfo.getBigDecimal("baseQty");
                        Boolean isControlQty = entryInfo.getBoolean("iscontrolqty");
                        DynamicObject unit = entryInfo.getDynamicObject("unit");
                        DynamicObject baseUnit = entryInfo.getDynamicObject("baseunit");
                        if (isControlQty.booleanValue() && receiveRateUp != null && receiveRateDown != null) {
                            BigDecimal receiveQtyUp = this.getQtyUp(qty, receiveRateUp, unit);
                            BigDecimal receiveQtyDown = this.getQtyDown(qty, receiveRateDown, unit);
                            BigDecimal receiveBaseQtyUp = this.getQtyUp(baseQty, receiveRateUp, baseUnit);
                            BigDecimal receiveBaseQtyDown = this.getQtyDown(baseQty, receiveRateDown, baseUnit);
                            entryInfo.set("deliverqtyup", (Object)receiveQtyUp);
                            entryInfo.set("deliverqtydown", (Object)receiveQtyDown);
                            entryInfo.set("deliverbaseqtyup", (Object)receiveBaseQtyUp);
                            entryInfo.set("deliverbaseqtydown", (Object)receiveBaseQtyDown);
                        }
                        List<String> convertQtyFields = Arrays.asList("remainbackqty", "backqty", "purjoinqty", "purqty");
                        List<String> convertBaseQtyFields = Arrays.asList("remainbasebackqty", "basebackqty", "basepurjoinqty", "basepurqty");
                        this.setBaseQty(entryInfo, convertQtyFields, convertBaseQtyFields);
                        DynamicObject material = entryInfo.getDynamicObject("material");
                        if (material == null) continue;
                        BigDecimal minorderqty = material.getBigDecimal("minorderqty");
                        Long materialMasterID = material.getDynamicObject("masterid") != null ? Long.valueOf(material.getDynamicObject("masterid").getLong("id")) : null;
                        BigDecimal minorderBaseqty = BillQuantityHelper.getDesQtyConv(materialMasterID, material.getDynamicObject("salesunit"), minorderqty, entryInfo.getDynamicObject("baseunit"));
                        entryInfo.set("minorderbaseqty", (Object)minorderBaseqty);
                    }
                }
            } else if ("pm_purorderbill".equals(this.billEntityType.getName())) {
                for (DynamicObject bill : bills) {
                    DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
                    for (DynamicObject entryInfo : billentry) {
                        BigDecimal receiveRateUp = entryInfo.getBigDecimal("receiverateup");
                        BigDecimal receiveRateDown = entryInfo.getBigDecimal("receiveratedown");
                        BigDecimal qty = entryInfo.getBigDecimal("qty");
                        BigDecimal baseQty = entryInfo.getBigDecimal("baseQty");
                        Boolean isControlQty = entryInfo.getBoolean("iscontrolqty");
                        DynamicObject unit = entryInfo.getDynamicObject("unit");
                        DynamicObject baseUnit = entryInfo.getDynamicObject("baseunit");
                        if (isControlQty.booleanValue() && receiveRateUp != null && receiveRateDown != null) {
                            BigDecimal receiveQtyUp = this.getQtyUp(qty, receiveRateUp, unit);
                            BigDecimal receiveQtyDown = this.getQtyDown(qty, receiveRateDown, unit);
                            BigDecimal receiveBaseQtyUp = this.getQtyUp(baseQty, receiveRateUp, baseUnit);
                            BigDecimal receiveBaseQtyDown = this.getQtyDown(baseQty, receiveRateDown, baseUnit);
                            entryInfo.set("receiveqtyup", (Object)receiveQtyUp);
                            entryInfo.set("receiveqtydown", (Object)receiveQtyDown);
                            entryInfo.set("receivebaseqtyup", (Object)receiveBaseQtyUp);
                            entryInfo.set("receivebaseqtydown", (Object)receiveBaseQtyDown);
                        }
                        List<String> convertQtyFields = Arrays.asList("invretqty", "returnqty");
                        List<String> convertBaseQtyFields = Arrays.asList("invretbaseqty", "returnbaseqty");
                        this.setBaseQty(entryInfo, convertQtyFields, convertBaseQtyFields);
                    }
                }
            } else if ("conm_purcontract".equals(this.billEntityType.getName()) || "conm_salcontract".equals(this.billEntityType.getName())) {
                for (DynamicObject bill : bills) {
                    DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
                    for (DynamicObject entryInfo : billentry) {
                        List<String> convertQtyFields = Arrays.asList("joinorderqty", "orderqty");
                        List<String> convertBaseQtyFields = Arrays.asList("joinorderbaseqty", "orderbaseqty");
                        this.setBaseQty(entryInfo, convertQtyFields, convertBaseQtyFields);
                    }
                }
            } else if (!"pm_purrefundapplybill".equals(this.billEntityType.getName()) && "sctm_scpo".equals(this.billEntityType.getName())) {
                for (DynamicObject bill : bills) {
                    DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
                    for (DynamicObject entryInfo : billentry) {
                        BigDecimal receiveRateUp = entryInfo.getBigDecimal("receiverateup");
                        BigDecimal receiveRateDown = entryInfo.getBigDecimal("receiveratedown");
                        BigDecimal qty = entryInfo.getBigDecimal("qty");
                        BigDecimal baseQty = entryInfo.getBigDecimal("baseQty");
                        Boolean isControlQty = entryInfo.getBoolean("iscontrolqty");
                        DynamicObject unit = entryInfo.getDynamicObject("unit");
                        DynamicObject baseUnit = entryInfo.getDynamicObject("baseunit");
                        if (!isControlQty.booleanValue() || receiveRateUp == null || receiveRateDown == null) continue;
                        BigDecimal receiveQtyUp = this.getQtyUp(qty, receiveRateUp, unit);
                        BigDecimal receiveQtyDown = this.getQtyDown(qty, receiveRateDown, unit);
                        BigDecimal receiveBaseQtyUp = this.getQtyUp(baseQty, receiveRateUp, baseUnit);
                        BigDecimal receiveBaseQtyDown = this.getQtyDown(baseQty, receiveRateDown, baseUnit);
                        entryInfo.set("receiveqtyup", (Object)receiveQtyUp);
                        entryInfo.set("receiveqtydown", (Object)receiveQtyDown);
                        entryInfo.set("receivebaseqtyup", (Object)receiveBaseQtyUp);
                        entryInfo.set("receivebaseqtydown", (Object)receiveBaseQtyDown);
                    }
                }
            }
        }
        super.beginOperationTransaction(e);
    }

    private void initTaxRate(DynamicObject[] bills) {
        DynamicObject[] taxRates;
        DecimalFormat df4 = new DecimalFormat(FORMAT);
        HashMap<String, DynamicObject> taxRateCache = new HashMap<String, DynamicObject>(16);
        for (DynamicObject taxRate : taxRates = BusinessDataServiceHelper.load((String)"bd_taxrate", (String)"id,taxrate", (QFilter[])new QFilter[0], (String)"activedate")) {
            BigDecimal rate = taxRate.getBigDecimal("taxrate");
            String rateKey = df4.format(rate);
            taxRateCache.put(rateKey, taxRate);
        }
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entryInfo : billentry) {
                DynamicObject taxrateid = entryInfo.getDynamicObject("taxrateid");
                BigDecimal taxrate = entryInfo.getBigDecimal("taxrate");
                if (taxrateid != null) continue;
                String rateKey = df4.format(taxrate);
                entryInfo.set("taxrateid", taxRateCache.get(rateKey));
            }
        }
    }

    private void initExchangeRateInfo(DynamicObject[] bills) {
        DynamicObject org;
        HashMap<Long, Map<String, Long>> finInfoMap = new HashMap<Long, Map<String, Long>>(16);
        HashSet<Long> orgPKSet = new HashSet<Long>();
        for (Object bill : bills) {
            org = bill.getDynamicObject("org");
            if (org == null) continue;
            orgPKSet.add((Long)org.getPkValue());
        }
        for (Long orgPK : orgPKSet) {
            Map<String, Long> map = CurrencyHelper.getCurrencyAndExRateTable(orgPK);
            if (map == null) continue;
            finInfoMap.put(orgPK, map);
        }
        if (finInfoMap.size() > 0) {
            for (Object bill : bills) {
                DynamicObject exRateTable;
                org = bill.getDynamicObject("org");
                if (org == null) continue;
                Map accountingInfo = (Map)finInfoMap.get((Long)org.getPkValue());
                DynamicObject currency = bill.getDynamicObject("currency");
                if (currency == null) {
                    currency = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_currency"), accountingInfo.get("baseCurrencyID"));
                    bill.set("currency", (Object)currency);
                }
                if ((exRateTable = bill.getDynamicObject("exratetable")) != null) continue;
                exRateTable = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_exratetable"), accountingInfo.get("exchangeRateTableID"));
                bill.set("exratetable", (Object)exRateTable);
            }
        }
    }

    private BigDecimal getQtyUp(BigDecimal qty, BigDecimal receiveRateUp, DynamicObject unit) {
        return BigDecimalUtil.getByGrowRate(qty, BigDecimalUtil.div100(receiveRateUp)).setScale(this.getPrecision(unit), this.getUnitRoundingMode(unit));
    }

    private BigDecimal getQtyDown(BigDecimal qty, BigDecimal receiveRateDown, DynamicObject unit) {
        return BigDecimalUtil.getByReduceRate(qty, BigDecimalUtil.div100(receiveRateDown)).setScale(this.getPrecision(unit), this.getUnitRoundingMode(unit));
    }

    private int getPrecision(DynamicObject unit) {
        int precision = 10;
        if (unit != null) {
            precision = unit.getInt("precision");
        }
        return precision;
    }

    private RoundingMode getUnitRoundingMode(DynamicObject unit) {
        if (unit != null && !StringUtils.isBlank((Object)unit.get("precisionaccount"))) {
            RoundingMode roundingMode;
            switch (unit.getString("precisionaccount")) {
                case "2": {
                    roundingMode = RoundingMode.DOWN;
                    break;
                }
                case "3": {
                    roundingMode = RoundingMode.UP;
                    break;
                }
                default: {
                    roundingMode = RoundingMode.HALF_UP;
                }
            }
            return roundingMode;
        }
        return RoundingMode.HALF_UP;
    }

    private void setBaseQty(DynamicObject entryInfo, List<String> convertQtyFields, List<String> convertBaseQtyFields) {
        BigDecimal baseQty = entryInfo.getBigDecimal("baseqty");
        BigDecimal qty = entryInfo.getBigDecimal("qty");
        DynamicObject baseUnit = entryInfo.getDynamicObject("baseunit");
        for (int i = 0; i < convertQtyFields.size(); ++i) {
            BigDecimal convertQty = entryInfo.getBigDecimal(convertQtyFields.get(i));
            if (BigDecimal.ZERO.compareTo(qty) == 0) {
                entryInfo.set(convertBaseQtyFields.get(i), (Object)BigDecimal.ZERO);
                continue;
            }
            BigDecimal convertBaseQty = convertQty.multiply(baseQty).divide(qty, this.getPrecision(baseUnit), this.getUnitRoundingMode(baseUnit));
            entryInfo.set(convertBaseQtyFields.get(i), (Object)convertBaseQty);
        }
    }
}

