/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.expense.business.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.expense.business.helper.ExpenseBillHelper;
import kd.mpscmm.msbd.expense.business.helper.ExpenseExtHelper;
import kd.mpscmm.msbd.expense.business.pojo.UpDownBizRelation;
import kd.mpscmm.msbd.expense.business.service.ExpenseCtx;

public class ExpenseService {
    private static final Log logger = LogFactory.getLog(ExpenseService.class);

    public static Map<Long, Map<String, Object>> updateExpense(String bizBillEntity, Set<Long> bizBillIds, Map<String, Object> mapParam) {
        boolean expsScmParam;
        if (CommonUtils.isNull(bizBillIds) || bizBillIds.size() == 0) {
            return null;
        }
        long beginupdexpstime = System.currentTimeMillis();
        logger.info("updateExpense----Begin: " + new Date(beginupdexpstime));
        boolean isexpsbtn = false;
        if (mapParam != null) {
            isexpsbtn = (Boolean)mapParam.get("isexpsbtn");
        }
        if (!isexpsbtn && !(expsScmParam = ExpenseService.getExpenseScmParam())) {
            return null;
        }
        ExpenseCtx expsCtx = new ExpenseCtx();
        HashMap<Long, Map<String, Object>> expenseResult = new HashMap<Long, Map<String, Object>>(8);
        expsCtx.setExpenseResult(expenseResult);
        long beginfindmodelmaptime = System.currentTimeMillis();
        Map<String, String> priceModelMap = ExpenseBillHelper.getFieldMap(bizBillEntity);
        long endfindmodelmaptime = System.currentTimeMillis();
        expsCtx.setBizBillFldMap(priceModelMap);
        boolean hasModelMap = ExpenseService.checkModelMap(expsCtx, bizBillEntity, bizBillIds, priceModelMap);
        if (!hasModelMap) {
            return expsCtx.getExpenseResult();
        }
        ArrayList<DynamicObject> bizBills = new ArrayList<DynamicObject>(2);
        String selProps = ExpenseBillHelper.getSelectProps(bizBillEntity);
        String extSelProps = ExpenseExtHelper.getExtBizPops(bizBillEntity, priceModelMap);
        if (!StringUtils.isEmpty((String)extSelProps)) {
            selProps = selProps + "," + extSelProps;
        }
        long beginfindbizbilltime = System.currentTimeMillis();
        DynamicObject[] bizBillObjs = BusinessDataServiceHelper.load((String)bizBillEntity, (String)selProps, (QFilter[])new QFilter[]{new QFilter("id", "in", bizBillIds)});
        long endfindbizbilltime = System.currentTimeMillis();
        if (bizBillIds.size() == 1 && bizBillObjs.length == 0) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u5355\u636e\u3002", (String)"ExpenseService_13", (String)"mpscmm-msbd-expense", (Object[])new Object[0]);
            for (Long bizId : bizBillIds) {
                if (expenseResult.get(bizId) == null) {
                    HashMap<String, Object> rsltMap = new HashMap<String, Object>(8);
                    rsltMap.put("success", Boolean.FALSE);
                    rsltMap.put("billentity", bizBillEntity);
                    rsltMap.put("message", msg);
                    expenseResult.put(bizId, rsltMap);
                    continue;
                }
                ((Map)expenseResult.get(bizId)).put("success", Boolean.FALSE);
                ((Map)expenseResult.get(bizId)).put("billentity", bizBillEntity);
                if (((Map)expenseResult.get(bizId)).get("message") != null) {
                    ((Map)expenseResult.get(bizId)).put("message", ((Map)expenseResult.get(bizId)).get("message").toString() + msg);
                    continue;
                }
                ((Map)expenseResult.get(bizId)).put("message", msg);
            }
            return expsCtx.getExpenseResult();
        }
        for (DynamicObject bizBill : bizBillObjs) {
            bizBills.add(bizBill);
        }
        long begingetexpstime = System.currentTimeMillis();
        Map<Long, DynamicObject> expenseMap = ExpenseService.getExpenseBillByBizBillIds(bizBillIds);
        long endgetexpstime = System.currentTimeMillis();
        HashSet<Long> needGenerateIds = new HashSet<Long>(8);
        ArrayList<DynamicObject> needGenerateBills = new ArrayList<DynamicObject>(8);
        HashSet<Long> needReCalIds = new HashSet<Long>(8);
        ArrayList<DynamicObject> needReCalBills = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> needReCalExpenseBills = new ArrayList<DynamicObject>(8);
        HashSet<Long> needUpdStatusIds = new HashSet<Long>(8);
        ArrayList<DynamicObject> needUpdStatusExpenseBills = new ArrayList<DynamicObject>(8);
        ExpenseService.getGroups(expsCtx, bizBillEntity, expenseMap, bizBillIds, bizBills, needGenerateIds, needGenerateBills, needReCalIds, needReCalBills, needReCalExpenseBills, needUpdStatusIds, needUpdStatusExpenseBills);
        if (needGenerateIds.size() > 0 && needGenerateBills.size() > 0) {
            ExpenseService.generateExpense(expsCtx, bizBillEntity, needGenerateIds, needGenerateBills);
        }
        if (needReCalIds.size() > 0 && needReCalBills.size() > 0) {
            ExpenseService.reCalExpense(expsCtx, bizBillEntity, needReCalIds, needReCalBills, needReCalExpenseBills);
        }
        if (needUpdStatusExpenseBills != null && needUpdStatusExpenseBills.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needUpdStatusExpenseBills.toArray(new DynamicObject[0]));
            for (Long bizId : needUpdStatusIds) {
                if (expenseResult.get(bizId) == null) {
                    HashMap<String, Object> rsltMap = new HashMap<String, Object>(8);
                    rsltMap.put("success", Boolean.TRUE);
                    rsltMap.put("billentity", bizBillEntity);
                    if (expenseMap != null && expenseMap.get(bizId) != null) {
                        rsltMap.put("expensebillid", expenseMap.get(bizId).get("id"));
                        rsltMap.put("bizbillno", expenseMap.get(bizId).get("bizbillno"));
                    }
                    expenseResult.put(bizId, rsltMap);
                    continue;
                }
                ((Map)expenseResult.get(bizId)).put("success", Boolean.TRUE);
                ((Map)expenseResult.get(bizId)).put("billentity", bizBillEntity);
                if (expenseMap == null || expenseMap.get(bizId) == null) continue;
                ((Map)expenseResult.get(bizId)).put("expensebillid", expenseMap.get(bizId).get("id"));
                ((Map)expenseResult.get(bizId)).put("bizbillno", expenseMap.get(bizId).get("bizbillno"));
            }
        }
        long endupdexpstime = System.currentTimeMillis();
        logger.info("updateExpense----End: " + new Date(endupdexpstime));
        logger.info("updateExpense----UseTime: " + (endupdexpstime - beginupdexpstime) + " ms");
        return expsCtx.getExpenseResult();
    }

    public static void deleteExpenseBill(Set<Long> bizBillIds) {
        DynamicObject[] expenseBillColl = BusinessDataServiceHelper.load((String)"msbd_expensebill", (String)"id, bizbillid", (QFilter[])new QFilter[]{new QFilter("bizbillid", "in", bizBillIds)});
        if (expenseBillColl != null && expenseBillColl.length > 0) {
            ArrayList<Long> expenseIds = new ArrayList<Long>(8);
            for (DynamicObject expense : expenseBillColl) {
                expenseIds.add(expense.getLong("id"));
            }
            OperationServiceHelper.executeOperate((String)"delete", (String)"msbd_expensebill", (Object[])expenseIds.toArray(), null);
        }
    }

    public static boolean getExpenseScmParam() {
        QFilter qFilter = new QFilter("number", "=", (Object)"EXPENSE001");
        DynamicObject scmParam = QueryServiceHelper.queryOne((String)"sbs_scmcapplevelparam", (String)"enable", (QFilter[])qFilter.toArray());
        if (scmParam == null) {
            return false;
        }
        return scmParam.getBoolean("enable");
    }

    private static boolean checkModelMap(ExpenseCtx expsCtx, String bizBillEntity, Set<Long> bizBillIds, Map<String, String> priceModelMap) {
        if (priceModelMap == null || priceModelMap.size() == 0) {
            String billEntityName = ExpenseBillHelper.getEntityAlias(bizBillEntity);
            String billEntityStr = bizBillEntity;
            if (!StringUtils.isEmpty((String)billEntityName)) {
                billEntityStr = billEntityName;
            }
            String msg = ResManager.loadKDString((String)"\u201c\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u6765\u6e90\u5355\u636e\u201c%1$s\u201d\u548c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u201c\u4ef7\u683c\u6a21\u578b\u201d\u7684\u6709\u6548\u6620\u5c04\u4e0d\u5b58\u5728\u6216\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExpenseService_12", (String)"mpscmm-msbd-expense", (Object[])new Object[]{billEntityStr});
            for (Long bizBillId : bizBillIds) {
                Map<Object, Object> rsltMap;
                if (expsCtx.getExpenseResult().get(bizBillId) == null) {
                    rsltMap = new HashMap<String, Boolean>(4);
                    rsltMap.put("success", Boolean.FALSE);
                    rsltMap.put("billentity", bizBillEntity);
                    rsltMap.put("message", msg);
                    expsCtx.getExpenseResult().put(bizBillId, rsltMap);
                    continue;
                }
                rsltMap = expsCtx.getExpenseResult().get(bizBillId);
                rsltMap.put("success", Boolean.FALSE);
                rsltMap.put("billentity", bizBillEntity);
                if (rsltMap.get("message") != null) {
                    rsltMap.put("message", rsltMap.get("message").toString() + msg);
                    continue;
                }
                rsltMap.put("message", msg);
            }
            return false;
        }
        Set<String> needChkFldsCurrent = ExpenseBillHelper.getModelExpsFlds();
        String checkMsgCurrent = ExpenseBillHelper.checkExist(bizBillEntity, needChkFldsCurrent, priceModelMap);
        if (!CommonUtils.isNull((Object)checkMsgCurrent)) {
            for (Long bizBillId : bizBillIds) {
                Map<Object, Object> rsltMap;
                if (expsCtx.getExpenseResult().get(bizBillId) == null) {
                    rsltMap = new HashMap<String, Boolean>(4);
                    rsltMap.put("success", Boolean.FALSE);
                    rsltMap.put("billentity", bizBillEntity);
                    rsltMap.put("message", checkMsgCurrent);
                    expsCtx.getExpenseResult().put(bizBillId, rsltMap);
                    continue;
                }
                rsltMap = expsCtx.getExpenseResult().get(bizBillId);
                rsltMap.put("success", Boolean.FALSE);
                rsltMap.put("billentity", bizBillEntity);
                rsltMap.put("message", rsltMap.get("message").toString() + checkMsgCurrent);
            }
            return false;
        }
        return true;
    }

    private static void getGroups(ExpenseCtx expsCtx, String bizBillEntity, Map<Long, DynamicObject> expenseMap, Set<Long> bizBillIds, List<DynamicObject> bizBills, Set<Long> needGenerateIds, List<DynamicObject> needGenerateBills, Set<Long> needReCalIds, List<DynamicObject> needReCalBills, List<DynamicObject> needReCalExpenseBills, Set<Long> needUpdStatusIds, List<DynamicObject> needUpdStatusExpenseBills) {
        Map<String, String> priceModelMap = expsCtx.getBizBillFldMap();
        if (expenseMap == null || expenseMap.size() == 0) {
            needGenerateIds.addAll(bizBillIds);
            needGenerateBills.addAll(bizBills);
            for (DynamicObject bizBill : bizBills) {
                HashMap<String, Object> rsltMap = new HashMap<String, Object>(4);
                rsltMap.put("success", Boolean.TRUE);
                rsltMap.put("billentity", bizBillEntity);
                rsltMap.put("bizbillno", bizBill.getString(priceModelMap.get("bizbillno")));
                expsCtx.getExpenseResult().put(bizBill.getLong("id"), rsltMap);
            }
        } else {
            for (DynamicObject bizBill : bizBills) {
                Long bizBillId = (Long)bizBill.getPkValue();
                if (expenseMap.containsKey(bizBillId)) {
                    String bizBillStatus = bizBill.getString(priceModelMap.get("billstatus"));
                    String expsBillStatus = expenseMap.get(bizBillId).getString("billstatus");
                    if ("A".equals(bizBillStatus)) {
                        expenseMap.get(bizBillId).set("billstatus", (Object)"A");
                        needReCalIds.add(bizBillId);
                        needReCalBills.add(bizBill);
                        needReCalExpenseBills.add(expenseMap.get(bizBillId));
                    } else if ("B".equals(bizBillStatus) && "A".equals(expsBillStatus)) {
                        expenseMap.get(bizBillId).set("billstatus", (Object)"B");
                        needReCalIds.add(bizBillId);
                        needReCalBills.add(bizBill);
                        needReCalExpenseBills.add(expenseMap.get(bizBillId));
                    } else if (!"A".equals(bizBillStatus) && !"B".equals(bizBillStatus)) {
                        needUpdStatusIds.add(bizBillId);
                        if (!"C".equals(expsBillStatus)) {
                            expenseMap.get(bizBillId).set("billstatus", (Object)"C");
                            needUpdStatusExpenseBills.add(expenseMap.get(bizBillId));
                        }
                    }
                    if (expsCtx.getExpenseResult().get(bizBillId) == null) {
                        HashMap<String, Object> rsltMap = new HashMap<String, Object>(4);
                        rsltMap.put("success", Boolean.TRUE);
                        rsltMap.put("expensebillid", expenseMap.get(bizBillId).get("id"));
                        rsltMap.put("billentity", bizBillEntity);
                        rsltMap.put("bizbillno", expenseMap.get(bizBillId).get("bizbillno"));
                        expsCtx.getExpenseResult().put(bizBillId, rsltMap);
                        continue;
                    }
                    expsCtx.getExpenseResult().get(bizBillId).put("success", Boolean.TRUE);
                    expsCtx.getExpenseResult().get(bizBillId).put("expensebillid", expenseMap.get(bizBillId).get("id"));
                    expsCtx.getExpenseResult().get(bizBillId).put("billentity", bizBillEntity);
                    expsCtx.getExpenseResult().get(bizBillId).put("bizbillno", expenseMap.get(bizBillId).get("bizbillno"));
                    continue;
                }
                needGenerateIds.add(bizBillId);
                needGenerateBills.add(bizBill);
                if (expsCtx.getExpenseResult().get(bizBillId) == null) {
                    HashMap<String, Object> rsltMap = new HashMap<String, Object>(4);
                    rsltMap.put("success", Boolean.TRUE);
                    rsltMap.put("billentity", bizBillEntity);
                    rsltMap.put("bizbillno", bizBill.getString(priceModelMap.get("bizbillno")));
                    expsCtx.getExpenseResult().put(bizBillId, rsltMap);
                    continue;
                }
                expsCtx.getExpenseResult().get(bizBillId).put("success", Boolean.TRUE);
                expsCtx.getExpenseResult().get(bizBillId).put("billentity", bizBillEntity);
                expsCtx.getExpenseResult().get(bizBillId).put("bizbillno", bizBill.getString(priceModelMap.get("bizbillno")));
            }
        }
    }

    private static Map<Long, DynamicObject> getExpenseBillByBizBillIds(Set<Long> bizBillIds) {
        HashMap<Long, DynamicObject> expenseMap = new HashMap<Long, DynamicObject>(8);
        if (CommonUtils.isNull(bizBillIds) || bizBillIds.size() == 0) {
            return null;
        }
        long beginfindexpsbilltime = System.currentTimeMillis();
        DynamicObject[] expenseBillColl = BusinessDataServiceHelper.load((String)"msbd_expensebill", (String)"id, billno, biztime, bizbillid, bizbillentity, bizbillno, billstatus, billexpenseentry.pricetype, billexpenseentry.priceval, billexpenseentry.caltype, billexpenseentry.caltypeval, billexpenseentry.amount, billexpenseentry.currency, billexpenseentry.source, billexpenseentry.rowexpensejson_tag, rowexpenseentry.r_matnum, rowexpenseentry.r_mat, rowexpenseentry.r_pricetype, rowexpenseentry.r_priceval, rowexpenseentry.r_caltype, rowexpenseentry.r_caltypeval, rowexpenseentry.r_unit, rowexpenseentry.r_amount, rowexpenseentry.r_currency, rowexpenseentry.r_istax, rowexpenseentry.r_expsitm, rowexpenseentry.r_expssup, rowexpenseentry.r_isadvanced, rowexpenseentry.r_taxrate, rowexpenseentry.r_entrycomment, rowexpenseentry.r_settleorg, rowexpenseentry.r_bizentryid, rowexpenseentry.seq ", (QFilter[])new QFilter[]{new QFilter("bizbillid", "in", bizBillIds)});
        long endfindexpsbilltime = System.currentTimeMillis();
        for (DynamicObject expsBill : expenseBillColl) {
            Long bizBillId = expsBill.getLong("bizbillid");
            expenseMap.put(bizBillId, expsBill);
        }
        return expenseMap;
    }

    private static void generateExpense(ExpenseCtx expsCtx, String bizBillEntity, Set<Long> bizBillIds, List<DynamicObject> bizBills) {
        if (CommonUtils.isNull(bizBillIds)) {
            return;
        }
        long begingenerateexpstime = System.currentTimeMillis();
        ExpenseService.expenseCarry(expsCtx, bizBillEntity, bizBillIds, bizBills);
        long endgenerateexpstime = System.currentTimeMillis();
    }

    private static void reCalExpense(ExpenseCtx expsCtx, String bizBillEntity, Set<Long> bizBillIds, List<DynamicObject> bizBills, List<DynamicObject> expenseBills) {
        if (CommonUtils.isNull(bizBillIds)) {
            return;
        }
        long beginrecalexpstime = System.currentTimeMillis();
        ExpenseService.expenseReCalculate(expsCtx, bizBillEntity, bizBillIds, bizBills, expenseBills);
        long endrecalexpstime = System.currentTimeMillis();
    }

    public static void expenseCarry(ExpenseCtx expsCtx, String bizBillEntity, Set<Long> bizBillIds, List<DynamicObject> bizBills) {
        if (CommonUtils.isNull((Object)bizBillEntity) || bizBillIds == null || bizBillIds.size() == 0) {
            return;
        }
        Map<String, String> priceModelMap = expsCtx.getBizBillFldMap();
        HashMap<Long, Set<Long>> billEntryMap = new HashMap<Long, Set<Long>>(8);
        HashMap<Long, Long> entryBillMap = new HashMap<Long, Long>(8);
        for (DynamicObject dynamicObject : bizBills) {
            Long l = (Long)dynamicObject.getPkValue();
            DynamicObjectCollection bizBillEntrys = dynamicObject.getDynamicObjectCollection(priceModelMap.get("billentry"));
            for (DynamicObject entry : bizBillEntrys) {
                Long entryId = entry.getLong("id");
                if (billEntryMap.get(l) == null) {
                    HashSet<Object> hashSet = new HashSet<Object>(8);
                    hashSet.add(entryId);
                    billEntryMap.put(l, hashSet);
                } else {
                    ((Set)billEntryMap.get(l)).add(entryId);
                }
                entryBillMap.put(entryId, l);
            }
        }
        Map<Long, Map<Long, Boolean>> carryMap = ExpenseExtHelper.getIsCarry(bizBillEntity, bizBills);
        if (carryMap != null && carryMap.size() > 0) {
            for (Map.Entry<Long, Map<Long, Boolean>> entry : carryMap.entrySet()) {
                Long bizBillId = entry.getKey();
                Map<Long, Boolean> carryEntry = entry.getValue();
                HashSet<Long> entrySet = new HashSet<Long>(8);
                for (Map.Entry entry2 : carryEntry.entrySet()) {
                    Boolean isCarry = (Boolean)entry2.getValue();
                    if (isCarry.booleanValue()) continue;
                    entrySet.add((Long)entry2.getKey());
                    entryBillMap.remove((Long)entry2.getKey());
                }
                ((Set)billEntryMap.get(bizBillId)).removeAll(entrySet);
                if (billEntryMap.get(bizBillId) != null && ((Set)billEntryMap.get(bizBillId)).size() != 0) continue;
                billEntryMap.remove(bizBillId);
            }
        }
        if (billEntryMap == null || billEntryMap.size() == 0) {
            return;
        }
        HashMap<String, Set<Long>> hashMap = new HashMap<String, Set<Long>>(8);
        HashMap<String, Set<Long>> hashMap2 = new HashMap<String, Set<Long>>(8);
        HashMap<Long, Set<Long>> upBillEntryIDMap = new HashMap<Long, Set<Long>>(8);
        HashMap<Long, Set<Long>> upDownEtryMap = new HashMap<Long, Set<Long>>(8);
        HashMap<Long, Long> downUpEtryMap = new HashMap<Long, Long>(8);
        long beginfinddirtsrcexpstime = System.currentTimeMillis();
        ExpenseService.getUpDownRelation(bizBillEntity, bizBills, billEntryMap, hashMap, hashMap2, upBillEntryIDMap, upDownEtryMap, downUpEtryMap);
        long endfinddirtsrcexpstime = System.currentTimeMillis();
        long begingetrowexpstime = System.currentTimeMillis();
        DynamicObjectCollection rowExpsEtryColl = ExpenseService.getRowExpsColl(hashMap, hashMap2, billEntryMap, upBillEntryIDMap, upDownEtryMap, downUpEtryMap, entryBillMap);
        long endgetrowexpstime = System.currentTimeMillis();
        if (rowExpsEtryColl != null && rowExpsEtryColl.size() > 0) {
            HashMap<Long, DynamicObject> bizBillObjMap = new HashMap<Long, DynamicObject>(8);
            for (int i = 0; i < bizBills.size(); ++i) {
                Long bizBillId = (Long)bizBills.get(i).get("id");
                bizBillObjMap.put(bizBillId, bizBills.get(i));
            }
            long beginprocessrowexpstime = System.currentTimeMillis();
            ExpenseService.processRowExpsColl(expsCtx, rowExpsEtryColl, bizBillEntity, hashMap2, billEntryMap, bizBillObjMap, upDownEtryMap, downUpEtryMap, entryBillMap, hashMap);
            long endprocessrowexpstime = System.currentTimeMillis();
            long beginbuildexpstime = System.currentTimeMillis();
            ExpenseService.buildExpsBill(expsCtx, bizBillEntity, rowExpsEtryColl, billEntryMap, bizBills);
            long l = System.currentTimeMillis();
        }
    }

    private static void getUpDownRelation(String bizBillEntity, List<DynamicObject> bizBills, Map<Long, Set<Long>> billEntryMap, Map<String, Set<Long>> upEntityIdMap, Map<String, Set<Long>> upBillEntryMap, Map<Long, Set<Long>> upBillEntryIDMap, Map<Long, Set<Long>> upDownEtryMap, Map<Long, Long> downUpEtryMap) {
        UpDownBizRelation bizRelation = new UpDownBizRelation();
        bizRelation.setBizBillEntity(bizBillEntity);
        bizRelation.setBizBills(bizBills);
        bizRelation.setBillEntryMap(billEntryMap);
        bizRelation.setUpEntityIdMap(upEntityIdMap);
        bizRelation.setUpEntityEntryMap(upBillEntryMap);
        bizRelation.setUpBillEntryIDMap(upBillEntryIDMap);
        bizRelation.setUpDownEtryMap(upDownEtryMap);
        bizRelation.setDownUpEtryMap(downUpEtryMap);
        boolean isStdRelation = ExpenseExtHelper.getExtUpDownRelation(bizRelation);
        if (!isStdRelation) {
            billEntryMap = bizRelation.getBillEntryMap();
            upEntityIdMap = bizRelation.getUpEntityIdMap();
            upBillEntryMap = bizRelation.getUpEntityEntryMap();
            upBillEntryIDMap = bizRelation.getUpBillEntryIDMap();
            upDownEtryMap = bizRelation.getUpDownEtryMap();
            downUpEtryMap = bizRelation.getDownUpEtryMap();
            return;
        }
        Map<String, String> srcInfoMap = ExpenseExtHelper.getExtSourceInfo(bizBillEntity);
        if (!(srcInfoMap == null || StringUtils.isEmpty((String)srcInfoMap.get("srcbillentity")) || StringUtils.isEmpty((String)srcInfoMap.get("srcbillid")) || StringUtils.isEmpty((String)srcInfoMap.get("srcbillentryid")))) {
            for (DynamicObject bizBill : bizBills) {
                Long bizBillId = bizBill.getLong("id");
                DynamicObjectCollection entrys = bizBill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    HashSet<Long> srcEntryIds;
                    Long entryId = entry.getLong("id");
                    String srcBillEntity = entry.getString(srcInfoMap.get("srcbillentity"));
                    Long srcBillId = entry.getLong(srcInfoMap.get("srcbillid"));
                    Long srcBillEntryId = entry.getLong(srcInfoMap.get("srcbillentryid"));
                    if (StringUtils.isEmpty((String)srcBillEntity) || srcBillId == 0L || srcBillEntryId == 0L) continue;
                    if (upEntityIdMap.size() == 0 || upEntityIdMap.get(srcBillEntity) == null || upEntityIdMap.get(srcBillEntity).size() == 0) {
                        HashSet<Long> billIds = new HashSet<Long>(4);
                        billIds.add(srcBillId);
                        upEntityIdMap.put(srcBillEntity, billIds);
                    } else {
                        upEntityIdMap.get(srcBillEntity).add(srcBillId);
                    }
                    if (upBillEntryMap.size() == 0 || upBillEntryMap.get(srcBillEntity) == null || upBillEntryMap.get(srcBillEntity).size() == 0) {
                        srcEntryIds = new HashSet<Long>(4);
                        srcEntryIds.add(srcBillEntryId);
                        upBillEntryMap.put(srcBillEntity, srcEntryIds);
                    } else {
                        upBillEntryMap.get(srcBillEntity).add(srcBillEntryId);
                    }
                    if (upBillEntryIDMap.size() == 0 || upBillEntryIDMap.get(srcBillId) == null || upBillEntryIDMap.get(srcBillId).size() == 0) {
                        srcEntryIds = new HashSet(4);
                        srcEntryIds.add(srcBillEntryId);
                        upBillEntryIDMap.put(srcBillId, srcEntryIds);
                    } else {
                        upBillEntryIDMap.get(srcBillId).add(srcBillEntryId);
                    }
                    if (upDownEtryMap.size() == 0 || upDownEtryMap.get(srcBillEntryId) == null || upDownEtryMap.get(srcBillEntryId).size() == 0) {
                        HashSet<Long> downEIds = new HashSet<Long>(8);
                        downEIds.add(entryId);
                        upDownEtryMap.put(srcBillEntryId, downEIds);
                    } else {
                        upDownEtryMap.get(srcBillEntryId).add(entryId);
                    }
                    downUpEtryMap.put(entryId, srcBillEntryId);
                }
            }
        } else {
            long beginfinddirtsrctime = System.currentTimeMillis();
            Map dirtSourcBills = BFTrackerServiceHelper.findDirtSourceBills((String)bizBillEntity, (Long[])billEntryMap.keySet().toArray(new Long[0]));
            long endfinddirtsrctime = System.currentTimeMillis();
            upEntityIdMap = ExpenseService.getUpBillMap(dirtSourcBills, upEntityIdMap);
            upBillEntryMap = ExpenseService.getUpBillEntryMap(dirtSourcBills, upBillEntryMap);
            upBillEntryIDMap = ExpenseService.getUpBillEntryIDMap(dirtSourcBills, upBillEntryIDMap);
            upDownEtryMap = ExpenseService.getUpDownEtryMap(dirtSourcBills, upDownEtryMap);
            downUpEtryMap = ExpenseService.getDownUpEtryMap(dirtSourcBills, downUpEtryMap);
        }
    }

    private static Map<Long, Set<Long>> getUpDownEtryMap(Map<Long, List<BFRow>> dirtSourcBills, Map<Long, Set<Long>> upDownEtryMap) {
        for (Map.Entry<Long, List<BFRow>> dirtSourcBill : dirtSourcBills.entrySet()) {
            Long billId = dirtSourcBill.getKey();
            List<BFRow> BFRows = dirtSourcBill.getValue();
            for (int i = 0; i < BFRows.size(); ++i) {
                BFRow row = BFRows.get(i);
                Long srcEntryId = row.getSId().getEntryId();
                Long entryId = row.getId().getEntryId();
                if (upDownEtryMap.get(srcEntryId) == null) {
                    HashSet<Long> downEIds = new HashSet<Long>(8);
                    downEIds.add(entryId);
                    upDownEtryMap.put(srcEntryId, downEIds);
                    continue;
                }
                upDownEtryMap.get(srcEntryId).add(entryId);
            }
        }
        return upDownEtryMap;
    }

    private static Map<Long, Long> getDownUpEtryMap(Map<Long, List<BFRow>> dirtSourcBills, Map<Long, Long> downUpEtryMap) {
        for (Map.Entry<Long, List<BFRow>> dirtSourcBill : dirtSourcBills.entrySet()) {
            Long billId = dirtSourcBill.getKey();
            List<BFRow> BFRows = dirtSourcBill.getValue();
            for (int i = 0; i < BFRows.size(); ++i) {
                BFRow row = BFRows.get(i);
                Long srcEntryId = row.getSId().getEntryId();
                Long entryId = row.getId().getEntryId();
                downUpEtryMap.put(entryId, srcEntryId);
            }
        }
        return downUpEtryMap;
    }

    private static boolean checkBizBillCalcBase(ExpenseCtx expsCtx, DynamicObjectCollection rowExpsEtryColl, String bizBillEntity, Map<Long, Set<Long>> billEntryMap, Map<Long, Map<Long, Long>> entryMap, Map<Long, DynamicObject> bizBillObjMap) {
        HashSet<String> needChkFldsCurrent = new HashSet<String>(8);
        needChkFldsCurrent.add("billentry");
        needChkFldsCurrent.add("material");
        String checkMsgCurrent = ExpenseBillHelper.checkExist(bizBillEntity, needChkFldsCurrent, expsCtx.getBizBillFldMap());
        if (!CommonUtils.isNull((Object)checkMsgCurrent)) {
            Map<Long, Map<String, Object>> expsRslt = expsCtx.getExpenseResult();
            for (Map.Entry<Long, Map<String, Object>> rslt : expsRslt.entrySet()) {
                if (!billEntryMap.containsKey(rslt.getKey())) continue;
                Map<String, Object> msgRslt = rslt.getValue();
                if (CommonUtils.isNull(msgRslt)) {
                    msgRslt = new HashMap<String, Object>(8);
                    msgRslt.put("success", Boolean.FALSE);
                    msgRslt.put("message", checkMsgCurrent);
                    expsRslt.put(rslt.getKey(), msgRslt);
                    continue;
                }
                msgRslt.put("success", Boolean.FALSE);
                msgRslt.put("message", checkMsgCurrent);
                expsRslt.put(rslt.getKey(), msgRslt);
            }
            return false;
        }
        HashMap checkStrs = new HashMap(4);
        HashMap strEntryIDs = new HashMap(8);
        for (Object rowExpsEtry : rowExpsEtryColl) {
            DynamicObject dynamicObject = rowExpsEtry.getDynamicObject("r_caltype");
            if (dynamicObject == null) continue;
            String string = dynamicObject.getString("calcbase");
            String keyStr = "";
            keyStr = StringUtils.isEmpty((String)string) || "amountandtax".equals(string) ? "amountandtax" : ("qty".equals(string) ? "qty" : string);
            if (checkStrs.get(keyStr) == null) {
                HashSet<String> hashSet = new HashSet<String>(1);
                hashSet.add(keyStr);
                if (keyStr.equals("qty")) {
                    hashSet.add("unit");
                }
                checkStrs.put(keyStr, hashSet);
            }
            if (strEntryIDs.get(keyStr) == null) {
                HashSet<Long> hashSet = new HashSet<Long>(8);
                hashSet.add(rowExpsEtry.getLong("r_bizentryid"));
                strEntryIDs.put(keyStr, hashSet);
                continue;
            }
            ((Set)strEntryIDs.get(keyStr)).add(rowExpsEtry.getLong("r_bizentryid"));
        }
        if (checkStrs != null && checkStrs.size() > 0) {
            HashMap<String, String> chkMsgs = new HashMap<String, String>(3);
            for (Map.Entry entry : checkStrs.entrySet()) {
                Set set = (Set)entry.getValue();
                String msg = ExpenseBillHelper.checkExist(bizBillEntity, set, expsCtx.getBizBillFldMap());
                if (StringUtils.isEmpty((String)msg)) continue;
                chkMsgs.put(entry.getKey().toString(), msg);
            }
            if (chkMsgs != null && chkMsgs.size() > 0) {
                HashSet<Long> delBillIds = new HashSet<Long>(2);
                for (Map.Entry entry : chkMsgs.entrySet()) {
                    String kStr = entry.getKey().toString();
                    Set set = (Set)strEntryIDs.get(kStr);
                    block4: for (Map.Entry<Long, Set<Long>> bEtryM : billEntryMap.entrySet()) {
                        Set<Long> bEtrys = bEtryM.getValue();
                        if (bEtrys.size() <= 0) continue;
                        for (Long bEtry : bEtrys) {
                            if (!set.contains(bEtry)) continue;
                            delBillIds.add(bEtryM.getKey());
                            Map<String, Object> srvExpsMap = expsCtx.getExpenseResult().get(bEtryM.getKey());
                            DynamicObject bizBillObj = bizBillObjMap.get(bEtryM.getKey());
                            String bizBillNo = bizBillObj.getString("billno");
                            if (CommonUtils.isNull(srvExpsMap)) {
                                srvExpsMap = new HashMap<String, Object>(8);
                                srvExpsMap.put("success", Boolean.FALSE);
                                srvExpsMap.put("message", entry.getValue().toString());
                                srvExpsMap.put("billentity", bizBillEntity);
                                srvExpsMap.put("bizbillno", bizBillNo);
                            } else {
                                srvExpsMap.put("success", Boolean.FALSE);
                                if (srvExpsMap.get("message") != null) {
                                    srvExpsMap.put("message", srvExpsMap.get("message") + entry.getValue().toString());
                                } else if (srvExpsMap.get("message") == null) {
                                    srvExpsMap.put("message", entry.getValue().toString());
                                }
                                srvExpsMap.put("billentity", bizBillEntity);
                                srvExpsMap.put("bizbillno", bizBillNo);
                            }
                            expsCtx.getExpenseResult().put(bEtryM.getKey(), srvExpsMap);
                            continue block4;
                        }
                    }
                }
                if (delBillIds.size() > 0) {
                    for (Long l : delBillIds) {
                        billEntryMap.remove(l);
                        for (Map.Entry entry : entryMap.entrySet()) {
                            Map bEM = (Map)entry.getValue();
                            HashSet<Long> delBE = new HashSet<Long>(4);
                            for (Map.Entry bE : bEM.entrySet()) {
                                Long bId = (Long)bE.getValue();
                                if (!l.equals(bId)) continue;
                                delBE.add((Long)bE.getKey());
                            }
                            if (delBE.size() <= 0) continue;
                            for (Long be : delBE) {
                                bEM.remove(be);
                            }
                        }
                    }
                    HashSet<Long> hashSet = new HashSet<Long>(4);
                    for (Map.Entry<Long, Map<Long, Long>> eM : entryMap.entrySet()) {
                        Map<Long, Long> map = eM.getValue();
                        if (map != null) continue;
                        hashSet.add(eM.getKey());
                    }
                    if (hashSet.size() > 0) {
                        for (Long upEId : hashSet) {
                            entryMap.remove(upEId);
                        }
                    }
                }
            }
        }
        return true;
    }

    private static Map<String, Set<Long>> getUpBillMap(Map<Long, List<BFRow>> dirtSourcBills, Map<String, Set<Long>> upEntityIdMap) {
        for (Map.Entry<Long, List<BFRow>> dirtSourcBill : dirtSourcBills.entrySet()) {
            Long billId = dirtSourcBill.getKey();
            List<BFRow> BFRows = dirtSourcBill.getValue();
            for (int i = 0; i < BFRows.size(); ++i) {
                BFRow row = BFRows.get(i);
                Long srcMainTableId = row.getSId().getMainTableId();
                Long srcBillId = row.getSId().getBillId();
                Long srcEntryId = row.getSId().getEntryId();
                Long entryId = row.getId().getEntryId();
                TableDefine tableDef = EntityMetadataCache.loadTableDefine((Long)srcMainTableId);
                String srcEntityNumber = tableDef.getEntityNumber();
                if (CommonUtils.isNull(upEntityIdMap.get(srcEntityNumber))) {
                    HashSet<Long> srcBillIds = new HashSet<Long>(8);
                    srcBillIds.add(srcBillId);
                    upEntityIdMap.put(srcEntityNumber, srcBillIds);
                    continue;
                }
                upEntityIdMap.get(srcEntityNumber).add(srcBillId);
            }
        }
        return upEntityIdMap;
    }

    public static Map<Long, Map<Long, Long>> getEntryRelation(Map<Long, List<BFRow>> dirtSourcBills, Map<Long, Map<Long, Long>> entryMap) {
        for (Map.Entry<Long, List<BFRow>> dirtSourcBill : dirtSourcBills.entrySet()) {
            Long billId = dirtSourcBill.getKey();
            List<BFRow> BFRows = dirtSourcBill.getValue();
            for (int i = 0; i < BFRows.size(); ++i) {
                BFRow row = BFRows.get(i);
                Long srcEntryId = row.getSId().getEntryId();
                Long entryId = row.getId().getEntryId();
                if (CommonUtils.isNull(entryMap.get(srcEntryId))) {
                    HashMap<Long, Long> entryIdMap = new HashMap<Long, Long>(8);
                    entryIdMap.put(entryId, billId);
                    entryMap.put(srcEntryId, entryIdMap);
                    continue;
                }
                entryMap.get(srcEntryId).put(entryId, billId);
            }
        }
        return entryMap;
    }

    private static Map<Long, Set<Long>> getBillEntryMap(Map<Long, List<BFRow>> dirtSourcBills, Map<Long, Set<Long>> billEntryMap, Map<Long, Set<Long>> bizBillEntryIds) {
        for (Map.Entry<Long, List<BFRow>> dirtSourcBill : dirtSourcBills.entrySet()) {
            Long billId = dirtSourcBill.getKey();
            if (!CommonUtils.isNull(bizBillEntryIds) && !CommonUtils.isNull(bizBillEntryIds.get(billId))) {
                billEntryMap = bizBillEntryIds;
                continue;
            }
            List<BFRow> BFRows = dirtSourcBill.getValue();
            for (int i = 0; i < BFRows.size(); ++i) {
                BFRow row = BFRows.get(i);
                Long entryId = row.getId().getEntryId();
                if (CommonUtils.isNull(billEntryMap.get(billId))) {
                    HashSet<Long> entryIds = new HashSet<Long>(8);
                    entryIds.add(entryId);
                    billEntryMap.put(billId, entryIds);
                    continue;
                }
                billEntryMap.get(billId).add(entryId);
            }
        }
        return billEntryMap;
    }

    private static Map<String, Set<Long>> getUpBillEntryMap(Map<Long, List<BFRow>> dirtSourcBills, Map<String, Set<Long>> upBillEntryMap) {
        for (Map.Entry<Long, List<BFRow>> dirtSourcBill : dirtSourcBills.entrySet()) {
            List<BFRow> BFRows = dirtSourcBill.getValue();
            for (int i = 0; i < BFRows.size(); ++i) {
                BFRow row = BFRows.get(i);
                Long srcMainTableId = row.getSId().getMainTableId();
                TableDefine tableDef = EntityMetadataCache.loadTableDefine((Long)srcMainTableId);
                String srcEntityNumber = tableDef.getEntityNumber();
                Long srcEntryId = row.getSId().getEntryId();
                if (CommonUtils.isNull(upBillEntryMap) || CommonUtils.isNull(upBillEntryMap.get(srcEntityNumber))) {
                    HashSet<Long> entryIdSet = new HashSet<Long>(8);
                    entryIdSet.add(srcEntryId);
                    upBillEntryMap.put(srcEntityNumber, entryIdSet);
                    continue;
                }
                upBillEntryMap.get(srcEntityNumber).add(srcEntryId);
            }
        }
        return upBillEntryMap;
    }

    private static Map<Long, Set<Long>> getUpBillEntryIDMap(Map<Long, List<BFRow>> dirtSourcBills, Map<Long, Set<Long>> upBillEntryIDMap) {
        for (Map.Entry<Long, List<BFRow>> dirtSourcBill : dirtSourcBills.entrySet()) {
            List<BFRow> BFRows = dirtSourcBill.getValue();
            for (int i = 0; i < BFRows.size(); ++i) {
                BFRow row = BFRows.get(i);
                Long srcBillId = row.getSId().getBillId();
                Long srcEntryId = row.getSId().getEntryId();
                if (CommonUtils.isNull(upBillEntryIDMap) || CommonUtils.isNull(upBillEntryIDMap.get(srcBillId))) {
                    HashSet<Long> entryIdSet = new HashSet<Long>(8);
                    entryIdSet.add(srcEntryId);
                    upBillEntryIDMap.put(srcBillId, entryIdSet);
                    continue;
                }
                upBillEntryIDMap.get(srcBillId).add(srcEntryId);
            }
        }
        return upBillEntryIDMap;
    }

    private static DynamicObjectCollection getRowExpsColl(Map<String, Set<Long>> upEntityIdMap, Map<String, Set<Long>> upBillEntryMap, Map<Long, Set<Long>> billEntryMap, Map<Long, Set<Long>> upBillEntryIDMap, Map<Long, Set<Long>> upDownEtryMap, Map<Long, Long> downUpEtryMap, Map<Long, Long> entryBillMap) {
        ArrayList<Long> srcBillIds = new ArrayList<Long>(8);
        for (Map.Entry<String, Set<Long>> srcBill : upEntityIdMap.entrySet()) {
            Set<Long> srcIds = srcBill.getValue();
            srcBillIds.addAll(srcIds);
        }
        DynamicObjectCollection billExpsEtryColl = new DynamicObjectCollection();
        long beginfindupexpsbilltime = System.currentTimeMillis();
        DynamicObject[] expenseBillColl = BusinessDataServiceHelper.load((String)"msbd_expensebill", (String)"id, billno, biztime, bizbillid, bizbillentity, bizbillno, billstatus,  billexpenseentry.pricetype, billexpenseentry.priceval, billexpenseentry.caltype, billexpenseentry.caltypeval, billexpenseentry.amount, billexpenseentry.currency, billexpenseentry.source, billexpenseentry.rowexpensejson_tag,  rowexpenseentry.r_matnum, rowexpenseentry.r_mat, rowexpenseentry.r_pricetype, rowexpenseentry.r_priceval, rowexpenseentry.r_caltype, rowexpenseentry.r_caltypeval, rowexpenseentry.r_unit, rowexpenseentry.r_amount,  rowexpenseentry.r_currency, rowexpenseentry.r_istax, rowexpenseentry.r_expsitm, rowexpenseentry.r_expssup, rowexpenseentry.r_isadvanced, rowexpenseentry.r_taxrate, rowexpenseentry.r_entrycomment,  rowexpenseentry.r_settleorg, rowexpenseentry.r_bizentryid, rowexpenseentry.seq ", (QFilter[])new QFilter[]{new QFilter("bizbillid", "in", srcBillIds)});
        long endfindupexpsbilltime = System.currentTimeMillis();
        ArrayList<Long> needDelSrcBIds = new ArrayList<Long>(8);
        for (int k = 0; k < srcBillIds.size(); ++k) {
            boolean isExist = false;
            for (int j = 0; j < expenseBillColl.length; ++j) {
                if (!((Long)srcBillIds.get(k)).equals(expenseBillColl[j].get("bizbillid"))) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            needDelSrcBIds.add((Long)srcBillIds.get(k));
        }
        if (needDelSrcBIds != null && needDelSrcBIds.size() > 0) {
            ExpenseService.processMapsByBill(needDelSrcBIds, upEntityIdMap, billEntryMap, upBillEntryMap, upBillEntryIDMap, upDownEtryMap, downUpEtryMap, entryBillMap);
        }
        for (int i = 0; i < expenseBillColl.length; ++i) {
            DynamicObjectCollection expenseEntrys = expenseBillColl[i].getDynamicObjectCollection("billexpenseentry");
            billExpsEtryColl.addAll((Collection)expenseEntrys);
        }
        long beginstrtoobjecttime = System.currentTimeMillis();
        EntryType rowExpEtryType = null;
        if (!CommonUtils.isNull((Object)expenseBillColl) && expenseBillColl.length > 0 && !CommonUtils.isNull((Object)expenseBillColl[0])) {
            rowExpEtryType = (EntryType)expenseBillColl[0].getDynamicObjectCollection("rowexpenseentry").getDynamicObjectType();
        }
        DynamicObjectCollection rowExpsEtryColl = new DynamicObjectCollection();
        for (int i = 0; i < billExpsEtryColl.size(); ++i) {
            rowExpsEtryColl = ExpenseBillHelper.strToDynamicObjectColl(((DynamicObject)billExpsEtryColl.get(i)).getString("rowexpensejson_tag"), rowExpsEtryColl, rowExpEtryType);
        }
        long endstrtoobjecttime = System.currentTimeMillis();
        long beginprocessmaptime = System.currentTimeMillis();
        Set<Long> srcEntryIds = upDownEtryMap.keySet();
        DynamicObjectCollection needRemove = new DynamicObjectCollection();
        HashSet<Long> rowExps_BizEtryId = new HashSet<Long>(8);
        for (int i = 0; i < rowExpsEtryColl.size(); ++i) {
            Long bizEntryId = ((DynamicObject)rowExpsEtryColl.get(i)).getLong("r_bizentryid");
            rowExps_BizEtryId.add(bizEntryId);
            if (srcEntryIds.contains(bizEntryId)) continue;
            needRemove.add(rowExpsEtryColl.get(i));
        }
        rowExpsEtryColl.removeAll((Collection)needRemove);
        if (rowExps_BizEtryId != null && rowExps_BizEtryId.size() > 0) {
            HashSet<Long> delUpEntryIds = new HashSet<Long>();
            for (Long entryId : srcEntryIds) {
                if (rowExps_BizEtryId.contains(entryId)) continue;
                delUpEntryIds.add(entryId);
            }
            if (delUpEntryIds != null && delUpEntryIds.size() > 0) {
                ExpenseService.processMapsByEntry(delUpEntryIds, upBillEntryIDMap, upBillEntryMap, billEntryMap, upDownEtryMap, downUpEtryMap, entryBillMap);
            }
        }
        long endprocessmaptime = System.currentTimeMillis();
        long beginupdentryidtime = System.currentTimeMillis();
        DynamicObject rowExpsNeedClone = new DynamicObject();
        DynamicObjectCollection rowExpsEtryNew = new DynamicObjectCollection();
        int size = rowExpsEtryColl.size();
        for (int i = 0; i < size; ++i) {
            Set<Long> downEIds;
            Long upEntryId = ((DynamicObject)rowExpsEtryColl.get(i)).getLong("r_bizentryid");
            if (upDownEtryMap.get(upEntryId) == null || (downEIds = upDownEtryMap.get(upEntryId)) == null) continue;
            int k = 0;
            for (Long downEId : downEIds) {
                if (k == 0) {
                    rowExpsNeedClone = (DynamicObject)rowExpsEtryColl.get(i);
                    ((DynamicObject)rowExpsEtryColl.get(i)).set("r_bizentryid", (Object)downEId);
                    ++k;
                    continue;
                }
                DynamicObject rowExpsclone = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityType)rowExpEtryType, (Object)rowExpsNeedClone);
                rowExpsclone.set("r_bizentryid", (Object)downEId);
                rowExpsEtryNew.add((Object)rowExpsclone);
            }
        }
        if (rowExpsEtryNew.size() > 0) {
            rowExpsEtryColl.addAll((Collection)rowExpsEtryNew);
        }
        long endupdentryidtime = System.currentTimeMillis();
        return rowExpsEtryColl;
    }

    private static void processMapsByBill(List<Long> needDelSrcBIds, Map<String, Set<Long>> upEntityIdMap, Map<Long, Set<Long>> billEntryMap, Map<String, Set<Long>> upBillEntryMap, Map<Long, Set<Long>> upBillEntryIDMap, Map<Long, Set<Long>> upDownEtryMap, Map<Long, Long> downUpEtryMap, Map<Long, Long> entryBillMap) {
        if (needDelSrcBIds == null || needDelSrcBIds.size() == 0) {
            return;
        }
        for (Map.Entry<String, Set<Long>> upEntityBillIDs : upEntityIdMap.entrySet()) {
            Set<Long> set = upEntityBillIDs.getValue();
            set.removeAll(needDelSrcBIds);
        }
        HashSet<Long> needDelUpEntryIds = new HashSet<Long>();
        for (int i = 0; i < needDelSrcBIds.size(); ++i) {
            Set<Long> set = upBillEntryIDMap.get(needDelSrcBIds.get(i));
            needDelUpEntryIds.addAll(set);
            upBillEntryIDMap.remove(needDelSrcBIds.get(i));
        }
        if (needDelUpEntryIds != null && needDelUpEntryIds.size() != 0) {
            for (Map.Entry<String, Set<Long>> entry : upBillEntryMap.entrySet()) {
                entry.getValue().removeAll(needDelUpEntryIds);
                if (upBillEntryMap.get(entry.getKey()) != null && upBillEntryMap.get(entry.getKey()).size() != 0) continue;
                upBillEntryMap.remove(entry.getKey());
            }
            HashSet<Long> needDelDownEIDs = new HashSet<Long>(8);
            for (Long delUpEtryId : needDelUpEntryIds) {
                Set<Long> downEtryIds;
                if (upDownEtryMap == null || upDownEtryMap.size() <= 0 || (downEtryIds = upDownEtryMap.remove(delUpEtryId)) == null) continue;
                needDelDownEIDs.addAll(downEtryIds);
            }
            if (needDelDownEIDs != null && needDelDownEIDs.size() > 0) {
                for (Long downEID : needDelDownEIDs) {
                    downUpEtryMap.remove(downEID);
                    entryBillMap.remove(downEID);
                }
                HashSet<Long> hashSet = new HashSet<Long>(8);
                for (Map.Entry<Long, Set<Long>> billEId : billEntryMap.entrySet()) {
                    Set<Long> EIds = billEId.getValue();
                    if (EIds != null && EIds.size() > 0) {
                        EIds.removeAll(needDelDownEIDs);
                    }
                    if ((EIds == null || EIds.size() != 0) && EIds != null) continue;
                    hashSet.add(billEId.getKey());
                }
                if (hashSet.size() > 0) {
                    for (Long downId : hashSet) {
                        billEntryMap.remove(downId);
                    }
                }
            }
        }
    }

    private static void processMapsByEntry(Set<Long> delUpEntryIds, Map<Long, Set<Long>> upBillEntryIDMap, Map<String, Set<Long>> upBillEntryMap, Map<Long, Set<Long>> billEntryMap, Map<Long, Set<Long>> upDownEtryMap, Map<Long, Long> downUpEtryMap, Map<Long, Long> entryBillMap) {
        if (delUpEntryIds != null && delUpEntryIds.size() != 0) {
            for (Map.Entry<Long, Set<Long>> entry : upBillEntryIDMap.entrySet()) {
                entry.getValue().removeAll(delUpEntryIds);
                if (upBillEntryIDMap.get(entry.getKey()) != null && upBillEntryIDMap.get(entry.getKey()).size() != 0) continue;
                upBillEntryIDMap.remove(entry.getKey());
            }
            for (Map.Entry<Object, Set<Long>> entry : upBillEntryMap.entrySet()) {
                entry.getValue().removeAll(delUpEntryIds);
                if (upBillEntryMap.get(entry.getKey()) != null && upBillEntryMap.get(entry.getKey()).size() != 0) continue;
                upBillEntryMap.remove(entry.getKey());
            }
            HashSet<Long> needDelDownEIDs = new HashSet<Long>(8);
            for (Long delUpEtryId : delUpEntryIds) {
                Set<Long> downEtryIds;
                if (upDownEtryMap == null || upDownEtryMap.size() <= 0 || (downEtryIds = upDownEtryMap.remove(delUpEtryId)) == null) continue;
                needDelDownEIDs.addAll(downEtryIds);
            }
            if (needDelDownEIDs != null && needDelDownEIDs.size() > 0) {
                for (Long downEID : needDelDownEIDs) {
                    downUpEtryMap.remove(downEID);
                    entryBillMap.remove(downEID);
                }
                HashSet<Long> hashSet = new HashSet<Long>(8);
                for (Map.Entry<Long, Set<Long>> billEId : billEntryMap.entrySet()) {
                    Set<Long> EIds = billEId.getValue();
                    if (EIds != null && EIds.size() > 0) {
                        EIds.removeAll(needDelDownEIDs);
                    }
                    if ((EIds == null || EIds.size() != 0) && EIds != null) continue;
                    hashSet.add(billEId.getKey());
                }
                if (hashSet.size() > 0) {
                    for (Long downId : hashSet) {
                        billEntryMap.remove(downId);
                    }
                }
            }
        }
    }

    private static DynamicObjectCollection processRowExpsColl(ExpenseCtx expsCtx, DynamicObjectCollection rowExpsEtryColl, String billEntity, Map<String, Set<Long>> upBillEntryMap, Map<Long, Set<Long>> billEntryMap, Map<Long, DynamicObject> bizBillObjMap, Map<Long, Set<Long>> upDownEtryMap, Map<Long, Long> downUpEtryMap, Map<Long, Long> entryBillMap, Map<String, Set<Long>> upEntityIdMap) {
        for (Map.Entry<String, Set<Long>> mapEntry : upBillEntryMap.entrySet()) {
            long begintime = System.currentTimeMillis();
            Set<Long> upBillIds = upEntityIdMap.get(mapEntry.getKey());
            Set<Long> upEntryIds = mapEntry.getValue();
            HashMap<Long, Object> downBillEtryMap = new HashMap<Long, Object>(8);
            HashSet<Long> downEIDs = new HashSet<Long>(8);
            for (Long upEntryId : upEntryIds) {
                Set<Long> dEIDs = upDownEtryMap.get(upEntryId);
                if (dEIDs == null || dEIDs.size() <= 0) continue;
                downEIDs.addAll(dEIDs);
            }
            if (downEIDs != null && downEIDs.size() > 0) {
                for (Long dEID : downEIDs) {
                    Long billId = entryBillMap.get(dEID);
                    if (downBillEtryMap.get(billId) == null) {
                        HashSet eIDs = new HashSet(8);
                        eIDs.add(dEID);
                        downBillEtryMap.put(billId, eIDs);
                        continue;
                    }
                    ((Set)downBillEtryMap.get(billId)).add(dEID);
                }
            }
            Map<String, String> upModelMap = ExpenseBillHelper.getFieldMap(mapEntry.getKey().toString());
            if (downBillEtryMap == null || downBillEtryMap.size() <= 0) continue;
            HashSet<Long> downBillIds = new HashSet<Long>(downBillEtryMap.size());
            HashSet downEntryIds = new HashSet(8);
            for (Map.Entry entry : downBillEtryMap.entrySet()) {
                downBillIds.add((Long)entry.getKey());
                downEntryIds.addAll((Set)entry.getValue());
            }
            boolean upHasModel = ExpenseService.checkModelMap(expsCtx, mapEntry.getKey().toString(), downBillIds, upModelMap);
            if (!upHasModel) {
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
                for (DynamicObject rowExps : rowExpsEtryColl) {
                    if (!downEntryIds.contains(rowExps.getLong("r_bizentryid"))) continue;
                    dynamicObjectCollection.add((Object)rowExps);
                }
                rowExpsEtryColl.removeAll((Collection)dynamicObjectCollection);
                for (Long downBillId : downBillIds) {
                    billEntryMap.remove(downBillId);
                }
                continue;
            }
            DynamicObjectCollection downBizBillEntrys = new DynamicObjectCollection();
            HashSet<Long> chargeOffEntryIds = new HashSet<Long>(8);
            String isChargeOffStr = expsCtx.getBizBillFldMap().get("ischargeoff");
            for (Map.Entry entry : downBillEtryMap.entrySet()) {
                Long downBillId;
                downBillId = (Long)entry.getKey();
                Set downEtryIds = (Set)entry.getValue();
                DynamicObject downBizBillObj = bizBillObjMap.get(downBillId);
                boolean isChargeOff = false;
                if (!StringUtils.isEmpty((String)isChargeOffStr)) {
                    isChargeOff = downBizBillObj.getBoolean(isChargeOffStr);
                }
                DynamicObjectCollection downEntryColl = downBizBillObj.getDynamicObjectCollection(expsCtx.getBizBillFldMap().get("billentry"));
                for (int k = 0; k < downEntryColl.size(); ++k) {
                    if (!downEtryIds.contains(((DynamicObject)downEntryColl.get(k)).get("id"))) continue;
                    downBizBillEntrys.add(downEntryColl.get(k));
                    if (!isChargeOff) continue;
                    chargeOffEntryIds.add(((DynamicObject)downEntryColl.get(k)).getLong("id"));
                }
            }
            HashMap<Long, DynamicObject> hashMap = new HashMap<Long, DynamicObject>(8);
            for (DynamicObject downEtryObj : downBizBillEntrys) {
                hashMap.put(downEtryObj.getLong("id"), downEtryObj);
            }
            HashMap hashMap2 = new HashMap(8);
            String upBizSelProps = ExpenseBillHelper.getSelectPropsForDS(mapEntry.getKey().toString(), upModelMap);
            String upAmountTaxProp = ExpenseBillHelper.getBillFieldByMap(mapEntry.getKey().toString(), "amountandtax", null);
            String upBillEntryProp = ExpenseBillHelper.getBillFieldByMap(mapEntry.getKey().toString(), "billentry", upModelMap);
            long endtime = System.currentTimeMillis();
            long begintime2test = System.currentTimeMillis();
            if (!StringUtils.isEmpty((String)upAmountTaxProp)) {
                // empty if block
            }
            long endupbizbill = System.currentTimeMillis();
            for (int i = 0; i < rowExpsEtryColl.size(); ++i) {
                if (chargeOffEntryIds.contains(((DynamicObject)rowExpsEtryColl.get(i)).getLong("r_bizentryid"))) {
                    ((DynamicObject)rowExpsEtryColl.get(i)).set("r_priceval", (Object)((DynamicObject)rowExpsEtryColl.get(i)).getBigDecimal("r_priceval").multiply(new BigDecimal(-1)));
                    ((DynamicObject)rowExpsEtryColl.get(i)).set("r_amount", (Object)((DynamicObject)rowExpsEtryColl.get(i)).getBigDecimal("r_amount").multiply(new BigDecimal(-1)));
                    continue;
                }
                DynamicObject downEtryObj = (DynamicObject)hashMap.get(((DynamicObject)rowExpsEtryColl.get(i)).getLong("r_bizentryid"));
                if (downEtryObj == null) continue;
                String calcbase = ((DynamicObject)rowExpsEtryColl.get(i)).getDynamicObject("r_caltype").getString("calcbase");
                DynamicObject currency = ((DynamicObject)rowExpsEtryColl.get(i)).getDynamicObject("r_currency");
                int amtprecision = 10;
                if (currency != null) {
                    amtprecision = currency.getInt("amtprecision");
                }
                if ("qty".equals(calcbase)) {
                    DynamicObject material;
                    String materialPorp = ExpenseBillHelper.getBillFieldByMap(billEntity, "material", expsCtx.getBizBillFldMap());
                    if (StringUtils.isEmpty((String)materialPorp) || (material = downEtryObj.getDynamicObject(materialPorp)) == null) break;
                    Long materialId = material.getLong("id");
                    String desUnitProp = ExpenseBillHelper.getBillFieldByMap(billEntity, "unit", expsCtx.getBizBillFldMap());
                    if (StringUtils.isEmpty((String)desUnitProp)) break;
                    BigDecimal priceVal = BigDecimal.ZERO;
                    DynamicObject srcUnit = ((DynamicObject)rowExpsEtryColl.get(i)).getDynamicObject("r_unit");
                    BigDecimal oldPriceVal = ((DynamicObject)rowExpsEtryColl.get(i)).getBigDecimal("r_priceval");
                    DynamicObject desUnit = downEtryObj.getDynamicObject(desUnitProp);
                    priceVal = ExpenseBillHelper.getDesQtyConv(materialId, srcUnit, oldPriceVal, desUnit);
                    ((DynamicObject)rowExpsEtryColl.get(i)).set("r_priceval", (Object)priceVal);
                    ((DynamicObject)rowExpsEtryColl.get(i)).set("r_unit", (Object)desUnit);
                    String qtyProp = ExpenseBillHelper.getBillFieldByMap(billEntity, calcbase, expsCtx.getBizBillFldMap());
                    if (StringUtils.isEmpty((String)qtyProp)) break;
                    BigDecimal calTypeVal = BigDecimal.ZERO;
                    calTypeVal = downEtryObj.getBigDecimal(qtyProp).abs();
                    ((DynamicObject)rowExpsEtryColl.get(i)).set("r_caltypeval", (Object)calTypeVal);
                    ((DynamicObject)rowExpsEtryColl.get(i)).set("r_amount", (Object)priceVal.multiply(calTypeVal).setScale(amtprecision, RoundingMode.HALF_UP));
                }
                if ("amountandtax".equals(calcbase)) {
                    String amountTaxProp = ExpenseBillHelper.getBillFieldByMap(billEntity, "amountandtax", expsCtx.getBizBillFldMap());
                    if (StringUtils.isEmpty((String)amountTaxProp)) break;
                    BigDecimal downAmountAndTax = downEtryObj.getBigDecimal(amountTaxProp).abs();
                    BigDecimal oldPriceVal = ((DynamicObject)rowExpsEtryColl.get(i)).getBigDecimal("r_priceval");
                    ((DynamicObject)rowExpsEtryColl.get(i)).set("r_caltypeval", (Object)downAmountAndTax);
                    ((DynamicObject)rowExpsEtryColl.get(i)).set("r_amount", (Object)downAmountAndTax.multiply(oldPriceVal).divide(new BigDecimal(100)).setScale(amtprecision, RoundingMode.HALF_UP));
                }
                if (!StringUtils.isEmpty((String)calcbase)) continue;
                String downAmountTaxProp = ExpenseBillHelper.getBillFieldByMap(billEntity, "amountandtax", expsCtx.getBizBillFldMap());
                if (StringUtils.isEmpty((String)downAmountTaxProp)) break;
                Long upEtryID = downUpEtryMap.get(((DynamicObject)rowExpsEtryColl.get(i)).getLong("r_bizentryid"));
                BigDecimal upAmountAndTax = ((BigDecimal)hashMap2.get(upEtryID)).abs();
                BigDecimal downAmountAndTax = downEtryObj.getBigDecimal(downAmountTaxProp).abs();
                BigDecimal oldPriceVal = ((DynamicObject)rowExpsEtryColl.get(i)).getBigDecimal("r_priceval");
                if (upAmountAndTax.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal priceVal = downAmountAndTax.multiply(oldPriceVal).divide(upAmountAndTax, amtprecision, RoundingMode.HALF_UP);
                    ((DynamicObject)rowExpsEtryColl.get(i)).set("r_priceval", (Object)priceVal);
                    ((DynamicObject)rowExpsEtryColl.get(i)).set("r_amount", (Object)priceVal);
                    continue;
                }
                ((DynamicObject)rowExpsEtryColl.get(i)).set("r_priceval", (Object)BigDecimal.ZERO);
                ((DynamicObject)rowExpsEtryColl.get(i)).set("r_amount", (Object)BigDecimal.ZERO);
            }
            long l = System.currentTimeMillis();
        }
        return rowExpsEtryColl;
    }

    private static void buildExpsBill(ExpenseCtx expsCtx, String bizBillEntity, DynamicObjectCollection rowExpsEtryColl, Map<Long, Set<Long>> billEntryMap, List<DynamicObject> bizBills) {
        if (rowExpsEtryColl == null || rowExpsEtryColl.size() == 0) {
            return;
        }
        MainEntityType expsEntityType = MetadataServiceHelper.getDataEntityType((String)"msbd_expensebill");
        ArrayList<DynamicObject> expsColl = new ArrayList<DynamicObject>(8);
        HashMap<Long, String> bizBillNumMap = new HashMap<Long, String>(8);
        HashMap<Long, DynamicObject> bizBillOrgMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject bizBill : bizBills) {
            bizBillNumMap.put(bizBill.getLong("id"), bizBill.getString(expsCtx.getBizBillFldMap().get("bizbillno")));
            bizBillOrgMap.put(bizBill.getLong("id"), bizBill.getDynamicObject(expsCtx.getBizBillFldMap().get("bizorg")));
        }
        long begingenexpsidtime = System.currentTimeMillis();
        long[] expsIds = DBServiceHelper.genLongIds((String)"msbd_expensebill", (int)billEntryMap.size());
        long endgenexpsidtime = System.currentTimeMillis();
        int k = 0;
        for (Map.Entry<Long, Set<Long>> entryIdMap : billEntryMap.entrySet()) {
            Set<Long> entryIds = entryIdMap.getValue();
            Long bizBillId = entryIdMap.getKey();
            DynamicObject exps = new DynamicObject((DynamicObjectType)expsEntityType);
            ArrayList<Long> entryIdList = new ArrayList<Long>(entryIds);
            Collections.sort(entryIdList);
            for (int n = 0; n < entryIdList.size(); ++n) {
                for (int i = 0; i < rowExpsEtryColl.size(); ++i) {
                    if (!((Long)entryIdList.get(n)).equals(((DynamicObject)rowExpsEtryColl.get(i)).getLong("r_bizentryid"))) continue;
                    exps.getDynamicObjectCollection("rowexpenseentry").add(rowExpsEtryColl.get(i));
                }
            }
            exps.set("id", (Object)expsIds[k]);
            exps.set("bizbillid", (Object)entryIdMap.getKey());
            exps.set("bizbillentity", (Object)bizBillEntity);
            exps.set("bizbillno", bizBillNumMap.get(entryIdMap.getKey()));
            exps.set("org", bizBillOrgMap.get(entryIdMap.getKey()));
            exps.set("billstatus", (Object)"A");
            Date today = TimeServiceHelper.today();
            exps.set("biztime", (Object)today);
            expsColl.add(exps);
            ++k;
        }
        if (expsColl != null && expsColl.size() > 0) {
            long begingetexpsnumstime = System.currentTimeMillis();
            Object[] numbers = CodeRuleServiceHelper.getBatchNumber((String)"msbd_expensebill", (DynamicObject)((DynamicObject)expsColl.get(0)), null, (int)billEntryMap.size());
            long endgetexpsnumstime = System.currentTimeMillis();
            if (!ObjectUtils.isEmpty((Object[])numbers) && numbers.length == billEntryMap.size()) {
                int m = 0;
                for (DynamicObject exps : expsColl) {
                    exps.set("billno", numbers[m]);
                    ++m;
                }
                for (DynamicObject exps : expsColl) {
                    if (exps == null) continue;
                    DynamicObjectCollection billExpsEtrys = exps.getDynamicObjectCollection("billexpenseentry");
                    DynamicObjectCollection rowExpsEtrys = exps.getDynamicObjectCollection("rowexpenseentry");
                    EntryType billExpEtryType = (EntryType)expsEntityType.getAllEntities().get("billexpenseentry");
                    EntryType rowExpEtryType = (EntryType)expsEntityType.getAllEntities().get("rowexpenseentry");
                    Map<String, Map<String, Object>> rowExpMap = ExpenseBillHelper.rowExpsSumByAll(rowExpsEtrys);
                    ExpenseBillHelper.rowExpsToBillEntry(billExpsEtrys, billExpEtryType, rowExpsEtrys, rowExpMap);
                    ExpenseService.expenseCheck(expsCtx, exps);
                    long begingenentryidstime = System.currentTimeMillis();
                    long[] ids = DBServiceHelper.genLongIds((String)"rowexpenseentry", (int)rowExpsEtrys.size());
                    long endgenentryidstime = System.currentTimeMillis();
                    for (int n = 0; n < rowExpsEtrys.size(); ++n) {
                        ((DynamicObject)rowExpsEtrys.get(n)).set("seq", (Object)(n + 1));
                        ((DynamicObject)rowExpsEtrys.get(n)).set("id", (Object)ids[n]);
                    }
                    for (int i = 0; i < billExpsEtrys.size(); ++i) {
                        DynamicObjectCollection rowExpToStr = new DynamicObjectCollection();
                        DynamicObject priceType = ((DynamicObject)billExpsEtrys.get(i)).getDynamicObject("pricetype");
                        DynamicObject currency = ((DynamicObject)billExpsEtrys.get(i)).getDynamicObject("currency");
                        if (priceType == null || currency == null) continue;
                        for (int j = 0; j < rowExpsEtrys.size(); ++j) {
                            DynamicObject r_priceType = ((DynamicObject)rowExpsEtrys.get(j)).getDynamicObject("r_pricetype");
                            DynamicObject r_currency = ((DynamicObject)rowExpsEtrys.get(j)).getDynamicObject("r_currency");
                            if (r_priceType == null || r_currency == null || !priceType.getPkValue().equals(r_priceType.getPkValue()) || !currency.getPkValue().equals(r_currency.getPkValue())) continue;
                            rowExpToStr.add(rowExpsEtrys.get(j));
                        }
                        if (rowExpToStr.size() <= 0) continue;
                        String str = ExpenseBillHelper.DOToStr(rowExpToStr, rowExpEtryType);
                        ((DynamicObject)billExpsEtrys.get(i)).set("rowexpensejson_tag", (Object)str);
                    }
                    Map<String, Object> srvExpsMap = expsCtx.getExpenseResult().get(exps.getLong("bizbillid"));
                    if (CommonUtils.isNull(srvExpsMap)) {
                        srvExpsMap = new HashMap<String, Object>(8);
                        srvExpsMap.put("success", Boolean.TRUE);
                        srvExpsMap.put("expensebillid", exps.get("id"));
                    } else if (srvExpsMap.get("success") != null && !((Boolean)srvExpsMap.get("success")).booleanValue()) {
                        srvExpsMap.put("expensebillid", exps.get("id"));
                    } else {
                        srvExpsMap.put("success", Boolean.TRUE);
                        srvExpsMap.put("expensebillid", exps.get("id"));
                    }
                    expsCtx.getExpenseResult().put(exps.getLong("bizbillid"), srvExpsMap);
                }
                long beginsavetime = System.currentTimeMillis();
                SaveServiceHelper.save((DynamicObject[])expsColl.toArray(new DynamicObject[0]));
                long l = System.currentTimeMillis();
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d39\u7528\u6e05\u5355\u7f16\u7801\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u89c4\u5219\u3002", (String)"ExpenseService_10", (String)"mpscmm-msbd-expense", (Object[])new Object[0]));
            }
        }
    }

    public static void expenseCheck(ExpenseCtx expsCtx, DynamicObject expsBill) {
        BigDecimal maxValue = new BigDecimal("9999999999999");
        BigDecimal minValue = new BigDecimal("-9999999999999");
        DynamicObjectCollection billExpsEtrys = expsBill.getDynamicObjectCollection("billexpenseentry");
        DynamicObjectCollection rowExpsEtrys = expsBill.getDynamicObjectCollection("rowexpenseentry");
        Map<String, Object> srvExpsMap = expsCtx.getExpenseResult().get(expsBill.getLong("bizbillid"));
        if (billExpsEtrys != null && billExpsEtrys.size() > 0) {
            for (int i = 0; i < billExpsEtrys.size(); ++i) {
                String msg;
                BigDecimal priceval = ((DynamicObject)billExpsEtrys.get(i)).getBigDecimal("priceval");
                String priceval_msg = "";
                if (maxValue.compareTo(priceval) < 0 || minValue.compareTo(priceval) > 0) {
                    priceval_msg = ResManager.loadKDString((String)"\u6574\u5355\u8d39\u7528\u9875\u7b7e\uff0c\u884c\u53f7\u201c%1$s\u201d\uff0c\u4ef7\u683c\u503c\u8d85\u51fa\u6570\u503c\u8303\u56f4[-999999999999,999999999999]\uff0c\u8bf7\u7ef4\u62a4\u3002\n", (String)"ExpenseService_0", (String)"mpscmm-msbd-expense", (Object[])new Object[]{i + 1});
                    ((DynamicObject)billExpsEtrys.get(i)).set("priceval", (Object)BigDecimal.ZERO);
                }
                BigDecimal caltypeval = ((DynamicObject)billExpsEtrys.get(i)).getBigDecimal("caltypeval");
                String caltypeval_msg = "";
                if (maxValue.compareTo(caltypeval) < 0 || BigDecimal.ZERO.compareTo(caltypeval) > 0) {
                    caltypeval_msg = ResManager.loadKDString((String)"\u6574\u5355\u8d39\u7528\u9875\u7b7e\uff0c\u884c\u53f7\u201c%1$s\u201d\uff0c\u8ba1\u7b97\u4f9d\u636e\u503c\u8d85\u51fa\u6570\u503c\u8303\u56f4[0,999999999999]\uff0c\u8bf7\u7ef4\u62a4\u3002\n", (String)"ExpenseService_1", (String)"mpscmm-msbd-expense", (Object[])new Object[]{i + 1});
                    ((DynamicObject)billExpsEtrys.get(i)).set("caltypeval", (Object)BigDecimal.ZERO);
                }
                BigDecimal amount = ((DynamicObject)billExpsEtrys.get(i)).getBigDecimal("amount");
                String amount_msg = "";
                if (amount.compareTo(BigDecimal.ZERO) == 0) {
                    amount_msg = ResManager.loadKDString((String)"\u6574\u5355\u8d39\u7528\u9875\u7b7e\uff0c\u884c\u53f7\u201c%1$s\u201d\uff0c\u8d39\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002\n", (String)"ExpenseService_2", (String)"mpscmm-msbd-expense", (Object[])new Object[]{i + 1});
                }
                if (maxValue.compareTo(amount) < 0 || minValue.compareTo(amount) > 0) {
                    amount_msg = ResManager.loadKDString((String)"\u6574\u5355\u8d39\u7528\u9875\u7b7e\uff0c\u884c\u53f7\u201c%1$s\u201d\uff0c\u8d39\u7528\u91d1\u989d\u8d85\u51fa\u6570\u503c\u8303\u56f4[-999999999999,999999999999]\uff0c\u8bf7\u7ef4\u62a4\u3002\n", (String)"ExpenseService_3", (String)"mpscmm-msbd-expense", (Object[])new Object[]{i + 1});
                    ((DynamicObject)billExpsEtrys.get(i)).set("amount", (Object)BigDecimal.ZERO);
                }
                if (StringUtils.isEmpty((String)(msg = priceval_msg + caltypeval_msg + amount_msg))) continue;
                if (CommonUtils.isNull(srvExpsMap)) {
                    srvExpsMap = new HashMap<String, Object>(8);
                    srvExpsMap.put("success", Boolean.FALSE);
                    srvExpsMap.put("message", msg);
                    srvExpsMap.put("billentity", expsBill.get("bizbillentity"));
                    srvExpsMap.put("expensebillid", expsBill.get("id"));
                    srvExpsMap.put("bizbillno", expsBill.get("bizbillno"));
                } else {
                    srvExpsMap.put("success", Boolean.FALSE);
                    if (srvExpsMap.get("message") != null) {
                        srvExpsMap.put("message", srvExpsMap.get("message") + msg);
                    } else {
                        srvExpsMap.put("message", msg);
                    }
                    srvExpsMap.put("billentity", expsBill.get("bizbillentity"));
                    srvExpsMap.put("expensebillid", expsBill.get("id"));
                    srvExpsMap.put("bizbillno", expsBill.get("bizbillno"));
                }
                expsCtx.getExpenseResult().put(expsBill.getLong("bizbillid"), srvExpsMap);
            }
        }
        if (rowExpsEtrys != null && rowExpsEtrys.size() > 0) {
            for (int j = 0; j < rowExpsEtrys.size(); ++j) {
                String msg;
                BigDecimal r_priceval = ((DynamicObject)rowExpsEtrys.get(j)).getBigDecimal("r_priceval");
                String r_priceval_msg = "";
                if (maxValue.compareTo(r_priceval) < 0 || minValue.compareTo(r_priceval) > 0) {
                    r_priceval_msg = ResManager.loadKDString((String)"\u884c\u8d39\u7528\u9875\u7b7e\uff0c\u884c\u53f7\u201c%1$s\u201d\uff0c\u4ef7\u683c\u503c\u8d85\u51fa\u6570\u503c\u8303\u56f4[-999999999999,999999999999]\uff0c\u8bf7\u7ef4\u62a4\u3002\n", (String)"ExpenseService_4", (String)"mpscmm-msbd-expense", (Object[])new Object[]{j + 1});
                    ((DynamicObject)rowExpsEtrys.get(j)).set("r_priceval", (Object)BigDecimal.ZERO);
                }
                BigDecimal r_caltypeval = ((DynamicObject)rowExpsEtrys.get(j)).getBigDecimal("r_caltypeval");
                String r_caltypeval_msg = "";
                if (maxValue.compareTo(r_caltypeval) < 0 || BigDecimal.ZERO.compareTo(r_caltypeval) > 0) {
                    r_caltypeval_msg = ResManager.loadKDString((String)"\u884c\u8d39\u7528\u9875\u7b7e\uff0c\u884c\u53f7\u201c%1$s\u201d\uff0c\u8ba1\u7b97\u4f9d\u636e\u503c\u8d85\u51fa\u6570\u503c\u8303\u56f4[0,999999999999]\uff0c\u8bf7\u7ef4\u62a4\u3002\n", (String)"ExpenseService_5", (String)"mpscmm-msbd-expense", (Object[])new Object[]{j + 1});
                    ((DynamicObject)rowExpsEtrys.get(j)).set("r_caltypeval", (Object)BigDecimal.ZERO);
                }
                BigDecimal r_amount = ((DynamicObject)rowExpsEtrys.get(j)).getBigDecimal("r_amount");
                String r_amount_msg = "";
                if (r_amount.compareTo(BigDecimal.ZERO) == 0) {
                    r_amount_msg = ResManager.loadKDString((String)"\u884c\u8d39\u7528\u9875\u7b7e\uff0c\u884c\u53f7\u201c%1$s\u201d\uff0c\u8d39\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002\n", (String)"ExpenseService_6", (String)"mpscmm-msbd-expense", (Object[])new Object[]{j + 1});
                }
                if (maxValue.compareTo(r_amount) < 0 || minValue.compareTo(r_amount) > 0) {
                    r_amount_msg = ResManager.loadKDString((String)"\u884c\u8d39\u7528\u9875\u7b7e\uff0c\u884c\u53f7\u201c%1$s\u201d\uff0c\u8d39\u7528\u91d1\u989d\u8d85\u51fa\u6570\u503c\u8303\u56f4[-999999999999,999999999999]\uff0c\u8bf7\u7ef4\u62a4\u3002\n", (String)"ExpenseService_7", (String)"mpscmm-msbd-expense", (Object[])new Object[]{j + 1});
                    ((DynamicObject)rowExpsEtrys.get(j)).set("r_amount", (Object)BigDecimal.ZERO);
                }
                DynamicObject r_expsItem = ((DynamicObject)rowExpsEtrys.get(j)).getDynamicObject("r_expsitm");
                String r_expsitem_msg = "";
                if (r_expsItem == null || r_expsItem.getLong("id") == 0L) {
                    r_expsitem_msg = ResManager.loadKDString((String)"\u884c\u8d39\u7528\u9875\u7b7e\uff0c\u884c\u53f7\u201c%1$s\u201d\uff0c\u8d39\u7528\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002\n", (String)"ExpenseService_11", (String)"mpscmm-msbd-expense", (Object[])new Object[]{j + 1});
                }
                if (StringUtils.isEmpty((String)(msg = r_priceval_msg + r_caltypeval_msg + r_amount_msg + r_expsitem_msg))) continue;
                if (CommonUtils.isNull(srvExpsMap)) {
                    srvExpsMap = new HashMap<String, Object>(8);
                    srvExpsMap.put("success", Boolean.FALSE);
                    srvExpsMap.put("message", msg);
                    srvExpsMap.put("billentity", expsBill.get("bizbillentity"));
                    srvExpsMap.put("expensebillid", expsBill.get("id"));
                    srvExpsMap.put("bizbillno", expsBill.get("bizbillno"));
                } else {
                    srvExpsMap.put("success", Boolean.FALSE);
                    if (srvExpsMap.get("message") != null) {
                        srvExpsMap.put("message", srvExpsMap.get("message") + msg);
                    } else {
                        srvExpsMap.put("message", msg);
                    }
                    srvExpsMap.put("billentity", expsBill.get("bizbillentity"));
                    srvExpsMap.put("expensebillid", expsBill.get("id"));
                    srvExpsMap.put("bizbillno", expsBill.get("bizbillno"));
                }
                expsCtx.getExpenseResult().put(expsBill.getLong("bizbillid"), srvExpsMap);
            }
        }
        if (billExpsEtrys != null && billExpsEtrys.size() > 0) {
            DynamicObject currencyObj;
            DynamicObject priceTypeObj;
            Map<Object, Object> rowExpMap = new HashMap(8);
            rowExpMap = ExpenseBillHelper.rowExpsSumByAll(rowExpsEtrys);
            for (int k = 0; k < billExpsEtrys.size() && (priceTypeObj = ((DynamicObject)billExpsEtrys.get(k)).getDynamicObject("pricetype")) != null && (currencyObj = ((DynamicObject)billExpsEtrys.get(k)).getDynamicObject("currency")) != null; ++k) {
                String priceType = priceTypeObj.getPkValue().toString();
                String currency = currencyObj.getPkValue().toString();
                String billExpMapKey = priceType + "&" + currency;
                BigDecimal amount = ((DynamicObject)billExpsEtrys.get(k)).getBigDecimal("amount");
                if (rowExpMap.get(billExpMapKey) == null) continue;
                BigDecimal r_amount = (BigDecimal)((Map)rowExpMap.get(billExpMapKey)).get("amount");
                if (amount == null || amount.compareTo(r_amount) == 0) continue;
                String priceTypeName = priceTypeObj.getLocaleString("name").toString();
                String msg = ResManager.loadKDString((String)"\u6574\u5355\u8d39\u7528\u9875\u7b7e\uff0c\u4ef7\u683c\u7c7b\u578b\u201c%1$s\u201d\u7684\u8d39\u7528\u91d1\u989d\uff08%2$s\uff09\u4e0e\u884c\u8d39\u7528\uff08%3$s\uff09\u4e0d\u76f8\u7b49\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ExpenseService_8", (String)"mpscmm-msbd-expense", (Object[])new Object[]{priceTypeName, amount, r_amount});
                if (CommonUtils.isNull(srvExpsMap)) {
                    srvExpsMap = new HashMap<String, Object>(8);
                    srvExpsMap.put("success", Boolean.FALSE);
                    srvExpsMap.put("message", msg);
                    srvExpsMap.put("billentity", expsBill.get("bizbillentity"));
                    srvExpsMap.put("expensebillid", expsBill.get("id"));
                    srvExpsMap.put("bizbillno", expsBill.get("bizbillno"));
                } else {
                    srvExpsMap.put("success", Boolean.FALSE);
                    if (srvExpsMap.get("message") != null) {
                        srvExpsMap.put("message", srvExpsMap.get("message") + msg);
                    } else {
                        srvExpsMap.put("message", msg);
                    }
                    srvExpsMap.put("billentity", expsBill.get("bizbillentity"));
                    srvExpsMap.put("expensebillid", expsBill.get("id"));
                    srvExpsMap.put("bizbillno", expsBill.get("bizbillno"));
                }
                expsCtx.getExpenseResult().put(expsBill.getLong("bizbillid"), srvExpsMap);
            }
        }
    }

    private static void expenseReCalculate(ExpenseCtx expsCtx, String bizBillEntity, Set<Long> bizBillIds, List<DynamicObject> bizBills, List<DynamicObject> expenseBills) {
        long begingetunprocexpstime = System.currentTimeMillis();
        List<DynamicObject> expenseBillColl = ExpenseService.getUnProcessExpenseColl(bizBillIds, expenseBills);
        long endgetunprocexpstime = System.currentTimeMillis();
        if (CommonUtils.isNull(expenseBillColl)) {
            return;
        }
        Map<Long, Set<Long>> expsBizBillEntryIdMap = new HashMap<Long, Set<Long>>(8);
        expsBizBillEntryIdMap = ExpenseService.getBizBillEntryFromExps(expsBizBillEntryIdMap, expenseBillColl);
        Map<Long, Set<Long>> bizBillEntryIdMap = new HashMap<Long, Set<Long>>(8);
        if ((bizBillEntryIdMap = ExpenseService.getBillEntryFromBiz(expsCtx, bizBillEntryIdMap, bizBillEntity, bizBillIds, bizBills)) == null || bizBillEntryIdMap.size() == 0) {
            return;
        }
        Set<Long> delBillEntryIds = new HashSet<Long>(8);
        for (Map.Entry<Long, Set<Long>> expsMap : expsBizBillEntryIdMap.entrySet()) {
            Long bizBillId = expsMap.getKey();
            Set<Long> bizBillEntryIds_exps = expsMap.getValue();
            Set<Long> bizBillEntryIds = bizBillEntryIdMap.get(bizBillId);
            delBillEntryIds = ExpenseService.getIdSet(bizBillEntryIds_exps, delBillEntryIds);
            delBillEntryIds.removeAll(bizBillEntryIds);
        }
        if (delBillEntryIds.size() > 0) {
            ExpenseService.delRowExpsByEntryIds(expenseBillColl, delBillEntryIds);
        }
        long begingetprocexpstime = System.currentTimeMillis();
        ExpenseService.getProcessedExpenseColl(expsCtx, expenseBillColl, bizBills);
        long endgetprocexpstime = System.currentTimeMillis();
        if (expenseBillColl != null && expenseBillColl.size() > 0) {
            for (DynamicObject exps : expenseBillColl) {
                if (exps == null) continue;
                DynamicObjectCollection billExpsEtrys = exps.getDynamicObjectCollection("billexpenseentry");
                DynamicObjectCollection rowExpsEtrys = exps.getDynamicObjectCollection("rowexpenseentry");
                EntryType rowExpEtryType = (EntryType)rowExpsEtrys.getDynamicObjectType();
                long beginchecktime = System.currentTimeMillis();
                ExpenseService.expenseCheck(expsCtx, exps);
                long endchecktime = System.currentTimeMillis();
                long beginrowtostrtime = System.currentTimeMillis();
                for (int i = 0; i < billExpsEtrys.size(); ++i) {
                    DynamicObjectCollection rowExpToStr = new DynamicObjectCollection();
                    DynamicObject priceType = ((DynamicObject)billExpsEtrys.get(i)).getDynamicObject("pricetype");
                    DynamicObject currency = ((DynamicObject)billExpsEtrys.get(i)).getDynamicObject("currency");
                    if (priceType == null || currency == null) continue;
                    for (int j = 0; j < rowExpsEtrys.size(); ++j) {
                        DynamicObject r_priceType = ((DynamicObject)rowExpsEtrys.get(j)).getDynamicObject("r_pricetype");
                        DynamicObject r_currency = ((DynamicObject)rowExpsEtrys.get(j)).getDynamicObject("r_currency");
                        if (r_priceType == null || r_currency == null || !priceType.getPkValue().equals(r_priceType.getPkValue()) || !currency.getPkValue().equals(r_currency.getPkValue())) continue;
                        rowExpToStr.add(rowExpsEtrys.get(j));
                    }
                    if (rowExpToStr.size() <= 0) continue;
                    String str = ExpenseBillHelper.DOToStr(rowExpToStr, rowExpEtryType);
                    ((DynamicObject)billExpsEtrys.get(i)).set("rowexpensejson_tag", (Object)str);
                }
                long l = System.currentTimeMillis();
            }
            long beginsavetime = System.currentTimeMillis();
            SaveServiceHelper.save((DynamicObject[])expenseBillColl.toArray(new DynamicObject[0]));
            long l = System.currentTimeMillis();
        }
    }

    private static List<DynamicObject> getUnProcessExpenseColl(Set<Long> bizBillIds, List<DynamicObject> expenseBills) {
        if (expenseBills.size() > 0) {
            EntryType rowExpEtryType = (EntryType)expenseBills.get(0).getDynamicObjectCollection("rowexpenseentry").getDynamicObjectType();
            for (int i = 0; i < expenseBills.size(); ++i) {
                DynamicObjectCollection billExpsEntrys = expenseBills.get(i).getDynamicObjectCollection("billexpenseentry");
                DynamicObjectCollection rowExpsEtryColl = expenseBills.get(i).getDynamicObjectCollection("rowexpenseentry");
                for (DynamicObject billExpsEntry : billExpsEntrys) {
                    ExpenseBillHelper.strToDynamicObjectColl(billExpsEntry.getString("rowexpensejson_tag"), rowExpsEtryColl, rowExpEtryType);
                }
                if (rowExpsEtryColl == null || rowExpsEtryColl.size() <= 0) continue;
                ArrayList<Long> rowExpsEntryIdList = new ArrayList<Long>(rowExpsEtryColl.size());
                HashMap<Long, Object> rowExpsMap = new HashMap<Long, Object>(8);
                for (int j = 0; j < rowExpsEtryColl.size(); ++j) {
                    rowExpsEntryIdList.add(((DynamicObject)rowExpsEtryColl.get(j)).getLong("id"));
                    rowExpsMap.put(((DynamicObject)rowExpsEtryColl.get(j)).getLong("id"), rowExpsEtryColl.get(j));
                }
                Collections.sort(rowExpsEntryIdList);
                DynamicObjectCollection sortedRowExpsEntryColl = new DynamicObjectCollection();
                for (int n = 0; n < rowExpsEntryIdList.size(); ++n) {
                    DynamicObject rowExps = (DynamicObject)rowExpsMap.get(rowExpsEntryIdList.get(n));
                    if (rowExps == null) continue;
                    sortedRowExpsEntryColl.add((Object)rowExps);
                }
                if (sortedRowExpsEntryColl.size() == 0) {
                    sortedRowExpsEntryColl = rowExpsEtryColl;
                }
                expenseBills.get(i).set("rowexpenseentry", (Object)sortedRowExpsEntryColl);
            }
        }
        return expenseBills;
    }

    private static Map<Long, Set<Long>> getBizBillEntryFromExps(Map<Long, Set<Long>> expsBizBillEntryIdMap, List<DynamicObject> expenseBillColl) {
        for (DynamicObject expenseBill : expenseBillColl) {
            DynamicObjectCollection rowExpsEtryColl = expenseBill.getDynamicObjectCollection("rowexpenseentry");
            for (DynamicObject rowExpsEtry : rowExpsEtryColl) {
                if (!CommonUtils.isNull(expsBizBillEntryIdMap.get(expenseBill.getLong("bizbillid")))) {
                    expsBizBillEntryIdMap.get(expenseBill.getLong("bizbillid")).add(rowExpsEtry.getLong("r_bizentryid"));
                    continue;
                }
                HashSet<Long> entryIds = new HashSet<Long>(8);
                entryIds.add(rowExpsEtry.getLong("r_bizentryid"));
                expsBizBillEntryIdMap.put(expenseBill.getLong("bizbillid"), entryIds);
            }
        }
        return expsBizBillEntryIdMap;
    }

    private static Map<Long, Set<Long>> getBillEntryFromBiz(ExpenseCtx expsCtx, Map<Long, Set<Long>> bizBillEntryIdMap, String bizBillEntity, Set<Long> bizBillIds, List<DynamicObject> bizBills) {
        String billEntryStr = expsCtx.getBizBillFldMap().get("billentry");
        if (StringUtils.isEmpty((String)billEntryStr)) {
            return null;
        }
        for (DynamicObject bizBill : bizBills) {
            DynamicObjectCollection entryColl = bizBill.getDynamicObjectCollection(ExpenseBillHelper.getBillFieldByMap(bizBillEntity, billEntryStr, expsCtx.getBizBillFldMap()));
            for (DynamicObject entry : entryColl) {
                if (!CommonUtils.isNull(bizBillEntryIdMap.get(bizBill.getLong("id")))) {
                    bizBillEntryIdMap.get(bizBill.getLong("id")).add(entry.getLong("id"));
                    continue;
                }
                HashSet<Long> entryIds = new HashSet<Long>(8);
                entryIds.add(entry.getLong("id"));
                bizBillEntryIdMap.put(bizBill.getLong("id"), entryIds);
            }
        }
        return bizBillEntryIdMap;
    }

    private static List<DynamicObject> delRowExpsByEntryIds(List<DynamicObject> expenseBillColl, Set<Long> delBillEntryIds) {
        for (DynamicObject expenseBill : expenseBillColl) {
            DynamicObjectCollection rowExpsEtryColl = expenseBill.getDynamicObjectCollection("rowexpenseentry");
            DynamicObjectCollection needRemove = new DynamicObjectCollection();
            for (DynamicObject rowExpsEtry : rowExpsEtryColl) {
                if (!delBillEntryIds.contains(rowExpsEtry.getLong("r_bizentryid"))) continue;
                needRemove.add((Object)rowExpsEtry);
            }
            if (needRemove.size() <= 0) continue;
            rowExpsEtryColl.removeAll((Collection)needRemove);
        }
        return expenseBillColl;
    }

    private static Map<Long, Set<Long>> getNewEntryByBotp(Map<Long, Set<Long>> newEntryBotp, Map<Long, Set<Long>> newBillEntryIdMap) {
        Long[] bizBillIdList = new Long[newBillEntryIdMap.size()];
        int m = 0;
        for (Map.Entry<Long, Set<Long>> entryIds : newBillEntryIdMap.entrySet()) {
            bizBillIdList[m] = entryIds.getKey();
            ++m;
        }
        Map dirtSourcBills = BFTrackerServiceHelper.findDirtSourceBills((String)"im_purinbill", (Long[])bizBillIdList);
        Map<Long, Set<Long>> entryMap_botp = new HashMap<Long, Set<Long>>(8);
        entryMap_botp = ExpenseService.getBotpEntrys(dirtSourcBills, entryMap_botp);
        for (Map.Entry<Long, Set<Long>> newBillEntry : newBillEntryIdMap.entrySet()) {
            Set<Long> billEntry = newBillEntry.getValue();
            Set<Long> botpEntry = entryMap_botp.get(newBillEntry.getKey());
            billEntry.retainAll(botpEntry);
            newEntryBotp.put(newBillEntry.getKey(), billEntry);
        }
        return newEntryBotp;
    }

    private static Map<Long, Set<Long>> getBotpEntrys(Map<Long, List<BFRow>> dirtSourcBills, Map<Long, Set<Long>> entryMap) {
        for (Map.Entry<Long, List<BFRow>> dirtSourcBill : dirtSourcBills.entrySet()) {
            Long billId = dirtSourcBill.getKey();
            List<BFRow> BFRows = dirtSourcBill.getValue();
            for (int i = 0; i < BFRows.size(); ++i) {
                BFRow row = BFRows.get(i);
                Long entryId = row.getId().getEntryId();
                if (CommonUtils.isNull(entryMap.get(billId))) {
                    HashSet<Long> entryIds = new HashSet<Long>(8);
                    entryIds.add(entryId);
                    entryMap.put(billId, entryIds);
                    continue;
                }
                entryMap.get(billId).add(entryId);
            }
        }
        return entryMap;
    }

    private static void getProcessedExpenseColl(ExpenseCtx expsCtx, List<DynamicObject> expenseBillColl, List<DynamicObject> bizBills) {
        if (CommonUtils.isNull(expenseBillColl) || expenseBillColl.size() == 0) {
            return;
        }
        HashMap<Long, DynamicObject> bizEntryObjMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject bizBill : bizBills) {
            DynamicObjectCollection bizBillEntrys = bizBill.getDynamicObjectCollection(expsCtx.getBizBillFldMap().get("billentry"));
            for (DynamicObject bizEntry : bizBillEntrys) {
                Long bizEntryId = bizEntry.getLong("id");
                bizEntryObjMap.put(bizEntryId, bizEntry);
            }
        }
        String srcEntity = expenseBillColl.get(0).getString("bizbillentity");
        try (TraceSpan span = Tracer.create((String)"ExpenseService", (String)"getProcessedExpenseColl");){
            for (int i = 0; i < expenseBillColl.size(); ++i) {
                DynamicObjectCollection rowExpsEtryColl = expenseBillColl.get(i).getDynamicObjectCollection("rowexpenseentry");
                if (rowExpsEtryColl == null) continue;
                Object objId = expenseBillColl.get(i).get("bizbillid");
                for (int j = 0; j < rowExpsEtryColl.size(); ++j) {
                    String settleOrgStr;
                    String matFld;
                    DynamicObject mat;
                    String unitFldName;
                    String fldName;
                    boolean isExistFldMap;
                    DynamicObject r_calType = ((DynamicObject)rowExpsEtryColl.get(j)).getDynamicObject("r_caltype");
                    String fld = r_calType.getString("calcbase");
                    BigDecimal calTypeVal = BigDecimal.ZERO;
                    Long expsBizEntryId = ((DynamicObject)rowExpsEtryColl.get(j)).getLong("r_bizentryid");
                    DynamicObject bizEntryObj = (DynamicObject)bizEntryObjMap.get(expsBizEntryId);
                    if (bizEntryObj == null) continue;
                    if (!StringUtils.isEmpty((String)fld) && (isExistFldMap = ExpenseService.isExistFieldMap(expsCtx, fld, fldName = ExpenseBillHelper.getBillFieldByMap(srcEntity, fld, expsCtx.getBizBillFldMap()), expenseBillColl.get(i), srcEntity))) {
                        calTypeVal = bizEntryObj.getBigDecimal(fldName).abs();
                        ((DynamicObject)rowExpsEtryColl.get(j)).set("r_caltypeval", (Object)calTypeVal);
                        ExpenseBillHelper.expsCalculate((DynamicObject)rowExpsEtryColl.get(j));
                    }
                    if ("qty".equals(fld) && (isExistFldMap = ExpenseService.isExistFieldMap(expsCtx, "unit", unitFldName = ExpenseBillHelper.getBillFieldByMap(srcEntity, "unit", expsCtx.getBizBillFldMap()), expenseBillColl.get(i), srcEntity))) {
                        ((DynamicObject)rowExpsEtryColl.get(j)).set("r_unit", (Object)bizEntryObj.getDynamicObject(unitFldName));
                    }
                    if ((mat = bizEntryObj.getDynamicObject(matFld = ExpenseBillHelper.getBillFieldByMap(srcEntity, "material", expsCtx.getBizBillFldMap()))) != null) {
                        DynamicObject matMaster = bizEntryObj.getDynamicObject(matFld).getDynamicObject("masterid");
                        ((DynamicObject)rowExpsEtryColl.get(j)).set("r_matnum", matMaster.get("number"));
                        ((DynamicObject)rowExpsEtryColl.get(j)).set("r_mat", (Object)matMaster);
                    }
                    if (StringUtils.isEmpty((String)(settleOrgStr = ExpenseBillHelper.getBillFieldByMap(srcEntity, "settleorg", expsCtx.getBizBillFldMap())))) continue;
                    DynamicObject bizSettleOrg = bizEntryObj.getDynamicObject(settleOrgStr);
                    DynamicObject expsSettleOrg = ((DynamicObject)rowExpsEtryColl.get(j)).getDynamicObject("r_settleorg");
                    if (bizSettleOrg != null && expsSettleOrg != null && bizSettleOrg.getLong("id") == expsSettleOrg.getLong("id") || bizSettleOrg == null && expsSettleOrg == null) continue;
                    DynamicObject expsItem = ((DynamicObject)rowExpsEtryColl.get(j)).getDynamicObject("r_expsitm");
                    if (expsItem == null && bizSettleOrg != null) {
                        ((DynamicObject)rowExpsEtryColl.get(j)).set("r_settleorg", (Object)bizSettleOrg);
                    }
                    if (expsItem != null && bizSettleOrg == null) {
                        ((DynamicObject)rowExpsEtryColl.get(j)).set("r_settleorg", null);
                        ((DynamicObject)rowExpsEtryColl.get(j)).set("r_expsitm", null);
                    }
                    if (expsItem == null || bizSettleOrg == null) continue;
                    QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)bizSettleOrg.getLong("id"));
                    QFilter isLeafFilter = new QFilter("isleaf", "=", (Object)"1");
                    QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                    QFilter expsItemFilter = new QFilter("id", "=", (Object)expsItem.getLong("id"));
                    boolean isExist = QueryServiceHelper.exists((String)"er_expenseitemedit", (QFilter[])new QFilter[]{baseDataFilter.and(isLeafFilter).and(enableFilter).and(expsItemFilter)});
                    if (!isExist) {
                        ((DynamicObject)rowExpsEtryColl.get(j)).set("r_expsitm", null);
                    }
                    ((DynamicObject)rowExpsEtryColl.get(j)).set("r_settleorg", (Object)bizSettleOrg);
                }
                long beginsumtobilltime = System.currentTimeMillis();
                DynamicObjectCollection billExpEntrys = expenseBillColl.get(i).getDynamicObjectCollection("billexpenseentry");
                if (billExpEntrys != null) {
                    EntryType billExpEtryType = (EntryType)billExpEntrys.getDynamicObjectType();
                    Map<String, Map<String, Object>> rowExpMap = ExpenseBillHelper.rowExpsSumByAll(rowExpsEtryColl);
                    ExpenseBillHelper.rowExpsToBillEntry(billExpEntrys, billExpEtryType, rowExpsEtryColl, rowExpMap);
                }
                long endsumtobilltime = System.currentTimeMillis();
                Map<String, Object> srvExpsMap = expsCtx.getExpenseResult().get((Long)objId);
                if (CommonUtils.isNull(srvExpsMap)) {
                    srvExpsMap = new HashMap<String, Object>(8);
                    srvExpsMap.put("success", Boolean.TRUE);
                    srvExpsMap.put("message", "");
                    srvExpsMap.put("expensebillid", expenseBillColl.get(i).get("id"));
                    srvExpsMap.put("bizbillno", expenseBillColl.get(i).get("bizbillno"));
                } else if (((Boolean)srvExpsMap.get("success")).booleanValue()) {
                    srvExpsMap.put("expensebillid", expenseBillColl.get(i).get("id"));
                    srvExpsMap.put("bizbillno", expenseBillColl.get(i).get("bizbillno"));
                }
                expsCtx.getExpenseResult().put((Long)objId, srvExpsMap);
            }
        }
    }

    private static boolean isExistFieldMap(ExpenseCtx expsCtx, String modelFldProp, String billFldProp, DynamicObject expenseBill, String billEntity) {
        if (StringUtils.isEmpty((String)billFldProp)) {
            String billEntityName = ExpenseBillHelper.getEntityAlias(billEntity);
            String billEntityStr = billEntity;
            if (!StringUtils.isEmpty((String)billEntityName)) {
                billEntityStr = billEntityName;
            }
            String modelFldPropName = ExpenseBillHelper.getPropertyAlias(modelFldProp);
            String modelFldPropStr = modelFldProp;
            if (!StringUtils.isEmpty((String)modelFldPropName)) {
                modelFldPropStr = modelFldPropName;
            }
            String msg = ResManager.loadKDString((String)"\u201c\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u6765\u6e90\u5355\u636e\u201c%1$s\u201d\u548c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u201c\u4ef7\u683c\u6a21\u578b\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u672a\u6620\u5c04\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ExpenseService_9", (String)"mpscmm-msbd-expense", (Object[])new Object[]{billEntityStr, modelFldPropStr});
            Map<String, Object> srvExpsMap = expsCtx.getExpenseResult().get(expenseBill.get("bizbillid"));
            if (CommonUtils.isNull(srvExpsMap)) {
                srvExpsMap = new HashMap<String, Object>(8);
                srvExpsMap.put("success", Boolean.FALSE);
                srvExpsMap.put("message", msg);
                srvExpsMap.put("billentity", billEntity);
                srvExpsMap.put("expensebillid", expenseBill.get("id"));
                srvExpsMap.put("bizbillno", expenseBill.get("bizbillno"));
            } else {
                srvExpsMap.put("success", Boolean.FALSE);
                if (srvExpsMap.get("message") != null) {
                    srvExpsMap.put("message", srvExpsMap.get("message") + msg);
                } else {
                    srvExpsMap.put("message", msg);
                }
                srvExpsMap.put("billentity", billEntity);
                srvExpsMap.put("expensebillid", expenseBill.get("id"));
                srvExpsMap.put("bizbillno", expenseBill.get("bizbillno"));
            }
            expsCtx.getExpenseResult().put((Long)expenseBill.get("bizbillid"), srvExpsMap);
            return false;
        }
        return true;
    }

    private static Set<Long> getIdSet(Set<Long> srcSet, Set<Long> rsltSet) {
        for (Long src : srcSet) {
            rsltSet.add(src);
        }
        return rsltSet;
    }
}

