/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.expense.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.utils.CommonUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.expense.business.helper.ExpenseBillHelper;
import kd.mpscmm.msbd.pricemodel.common.enums.PriceCategoryEnum;

public class ExpenseBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private final Log log = LogFactory.getLog(ExpenseBillPlugin.class);
    private static final String CACHE_PRICETYPEID = "cache_pricetype_id";
    private static final String CACHE_CURRENCYID = "cache_currency_id";
    private static final String CACHE_PRICETYPEID_ROW = "cache_pricetype_id_row";
    private static final String CACHE_CURRENCYID_ROW = "cache_currency_id_row";
    private static final String CACHE_BIZBILLENTRYID_ROW = "cache_bizbillentry_id_row";
    private Map<String, String> entryEnableDel = new HashMap<String, String>(2);
    private Map<String, Map<String, Object>> rowExpsSumMap = new HashMap<String, Map<String, Object>>(2);
    private static final String CACHE_BILLNAME = "cache_billname";

    public void registerListener(EventObject e) {
        BasedataEdit taxrate_r;
        BasedataEdit taxrate;
        BasedataEdit supplier_r;
        BasedataEdit supplier;
        BasedataEdit priceType_r;
        BasedataEdit priceType;
        BasedataEdit expsitm;
        TextEdit material;
        Toolbar advcontoolbarap2;
        super.registerListener(e);
        this.addClickListeners(new String[]{"loadjson"});
        Toolbar advcontoolbarap1 = (Toolbar)this.getView().getControl("advcontoolbarap1");
        if (advcontoolbarap1 != null) {
            advcontoolbarap1.addItemClickListener((ItemClickListener)this);
        }
        if (advcontoolbarap1 != null) {
            advcontoolbarap1.addClickListener((ClickListener)this);
        }
        if ((advcontoolbarap2 = (Toolbar)this.getView().getControl("advcontoolbarap2")) != null) {
            advcontoolbarap2.addItemClickListener((ItemClickListener)this);
        }
        if ((material = (TextEdit)this.getControl("r_matnum")) != null) {
            material.addClickListener((ClickListener)this);
        }
        if ((expsitm = (BasedataEdit)this.getControl("r_expsitm")) != null) {
            expsitm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((priceType = (BasedataEdit)this.getControl("pricetype")) != null) {
            priceType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((priceType_r = (BasedataEdit)this.getControl("r_pricetype")) != null) {
            priceType_r.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getControl("expssup")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier_r = (BasedataEdit)this.getControl("r_expssup")) != null) {
            supplier_r.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((taxrate = (BasedataEdit)this.getControl("taxrate")) != null) {
            taxrate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((taxrate_r = (BasedataEdit)this.getControl("r_taxrate")) != null) {
            taxrate_r.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterLoadData(EventObject e) {
        this.expandRowExpenseEntrys();
        DynamicObject bizBill = this.getBizBillObj();
        if (bizBill == null) {
            return;
        }
        String bizBillEntity = bizBill.getDataEntityType().getName();
        this.getPageCache().put(CACHE_BILLNAME, ExpenseBillHelper.getEntityAlias(bizBillEntity));
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
        this.getModel().setDataChanged(false);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject bizBill = this.getBizBillObj();
        if (bizBill == null) {
            return;
        }
        String bizBillEntity = bizBill.getDataEntityType().getName();
        this.getPageCache().put(CACHE_BILLNAME, ExpenseBillHelper.getEntityAlias(bizBillEntity));
        this.getModel().setValue("bizbillid", (Object)bizBill.getLong("id"));
        this.getModel().setValue("bizbillentity", (Object)bizBillEntity);
        String bizBillNoStr = ExpenseBillHelper.getBillFieldByMap(bizBillEntity, "bizbillno", null);
        if (StringUtils.isEmpty((String)bizBillNoStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u6765\u6e90\u5355\u636e\u201c%1$s\u201d\u548c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u201c\u4ef7\u683c\u6a21\u578b\u201d\u7684\u5b57\u6bb5\u201c\u5355\u636e\u7f16\u53f7\u201d\u672a\u6620\u5c04\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ExpenseBillPlugin_0", (String)"mpscmm-msbd-expense", (Object[])new Object[]{this.getPageCache().get(CACHE_BILLNAME)}));
            return;
        }
        String bizbillno = bizBill.getString(bizBillNoStr);
        this.getModel().setValue("bizbillno", (Object)bizbillno);
        String orgStr = ExpenseBillHelper.getBillFieldByMap(bizBillEntity, "bizorg", null);
        this.getModel().setValue("org", (Object)bizBill.getDynamicObject(orgStr));
        DynamicObject supplier = null;
        String expsSupOrigFld = ExpenseBillHelper.getOriginalBillField(bizBillEntity, "expensesupplier");
        if (!StringUtils.isEmpty((String)expsSupOrigFld) && !expsSupOrigFld.contains(".")) {
            supplier = bizBill.getDynamicObject(expsSupOrigFld);
        }
        DynamicObject currency = null;
        String currencyStr = ExpenseBillHelper.getBillFieldByMap(bizBillEntity, "currency", null);
        if (StringUtils.isEmpty((String)currencyStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u6765\u6e90\u5355\u636e\u201c%1$s\u201d\u548c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u201c\u4ef7\u683c\u6a21\u578b\u201d\u7684\u5b57\u6bb5\u201c\u5e01\u79cd\u201d\u672a\u6620\u5c04\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ExpenseBillPlugin_1", (String)"mpscmm-msbd-expense", (Object[])new Object[]{this.getPageCache().get(CACHE_BILLNAME)}));
            return;
        }
        currency = bizBill.getDynamicObject(currencyStr);
        int entryRowCount = this.getModel().getEntryRowCount("billexpenseentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getModel().setValue("currency", (Object)currency, i);
            this.getModel().setValue("expssup", (Object)supplier, i);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String bizBillEntity = this.getModel().getValue("bizbillentity").toString();
        int row = e.getRow();
        IDataModel model = this.getModel();
        DynamicObject bizBill = this.getBizBillObj();
        if (bizBill == null) {
            return;
        }
        Date bizTime = (Date)model.getValue("biztime");
        switch (fieldKey) {
            case "pricetype": 
            case "r_pricetype": {
                QFilter fltr1 = new QFilter("pricecategory", "=", (Object)PriceCategoryEnum.EXPENSE.getValue());
                showParameter.getListFilterParameter().getQFilters().add(fltr1);
                break;
            }
            case "r_expsitm": {
                DynamicObject settleOrg = (DynamicObject)model.getValue("r_settleorg", row);
                QFilter qf = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
                if (!kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)settleOrg) && !kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)settleOrg.getPkValue())) {
                    qf.and(BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)settleOrg.getLong("id")));
                }
                showParameter.getListFilterParameter().getQFilters().add(qf);
                break;
            }
            case "taxrate": {
                QFilter activeQfilter = new QFilter("activedate", "<=", (Object)bizTime);
                QFilter expQfilter = new QFilter("expdate", ">", (Object)bizTime);
                expQfilter = QFilter.isNull((String)"expdate").or(expQfilter);
                QFilter qFilter = expQfilter.and(activeQfilter);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "r_taxrate": {
                QFilter r_activeQfilter = new QFilter("activedate", "<=", (Object)bizTime);
                QFilter r_expQfilter = new QFilter("expdate", ">", (Object)bizTime);
                r_expQfilter = QFilter.isNull((String)"expdate").or(r_expQfilter);
                QFilter r_qFilter = r_expQfilter.and(r_activeQfilter);
                showParameter.getListFilterParameter().getQFilters().add(r_qFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        block28: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            DynamicObject oldValueDO = null;
            if (oldValue instanceof DynamicObject) {
                oldValueDO = (DynamicObject)oldValue;
            }
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            DynamicObject priceType = (DynamicObject)this.getModel().getValue("r_pricetype", rowIndex);
            DynamicObject currency = (DynamicObject)this.getModel().getValue("r_currency", rowIndex);
            switch (fieldKey) {
                case "pricetype": {
                    if (oldValueDO == null) {
                        this.getPageCache().put(CACHE_PRICETYPEID, String.valueOf(0L));
                    } else {
                        this.getPageCache().put(CACHE_PRICETYPEID, String.valueOf(oldValueDO.getPkValue()));
                    }
                    this.changePriceType(newValue, oldValue, rowIndex);
                    continue block28;
                }
                case "currency": {
                    if (oldValueDO == null) {
                        this.getPageCache().put(CACHE_CURRENCYID, String.valueOf(0L));
                    } else {
                        this.getPageCache().put(CACHE_CURRENCYID, String.valueOf(oldValueDO.getPkValue()));
                    }
                    this.changeCurrency(fieldKey, newValue, oldValue, rowIndex);
                    continue block28;
                }
                case "priceval": {
                    if (oldValue == null) {
                        this.getPageCache().put(String.valueOf(rowIndex), BigDecimal.ZERO.toString());
                    } else {
                        this.getPageCache().put(String.valueOf(rowIndex), oldValue.toString());
                    }
                    this.changePriceValue(newValue, oldValue, rowIndex);
                    continue block28;
                }
                case "expssup": {
                    this.billExpsShare("expssup", oldValue, newValue, rowIndex);
                    this.getView().updateView("rowexpenseentry");
                    this.getView().updateView("billexpenseentry");
                    continue block28;
                }
                case "isadvanced": {
                    this.billExpsShare("isadvanced", oldValue, newValue, rowIndex);
                    this.getView().updateView("rowexpenseentry");
                    continue block28;
                }
                case "taxrate": {
                    this.billExpsShare("taxrate", oldValue, newValue, rowIndex);
                    this.getView().updateView("rowexpenseentry");
                    continue block28;
                }
                case "r_pricetype": {
                    if (oldValueDO == null) {
                        this.getPageCache().put(CACHE_PRICETYPEID_ROW, String.valueOf(0L));
                    } else {
                        this.getPageCache().put(CACHE_PRICETYPEID_ROW, String.valueOf(oldValueDO.getPkValue()));
                    }
                    this.changePriceTypeRow(newValue, rowIndex);
                    continue block28;
                }
                case "r_currency": {
                    if (oldValueDO == null) {
                        this.getPageCache().put(CACHE_CURRENCYID_ROW, String.valueOf(0L));
                    } else {
                        this.getPageCache().put(CACHE_CURRENCYID_ROW, String.valueOf(oldValueDO.getPkValue()));
                    }
                    this.changeCurrencyRow(newValue, rowIndex);
                    continue block28;
                }
                case "r_priceval": {
                    this.changePriceValueRow(newValue, rowIndex);
                    continue block28;
                }
                case "r_settleorg": {
                    DynamicObject expsItemObj = this.initExpsItem(priceType, newValue);
                    this.getModel().setValue("r_expsitm", (Object)expsItemObj, rowIndex);
                    continue block28;
                }
                case "r_matnum": {
                    if (!StringUtils.isEmpty((String)((String)newValue))) continue block28;
                    this.getPageCache().put("stopChange", "true");
                    this.getModel().setValue("r_matnum", oldValue, rowIndex);
                    this.getPageCache().put("stopChange", "false");
                    continue block28;
                }
                case "r_bizentryid": {
                    if (newValue == null || newValue.equals(0L)) {
                        this.getPageCache().put("stopChange", "true");
                        this.getModel().setValue("r_bizentryid", oldValue, rowIndex);
                        this.getPageCache().put("stopChange", "false");
                        continue block28;
                    }
                    if (oldValue == null) {
                        this.getPageCache().put(CACHE_BIZBILLENTRYID_ROW, String.valueOf(0L));
                    } else {
                        this.getPageCache().put(CACHE_BIZBILLENTRYID_ROW, String.valueOf(oldValue));
                    }
                    this.changeBizBillEntryId(newValue, rowIndex);
                    continue block28;
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control button = (Control)evt.getSource();
        switch (button.getKey()) {
            case "r_matnum": {
                this.materialF7();
                break;
            }
        }
    }

    public void beforeAddRow(BeforeAddRowEventArgs e) {
        String bizBillEntity = this.getModel().getValue("bizbillentity").toString();
        HashSet<String> needChkFlds = new HashSet<String>(8);
        needChkFlds.add("currency");
        String checkMsg = ExpenseBillHelper.checkExist(bizBillEntity, needChkFlds, null);
        if (!kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)checkMsg)) {
            this.getView().showTipNotification(checkMsg);
            return;
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if (rowDataEntities == null || rowDataEntities.length < 1) {
            return;
        }
        String entryName = e.getEntryProp().getName();
        this.initExpsRow(entryName, rowDataEntities);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        if ("r_matnum".equals(e.getActionId()) && !kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)(returnData = e.getReturnData()))) {
            IDataModel model = this.getModel();
            int currentRowIndex = model.getEntryCurrentRowIndex("rowexpenseentry");
            String bizBillEntity = this.getModel().getValue("bizbillentity").toString();
            ListSelectedRowCollection coreBillCollection = (ListSelectedRowCollection)returnData;
            ArrayList<Long> bizEntryIds = new ArrayList<Long>(8);
            for (int j = 0; j < coreBillCollection.size(); ++j) {
                ListSelectedRow listSelectedRow = coreBillCollection.get(j);
                if (listSelectedRow != null && listSelectedRow.getEntryPrimaryKeyValue() != null) {
                    bizEntryIds.add((Long)listSelectedRow.getEntryPrimaryKeyValue());
                    continue;
                }
                if (listSelectedRow == null || !listSelectedRow.isPkLongType()) continue;
                DynamicObject bizBill = this.getBizBillObj();
                if (bizBill == null) {
                    return;
                }
                String bizEntryNameStr = "";
                Map<String, String> billentryExist = ExpenseBillHelper.checkExistByFld(bizBillEntity, "billentry");
                if (billentryExist != null && !StringUtils.isEmpty((String)billentryExist.get("msg"))) {
                    this.getView().showTipNotification(billentryExist.get("msg"));
                    return;
                }
                if (billentryExist != null && !StringUtils.isEmpty((String)billentryExist.get("bizfield"))) {
                    bizEntryNameStr = billentryExist.get("bizfield");
                }
                DynamicObjectCollection bizBillEntrys = bizBill.getDynamicObjectCollection(bizEntryNameStr);
                for (DynamicObject bizEntry : bizBillEntrys) {
                    bizEntryIds.add(bizEntry.getLong("id"));
                }
            }
            if (bizEntryIds.size() > 1) {
                EntryGrid rowEntryGrid = (EntryGrid)this.getView().getControl("rowexpenseentry");
                rowEntryGrid.getModel().batchCreateNewEntryRow("rowexpenseentry", bizEntryIds.size() - 1);
            }
            for (int k = 0; k < bizEntryIds.size(); ++k) {
                model.setValue("r_bizentryid", bizEntryIds.get(k), currentRowIndex + k);
            }
            DynamicObject data = model.getDataEntity(true);
            DynamicObjectCollection billExpEntrys = data.getDynamicObjectCollection("billexpenseentry");
            DynamicObjectCollection rowExpEntrys = data.getDynamicObjectCollection("rowexpenseentry");
            EntryType billExpEtryType = (EntryType)billExpEntrys.getDynamicObjectType();
            Map<String, Map<String, Object>> rowExpMap = ExpenseBillHelper.rowExpsSumByAll(rowExpEntrys);
            ExpenseBillHelper.rowExpsToBillEntry(billExpEntrys, billExpEtryType, rowExpEntrys, rowExpMap);
            this.getView().updateView("rowexpenseentry");
            this.getView().updateView("billexpenseentry");
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] billExpsSelected = e.getRowIndexs();
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection billExpEntrys = data.getDynamicObjectCollection("billexpenseentry");
        DynamicObjectCollection rowExpEntrys = data.getDynamicObjectCollection("rowexpenseentry");
        if ("rowexpenseentry".equals(e.getEntryProp().getName())) {
            int[] delIndexs = e.getRowIndexs();
            ArrayList<Integer> rowIndexs = new ArrayList<Integer>(8);
            for (int del : delIndexs) {
                rowIndexs.add(del);
            }
            Map<String, Map<String, Object>> rowExpMap = ExpenseBillHelper.rowExpsSumExcludeDelRows(rowExpEntrys, rowIndexs);
            this.rowExpsSumMap.clear();
            this.rowExpsSumMap = rowExpMap;
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if ("rowexpenseentry".equals(e.getEntryProp().getName()) && !"true".equals(this.entryEnableDel.get("rowexpenseentry"))) {
            DynamicObject data = this.getModel().getDataEntity(true);
            DynamicObjectCollection billExpEntrys = data.getDynamicObjectCollection("billexpenseentry");
            DynamicObjectCollection rowExpEntrys = data.getDynamicObjectCollection("rowexpenseentry");
            EntryType billExpEtryType = (EntryType)billExpEntrys.getDynamicObjectType();
            ExpenseBillHelper.rowExpsToBillEntry(billExpEntrys, billExpEtryType, rowExpEntrys, this.rowExpsSumMap);
            this.getView().updateView("billexpenseentry");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        EntryGrid entryEntity = (EntryGrid)this.getView().getControl("billexpenseentry");
        int[] billExpsSelected = entryEntity.getSelectRows();
        String customVaule = evt.getCustomVaule();
        switch (key) {
            case "billexpsdelelte": {
                if (!"Yes".equals(evt.getResultValue())) break;
                this.delRowExpsEntry(billExpsSelected, 0L, true);
                this.getView().updateView("rowexpenseentry");
                this.entryEnableDel.put("billexpenseentry", "true");
                this.getModel().deleteEntryRows("billexpenseentry", billExpsSelected);
                this.entryEnableDel.put("billexpenseentry", "false");
                break;
            }
            case "pricetypechange": {
                if (StringUtils.isEmpty((String)customVaule)) {
                    return;
                }
                int rowIndex = Integer.parseInt(customVaule);
                Long priceTypeId = Long.valueOf(this.getPageCache().get(CACHE_PRICETYPEID));
                if ("No".equals(evt.getResultValue())) {
                    this.getPageCache().put("stopChange", "true");
                    if (priceTypeId.equals(0L)) {
                        this.getModel().setValue("pricetype", null, rowIndex);
                    } else {
                        this.getModel().setValue("pricetype", (Object)priceTypeId, rowIndex);
                    }
                    this.getPageCache().put("stopChange", "false");
                    break;
                }
                int[] delIndex = new int[]{rowIndex};
                this.delRowExpsEntry(delIndex, priceTypeId, false);
                this.priceTypeConfirm(rowIndex);
                break;
            }
            case "pricevaluechange": {
                if (StringUtils.isEmpty((String)customVaule)) {
                    return;
                }
                Map dataInfo = (Map)SerializationUtils.fromJsonString((String)customVaule, Map.class);
                int rowIndex1 = Integer.parseInt(dataInfo.get("rowindex").toString());
                if ("No".equals(evt.getResultValue())) {
                    BigDecimal priceValue = new BigDecimal(this.getPageCache().get(String.valueOf(rowIndex1)));
                    this.getPageCache().put("stopChange", "true");
                    this.getModel().setValue("priceval", (Object)priceValue, rowIndex1);
                    this.getPageCache().put("stopChange", "false");
                    this.getPageCache().remove(String.valueOf(rowIndex1));
                    break;
                }
                BigDecimal priceValue = (BigDecimal)dataInfo.get("newvalue");
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", rowIndex1);
                IDataModel model = this.getModel();
                this.billExpsShare("priceval", null, priceValue, rowIndex1);
                this.getView().updateView("rowexpenseentry");
                this.getView().updateView("priceval", rowIndex1);
                this.getView().updateView("caltypeval", rowIndex1);
                this.getView().updateView("amount", rowIndex1);
                break;
            }
        }
    }

    private void priceTypeConfirm(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject priceType = (DynamicObject)this.getModel().getValue("pricetype", rowIndex);
        if (priceType == null) {
            model.setValue("priceval", null, rowIndex);
            model.setValue("caltype", null, rowIndex);
            model.setValue("caltypeval", null, rowIndex);
            model.setValue("amount", null, rowIndex);
            model.setValue("istax", null, rowIndex);
            model.setValue("taxrate", null, rowIndex);
        } else if (priceType instanceof DynamicObject) {
            this.getPageCache().put("stopChange", "true");
            model.setValue("priceval", null, rowIndex);
            model.setValue("caltypeval", null, rowIndex);
            model.setValue("amount", null, rowIndex);
            this.getPageCache().put("stopChange", "false");
            DynamicObject calType = priceType.getDynamicObject("calctype");
            model.setValue("caltype", (Object)calType, rowIndex);
            Boolean isTax = priceType.getBoolean("istax");
            model.setValue("istax", (Object)isTax, rowIndex);
            DynamicObject taxRate = priceType.getDynamicObject("taxrate");
            model.setValue("taxrate", (Object)taxRate, rowIndex);
        }
    }

    private void delRowExpsEntry(int[] billExpsSelected, Long priceTypeId, boolean billExpsDel) {
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection billExpEntrys = data.getDynamicObjectCollection("billexpenseentry");
        DynamicObjectCollection rowExpEntrys = data.getDynamicObjectCollection("rowexpenseentry");
        ArrayList<Integer> rowExpsIndex = new ArrayList<Integer>(8);
        for (int i = 0; i < billExpsSelected.length; ++i) {
            DynamicObject currency;
            Long currencyId;
            List<Integer> shareRow;
            DynamicObject priceType = ((DynamicObject)billExpEntrys.get(billExpsSelected[i])).getDynamicObject("pricetype");
            if (billExpsDel) {
                priceTypeId = priceType == null ? 0L : priceType.getLong("id");
            }
            if ((shareRow = this.existShared(priceTypeId, currencyId = Long.valueOf((currency = ((DynamicObject)billExpEntrys.get(billExpsSelected[i])).getDynamicObject("currency")) == null ? 0L : currency.getLong("id")), rowExpEntrys)).size() <= 0) continue;
            rowExpsIndex.addAll(shareRow);
        }
        if (rowExpsIndex.size() > 0) {
            int[] rowExps = new int[rowExpsIndex.size()];
            for (int j = 0; j < rowExpsIndex.size(); ++j) {
                rowExps[j] = (Integer)rowExpsIndex.get(j);
            }
            this.entryEnableDel.put("rowexpenseentry", "true");
            this.getModel().deleteEntryRows("rowexpenseentry", rowExps);
            this.entryEnableDel.put("rowexpenseentry", "false");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("deleteentry".equals(key)) {
            DynamicObject data = this.getModel().getDataEntity(true);
            DynamicObjectCollection billExpEntrys = data.getDynamicObjectCollection("billexpenseentry");
            DynamicObjectCollection rowExpEntrys = data.getDynamicObjectCollection("rowexpenseentry");
            EntryGrid entry = (EntryGrid)this.getControl("billexpenseentry");
            int[] billExpsSelected = entry.getSelectRows();
            if (!"true".equals(this.entryEnableDel.get("billexpenseentry")) && rowExpEntrys.size() > 0) {
                HashSet<Integer> sharedBillExpsIndex = new HashSet<Integer>(8);
                for (int i = 0; i < billExpsSelected.length; ++i) {
                    Long currencyId;
                    DynamicObject priceType = ((DynamicObject)billExpEntrys.get(billExpsSelected[i])).getDynamicObject("pricetype");
                    DynamicObject currency = ((DynamicObject)billExpEntrys.get(billExpsSelected[i])).getDynamicObject("currency");
                    Long priceTypeId = priceType == null ? 0L : priceType.getLong("id");
                    List<Integer> shareRow = this.existShared(priceTypeId, currencyId = Long.valueOf(currency == null ? 0L : currency.getLong("id")), rowExpEntrys);
                    if (shareRow.size() <= 0) continue;
                    sharedBillExpsIndex.add(billExpsSelected[i] + 1);
                }
                if (sharedBillExpsIndex.size() > 0) {
                    e.setCancel(true);
                    ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("billexpsdelelte", (IFormPlugin)this);
                    String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u5220\u9664\u65f6\u4f1a\u8054\u52a8\u5220\u9664\u5bf9\u5e94\u7684\u884c\u8d39\u7528\uff0c\u786e\u8ba4\u8981\u7ee7\u7eed\u5417\uff1f", (String)"ExpenseBillPlugin_3", (String)"mpscmm-msbd-expense", (Object[])new Object[0]), sharedBillExpsIndex);
                    this.getView().showConfirm(msg, MessageBoxOptions.YesNo, confirmCallBack);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        DynamicObject expsBill = this.getView().getModel().getDataEntity();
        DynamicObjectCollection billExpsEntryColl = expsBill.getDynamicObjectCollection("billexpenseentry");
        DynamicObjectCollection rowExpsEntryColl = expsBill.getDynamicObjectCollection("rowexpenseentry");
        if (e.getOperateKey().equals("save")) {
            for (DynamicObject rowEntry : rowExpsEntryColl) {
                rowEntry.getDataEntityState().setDirty(true);
            }
        }
    }

    private void initExpsRow(String entryName, RowDataEntity[] rowDataEntities) {
        String entrySupplierProp = "";
        String entryCurrencyProp = "";
        if ("billexpenseentry".equals(entryName)) {
            entrySupplierProp = "expssup";
            entryCurrencyProp = "currency";
        }
        if ("rowexpenseentry".equals(entryName)) {
            entrySupplierProp = "r_expssup";
            entryCurrencyProp = "r_currency";
        }
        String bizBillEntity = this.getModel().getValue("bizbillentity").toString();
        DynamicObject bizBill = this.getBizBillObj();
        if (bizBill == null) {
            return;
        }
        DynamicObject supplier = null;
        String expsSupOrigFld = ExpenseBillHelper.getOriginalBillField(bizBillEntity, "expensesupplier");
        if (!StringUtils.isEmpty((String)expsSupOrigFld) && !expsSupOrigFld.contains(".")) {
            supplier = bizBill.getDynamicObject(expsSupOrigFld);
        }
        DynamicObject currency = null;
        Map<String, String> currencyExist = ExpenseBillHelper.checkExistByFld(bizBillEntity, "currency");
        if (currencyExist != null && !StringUtils.isEmpty((String)currencyExist.get("msg"))) {
            this.getView().showTipNotification(currencyExist.get("msg"));
            return;
        }
        if (currencyExist != null && !StringUtils.isEmpty((String)currencyExist.get("bizfield"))) {
            String currencyStr = currencyExist.get("bizfield");
            currency = bizBill.getDynamicObject(currencyStr);
        }
        for (RowDataEntity rowDataEntity : rowDataEntities) {
            int rowIndex = rowDataEntity.getRowIndex();
            this.getModel().setValue(entrySupplierProp, (Object)supplier, rowIndex);
            this.getModel().setValue(entryCurrencyProp, (Object)currency, rowIndex);
        }
    }

    private void changePriceType(Object newValue, Object oldValue, int rowIndex) {
        IDataModel model = this.getModel();
        Map<String, String> existRslt = this.isExistInBillEntry("pricetype", newValue, rowIndex);
        if (existRslt.get("isexist").equals("true")) {
            this.getView().showTipNotification(existRslt.get("msg"));
        }
        if (existRslt.get("isexist").equals("true") || newValue == null) {
            String priceTypeId = this.getPageCache().get(CACHE_PRICETYPEID);
            this.getPageCache().put("stopChange", "true");
            if ("0".equals(priceTypeId)) {
                this.getModel().setValue("pricetype", null, rowIndex);
            } else {
                this.getModel().setValue("pricetype", (Object)Long.parseLong(priceTypeId), rowIndex);
            }
            this.getPageCache().put("stopChange", "false");
            return;
        }
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection rowExpEntrys = data.getDynamicObjectCollection("rowexpenseentry");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", rowIndex);
        Long currencyId = currency == null ? 0L : currency.getLong("id");
        Long oldPriceTypeId = 0L;
        if (oldValue instanceof DynamicObject) {
            oldPriceTypeId = Long.valueOf(((DynamicObject)oldValue).getPkValue().toString());
        }
        if (rowExpEntrys != null && rowExpEntrys.size() > 0 && oldPriceTypeId.compareTo(0L) != 0) {
            List<Integer> shareRow = this.existShared(oldPriceTypeId, currencyId, rowExpEntrys);
            if (shareRow != null && shareRow.size() > 0) {
                ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("pricetypechange", (IFormPlugin)this);
                String msg = String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u7c7b\u578b\u5207\u6362\u540e\uff0c\u5c06\u5220\u9664\u5bf9\u5e94\u7684\u884c\u8d39\u7528\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ExpenseBillPlugin_4", (String)"mpscmm-msbd-expense", (Object[])new Object[0]), new Object[0]);
                this.getView().showConfirm(msg, "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBack, null, String.valueOf(rowIndex));
            } else {
                this.priceTypeConfirm(rowIndex);
                this.billExpsShare("pricetype", oldValue, newValue, rowIndex);
            }
        } else {
            this.priceTypeConfirm(rowIndex);
            this.billExpsShare("pricetype", oldValue, newValue, rowIndex);
        }
        this.getView().updateView("rowexpenseentry");
        this.getView().updateView("billexpenseentry");
    }

    private void changeCurrency(String fieldKey, Object newValue, Object oldValue, int rowIndex) {
        Map<String, String> existRslt = this.isExistInBillEntry("currency", newValue, rowIndex);
        if (existRslt.get("isexist").equals("true")) {
            this.getView().showTipNotification(existRslt.get("msg"));
        }
        if (existRslt.get("isexist").equals("true") || newValue == null) {
            String currencyId = this.getPageCache().get(CACHE_CURRENCYID);
            this.getPageCache().put("stopChange", "true");
            if ("0".equals(currencyId)) {
                this.getModel().setValue("currency", null, rowIndex);
            } else {
                this.getModel().setValue("currency", (Object)Long.parseLong(currencyId), rowIndex);
            }
            this.getPageCache().put("stopChange", "false");
            return;
        }
        this.billExpsShare(fieldKey, oldValue, newValue, rowIndex);
        this.getView().updateView("rowexpenseentry");
        this.getView().updateView("billexpenseentry");
    }

    private void changePriceValue(Object newValue, Object oldValue, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject priceType = (DynamicObject)model.getValue("pricetype", rowIndex);
        DynamicObject currency = (DynamicObject)model.getValue("currency", rowIndex);
        if (priceType == null) {
            return;
        }
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection rowExpEntrys = data.getDynamicObjectCollection("rowexpenseentry");
        if (rowExpEntrys != null && rowExpEntrys.size() > 0) {
            Long currencyId;
            Long priceTypeId = Long.valueOf(priceType.getPkValue().toString());
            List<Integer> shareRow = this.existShared(priceTypeId, currencyId = Long.valueOf(currency == null ? 0L : currency.getLong("id")), rowExpEntrys);
            if (shareRow != null && shareRow.size() > 0) {
                ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("pricevaluechange", (IFormPlugin)this);
                String msg = String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u503c\u4fee\u6539\u540e\uff0c\u5c06\u6279\u91cf\u4fee\u6539\u884c\u8d39\u7528\u7684\u4ef7\u683c\u503c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ExpenseBillPlugin_5", (String)"mpscmm-msbd-expense", (Object[])new Object[0]), new Object[0]);
                HashMap<String, Number> dataInfo = new HashMap<String, Number>(2);
                dataInfo.put("rowindex", rowIndex);
                dataInfo.put("newvalue", (BigDecimal)newValue);
                this.getView().showConfirm(msg, "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBack, null, SerializationUtils.toJsonString(dataInfo));
            } else {
                this.billExpsShare("priceval", oldValue, newValue, rowIndex);
            }
        } else {
            this.billExpsShare("priceval", oldValue, newValue, rowIndex);
        }
        this.getView().updateView("rowexpenseentry");
        this.getView().updateView("priceval", rowIndex);
        this.getView().updateView("caltypeval", rowIndex);
        this.getView().updateView("amount", rowIndex);
    }

    private void changePriceTypeRow(Object newValue, int rowIndex) {
        Object priceType;
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity(true);
        DynamicObjectCollection billExpEntrys = data.getDynamicObjectCollection("billexpenseentry");
        DynamicObjectCollection rowExpEntrys = data.getDynamicObjectCollection("rowexpenseentry");
        String priceTypeId = this.getPageCache().get(CACHE_PRICETYPEID_ROW);
        if (newValue == null) {
            this.getPageCache().put("stopChange", "true");
            if ("0".equals(priceTypeId)) {
                this.getModel().setValue("r_pricetype", null, rowIndex);
            } else {
                this.getModel().setValue("r_pricetype", (Object)Long.parseLong(priceTypeId), rowIndex);
            }
            this.getPageCache().put("stopChange", "false");
            return;
        }
        if (newValue instanceof DynamicObject) {
            priceType = (DynamicObject)newValue;
            Map<String, String> existRslt = this.isExistInRowEntry("r_pricetype", newValue, rowIndex);
            if (existRslt.get("isexist").equals("true")) {
                this.getView().showTipNotification(existRslt.get("msg"));
                this.getPageCache().put("stopChange", "true");
                if ("0".equals(priceTypeId)) {
                    this.getModel().setValue("r_pricetype", null, rowIndex);
                } else {
                    this.getModel().setValue("r_pricetype", (Object)Long.parseLong(priceTypeId), rowIndex);
                }
                this.getPageCache().put("stopChange", "false");
                return;
            }
            this.getPageCache().put("stopChange", "true");
            model.setValue("r_priceval", null, rowIndex);
            model.setValue("r_caltypeval", null, rowIndex);
            model.setValue("r_unit", null, rowIndex);
            model.setValue("r_amount", null, rowIndex);
            model.setValue("r_istax", null, rowIndex);
            model.setValue("r_taxrate", null, rowIndex);
            model.setValue("r_expsitm", null, rowIndex);
            this.getPageCache().put("stopChange", "false");
            DynamicObject calType = priceType.getDynamicObject("calctype");
            model.setValue("r_caltype", (Object)calType, rowIndex);
            DynamicObject taxRate = priceType.getDynamicObject("taxrate");
            if (!kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)taxRate)) {
                model.setValue("r_taxrate", (Object)taxRate.getLong("id"), rowIndex);
            }
            Boolean isTax = priceType.getBoolean("istax");
            model.setValue("r_istax", (Object)isTax, rowIndex);
            if (calType != null) {
                Long bizEntryId;
                DynamicObject bizBill = this.getBizBillObj();
                if (bizBill == null) {
                    return;
                }
                String bizBillEntity = this.getModel().getValue("bizbillentity").toString();
                String entryProp = ExpenseBillHelper.getBillFieldByMap(bizBillEntity, "billentry", null);
                DynamicObjectCollection bizBillEntrys = bizBill.getDynamicObjectCollection(entryProp);
                if (bizBillEntrys != null && bizBillEntrys.size() > 0 && !(bizEntryId = (Long)model.getValue("r_bizentryid", rowIndex)).equals(0L)) {
                    for (int i = 0; i < bizBillEntrys.size(); ++i) {
                        if (!bizEntryId.equals((Long)((DynamicObject)bizBillEntrys.get(i)).get("id"))) continue;
                        DynamicObject calTypeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_calctype", (QFilter[])new QFilter[]{new QFilter("id", "=", calType.getPkValue())});
                        if (calTypeObj != null) {
                            String calcbase = calTypeObj.getString("calcbase");
                            if (StringUtils.isEmpty((String)calcbase)) {
                                model.setValue("r_unit", null, rowIndex);
                                model.setValue("r_caltypeval", null, rowIndex);
                            } else if ("qty".equals(calcbase)) {
                                String unitStr = ExpenseBillHelper.getBillFieldByMap(bizBillEntity, "unit", null);
                                if (StringUtils.isEmpty((String)unitStr)) {
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u6765\u6e90\u5355\u636e\u201c%1$s\u201d\u548c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u201c\u4ef7\u683c\u6a21\u578b\u201d\u7684\u5b57\u6bb5\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u672a\u6620\u5c04\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ExpenseBillPlugin_6", (String)"mpscmm-msbd-expense", (Object[])new Object[]{this.getPageCache().get(CACHE_BILLNAME)}));
                                    return;
                                }
                                DynamicObject unit = ((DynamicObject)bizBillEntrys.get(i)).getDynamicObject(unitStr);
                                String qtyStr = ExpenseBillHelper.getBillFieldByMap(bizBillEntity, "qty", null);
                                if (StringUtils.isEmpty((String)qtyStr)) {
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u6765\u6e90\u5355\u636e\u201c%1$s\u201d\u548c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u201c\u4ef7\u683c\u6a21\u578b\u201d\u7684\u5b57\u6bb5\u201c\u6570\u91cf\u201d\u672a\u6620\u5c04\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ExpenseBillPlugin_7", (String)"mpscmm-msbd-expense", (Object[])new Object[]{this.getPageCache().get(CACHE_BILLNAME)}));
                                    return;
                                }
                                BigDecimal qty = ((DynamicObject)bizBillEntrys.get(i)).getBigDecimal(qtyStr);
                                model.setValue("r_unit", (Object)unit, rowIndex);
                                model.setValue("r_caltypeval", (Object)qty.abs(), rowIndex);
                            } else if ("amountandtax".equals(calcbase)) {
                                model.setValue("r_unit", null, rowIndex);
                                String amoutandtaxStr = ExpenseBillHelper.getBillFieldByMap(bizBillEntity, "amountandtax", null);
                                if (StringUtils.isEmpty((String)amoutandtaxStr)) {
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u6765\u6e90\u5355\u636e\u201c%1$s\u201d\u548c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u201c\u4ef7\u683c\u6a21\u578b\u201d\u7684\u5b57\u6bb5\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\u672a\u6620\u5c04\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ExpenseBillPlugin_8", (String)"mpscmm-msbd-expense", (Object[])new Object[]{this.getPageCache().get(CACHE_BILLNAME)}));
                                    return;
                                }
                                BigDecimal amountAndTax = ((DynamicObject)bizBillEntrys.get(i)).getBigDecimal(amoutandtaxStr);
                                model.setValue("r_caltypeval", (Object)amountAndTax.abs(), rowIndex);
                            } else {
                                String calcbaseStr = ExpenseBillHelper.getBillFieldByMap(bizBillEntity, calcbase, null);
                                if (StringUtils.isEmpty((String)calcbaseStr)) {
                                    String calcBaseLocal = ExpenseBillHelper.getPropertyAlias(calcbase);
                                    if (StringUtils.isEmpty((String)calcBaseLocal)) {
                                        calcBaseLocal = calcbase;
                                    }
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u6765\u6e90\u5355\u636e\u201c%1$s\u201d\u548c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u201c\u4ef7\u683c\u6a21\u578b\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u672a\u6620\u5c04\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ExpenseBillPlugin_9", (String)"mpscmm-msbd-expense", (Object[])new Object[]{this.getPageCache().get(CACHE_BILLNAME), calcBaseLocal}));
                                    return;
                                }
                                BigDecimal otherbase = ((DynamicObject)bizBillEntrys.get(i)).getBigDecimal(calcbaseStr);
                                model.setValue("r_caltypeval", (Object)otherbase.abs(), rowIndex);
                            }
                            ExpenseBillHelper.expsCalculate((DynamicObject)rowExpEntrys.get(rowIndex));
                        }
                        Object settleOrg_row = model.getValue("r_settleorg", rowIndex);
                        DynamicObject expsItem = null;
                        expsItem = settleOrg_row == null ? this.initExpsItem((DynamicObject)priceType, null) : this.initExpsItem((DynamicObject)priceType, settleOrg_row);
                        model.setValue("r_expsitm", (Object)expsItem, rowIndex);
                    }
                }
            }
        }
        priceType = model.getValue("r_pricetype", rowIndex);
        DynamicObject currency = (DynamicObject)model.getValue("r_currency", rowIndex);
        Long currencyId = 0L;
        if (currency != null) {
            currencyId = Long.valueOf(currency.getPkValue().toString());
        }
        EntryType billExpEtryType = (EntryType)billExpEntrys.getDynamicObjectType();
        Map<String, Map<String, Object>> rowExpMap_old = ExpenseBillHelper.rowExpsSumExcludeCurrent(rowExpEntrys, Long.valueOf(priceTypeId), currencyId, rowIndex);
        ExpenseBillHelper.rowExpsToBillEntry(billExpEntrys, billExpEtryType, rowExpEntrys, rowExpMap_old);
        if (priceType instanceof DynamicObject) {
            Object priceType_new = priceType;
            Long priceTypeId_new = Long.valueOf(priceType_new.getPkValue().toString());
            Map<String, Map<String, Object>> rowExpMap_new = ExpenseBillHelper.rowExpsSumByDimension(rowExpEntrys, priceTypeId_new, currencyId);
            ExpenseBillHelper.rowExpsToBillEntry(billExpEntrys, billExpEtryType, rowExpEntrys, rowExpMap_new);
        }
        this.getView().updateView("billexpenseentry");
    }

    private void changeCurrencyRow(Object newValue, int rowIndex) {
        String currencyId = this.getPageCache().get(CACHE_CURRENCYID_ROW);
        Map<String, String> existRslt = this.isExistInRowEntry("r_currency", newValue, rowIndex);
        if (existRslt.get("isexist").equals("true")) {
            this.getView().showTipNotification(existRslt.get("msg"));
        }
        if (existRslt.get("isexist").equals("true") || newValue == null) {
            this.getPageCache().put("stopChange", "true");
            if ("0".equals(currencyId)) {
                this.getModel().setValue("r_currency", null, rowIndex);
            } else {
                this.getModel().setValue("r_currency", (Object)Long.parseLong(currencyId), rowIndex);
            }
            this.getPageCache().put("stopChange", "false");
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject priceType = (DynamicObject)model.getValue("r_pricetype", rowIndex);
        if (priceType == null) {
            return;
        }
        Long priceTypeId = Long.valueOf(priceType.getPkValue().toString());
        DynamicObject data = model.getDataEntity(true);
        DynamicObjectCollection billExpEntrys = data.getDynamicObjectCollection("billexpenseentry");
        DynamicObjectCollection rowExpEntrys = data.getDynamicObjectCollection("rowexpenseentry");
        EntryType billExpEtryType = (EntryType)billExpEntrys.getDynamicObjectType();
        Map<String, Map<String, Object>> rowExpMap_old = ExpenseBillHelper.rowExpsSumExcludeCurrent(rowExpEntrys, priceTypeId, Long.valueOf(currencyId), rowIndex);
        ExpenseBillHelper.rowExpsToBillEntry(billExpEntrys, billExpEtryType, rowExpEntrys, rowExpMap_old);
        DynamicObject calType = (DynamicObject)model.getValue("r_caltype", rowIndex);
        if (calType == null) {
            return;
        }
        String calcbase = calType.getString("calcbase");
        DynamicObject currency_new = (DynamicObject)model.getValue("r_currency", rowIndex);
        if (StringUtils.isEmpty((String)calcbase)) {
            int amtprecision = 10;
            if (currency_new != null) {
                amtprecision = currency_new.getInt("amtprecision");
            }
            BigDecimal priceValRow = ((BigDecimal)model.getValue("r_priceval", rowIndex)).setScale(amtprecision, RoundingMode.HALF_UP);
            this.getPageCache().put("stopChange", "true");
            model.setValue("r_priceval", (Object)priceValRow);
            this.getPageCache().put("stopChange", "false");
        }
        ExpenseBillHelper.expsCalculate((DynamicObject)rowExpEntrys.get(rowIndex));
        Long currencyId_new = 0L;
        if (currency_new != null) {
            currencyId_new = Long.valueOf(currency_new.getPkValue().toString());
        }
        Map<String, Map<String, Object>> rowExpMap_new = ExpenseBillHelper.rowExpsSumByDimension(rowExpEntrys, priceTypeId, currencyId_new);
        ExpenseBillHelper.rowExpsToBillEntry(billExpEntrys, billExpEtryType, rowExpEntrys, rowExpMap_new);
        this.getView().updateView("r_amount", rowIndex);
        this.getView().updateView("billexpenseentry");
    }

    private void changePriceValueRow(Object newValue, int rowIndex) {
        if (newValue == null) {
            this.getView().getModel().setValue("r_amount", (Object)BigDecimal.ZERO, rowIndex);
        } else {
            newValue = (BigDecimal)newValue;
            IDataModel model = this.getModel();
            DynamicObject calType = (DynamicObject)model.getValue("r_caltype", rowIndex);
            if (calType == null) {
                return;
            }
            String calcbase = calType.getString("calcbase");
            if (StringUtils.isEmpty((String)calcbase)) {
                DynamicObject currencyObj = (DynamicObject)model.getValue("r_currency", rowIndex);
                int amtprecision = 10;
                if (currencyObj != null) {
                    amtprecision = currencyObj.getInt("amtprecision");
                }
                newValue = ((BigDecimal)newValue).setScale(amtprecision, RoundingMode.HALF_UP);
                this.getPageCache().put("stopChange", "true");
                model.setValue("r_priceval", newValue);
                this.getPageCache().put("stopChange", "false");
            }
            DynamicObject data = this.getModel().getDataEntity(true);
            DynamicObjectCollection rowExpEntrys = data.getDynamicObjectCollection("rowexpenseentry");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("r_currency", rowIndex);
            if (currency == null) {
                return;
            }
            ExpenseBillHelper.expsCalculate((DynamicObject)rowExpEntrys.get(rowIndex));
            DynamicObjectCollection billExpEntrys = data.getDynamicObjectCollection("billexpenseentry");
            EntryType billExpEtryType = (EntryType)billExpEntrys.getDynamicObjectType();
            DynamicObject priceType = (DynamicObject)this.getModel().getValue("r_pricetype", rowIndex);
            if (priceType == null) {
                return;
            }
            Long priceTypeId = Long.valueOf(priceType.getPkValue().toString());
            Long currencyId = Long.valueOf(currency.getPkValue().toString());
            Map<String, Map<String, Object>> rowExpMap_new = ExpenseBillHelper.rowExpsSumByDimension(rowExpEntrys, priceTypeId, currencyId);
            ExpenseBillHelper.rowExpsToBillEntry(billExpEntrys, billExpEtryType, rowExpEntrys, rowExpMap_new);
            this.getView().updateView("r_priceval", rowIndex);
            this.getView().updateView("r_amount", rowIndex);
            this.getView().updateView("billexpenseentry");
        }
    }

    private void changeBizBillEntryId(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        Map<String, String> existRslt = this.isExistInRowEntry("r_bizentryid", newValue, rowIndex);
        if (existRslt.get("isexist").equals("true")) {
            this.getView().showTipNotification(existRslt.get("msg"));
            String bizBillEntryId = this.getPageCache().get(CACHE_BIZBILLENTRYID_ROW);
            this.getPageCache().put("stopChange", "true");
            if ("0".equals(bizBillEntryId)) {
                model.setValue("r_bizentryid", null);
            } else {
                model.setValue("r_bizentryid", (Object)Long.parseLong(bizBillEntryId));
            }
            this.getPageCache().put("stopChange", "false");
            return;
        }
        DynamicObject data = model.getDataEntity(true);
        DynamicObjectCollection rowExpEntrys = data.getDynamicObjectCollection("rowexpenseentry");
        DynamicObject bizBill = this.getBizBillObj();
        String bizBillEntity = this.getModel().getValue("bizbillentity").toString();
        String bizEntryNameStr = "";
        Map<String, String> billentryExist = ExpenseBillHelper.checkExistByFld(bizBillEntity, "billentry");
        if (billentryExist != null && !StringUtils.isEmpty((String)billentryExist.get("msg"))) {
            this.getView().showTipNotification(billentryExist.get("msg"));
            return;
        }
        if (billentryExist != null && !StringUtils.isEmpty((String)billentryExist.get("bizfield"))) {
            bizEntryNameStr = billentryExist.get("bizfield");
        }
        DynamicObjectCollection bizEntrys = bizBill.getDynamicObjectCollection(bizEntryNameStr);
        Long bizBillEntryId = (Long)newValue;
        for (int k = 0; k < bizEntrys.size(); ++k) {
            DynamicObject calType;
            DynamicObject material;
            if (!bizBillEntryId.equals(((DynamicObject)bizEntrys.get(k)).getLong("id"))) continue;
            String materialStr = "";
            Map<String, String> materialExist = ExpenseBillHelper.checkExistByFld(bizBillEntity, "material");
            if (materialExist != null && !StringUtils.isEmpty((String)materialExist.get("msg"))) {
                this.getView().showTipNotification(materialExist.get("msg"));
                return;
            }
            if (materialExist != null && !StringUtils.isEmpty((String)materialExist.get("bizfield"))) {
                materialStr = materialExist.get("bizfield");
            }
            if ((material = ((DynamicObject)bizEntrys.get(k)).getDynamicObject(materialStr)) != null) {
                DynamicObject matMaster = material.getDynamicObject("masterid");
                model.setValue("r_matnum", matMaster.get("number"), rowIndex);
                model.setValue("r_mat", (Object)matMaster, rowIndex);
            }
            if (!kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)(calType = (DynamicObject)model.getValue("r_caltype", rowIndex)))) {
                String calcbase = calType.getString("calcbase");
                if (StringUtils.isEmpty((String)calcbase)) {
                    model.setValue("r_unit", null, rowIndex);
                    model.setValue("r_caltypeval", null, rowIndex);
                } else if ("qty".equals(calcbase)) {
                    String unitStr = "";
                    Map<String, String> unitExist = ExpenseBillHelper.checkExistByFld(bizBillEntity, "unit");
                    if (unitExist != null && !StringUtils.isEmpty((String)unitExist.get("msg"))) {
                        this.getView().showTipNotification(unitExist.get("msg"));
                        return;
                    }
                    if (unitExist != null && !StringUtils.isEmpty((String)unitExist.get("bizfield"))) {
                        unitStr = unitExist.get("bizfield");
                    }
                    DynamicObject unit = ((DynamicObject)bizEntrys.get(k)).getDynamicObject(unitStr);
                    String qtyStr = "";
                    Map<String, String> qtyExist = ExpenseBillHelper.checkExistByFld(bizBillEntity, "qty");
                    if (qtyExist != null && !StringUtils.isEmpty((String)qtyExist.get("msg"))) {
                        this.getView().showTipNotification(qtyExist.get("msg"));
                        return;
                    }
                    if (qtyExist != null && !StringUtils.isEmpty((String)qtyExist.get("bizfield"))) {
                        qtyStr = qtyExist.get("bizfield");
                    }
                    BigDecimal qty = ((DynamicObject)bizEntrys.get(k)).getBigDecimal(qtyStr);
                    model.setValue("r_unit", (Object)unit, rowIndex);
                    model.setValue("r_caltypeval", (Object)qty.abs(), rowIndex);
                } else if ("amountandtax".equals(calcbase)) {
                    String amoutandtaxStr = "";
                    Map<String, String> amountandtaxExist = ExpenseBillHelper.checkExistByFld(bizBillEntity, "amountandtax");
                    if (amountandtaxExist != null && !StringUtils.isEmpty((String)amountandtaxExist.get("msg"))) {
                        this.getView().showTipNotification(amountandtaxExist.get("msg"));
                        return;
                    }
                    if (amountandtaxExist != null && !StringUtils.isEmpty((String)amountandtaxExist.get("bizfield"))) {
                        amoutandtaxStr = amountandtaxExist.get("bizfield");
                    }
                    BigDecimal amountAndTax = ((DynamicObject)bizEntrys.get(k)).getBigDecimal(amoutandtaxStr);
                    model.setValue("r_unit", null, rowIndex);
                    model.setValue("r_caltypeval", (Object)amountAndTax.abs(), rowIndex);
                } else {
                    String calcbaseStr = ExpenseBillHelper.getBillFieldByMap(bizBillEntity, calcbase, null);
                    Map<String, String> calcbaseExist = ExpenseBillHelper.checkExistByFld(bizBillEntity, "calcbase");
                    if (calcbaseExist != null && !StringUtils.isEmpty((String)calcbaseExist.get("msg"))) {
                        this.getView().showTipNotification(calcbaseExist.get("msg"));
                        return;
                    }
                    if (calcbaseExist != null && !StringUtils.isEmpty((String)calcbaseExist.get("bizfield"))) {
                        calcbaseStr = calcbaseExist.get("bizfield");
                    }
                    BigDecimal otherbase = ((DynamicObject)bizEntrys.get(k)).getBigDecimal(calcbaseStr);
                    model.setValue("r_caltypeval", (Object)otherbase.abs(), rowIndex);
                }
                ExpenseBillHelper.expsCalculate((DynamicObject)rowExpEntrys.get(rowIndex));
            }
            String settleOrgStr = "";
            Map<String, String> settleorgExist = ExpenseBillHelper.checkExistByFld(bizBillEntity, "settleorg");
            if (settleorgExist != null && !StringUtils.isEmpty((String)settleorgExist.get("msg"))) {
                this.getView().showTipNotification(settleorgExist.get("msg"));
                return;
            }
            if (settleorgExist != null && !StringUtils.isEmpty((String)settleorgExist.get("bizfield"))) {
                settleOrgStr = settleorgExist.get("bizfield");
            }
            DynamicObject settleOrg = ((DynamicObject)bizEntrys.get(k)).getDynamicObject(settleOrgStr);
            model.setValue("r_settleorg", (Object)settleOrg, rowIndex);
            DynamicObject priceType_row = (DynamicObject)model.getValue("r_pricetype", rowIndex);
            if (priceType_row == null) continue;
            DynamicObject expsItemObj = this.initExpsItem(priceType_row, settleOrg);
            model.setValue("r_expsitm", (Object)expsItemObj, rowIndex);
        }
    }

    private Map<String, String> isExistInBillEntry(String fieldKey, Object newValue, int rowIndex) {
        HashMap<String, String> result = new HashMap<String, String>(8);
        if (kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)fieldKey) || newValue == null) {
            result.put("isexist", "false");
            return result;
        }
        Long priceTypeId = 0L;
        Long currencyId = 0L;
        DynamicObject newValueDO = null;
        if (newValue instanceof DynamicObject) {
            newValueDO = (DynamicObject)newValue;
        }
        if ("pricetype".equals(fieldKey)) {
            Object currency = this.getModel().getValue("currency", rowIndex);
            DynamicObject currencyDO = null;
            if (currency != null) {
                currencyDO = (DynamicObject)currency;
                currencyId = (Long)currencyDO.getPkValue();
            }
            if (newValueDO == null && currencyDO == null) {
                result.put("isexist", "false");
                return result;
            }
            if (newValueDO != null) {
                priceTypeId = (Long)newValueDO.getPkValue();
            }
        } else if ("currency".equals(fieldKey)) {
            DynamicObject priceType = (DynamicObject)this.getModel().getValue("pricetype", rowIndex);
            DynamicObject priceTypeDO = null;
            if (priceType != null) {
                priceTypeDO = priceType;
                priceTypeId = (Long)priceTypeDO.getPkValue();
            }
            if (newValueDO == null && priceTypeDO == null) {
                result.put("isexist", "false");
                return result;
            }
            if (newValueDO != null) {
                currencyId = (Long)newValueDO.getPkValue();
            }
        }
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection billExpEntrys = data.getDynamicObjectCollection("billexpenseentry");
        if (kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)billExpEntrys) || billExpEntrys.size() == 1) {
            result.put("isexist", "false");
            return result;
        }
        boolean isExist = false;
        for (int i = 0; i < billExpEntrys.size(); ++i) {
            if (i == rowIndex) continue;
            DynamicObject priceType_o = ((DynamicObject)billExpEntrys.get(i)).getDynamicObject("pricetype");
            DynamicObject currency_o = ((DynamicObject)billExpEntrys.get(i)).getDynamicObject("currency");
            Long priceTypeId_o = 0L;
            Long currencyId_o = 0L;
            if (priceType_o != null) {
                priceTypeId_o = (Long)priceType_o.getPkValue();
            }
            if (currency_o != null) {
                currencyId_o = (Long)currency_o.getPkValue();
            }
            if (priceTypeId_o.equals(0L) || currencyId_o.equals(0L) || !priceTypeId.equals(priceTypeId_o) || !currencyId.equals(currencyId_o)) continue;
            result.put("isexist", "true");
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8f93\u5165\u7684\u884c\u4e0e\u7b2c%1$s\u884c\u201c\u4ef7\u683c\u7c7b\u578b\u201d\u548c\u201c\u5e01\u79cd\u201d\u7ec4\u5408\u503c\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ExpenseBillPlugin_11", (String)"mpscmm-msbd-expense", (Object[])new Object[0]), i + 1);
            result.put("msg", msg);
            isExist = true;
        }
        if (!isExist) {
            result.put("isexist", "false");
        }
        return result;
    }

    private Map<String, String> isExistInRowEntry(String fieldKey, Object newValue, int rowIndex) {
        Object bizBillEntry;
        DynamicObject currencyDO;
        Object currency;
        HashMap<String, String> result = new HashMap<String, String>(8);
        if (kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)fieldKey) || newValue == null) {
            result.put("isexist", "false");
            return result;
        }
        Long priceTypeId = 0L;
        Long currencyId = 0L;
        Long bizBillEntryId = 0L;
        DynamicObject newValueDO = null;
        if (newValue instanceof DynamicObject) {
            newValueDO = (DynamicObject)newValue;
        } else if (newValue instanceof Long) {
            bizBillEntryId = (Long)newValue;
        }
        if ("r_pricetype".equals(fieldKey)) {
            currency = this.getModel().getValue("r_currency", rowIndex);
            currencyDO = null;
            if (currency != null) {
                currencyDO = (DynamicObject)currency;
                currencyId = (Long)currencyDO.getPkValue();
            }
            if ((bizBillEntry = this.getModel().getValue("r_bizentryid", rowIndex)) != null) {
                bizBillEntryId = (Long)bizBillEntry;
            }
            if (newValueDO != null) {
                priceTypeId = (Long)newValueDO.getPkValue();
            }
        } else if ("r_currency".equals(fieldKey)) {
            DynamicObject priceType = (DynamicObject)this.getModel().getValue("r_pricetype", rowIndex);
            DynamicObject priceTypeDO = null;
            if (priceType != null) {
                priceTypeDO = priceType;
                priceTypeId = (Long)priceTypeDO.getPkValue();
            }
            if (newValueDO == null && priceTypeDO == null) {
                result.put("isexist", "false");
                return result;
            }
            bizBillEntry = this.getModel().getValue("r_bizentryid", rowIndex);
            if (bizBillEntry != null) {
                bizBillEntryId = (Long)bizBillEntry;
            }
            if (newValueDO != null) {
                currencyId = (Long)newValueDO.getPkValue();
            }
        } else if ("r_bizentryid".equals(fieldKey)) {
            if (newValue instanceof Long) {
                bizBillEntryId = (Long)newValue;
            }
            currency = this.getModel().getValue("r_currency", rowIndex);
            currencyDO = null;
            if (currency != null) {
                currencyDO = (DynamicObject)currency;
                currencyId = (Long)currencyDO.getPkValue();
            }
            DynamicObject priceType = (DynamicObject)this.getModel().getValue("r_pricetype", rowIndex);
            DynamicObject priceTypeDO = null;
            if (priceType != null) {
                priceTypeDO = priceType;
                priceTypeId = (Long)priceTypeDO.getPkValue();
            }
        }
        if (priceTypeId.equals(0L) || currencyId.equals(0L) || bizBillEntryId.equals(0L)) {
            result.put("isexist", "false");
            return result;
        }
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection rowExpEntrys = data.getDynamicObjectCollection("rowexpenseentry");
        if (kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)rowExpEntrys) || rowExpEntrys.size() == 1) {
            result.put("isexist", "false");
            return result;
        }
        boolean isExist = false;
        for (int i = 0; i < rowExpEntrys.size(); ++i) {
            if (i == rowIndex) continue;
            DynamicObject priceType_o = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_pricetype");
            DynamicObject currency_o = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_currency");
            Long priceTypeId_o = 0L;
            Long currencyId_o = 0L;
            if (priceType_o != null) {
                priceTypeId_o = (Long)priceType_o.getPkValue();
            }
            if (currency_o != null) {
                currencyId_o = (Long)currency_o.getPkValue();
            }
            Long bizBillEntryId_o = ((DynamicObject)rowExpEntrys.get(i)).getLong("r_bizentryid");
            if (!priceTypeId.equals(priceTypeId_o) || !currencyId.equals(currencyId_o) || !bizBillEntryId.equals(bizBillEntryId_o)) continue;
            result.put("isexist", "true");
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8f93\u5165\u7684\u884c\u4e0e\u7b2c%1$s\u884c\u7684\u201c\u7269\u6599\u7f16\u7801\u201d\u3001\u201c\u4ef7\u683c\u7c7b\u578b\u201d\u548c\u201c\u5e01\u79cd\u201d\u7ec4\u5408\u503c\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ExpenseBillPlugin_12", (String)"mpscmm-msbd-expense", (Object[])new Object[0]), i + 1);
            result.put("msg", msg);
            isExist = true;
        }
        if (!isExist) {
            result.put("isexist", "false");
        }
        return result;
    }

    private void materialF7() {
        IDataModel model = this.getModel();
        int currentRowIndex = model.getEntryCurrentRowIndex("rowexpenseentry");
        String bizBillEntity = this.getModel().getValue("bizbillentity").toString();
        Long bizBillId = (Long)this.getModel().getValue("bizbillid");
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)bizBillEntity, (boolean)true, (int)2);
        ListFilterParameter lfp = new ListFilterParameter();
        lfp.setFilter(new QFilter("id", "=", (Object)bizBillId));
        lsp.setListFilterParameter(lfp);
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), "r_matnum");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void billExpsShare(String changeKey, Object oldValue, Object newValue, int billIndex) {
        Long currencyId;
        Long priceTypeId;
        List<Integer> shareRow;
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection billExpEntrys = data.getDynamicObjectCollection("billexpenseentry");
        DynamicObjectCollection rowExpEntrys = data.getDynamicObjectCollection("rowexpenseentry");
        DynamicObject priceType = (DynamicObject)((DynamicObject)billExpEntrys.get(billIndex)).get("pricetype");
        DynamicObject currency = (DynamicObject)((DynamicObject)billExpEntrys.get(billIndex)).get("currency");
        EntryType billExpEtryType = (EntryType)billExpEntrys.getDynamicObjectType();
        Map billExpFieldMap = billExpEtryType.getFields();
        EntryType rowExpEtryType = (EntryType)rowExpEntrys.getDynamicObjectType();
        Map rowExpFieldMap = rowExpEtryType.getFields();
        if ("currency".equals(changeKey)) {
            currency = (DynamicObject)oldValue;
        }
        if ("pricetype".equals(changeKey)) {
            priceType = (DynamicObject)oldValue;
        }
        if ((shareRow = this.existShared(priceTypeId = Long.valueOf(priceType == null ? 0L : priceType.getLong("id")), currencyId = Long.valueOf(currency == null ? 0L : currency.getLong("id")), rowExpEntrys)).size() > 0) {
            block45: {
                DynamicObject calTypeObj = ((DynamicObject)billExpEntrys.get(billIndex)).getDynamicObject("caltype");
                if (kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)calTypeObj)) {
                    return;
                }
                String calcbase = calTypeObj.getString("calcbase");
                for (int i = 0; i < shareRow.size(); ++i) {
                    if (changeKey.equals("currency")) {
                        ((DynamicObject)rowExpEntrys.get(shareRow.get(i).intValue())).set("r_" + changeKey, newValue);
                        if (StringUtils.isEmpty((String)calcbase)) {
                            BigDecimal priceValRow = ((DynamicObject)rowExpEntrys.get(shareRow.get(i).intValue())).getBigDecimal("r_priceval");
                            if (newValue != null) {
                                int amtprecision = ((DynamicObject)newValue).getInt("amtprecision");
                                BigDecimal priceValRowPrecision = priceValRow.setScale(amtprecision, RoundingMode.HALF_UP);
                                ((DynamicObject)rowExpEntrys.get(shareRow.get(i).intValue())).set("r_priceval", (Object)priceValRowPrecision);
                            }
                        }
                        ExpenseBillHelper.expsCalculate((DynamicObject)rowExpEntrys.get(shareRow.get(i).intValue()));
                        continue;
                    }
                    if (changeKey.equals("priceval")) {
                        if (StringUtils.isEmpty((String)calcbase)) continue;
                        this.getModel().setValue("r_" + changeKey, newValue, shareRow.get(i).intValue());
                        ExpenseBillHelper.expsCalculate((DynamicObject)rowExpEntrys.get(shareRow.get(i).intValue()));
                        continue;
                    }
                    ((DynamicObject)rowExpEntrys.get(shareRow.get(i).intValue())).set("r_" + changeKey, newValue);
                }
                if (changeKey.equals("priceval") && StringUtils.isEmpty((String)calcbase)) {
                    HashSet<Long> bizEntryIds = new HashSet<Long>(8);
                    for (int j = 0; j < shareRow.size(); ++j) {
                        Long bizEntryId = ((DynamicObject)rowExpEntrys.get(shareRow.get(j).intValue())).getLong("r_bizentryid");
                        bizEntryIds.add(bizEntryId);
                    }
                    if (bizEntryIds.size() > 0) {
                        String srcEntity = this.getModel().getValue("bizbillentity").toString();
                        String bizSelProps = ExpenseBillHelper.getSelectProps(srcEntity);
                        String bizBillEntryStr = "";
                        Map<String, String> billentryExist = ExpenseBillHelper.checkExistByFld(srcEntity, "billentry");
                        if (billentryExist != null && !StringUtils.isEmpty((String)billentryExist.get("msg"))) {
                            this.getView().showTipNotification(billentryExist.get("msg"));
                            return;
                        }
                        if (billentryExist != null && !StringUtils.isEmpty((String)billentryExist.get("bizfield"))) {
                            bizBillEntryStr = billentryExist.get("bizfield");
                        }
                        String amountandtaxStr = "";
                        Map<String, String> amountandtaxExist = ExpenseBillHelper.checkExistByFld(srcEntity, "amountandtax");
                        if (amountandtaxExist != null && !StringUtils.isEmpty((String)amountandtaxExist.get("msg"))) {
                            this.getView().showTipNotification(amountandtaxExist.get("msg"));
                            return;
                        }
                        if (amountandtaxExist != null && !StringUtils.isEmpty((String)amountandtaxExist.get("bizfield"))) {
                            amountandtaxStr = amountandtaxExist.get("bizfield");
                        }
                        if (!StringUtils.isEmpty((String)bizBillEntryStr) && !StringUtils.isEmpty((String)amountandtaxStr)) {
                            try (DataSet bizEntrys = QueryServiceHelper.queryDataSet((String)"ExpsQueryBizBill", (String)srcEntity, (String)bizSelProps, (QFilter[])new QFilter[]{new QFilter(bizBillEntryStr + ".id", "in", bizEntryIds)}, null);){
                                BigDecimal allPriceVal;
                                if (bizEntrys == null) break block45;
                                DataSet bizEntrysAllAmount = bizEntrys.copy();
                                BigDecimal allAmount = BigDecimalUtil.ZERO;
                                for (Row row : bizEntrysAllAmount) {
                                    allAmount = allAmount.add(row.getBigDecimal(bizBillEntryStr + "." + amountandtaxStr));
                                }
                                bizEntrysAllAmount.close();
                                if (allAmount.compareTo(BigDecimal.ZERO) <= 0) break block45;
                                int amtprecision = 10;
                                if (currency != null) {
                                    amtprecision = currency.getInt("amtprecision");
                                    newValue = ((BigDecimal)newValue).setScale(amtprecision, RoundingMode.HALF_UP);
                                }
                                if ((allPriceVal = (BigDecimal)newValue).compareTo(BigDecimal.ZERO) == 0) {
                                    for (int k = 0; k < shareRow.size(); ++k) {
                                        ((DynamicObject)rowExpEntrys.get(shareRow.get(k).intValue())).set("r_priceval", (Object)BigDecimal.ZERO);
                                        ((DynamicObject)rowExpEntrys.get(shareRow.get(k).intValue())).set("r_amount", (Object)BigDecimal.ZERO);
                                    }
                                } else {
                                    BigDecimal addPriceVal = BigDecimalUtil.ZERO;
                                    int count = bizEntrys.count(bizBillEntryStr + ".id", false);
                                    for (Row row : bizEntrys) {
                                        for (int m = 0; m < rowExpEntrys.size(); ++m) {
                                            if (!shareRow.contains(m) || row.getLong(bizBillEntryStr + ".id").longValue() != ((DynamicObject)rowExpEntrys.get(m)).getLong("r_bizentryid")) continue;
                                            if (allPriceVal.compareTo(BigDecimal.ZERO) > 0 && allPriceVal.compareTo(addPriceVal) > 0 || allPriceVal.compareTo(BigDecimal.ZERO) < 0 && allPriceVal.compareTo(addPriceVal) < 0) {
                                                if (count != 1) {
                                                    BigDecimal bizAmtTax = row.getBigDecimal(bizBillEntryStr + "." + amountandtaxStr);
                                                    BigDecimal rowExpsPriceVal = allPriceVal.multiply(bizAmtTax).divide(allAmount, amtprecision, RoundingMode.HALF_UP);
                                                    BigDecimal addAmountTemp = addPriceVal.add(rowExpsPriceVal);
                                                    if (addAmountTemp.compareTo(allPriceVal) == 0 || allPriceVal.compareTo(BigDecimal.ZERO) > 0 && addAmountTemp.compareTo(allPriceVal) > 0 || allPriceVal.compareTo(BigDecimal.ZERO) < 0 && addAmountTemp.compareTo(allPriceVal) < 0) {
                                                        ((DynamicObject)rowExpEntrys.get(m)).set("r_priceval", (Object)allPriceVal.subtract(addPriceVal));
                                                    } else {
                                                        ((DynamicObject)rowExpEntrys.get(m)).set("r_priceval", (Object)rowExpsPriceVal);
                                                    }
                                                    addPriceVal = addPriceVal.add(rowExpsPriceVal);
                                                } else {
                                                    BigDecimal rowExpsPriceVal = allPriceVal.subtract(addPriceVal);
                                                    ((DynamicObject)rowExpEntrys.get(m)).set("r_priceval", (Object)rowExpsPriceVal);
                                                }
                                            } else {
                                                ((DynamicObject)rowExpEntrys.get(m)).set("r_priceval", (Object)BigDecimal.ZERO);
                                            }
                                            ExpenseBillHelper.expsCalculate((DynamicObject)rowExpEntrys.get(m));
                                        }
                                        --count;
                                    }
                                }
                                bizEntrys.close();
                            }
                        }
                    }
                }
            }
            Long crrcyId = 0L;
            DynamicObject crrcy = (DynamicObject)((DynamicObject)billExpEntrys.get(billIndex)).get("currency");
            if (crrcy != null) {
                crrcyId = crrcy.getLong("id");
            }
            if (changeKey.equals("priceval") || changeKey.equals("currency")) {
                Map<String, Map<String, Object>> rowExpMap = ExpenseBillHelper.rowExpsSumByDimension(rowExpEntrys, priceTypeId, crrcyId);
                ExpenseBillHelper.rowExpsToBillEntry(billExpEntrys, billExpEtryType, rowExpEntrys, rowExpMap);
            }
        } else {
            this.generateRowExpsByShare(billIndex);
        }
    }

    private void generateRowExpsByShare(int billIndex) {
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection billExpEntrys = data.getDynamicObjectCollection("billexpenseentry");
        DynamicObjectCollection rowExpEntrys = data.getDynamicObjectCollection("rowexpenseentry");
        EntryType billExpEtryType = (EntryType)billExpEntrys.getDynamicObjectType();
        Map billExpFieldMap = billExpEtryType.getFields();
        EntryType rowExpEtryType = (EntryType)rowExpEntrys.getDynamicObjectType();
        Map rowExpFieldMap = rowExpEtryType.getFields();
        DynamicObject priceTypeObj = (DynamicObject)((DynamicObject)billExpEntrys.get(billIndex)).get("pricetype");
        DynamicObject currencyObj = (DynamicObject)((DynamicObject)billExpEntrys.get(billIndex)).get("currency");
        BigDecimal priceValue = (BigDecimal)((DynamicObject)billExpEntrys.get(billIndex)).get("priceval");
        if (priceTypeObj == null || currencyObj == null || priceValue.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        Object objId = this.getModel().getValue("bizbillid");
        String srcEntity = this.getModel().getValue("bizbillentity").toString();
        String bizSelProps = ExpenseBillHelper.getSelectProps(srcEntity);
        DynamicObject calTypeObj = ((DynamicObject)billExpEntrys.get(billIndex)).getDynamicObject("caltype");
        if (kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)calTypeObj)) {
            return;
        }
        String calcbase = calTypeObj.getString("calcbase");
        String amountandtaxStr = "";
        if (StringUtils.isEmpty((String)calcbase) || "amountandtax".equals(calcbase)) {
            Map<String, String> fieldExist = ExpenseBillHelper.checkExistByFld(srcEntity, "amountandtax");
            if (fieldExist != null && !StringUtils.isEmpty((String)fieldExist.get("msg"))) {
                this.getView().showTipNotification(fieldExist.get("msg"));
                return;
            }
            if (fieldExist != null && !StringUtils.isEmpty((String)fieldExist.get("bizfield"))) {
                amountandtaxStr = fieldExist.get("bizfield");
            }
        }
        DynamicObject bizBill = this.getBizBillObj();
        String bizBillEntryStr = "";
        Map<String, String> fieldExist = ExpenseBillHelper.checkExistByFld(srcEntity, "billentry");
        if (fieldExist != null && !StringUtils.isEmpty((String)fieldExist.get("msg"))) {
            this.getView().showTipNotification(fieldExist.get("msg"));
            return;
        }
        if (fieldExist != null && !StringUtils.isEmpty((String)fieldExist.get("bizfield"))) {
            bizBillEntryStr = fieldExist.get("bizfield");
        }
        DynamicObjectCollection bizBillEntrys = bizBill.getDynamicObjectCollection(bizBillEntryStr);
        BigDecimal allAmount = BigDecimalUtil.ZERO;
        if (StringUtils.isEmpty((String)calcbase)) {
            for (int i = 0; i < bizBillEntrys.size(); ++i) {
                allAmount = allAmount.add(((DynamicObject)bizBillEntrys.get(i)).getBigDecimal(amountandtaxStr));
            }
        }
        BigDecimal addPriceVal = BigDecimalUtil.ZERO;
        String expsSupStr = "";
        String expsSupOrigFld = ExpenseBillHelper.getOriginalBillField(srcEntity, "expensesupplier");
        if (!StringUtils.isEmpty((String)expsSupOrigFld) && expsSupOrigFld.contains(".")) {
            expsSupStr = ExpenseBillHelper.getSplitStrs(expsSupOrigFld);
        }
        for (int i = 0; i < bizBillEntrys.size(); ++i) {
            DynamicObject mat;
            DynamicObject rowExpEntry = rowExpEntrys.addNew();
            for (String prop : rowExpFieldMap.keySet()) {
                if (!billExpFieldMap.containsKey(prop.substring(2))) continue;
                if (StringUtils.isEmpty((String)calcbase) && prop.equals("r_priceval")) {
                    if (allAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal allPriceVal = ((DynamicObject)billExpEntrys.get(billIndex)).getBigDecimal(prop.substring(2));
                    int amtprecision = 10;
                    if (currencyObj != null) {
                        amtprecision = currencyObj.getInt("amtprecision");
                        allPriceVal = allPriceVal.setScale(amtprecision, RoundingMode.HALF_UP);
                    }
                    if ((allPriceVal.compareTo(BigDecimal.ZERO) <= 0 || allPriceVal.compareTo(addPriceVal) <= 0) && (allPriceVal.compareTo(BigDecimal.ZERO) >= 0 || allPriceVal.compareTo(addPriceVal) >= 0)) continue;
                    if (i != bizBillEntrys.size() - 1) {
                        BigDecimal bizAmtTax = ((DynamicObject)bizBillEntrys.get(i)).getBigDecimal(amountandtaxStr);
                        BigDecimal rowExpsPriceVal = allPriceVal.multiply(bizAmtTax).divide(allAmount, amtprecision, RoundingMode.HALF_UP);
                        BigDecimal addAmountTemp = addPriceVal.add(rowExpsPriceVal);
                        if (addAmountTemp.compareTo(allPriceVal) == 0 || allPriceVal.compareTo(BigDecimal.ZERO) > 0 && addAmountTemp.compareTo(allPriceVal) > 0 || allPriceVal.compareTo(BigDecimal.ZERO) < 0 && addAmountTemp.compareTo(allPriceVal) < 0) {
                            rowExpEntry.set(prop, (Object)allPriceVal.subtract(addPriceVal));
                            addPriceVal = allPriceVal;
                            continue;
                        }
                        rowExpEntry.set(prop, (Object)rowExpsPriceVal);
                        addPriceVal = addPriceVal.add(rowExpsPriceVal);
                        continue;
                    }
                    BigDecimal rowExpsPriceVal = allPriceVal.subtract(addPriceVal);
                    rowExpEntry.set(prop, (Object)rowExpsPriceVal);
                    continue;
                }
                rowExpEntry.set(prop, ((DynamicObject)billExpEntrys.get(billIndex)).get(prop.substring(2)));
                if (!"r_expssup".equals(prop) || ((DynamicObject)billExpEntrys.get(billIndex)).get(prop.substring(2)) != null || StringUtils.isEmpty((String)expsSupStr)) continue;
                rowExpEntry.set(prop, (Object)((DynamicObject)bizBillEntrys.get(i)).getDynamicObject(expsSupStr));
            }
            rowExpEntry.set("r_bizentryid", ((DynamicObject)bizBillEntrys.get(i)).get("id"));
            String matStr = "";
            Map<String, String> materialExist = ExpenseBillHelper.checkExistByFld(srcEntity, "material");
            if (materialExist != null && !StringUtils.isEmpty((String)materialExist.get("msg"))) {
                this.getView().showTipNotification(materialExist.get("msg"));
                return;
            }
            if (materialExist != null && !StringUtils.isEmpty((String)materialExist.get("bizfield"))) {
                matStr = materialExist.get("bizfield");
            }
            if ((mat = ((DynamicObject)bizBillEntrys.get(i)).getDynamicObject(matStr)) != null) {
                DynamicObject matMaster = mat.getDynamicObject("masterid");
                rowExpEntry.set("r_mat", (Object)matMaster);
                rowExpEntry.set("r_matnum", (Object)matMaster.getString("number"));
            }
            if (!StringUtils.isEmpty((String)calcbase) && !calcbase.equals("amountandtax")) {
                String unitStr = "";
                Map<String, String> unitExist = ExpenseBillHelper.checkExistByFld(srcEntity, "unit");
                if (unitExist != null && !StringUtils.isEmpty((String)unitExist.get("msg"))) {
                    this.getView().showTipNotification(unitExist.get("msg"));
                    return;
                }
                if (unitExist != null && !StringUtils.isEmpty((String)unitExist.get("bizfield"))) {
                    unitStr = unitExist.get("bizfield");
                }
                rowExpEntry.set("r_unit", ((DynamicObject)bizBillEntrys.get(i)).get(unitStr));
            }
            if (!StringUtils.isEmpty((String)calcbase)) {
                String calcbaseStr = "";
                Map<String, String> calcbaseExist = ExpenseBillHelper.checkExistByFld(srcEntity, calcbase);
                if (calcbaseExist != null && !StringUtils.isEmpty((String)calcbaseExist.get("msg"))) {
                    this.getView().showTipNotification(calcbaseExist.get("msg"));
                    return;
                }
                if (calcbaseExist != null && !StringUtils.isEmpty((String)calcbaseExist.get("bizfield"))) {
                    calcbaseStr = calcbaseExist.get("bizfield");
                }
                rowExpEntry.set("r_caltypeval", (Object)((BigDecimal)((DynamicObject)bizBillEntrys.get(i)).get(calcbaseStr)).abs());
            }
            String settleOrgFld = ExpenseBillHelper.getBillFieldByMap(srcEntity, "settleorg", null);
            DynamicObject settleOrg = null;
            if (!StringUtils.isEmpty((String)settleOrgFld)) {
                settleOrg = ((DynamicObject)bizBillEntrys.get(i)).getDynamicObject(settleOrgFld);
            }
            rowExpEntry.set("r_settleorg", settleOrg);
            DynamicObject expsItemObj = this.initExpsItem(priceTypeObj, settleOrg);
            rowExpEntry.set("r_expsitm", (Object)expsItemObj);
            ExpenseBillHelper.expsCalculate(rowExpEntry);
        }
        Map<String, Map<String, Object>> rowExpMap = ExpenseBillHelper.rowExpsSumByAll(rowExpEntrys);
        ExpenseBillHelper.rowExpsToBillEntry(billExpEntrys, billExpEtryType, rowExpEntrys, rowExpMap);
    }

    private void rowSumToBill() {
    }

    private List<Integer> existShared(Long priceTypeId, Long currencyId, DynamicObjectCollection rowExpEntrys) {
        ArrayList<Integer> shareRow = new ArrayList<Integer>(8);
        if (priceTypeId == null || priceTypeId.equals(0L)) {
            return shareRow;
        }
        if (currencyId == null || currencyId.equals(0L)) {
            return shareRow;
        }
        for (int i = 0; i < rowExpEntrys.size(); ++i) {
            Long rowPriceTypeId = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_pricetype") == null ? 0L : ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_pricetype").getLong("id");
            Long rowCurrcyId = ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_currency") == null ? 0L : ((DynamicObject)rowExpEntrys.get(i)).getDynamicObject("r_currency").getLong("id");
            if (!priceTypeId.equals(rowPriceTypeId) || !currencyId.equals(rowCurrcyId)) continue;
            shareRow.add(i);
        }
        return shareRow;
    }

    private void expandRowExpenseEntrys() {
        DynamicObject expsBill = this.getView().getModel().getDataEntity();
        DynamicObjectCollection billExpsEntryColl = expsBill.getDynamicObjectCollection("billexpenseentry");
        DynamicObjectCollection rowExpsEntryColl = expsBill.getDynamicObjectCollection("rowexpenseentry");
        if (rowExpsEntryColl.size() == 0) {
            EntryType rowExpEtryType = (EntryType)rowExpsEntryColl.getDynamicObjectType();
            for (DynamicObject billExpsEntry : billExpsEntryColl) {
                String rowJsonStr = billExpsEntry.getString("rowexpensejson_tag");
                if (rowJsonStr == null || rowJsonStr.trim().equals("")) continue;
                ExpenseBillHelper.strToDynamicObjectColl(rowJsonStr, rowExpsEntryColl, rowExpEtryType);
            }
            if (rowExpsEntryColl != null && rowExpsEntryColl.size() > 0) {
                ArrayList<Long> rowExpsEntryIdList = new ArrayList<Long>(rowExpsEntryColl.size());
                for (int i = 0; i < rowExpsEntryColl.size(); ++i) {
                    rowExpsEntryIdList.add(((DynamicObject)rowExpsEntryColl.get(i)).getLong("id"));
                }
                Collections.sort(rowExpsEntryIdList);
                DynamicObjectCollection sortedRowExpsEntryColl = new DynamicObjectCollection();
                for (int j = 0; j < rowExpsEntryIdList.size(); ++j) {
                    if ((Long)rowExpsEntryIdList.get(j) == 0L) continue;
                    for (int m = 0; m < rowExpsEntryColl.size(); ++m) {
                        if (!((Long)rowExpsEntryIdList.get(j)).equals(((DynamicObject)rowExpsEntryColl.get(m)).getLong("id"))) continue;
                        sortedRowExpsEntryColl.add(rowExpsEntryColl.get(m));
                    }
                }
                if (sortedRowExpsEntryColl.size() == 0) {
                    sortedRowExpsEntryColl = rowExpsEntryColl;
                }
                expsBill.set("rowexpenseentry", (Object)sortedRowExpsEntryColl);
            }
            this.getView().updateView("rowexpenseentry");
        }
    }

    private DynamicObject getBizBillObj() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String parentPageId = (String)fsp.getCustomParam("parentPageId");
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        if (parentView == null) {
            return null;
        }
        DynamicObject bizBill = parentView.getModel().getDataEntity(true);
        if (bizBill == null) {
            return null;
        }
        return bizBill;
    }

    private DynamicObject initExpsItem(DynamicObject priceType, Object settleOrg) {
        QFilter settleOrgBlankFltr;
        QFilter priceTypeFltr;
        DynamicObject expsItem1;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"er_expenseitemedit");
        DynamicObject expsItemObj = new DynamicObject((DynamicObjectType)type);
        if (settleOrg instanceof DynamicObject && !kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)priceType) && !kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)settleOrg)) {
            QFilter settleOrgFltr;
            DynamicObject settleOrgObj = (DynamicObject)settleOrg;
            QFilter priceTypeFltr2 = new QFilter("pricetype", "=", priceType.getPkValue());
            DynamicObject expsItem = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_pricetype_expsitem", (QFilter[])new QFilter[]{priceTypeFltr2, settleOrgFltr = new QFilter("org", "=", settleOrgObj.getPkValue())});
            if (!CommonUtils.isNull((Object)expsItem)) {
                expsItemObj = expsItem.getDynamicObject("expenseitem");
            } else {
                QFilter settleOrgBlankFltr2 = new QFilter("org", "=", (Object)0L);
                DynamicObject expsItem12 = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_pricetype_expsitem", (QFilter[])new QFilter[]{priceTypeFltr2, settleOrgBlankFltr2});
                if (!CommonUtils.isNull((Object)expsItem12)) {
                    expsItemObj = expsItem12.getDynamicObject("expenseitem");
                }
            }
        }
        if (!kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)priceType) && kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)settleOrg) && !kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)(expsItem1 = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_pricetype_expsitem", (QFilter[])new QFilter[]{priceTypeFltr = new QFilter("pricetype", "=", priceType.getPkValue()), settleOrgBlankFltr = new QFilter("org", "=", (Object)0L)})))) {
            expsItemObj = expsItem1.getDynamicObject("expenseitem");
        }
        return expsItemObj;
    }
}

