/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.expense.opplugin;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntryType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.mpscmm.msbd.expense.business.helper.ExpenseBillHelper;
import kd.mpscmm.msbd.expense.opplugin.ExpenseBillSaveValidator;

public class ExpenseBillSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ExpenseBillSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billexpenseentry");
        e.getFieldKeys().add("rowexpenseentry");
        e.getFieldKeys().add("pricetype");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("priceval");
        e.getFieldKeys().add("r_priceval");
        e.getFieldKeys().add("r_matnum");
        e.getFieldKeys().add("r_settleorg");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ExpenseBillSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] expsBills;
        for (DynamicObject bill : expsBills = e.getDataEntities()) {
            DynamicObjectCollection billExpEntrys = bill.getDynamicObjectCollection("billexpenseentry");
            DynamicObjectCollection rowExpEntrys = bill.getDynamicObjectCollection("rowexpenseentry");
            if (rowExpEntrys == null || rowExpEntrys.size() == 0) continue;
            EntryType rowExpEtryType = (EntryType)rowExpEntrys.getDynamicObjectType();
            int countNoID = 0;
            int maxSeq = 0;
            boolean existBlankSeq = false;
            for (int k = 0; k < rowExpEntrys.size(); ++k) {
                if (((DynamicObject)rowExpEntrys.get(k)).getLong("id") == 0L) {
                    ++countNoID;
                }
                if (((DynamicObject)rowExpEntrys.get(k)).getInt("seq") == 0) {
                    existBlankSeq = true;
                    continue;
                }
                if (((DynamicObject)rowExpEntrys.get(k)).getInt("seq") <= maxSeq) continue;
                maxSeq = ((DynamicObject)rowExpEntrys.get(k)).getInt("seq");
            }
            if (countNoID > 0) {
                long[] ids = DBServiceHelper.genLongIds((String)"rowexpenseentry", (int)countNoID);
                for (int m = 0; m < rowExpEntrys.size(); ++m) {
                    if (((DynamicObject)rowExpEntrys.get(m)).getLong("id") != 0L) continue;
                    ((DynamicObject)rowExpEntrys.get(m)).set("id", (Object)ids[--countNoID]);
                }
            }
            if (existBlankSeq) {
                for (int n = 0; n < rowExpEntrys.size(); ++n) {
                    if (((DynamicObject)rowExpEntrys.get(n)).getInt("seq") != 0) continue;
                    ((DynamicObject)rowExpEntrys.get(n)).set("seq", (Object)(maxSeq + 1));
                    ++maxSeq;
                }
            }
            long beginDOToStrtime = System.currentTimeMillis();
            logger.info("ExpenseBillSaveOp:DOToStr----rowExpEntrys.size(): " + rowExpEntrys.size());
            logger.info("ExpenseBillSaveOp:DOToStr----Begin: " + new Date(beginDOToStrtime));
            for (int i = 0; i < billExpEntrys.size(); ++i) {
                DynamicObjectCollection rowExpToStr = new DynamicObjectCollection();
                DynamicObject priceType = ((DynamicObject)billExpEntrys.get(i)).getDynamicObject("pricetype");
                DynamicObject currency = ((DynamicObject)billExpEntrys.get(i)).getDynamicObject("currency");
                if (priceType == null || currency == null) continue;
                for (int j = 0; j < rowExpEntrys.size(); ++j) {
                    DynamicObject r_priceType = ((DynamicObject)rowExpEntrys.get(j)).getDynamicObject("r_pricetype");
                    DynamicObject r_currency = ((DynamicObject)rowExpEntrys.get(j)).getDynamicObject("r_currency");
                    if (r_priceType == null || r_currency == null || !priceType.getPkValue().equals(r_priceType.getPkValue()) || !currency.getPkValue().equals(r_currency.getPkValue())) continue;
                    rowExpToStr.add(rowExpEntrys.get(j));
                }
                if (rowExpToStr.size() <= 0) continue;
                String str = ExpenseBillHelper.DOToStr(rowExpToStr, rowExpEtryType);
                ((DynamicObject)billExpEntrys.get(i)).set("rowexpensejson_tag", (Object)str);
            }
            long endDOToStrtime = System.currentTimeMillis();
            logger.info("ExpenseBillSaveOp:DOToStr----End: " + new Date(endDOToStrtime));
            logger.info("ExpenseBillSaveOp:DOToStr----UseTime: " + (endDOToStrtime - beginDOToStrtime) + " ms");
        }
    }
}

