/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.business.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.mpscmm.msbd.algorithm.business.helper.PreinCalExprHelper;
import kd.mpscmm.msbd.algorithm.model.expr.sort.impl.TopologicalCalExprSorter;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalBillModel;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalExprProvider;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalculateExpr;

public final class CalculateExprLocalCache {
    private Map<String, List<ICalculateExpr>> cachedSortedExprs = new ConcurrentHashMap<String, List<ICalculateExpr>>(512);
    private static volatile CalculateExprLocalCache instance = null;

    private CalculateExprLocalCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CalculateExprLocalCache getInstance() {
        if (instance != null) return instance;
        Class<CalculateExprLocalCache> clazz = CalculateExprLocalCache.class;
        synchronized (CalculateExprLocalCache.class) {
            if (instance != null) return instance;
            instance = CalculateExprLocalCache.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static CalculateExprLocalCache build() {
        CalculateExprLocalCache cache = new CalculateExprLocalCache();
        return cache;
    }

    private Map<String, ICalExprProvider> getProviders() {
        ArrayList<ICalExprProvider> providers = new ArrayList<ICalExprProvider>(16);
        providers.addAll(PreinCalExprHelper.getPreinProvider());
        HashMap<String, ICalExprProvider> providerMap = new HashMap<String, ICalExprProvider>(16);
        for (ICalExprProvider provider : providers) {
            providerMap.put(provider.getKey(), provider);
        }
        return providerMap;
    }

    public List<ICalculateExpr> getBillCalExprsByRealTime(ICalBillModel billModel, String changedModelProp) {
        String billProviderKey = this.getBillProviderKey(billModel);
        ICalExprProvider provider = this.getProviders().get(billProviderKey);
        if (provider != null) {
            List provide = provider.provide(billModel.getBillEntity(), changedModelProp);
            List<ICalculateExpr> sortExprs = new TopologicalCalExprSorter().sort(provide, changedModelProp);
            return sortExprs;
        }
        return Collections.emptyList();
    }

    public List<ICalculateExpr> getBillCalExprs(ICalBillModel billModel, String changedModelProp) {
        String matchkey = this.buildMatchKey(this.getBillProviderKey(billModel), billModel.getBillEntity(), changedModelProp);
        List<ICalculateExpr> billCalExprs = this.cachedSortedExprs.get(matchkey);
        if (billCalExprs == null) {
            billCalExprs = this.getBillCalExprsByRealTime(billModel, changedModelProp);
            this.cachedSortedExprs.putIfAbsent(matchkey, billCalExprs);
        }
        return billCalExprs;
    }

    private String getBillProviderKey(ICalBillModel billModel) {
        String key = PreinCalExprHelper.getBillProvider(billModel);
        return key;
    }

    private String buildMatchKey(String providerKey, String billEntity, String changedProp) {
        StringBuilder str = new StringBuilder();
        str.append(providerKey);
        str.append('$');
        str.append(billEntity);
        str.append('$');
        str.append(changedProp);
        return str.toString();
    }
}

