/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.business.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.algorithm.business.cache.BillMappingCache;
import kd.mpscmm.msbd.algorithm.business.cache.CalculateExprLocalCache;
import kd.mpscmm.msbd.algorithm.common.entity.EntryPrecInfo;
import kd.mpscmm.msbd.algorithm.lang.ModelLang;
import kd.mpscmm.msbd.algorithm.model.AlgorithmExecutor;
import kd.mpscmm.msbd.algorithm.model.bill.CalBillModelConfig;
import kd.mpscmm.msbd.algorithm.model.bill.impl.MappingBillEntryModel;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalculateExpr;

public class AlgorithmHelper {
    private static final Log logger = LogFactory.getLog(AlgorithmHelper.class);

    public static Map<String, Object> entryCalculate(String dataEntity, DynamicObject entry, String changeProp) {
        Map<Long, Map<String, Object>> batchEntryCalculate = AlgorithmHelper.batchEntryCalculate(dataEntity, Collections.singletonMap(0L, entry), changeProp);
        if (batchEntryCalculate.isEmpty()) {
            return Collections.emptyMap();
        }
        return batchEntryCalculate.values().iterator().next();
    }

    public static List<Map<String, Object>> batchEntryCalculate(String dataEntity, List<DynamicObject> entries, String changeProp) {
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>(16);
        for (int i = 0; i < entries.size(); ++i) {
            entryMap.put(Long.valueOf(i), entries.get(i));
        }
        Map<Long, Map<String, Object>> batchEntryCalculate = AlgorithmHelper.batchEntryCalculate(dataEntity, entryMap, changeProp);
        if (batchEntryCalculate.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        for (int i = 0; i < entries.size(); ++i) {
            result.add(batchEntryCalculate.get(i));
        }
        return result;
    }

    private static Map<Long, Map<String, Object>> batchEntryCalculate(String dataEntity, Map<Long, DynamicObject> entries, String changeProp) {
        logger.info("\u91d1\u989d\u7b97\u6cd5\u8ba1\u7b97\uff1a" + dataEntity + " \u4fee\u6539\u5b57\u6bb5:" + changeProp);
        if (entries == null || entries.size() == 0) {
            return Collections.emptyMap();
        }
        DynamicObject fristEntry = entries.values().iterator().next();
        String entryKey = fristEntry.getDataEntityType().getName();
        CalBillModelConfig config = BillMappingCache.getInstance().getModelConfig(dataEntity, entryKey);
        String changeModelProp = config.getModelFieldBySrcField(changeProp);
        if (changeModelProp == null) {
            throw new KDBizException(ModelLang.notConfigProp(changeProp));
        }
        List<ICalculateExpr> sortedExprs = CalculateExprLocalCache.getInstance().getBillCalExprs(new MappingBillEntryModel(config, dataEntity, fristEntry), changeModelProp);
        HashSet<String> fields = new HashSet<String>(16);
        for (ICalculateExpr iCalculateExpr : sortedExprs) {
            fields.add(iCalculateExpr.getTargetField());
        }
        EntryPrecInfo entryPrecInfo = new EntryPrecInfo(config, fields);
        for (Map.Entry<Long, DynamicObject> entry : entries.entrySet()) {
            entryPrecInfo.addPrecisionDataInfo(entry.getValue());
        }
        entryPrecInfo.loadPrecision();
        AlgorithmExecutor algorithmExecutor = new AlgorithmExecutor(sortedExprs);
        algorithmExecutor.setEntryPrecInfo(entryPrecInfo);
        HashMap<Long, Map<String, Object>> hashMap = new HashMap<Long, Map<String, Object>>(16);
        for (Map.Entry<Long, DynamicObject> entry : entries.entrySet()) {
            MappingBillEntryModel entryModel = new MappingBillEntryModel(config, dataEntity, entry.getValue());
            Map<String, Object> doCalculate = algorithmExecutor.doCalculate(entryModel);
            logger.info("\u91d1\u989d\u7b97\u6cd5\u8ba1\u7b97\u7ed3\u679cdoCalculate\uff1a" + doCalculate);
            LinkedHashMap<String, Object> convertMap = new LinkedHashMap<String, Object>(16);
            for (Map.Entry<String, Object> calculateEntry : doCalculate.entrySet()) {
                convertMap.put(config.getFieldInfoByModelKey(calculateEntry.getKey()).getFieldKey(), calculateEntry.getValue());
            }
            hashMap.put(entry.getKey(), convertMap);
            logger.info("\u91d1\u989d\u7b97\u6cd5\u8ba1\u7b97\u7ed3\u679cconvertMap\uff1a" + convertMap);
        }
        logger.info("\u91d1\u989d\u7b97\u6cd5\u8ba1\u7b97\u7ed3\u679cresult\uff1a" + hashMap);
        return hashMap;
    }
}

