/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalculateExpr;

public class CalculateExprHelper {
    public static List<ICalculateExpr> removeTargetCalExpr(Collection<ICalculateExpr> expressions, String changedProp) {
        ArrayList<ICalculateExpr> noLoopList = new ArrayList<ICalculateExpr>(16);
        for (ICalculateExpr expr : expressions) {
            if (expr.getTargetField().equals(changedProp)) continue;
            noLoopList.add(expr);
        }
        return noLoopList;
    }

    public static List<ICalculateExpr> topologicalSort(Collection<ICalculateExpr> expressions) {
        ArrayList<ICalculateExpr> sortedList = new ArrayList<ICalculateExpr>(expressions.size());
        HashSet<String> unknowPort = new HashSet<String>(16);
        ArrayList<ICalculateExpr> waitForSortList = new ArrayList<ICalculateExpr>(expressions);
        for (ICalculateExpr exprs : waitForSortList) {
            unknowPort.add(exprs.getTargetField());
        }
        while (!waitForSortList.isEmpty()) {
            boolean isHasRemoved = false;
            Iterator iterator = waitForSortList.iterator();
            while (iterator.hasNext()) {
                ICalculateExpr calExpr = (ICalculateExpr)iterator.next();
                boolean hasContain = CalculateExprHelper.isIntersect(unknowPort, calExpr.getCalFactors());
                if (hasContain) continue;
                unknowPort.remove(calExpr.getTargetField());
                sortedList.add(calExpr);
                iterator.remove();
                isHasRemoved = true;
            }
            if (isHasRemoved) continue;
            break;
        }
        return sortedList;
    }

    public static List<ICalculateExpr> reachedSort(Collection<ICalculateExpr> expressions, String changedProp) {
        HashSet<String> changedProps = new HashSet<String>(16);
        changedProps.add(changedProp);
        ArrayList<ICalculateExpr> waitForSortList = new ArrayList<ICalculateExpr>(expressions);
        ArrayList<ICalculateExpr> sortedList = new ArrayList<ICalculateExpr>(expressions.size());
        while (!waitForSortList.isEmpty()) {
            boolean isHasRemoved = false;
            Iterator iterator = waitForSortList.iterator();
            while (iterator.hasNext()) {
                ICalculateExpr curExpr = (ICalculateExpr)iterator.next();
                if (changedProps.contains(curExpr.getTargetField())) {
                    iterator.remove();
                    isHasRemoved = true;
                    continue;
                }
                if (!CalculateExprHelper.isIntersect(changedProps, curExpr.getCalFactors())) continue;
                changedProps.add(curExpr.getTargetField());
                sortedList.add(curExpr);
                iterator.remove();
                isHasRemoved = true;
            }
            if (isHasRemoved) continue;
            break;
        }
        return sortedList;
    }

    private static boolean isIntersect(Set<String> curExpt, Collection<String> imports) {
        for (String improt : imports) {
            if (!curExpt.contains(improt)) continue;
            return true;
        }
        return false;
    }
}

