/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.business.mapper;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.algorithm.business.mapper.AbstractMapper;
import kd.mpscmm.msbd.algorithm.business.mapper.MaterialUnitEntity;
import kd.mpscmm.msbd.algorithm.business.utils.CommonUtils;

public class MaterialUnitConvertMapper
extends AbstractMapper<Long, MaterialUnitEntity> {
    @Override
    protected List<MaterialUnitEntity> handle(Collection<Long> objects) {
        Map materialUnits = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (QFilter[])new QFilter("materialid", "in", objects).toArray());
        if (CommonUtils.mapIsEmpty(materialUnits)) {
            return null;
        }
        Map materialInfo = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (QFilter[])new QFilter("id", "in", objects).toArray());
        for (DynamicObject materialUnit : materialUnits.values()) {
            long materialId = CommonUtils.getPkValue(materialUnit.getDynamicObject("materialid"));
            MaterialUnitEntity materialUnitEntity = (MaterialUnitEntity)this.map.get(materialId);
            if (materialUnitEntity == null) {
                DynamicObject materialObj = (DynamicObject)materialInfo.get(materialId);
                long baseUnitId = CommonUtils.getPkValue(materialObj.getDynamicObject("baseunit"));
                materialUnitEntity = new MaterialUnitEntity(materialId, baseUnitId);
                this.map.put(materialId, materialUnitEntity);
            }
            materialUnitEntity.addMaterialUnitInfo(materialUnit);
        }
        return null;
    }

    public BigDecimal getUnitConvert(long materialid, BigDecimal srcQty, long sourceUnit, long targetUnitId) {
        MaterialUnitEntity materialUnitEntity = (MaterialUnitEntity)this.get(materialid);
        if (materialUnitEntity != null) {
            return materialUnitEntity.getConvertQty(srcQty, sourceUnit, targetUnitId);
        }
        return srcQty;
    }
}

