/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.business.mapper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;

public class MaterialUnitEntity {
    private long materialId = 0L;
    private long baseUnit = 0L;
    private Map<Long, DynamicObject> unitConvertMap = new HashMap<Long, DynamicObject>(16);

    public MaterialUnitEntity(long materialId, long baseUnit) {
        this.materialId = materialId;
        this.baseUnit = baseUnit;
    }

    public long getMaterialId() {
        return this.materialId;
    }

    public void addMaterialUnitInfo(DynamicObject materialUnitObj) {
        DynamicObject unit = materialUnitObj.getDynamicObject("measureunitid");
        this.unitConvertMap.put(unit.getLong("id"), materialUnitObj);
    }

    public BigDecimal getConvertQty(BigDecimal sourceQty, long sourceUnit, long targetUnitId) {
        BigDecimal srcNumerator = null;
        BigDecimal srcDenominator = null;
        if (this.baseUnit == sourceUnit) {
            srcNumerator = BigDecimal.ONE;
            srcDenominator = BigDecimal.ONE;
        } else {
            DynamicObject tgtUnitObj = this.unitConvertMap.get(sourceUnit);
            if (tgtUnitObj != null) {
                srcNumerator = tgtUnitObj.getBigDecimal("numerator");
                srcDenominator = tgtUnitObj.getBigDecimal("denominator");
            } else {
                return sourceQty;
            }
        }
        BigDecimal tgtNumerator = null;
        BigDecimal tgtDenominator = null;
        if (this.baseUnit == targetUnitId) {
            tgtNumerator = BigDecimal.ONE;
            tgtDenominator = BigDecimal.ONE;
        } else {
            DynamicObject tgtUnitObj = this.unitConvertMap.get(targetUnitId);
            if (tgtUnitObj != null) {
                tgtNumerator = tgtUnitObj.getBigDecimal("numerator");
                tgtDenominator = tgtUnitObj.getBigDecimal("denominator");
            } else {
                return null;
            }
        }
        BigDecimal ratio = tgtDenominator.multiply(srcNumerator).divide(tgtNumerator.multiply(srcDenominator), 10, RoundingMode.HALF_UP);
        return sourceQty.multiply(ratio);
    }
}

