/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.business.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.algorithm.business.utils.CommonUtils;
import kd.mpscmm.msbd.algorithm.common.utils.DynamicObjectUtils;

public class PrecisionMapper {
    private static final int unitPrecision = 2;
    private static final int amountPrecision = 2;
    private static final int pricePrecision = 10;
    public static final String TYPE_AMOUNT = "amount";
    public static final String TYPE_PRICE = "price";
    public static final String TYPE_QTY = "qty";
    private Map<String, Map<Long, Integer>> precisionMappers = new HashMap<String, Map<Long, Integer>>(3);

    public Integer get(String type, Long objId) {
        Integer precision;
        if (objId == null) {
            return null;
        }
        Map<Long, Integer> precisionMap = CommonUtils.mapGetMapValue(this.precisionMappers, type);
        if (!precisionMap.containsKey(objId)) {
            this.handleData(type, Collections.singleton(objId));
        }
        if ((precision = precisionMap.get(objId)) == null) {
            switch (type) {
                case "price": {
                    return 2;
                }
                case "amount": {
                    return 2;
                }
                case "qty": {
                    return 10;
                }
            }
        }
        return precision;
    }

    public void load(String type, Collection<DynamicObject> objects) {
        String precisionField = null;
        switch (type) {
            case "price": {
                precisionField = "priceprecision";
                break;
            }
            case "amount": {
                precisionField = "amtprecision";
                break;
            }
            case "qty": {
                precisionField = "precision";
                break;
            }
            default: {
                return;
            }
        }
        Map<Long, Integer> precisionMap = CommonUtils.mapGetMapValue(this.precisionMappers, type);
        HashSet<Long> needQueryUnitId = new HashSet<Long>(16);
        for (DynamicObject object : objects) {
            long objId = object.getLong("id");
            if (precisionMap.containsKey(objId)) continue;
            IDataEntityProperty precisionProp = DynamicObjectUtils.getProp(object, precisionField);
            if (precisionProp == null) {
                needQueryUnitId.add(objId);
                continue;
            }
            precisionMap.put(objId, (Integer)precisionProp.getValueFast((Object)object));
        }
        if (!needQueryUnitId.isEmpty()) {
            this.handleData(type, needQueryUnitId);
        }
    }

    private void handleData(String type, Set<Long> needQueryUnitId) {
        block5: {
            block4: {
                if (!TYPE_AMOUNT.equals(type) && !TYPE_PRICE.equals(type)) break block4;
                Map<Long, Integer> pricePrecisionMap = CommonUtils.mapGetMapValue(this.precisionMappers, TYPE_PRICE);
                Map<Long, Integer> amtPrecisionMap = CommonUtils.mapGetMapValue(this.precisionMappers, TYPE_AMOUNT);
                Map currencys = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"priceprecision,amtprecision", (QFilter[])new QFilter("id", "in", needQueryUnitId).toArray());
                for (Long currencyId : needQueryUnitId) {
                    DynamicObject currency = (DynamicObject)currencys.get(currencyId);
                    if (currency != null) {
                        pricePrecisionMap.put(currencyId, currency.getInt("priceprecision"));
                        amtPrecisionMap.put(currencyId, currency.getInt("amtprecision"));
                        continue;
                    }
                    pricePrecisionMap.put(currencyId, null);
                    amtPrecisionMap.put(currencyId, null);
                }
                break block5;
            }
            if (!TYPE_QTY.equals(type)) break block5;
            Map<Long, Integer> qtyPrecisionMap = CommonUtils.mapGetMapValue(this.precisionMappers, type);
            Map units = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"precision", (QFilter[])new QFilter("id", "in", needQueryUnitId).toArray());
            for (Long unitId : needQueryUnitId) {
                DynamicObject unit = (DynamicObject)units.get(unitId);
                if (unit != null) {
                    qtyPrecisionMap.put(unitId, unit.getInt("precision"));
                    continue;
                }
                qtyPrecisionMap.put(unitId, null);
            }
        }
    }
}

