/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.business.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;

public class CommonUtils {
    private CommonUtils() {
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static Long[] getIds(Collection<DynamicObject> bills) {
        int i = 0;
        Long[] ids = new Long[bills.size()];
        for (DynamicObject bill : bills) {
            ids[i] = bill.getLong("id");
        }
        return ids;
    }

    public static List<Long> getIdList(DynamicObjectCollection colls) {
        ArrayList<Long> idList = new ArrayList<Long>(colls.size());
        for (DynamicObject obj : colls) {
            idList.add(obj.getLong("id"));
        }
        return idList;
    }

    public static Set<String> getNumberList(DynamicObjectCollection colls) {
        HashSet<String> numberList = new HashSet<String>(colls.size());
        for (DynamicObject obj : colls) {
            numberList.add(obj.getString("id"));
        }
        return numberList;
    }

    public static boolean collectionIsEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean mapIsEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean mapIsNotEmpty(Map<?, ?> map) {
        return !CommonUtils.mapIsEmpty(map);
    }

    public static boolean collectionIsNotEmpty(Collection<?> collection) {
        return !CommonUtils.collectionIsEmpty(collection);
    }

    public static boolean arrayIsEmpty(Object[] collection) {
        return collection == null || collection.length == 0;
    }

    public static boolean arrayIsNotEmpty(Object[] collection) {
        return !CommonUtils.arrayIsEmpty(collection);
    }

    public static <T> List<T> arrayToList(T[] array) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T t : array) {
            list.add(t);
        }
        return list;
    }

    public static boolean idIsNull(Long id) {
        return id == null || id.compareTo(0L) == 0;
    }

    public static boolean idIsNotNull(Long id) {
        return !CommonUtils.idIsNull(id);
    }

    public static boolean objectIsNull(Object object) {
        return object == null;
    }

    public static <T, A> List<T> mapGetListValue(Map<A, List<T>> map, A key) {
        List<T> value = map.get(key);
        if (value == null) {
            value = new ArrayList<T>(16);
            map.put(key, value);
        }
        return value;
    }

    public static <A, K, V> Map<K, V> mapGetMapValue(Map<A, Map<K, V>> map, A key) {
        Map<K, V> value = map.get(key);
        if (value == null) {
            value = new HashMap(16);
            map.put(key, value);
        }
        return value;
    }

    public static <A, K, V> Map<K, V> mapGetLinkedMapValue(Map<A, Map<K, V>> map, A key) {
        Map<K, V> value = map.get(key);
        if (value == null) {
            value = new LinkedHashMap(16);
            map.put(key, value);
        }
        return value;
    }

    public static <K, V> Set<V> mapGetSetValue(Map<K, Set<V>> map, K key) {
        Set<V> value = map.get(key);
        if (value == null) {
            value = new HashSet<V>(16);
            map.put(key, value);
        }
        return value;
    }

    public static String transToStr(String[] fields) {
        return CommonUtils.transToStr(Arrays.asList(fields));
    }

    public static String transToStr(Collection<String> fields) {
        return CommonUtils.transToStr(fields, String.valueOf(","));
    }

    public static String transToStr(Collection<String> fields, String splitStr) {
        StringBuilder strs = new StringBuilder();
        boolean isFrist = true;
        for (String field : fields) {
            if (!isFrist) {
                strs.append(splitStr);
            }
            strs.append(field);
            isFrist = false;
        }
        return strs.toString();
    }

    public static String cutStr(String message, int size) {
        if (message != null && message.length() >= size) {
            message = message.substring(0, size - 4) + "...";
        }
        return message;
    }

    public static Long getPkValue(DynamicObject obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getLong("id");
    }

    public static Long getMaterialMasterObjectId(DynamicObject valObj) {
        String materialEntity;
        switch (materialEntity = valObj.getDataEntityType().getName()) {
            case "bd_materialinventoryinfo": 
            case "bd_materialpurchaseinfo": 
            case "bd_materialsalinfo": 
            case "bd_materialmftinfo": 
            case "bd_inspect_cfg": {
                return CommonUtils.getPkValue(valObj.getDynamicObject("masterid"));
            }
        }
        return CommonUtils.getPkValue(valObj);
    }
}

