/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.form;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public abstract class AbstractMSBDFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String NULL_VALUE_CODE = "NULL-0001";

    public void setComboValues(String key, Map<String, LocaleString> comboValues) {
        this.getModel().setValue(key, null);
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(16);
        for (Map.Entry<String, LocaleString> entry : comboValues.entrySet()) {
            String billNum = entry.getKey();
            ComboItem item = new ComboItem();
            item.setCaption(entry.getValue());
            item.setId(billNum);
            item.setValue(billNum);
            itemList.add(item);
        }
        ((ComboEdit)this.getControl(key)).setComboItems(itemList);
    }

    public void addF7Listener(String ... f7Name) {
        this.addF7Listener(this, f7Name);
    }

    public void addF7Listener(BeforeF7SelectListener listener, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(listener);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        try {
            QFilter filter = this.buildF7SelectFilter(event.getProperty().getName(), event);
            if (filter != null) {
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
            }
        }
        catch (KDBizException e) {
            event.setCancel(true);
            ErrorCode errorCode = e.getErrorCode();
            if (NULL_VALUE_CODE.equals(errorCode.getCode())) {
                if (!event.getSourceMethod().equals("setItemByNumber")) {
                    this.getView().showErrorNotification(errorCode.getMessage());
                }
            }
            throw e;
        }
    }

    protected QFilter buildF7SelectFilter(String key, BeforeF7SelectEvent event) {
        return null;
    }

    protected Object getValue(String key) {
        Object value = this.getModel().getValue(key);
        if (value == null) {
            this.keyNoValue(key);
        }
        return value;
    }

    protected String getStrValue(String key) {
        String value = (String)this.getModel().getValue(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.keyNoValue(key);
        }
        return value;
    }

    protected Object getValue(String key, int index) {
        Object value = this.getModel().getValue(key, index);
        if (value == null) {
            this.entryKetNoValue(key, index);
        }
        return value;
    }

    protected String getStrValue(String key, int index) {
        String value = (String)this.getModel().getValue(key, index);
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.entryKetNoValue(key, index);
        }
        return value;
    }

    private void entryKetNoValue(String key, int index) {
        MainEntityType entityType = this.getModel().getDataEntityType();
        IDataEntityProperty findProperty = entityType.findProperty(key);
        throw new KDBizException(new ErrorCode(NULL_VALUE_CODE, AbstractMSBDFormPlugin.PlsSelectIndex(findProperty.getDisplayName().getLocaleValue(), index)), new Object[0]);
    }

    private void keyNoValue(String key) {
        MainEntityType entityType = this.getModel().getDataEntityType();
        IDataEntityProperty findProperty = entityType.findProperty(key);
        throw new KDBizException(new ErrorCode(NULL_VALUE_CODE, AbstractMSBDFormPlugin.plsSelect(findProperty.getDisplayName().getLocaleValue())), new Object[0]);
    }

    public static String plsSelect(String fieldName) {
        return String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%1$s\u201d\u3002", (String)"PlsSelect", (String)"mpscmm-msbd-algorithm", (Object[])new Object[0]), fieldName);
    }

    public static String PlsSelectIndex(String fieldName, int i) {
        return String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b2c%1$s\u884c\u7684\u201c%2$s\u201d\u3002", (String)"PlsSelectIndex", (String)"mpscmm-msbd-algorithm", (Object[])new Object[0]), i + 1, fieldName);
    }
}

