/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.mpscmm.msbd.algorithm.common.entity.EntryPrecInfo;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalBillModel;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalculateExpr;

public class AlgorithmExecutor {
    private List<ICalculateExpr> calExprs = Collections.emptyList();
    private EntryPrecInfo entryPrecInfo;

    public AlgorithmExecutor(List<ICalculateExpr> calExprs) {
        if (calExprs != null) {
            this.calExprs = calExprs;
        }
    }

    public Map<String, Object> doCalculate(ICalBillModel billModel) {
        List<ICalculateExpr> sortedCalExprs = this.getCalExprs();
        Map<String, Object> calculatedValueMap = this.calculateValue(billModel, sortedCalExprs);
        return calculatedValueMap;
    }

    private List<ICalculateExpr> getCalExprs() {
        return this.calExprs;
    }

    private Map<String, Object> calculateValue(ICalBillModel billModel, List<ICalculateExpr> sortedCalExprs) {
        LinkedHashMap<String, Object> calculatedValueMap = new LinkedHashMap<String, Object>(16);
        for (ICalculateExpr expr : sortedCalExprs) {
            HashSet<String> fields = new HashSet<String>(expr.getCalFactors());
            String targetField = expr.getTargetField();
            fields.add(targetField);
            Map<String, Object> valueMap = this.getValueMap(billModel, calculatedValueMap, fields);
            Object calculateValue = expr.calculate(valueMap);
            if (calculateValue == null) continue;
            if (this.entryPrecInfo != null) {
                calculateValue = this.entryPrecInfo.handleResultPrecision(billModel, targetField, calculateValue);
            }
            calculatedValueMap.put(targetField, calculateValue);
        }
        return calculatedValueMap;
    }

    private Map<String, Object> getValueMap(ICalBillModel model, Map<String, Object> calculatedValueMap, Collection<String> fieldKey) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
        for (String key : fieldKey) {
            Object calculatedValue = calculatedValueMap.get(key);
            if (calculatedValue != null) {
                valueMap.put(key, calculatedValue);
                continue;
            }
            valueMap.put(key, model.getValue(key));
        }
        return valueMap;
    }

    public void setEntryPrecInfo(EntryPrecInfo entryPrecInfo) {
        this.entryPrecInfo = entryPrecInfo;
    }
}

