/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.model.expr.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.mpscmm.msbd.algorithm.model.expr.impl.AbstractCalculateExpr;

public class ExrateConvertCalculateExpr
extends AbstractCalculateExpr {
    private String srcAmtField = null;
    private String exrateField = null;
    private String quotationField = null;

    public ExrateConvertCalculateExpr(String tgtAmtField, String srcAmtField) {
        this(tgtAmtField, srcAmtField, "exrate", "quotation");
    }

    public ExrateConvertCalculateExpr(String tgtAmtField, String srcAmtField, String exrateField, String quotationField) {
        super(tgtAmtField);
        this.srcAmtField = srcAmtField;
        this.exrateField = exrateField;
        this.quotationField = quotationField;
    }

    public Set<String> getCalFactors() {
        HashSet<String> factors = new HashSet<String>();
        factors.add(this.srcAmtField);
        factors.add(this.exrateField);
        factors.add(this.quotationField);
        return factors;
    }

    public Object calculate(Map<String, Object> billInfo) {
        Object quotation = billInfo.get(this.quotationField);
        BigDecimal exrate = (BigDecimal)billInfo.get(this.exrateField);
        BigDecimal srcAmt = (BigDecimal)billInfo.get(this.srcAmtField);
        if (exrate == null || srcAmt == null) {
            return null;
        }
        if ("1".equals(quotation)) {
            return srcAmt.divide(exrate, 10, RoundingMode.HALF_UP);
        }
        return srcAmt.multiply(exrate);
    }

    public String toString() {
        return String.format("%1s -> %2s", this.srcAmtField, this.getTargetField());
    }
}

