/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.model.expr.impl;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.AbstractCalculateExpr;

public final class FormulaCalculateExpr
extends AbstractCalculateExpr {
    private final String expressionStr;
    private BOSExpression expression;

    public static FormulaCalculateExpr create(String targetField, String expression) {
        FormulaCalculateExpr calExpr = new FormulaCalculateExpr(targetField, expression);
        String errMessage = calExpr.expression.getErrMessage();
        if (StringUtils.isNotEmpty((CharSequence)errMessage)) {
            throw new KDBizException(errMessage);
        }
        return calExpr;
    }

    protected FormulaCalculateExpr(String targetField, String expression) {
        super(targetField);
        this.expressionStr = expression;
        this.expression = new BOSExpression(this.expressionStr);
    }

    public Set<String> getCalFactors() {
        return this.expression.getVars();
    }

    public Object calculate(Map<String, Object> billInfo) {
        Object calculateResult = null;
        try {
            calculateResult = FormulaEngine.execExcelFormula((Expr)this.expression.getExpr(), billInfo);
        }
        catch (ArithmeticException e) {
            return BigDecimal.ZERO;
        }
        if (calculateResult instanceof Integer) {
            calculateResult = BigDecimal.valueOf(((Integer)calculateResult).intValue());
        }
        return calculateResult;
    }

    public String toString() {
        return String.format("%s = %s", this.getTargetField(), this.expressionStr);
    }
}

