/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.model.expr.impl;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mpscmm.msbd.algorithm.business.mapper.MaterialUnitConvertMapper;
import kd.mpscmm.msbd.algorithm.business.utils.CommonUtils;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalculateExpr;

public class UnitConvertCalculateExpr
implements ICalculateExpr {
    private String srcQtyField;
    private String srcUnitField;
    private String tgtQtyField;
    private String tgtUnitField;
    private MaterialUnitConvertMapper unitConvMapper;

    public UnitConvertCalculateExpr(String tgtUnitField, String tgtQtyField, String srcUnitField, String srcQtyField) {
        this.tgtQtyField = tgtQtyField;
        this.tgtUnitField = tgtUnitField;
        this.srcQtyField = srcQtyField;
        this.srcUnitField = srcUnitField;
    }

    public Set<String> getCalFactors() {
        HashSet<String> factors = new HashSet<String>();
        factors.add("material");
        factors.add(this.srcQtyField);
        factors.add(this.srcUnitField);
        factors.add(this.tgtUnitField);
        return factors;
    }

    public String getTargetField() {
        return this.tgtQtyField;
    }

    public Object calculate(Map<String, Object> billInfo) {
        BigDecimal srcValue = (BigDecimal)billInfo.get(this.srcQtyField);
        DynamicObject mat = (DynamicObject)billInfo.get("material");
        DynamicObject srcUnit = (DynamicObject)billInfo.get(this.srcUnitField);
        DynamicObject tgtUnit = (DynamicObject)billInfo.get(this.tgtUnitField);
        if (srcValue != null && mat != null && srcUnit != null && tgtUnit != null) {
            return this.getUnitConvMapper().getUnitConvert(CommonUtils.getMaterialMasterObjectId(mat), srcValue, CommonUtils.getPkValue(srcUnit), CommonUtils.getPkValue(tgtUnit));
        }
        return null;
    }

    public MaterialUnitConvertMapper getUnitConvMapper() {
        if (this.unitConvMapper == null) {
            this.unitConvMapper = new MaterialUnitConvertMapper();
        }
        return this.unitConvMapper;
    }

    public String toString() {
        return String.format("%1s -> %2s", this.srcQtyField, this.tgtQtyField);
    }
}

