/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.model.expr.impl.purin;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.formula.FormulaEngine;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalculateExpr;

public class AmountAndTaxExpr
implements ICalculateExpr {
    private static final String DISCOUNT_TYPE = "A";
    private static final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100.0);

    public Set<String> getCalFactors() {
        HashSet<String> factors = new HashSet<String>();
        factors.add("qty");
        factors.add("priceandtax");
        factors.add("discountamount");
        factors.add("discounttype");
        factors.add("discountrate");
        factors.add("settlecurrency.amtprecision");
        return factors;
    }

    public String getTargetField() {
        return "amountandtax";
    }

    public Object calculate(Map<String, Object> billInfo) {
        Integer amtPrecision;
        BigDecimal priceAndTax;
        BigDecimal qty;
        BigDecimal discountAmount;
        BigDecimal value = BigDecimal.ZERO;
        String discountType = (String)billInfo.get("discounttype");
        BigDecimal discountRate = (BigDecimal)billInfo.getOrDefault("discountrate", BigDecimal.ZERO);
        if (discountRate == null) {
            discountRate = BigDecimal.ZERO;
        }
        if ((discountAmount = (BigDecimal)billInfo.getOrDefault("discountamount", BigDecimal.ZERO)) == null) {
            discountAmount = BigDecimal.ZERO;
        }
        if ((qty = (BigDecimal)billInfo.getOrDefault("qty", BigDecimal.ZERO)) == null) {
            qty = BigDecimal.ZERO;
        }
        if ((priceAndTax = (BigDecimal)billInfo.getOrDefault("priceandtax", BigDecimal.ZERO)) == null) {
            priceAndTax = BigDecimal.ZERO;
        }
        if ((amtPrecision = (Integer)billInfo.getOrDefault("settlecurrency.amtprecision", 2)) == null) {
            amtPrecision = 2;
        }
        value = DISCOUNT_TYPE.equals(discountType) && ONE_HUNDRED.compareTo(discountRate) == 0 ? qty.multiply(priceAndTax).setScale((int)amtPrecision, 4).subtract(discountAmount) : (BigDecimal)FormulaEngine.execExcelFormula((String)"priceandtax * qty - discountamount", billInfo);
        return value;
    }
}

