/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algorithm.model.expr.provider;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.mpscmm.msbd.algorithm.model.expr.impl.DiscountTypeConditionExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.ExrateConvertCalculateExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.FormulaCalculateExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.purin.DeductibleRateExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.purin.InterCostAmountExpr;
import kd.mpscmm.msbd.algorithm.model.expr.impl.purin.NoTaxDeductibleAmountExpr;
import kd.mpscmm.msbd.algorithm.model.expr.provider.AbstractModelExprProvider;
import kd.sdk.mpscmm.msbd.algorithm.entity.ICalculateExpr;

public final class NoTaxModelBillExprProvider
extends AbstractModelExprProvider {
    public List<ICalculateExpr> provide(String billentity, String changedProp) {
        ArrayList<ICalculateExpr> cals = new ArrayList<ICalculateExpr>(16);
        cals.add(FormulaCalculateExpr.create("priceandtax", "price * (1 + taxrate / 100)"));
        DiscountTypeConditionExpr amountExpr = new DiscountTypeConditionExpr("amount");
        amountExpr.setRateExpr("qty * price * (1 - discountrate / 100)");
        amountExpr.setAmountExpr("qty * (price - discountrate)");
        amountExpr.setDefaultExpr("qty * price");
        cals.add(amountExpr);
        cals.add(FormulaCalculateExpr.create("amountandtax", "amount + taxamount"));
        DiscountTypeConditionExpr discoutAmtExpr = new DiscountTypeConditionExpr("discountamount");
        discoutAmtExpr.setRateExpr("priceandtax * qty * (discountrate/100)");
        discoutAmtExpr.setAmountExpr("discountrate * qty * (1 + taxrate/100)");
        discoutAmtExpr.setDefaultValue(BigDecimal.ZERO);
        cals.add(discoutAmtExpr);
        cals.add(FormulaCalculateExpr.create("taxamount", "amount * taxrate/100"));
        cals.add(FormulaCalculateExpr.create("baseamountandtax", "baseamount + basetaxamount"));
        cals.add(new ExrateConvertCalculateExpr("basetaxamount", "taxamount"));
        cals.add(new ExrateConvertCalculateExpr("baseamount", "amount"));
        if ("amount".equals(changedProp)) {
            DiscountTypeConditionExpr priceExpr = new DiscountTypeConditionExpr("price");
            priceExpr.setRateExpr("amount / qty / (1 - discountrate/100)");
            priceExpr.setAmountExpr("amount / qty + discountrate");
            priceExpr.setDefaultExpr("amount / qty");
            cals.add(priceExpr);
        } else if ("actualprice".equals(changedProp)) {
            DiscountTypeConditionExpr discountRateExpr = new DiscountTypeConditionExpr("price");
            discountRateExpr.setRateExpr("(price - actualprice) / price");
            discountRateExpr.setAmountExpr("price - actualprice");
            discountRateExpr.setDefaultValue(BigDecimal.ZERO);
            cals.add(discountRateExpr);
        } else if ("discountamount".equals(changedProp)) {
            DiscountTypeConditionExpr discountRateExpr = new DiscountTypeConditionExpr("price");
            discountRateExpr.setRateExpr("discountamount / (priceandtax * qty)");
            discountRateExpr.setAmountExpr("discountamount / (qty * taxrate / 100)");
            discountRateExpr.setDefaultValue(BigDecimal.ZERO);
            cals.add(discountRateExpr);
        }
        if ("im_purinbill".equals(billentity)) {
            cals.add(new DeductibleRateExpr());
            cals.add(new NoTaxDeductibleAmountExpr());
            cals.add(new InterCostAmountExpr());
        }
        cals.addAll(this.getCommonPreinBillAlgorithm(billentity, changedProp));
        return cals;
    }

    public String getKey() {
        return "notaxbill";
    }
}

