/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.mservice.opvalidate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.metadata.entity.validation.PreCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class DmfVSchemeServiceImpl {
    public Map<String, Object> validate(String entity, String operation) {
        HashMap<String, Object> validateResult = new HashMap<String, Object>();
        if (CommonUtils.isNull((Object)operation) || CommonUtils.isNull((Object)entity)) {
            return null;
        }
        DynamicObject[] dmfValidSchemes = this.getDmfValidScheme(entity, operation);
        if (CommonUtils.isNull((Object)dmfValidSchemes)) {
            return validateResult;
        }
        ArrayList<ConditionValidation> validations = new ArrayList<ConditionValidation>(16);
        ArrayList<Map<String, Object>> plugins = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject dmfValidScheme : dmfValidSchemes) {
            DynamicObjectCollection dmfValidSchemeEntries = dmfValidScheme.getDynamicObjectCollection("entry");
            for (DynamicObject dmfValidSchemeEntry : dmfValidSchemeEntries) {
                Boolean dmfUnitEnable = dmfValidSchemeEntry.getBoolean("dmfunitenable");
                DynamicObject dmfUnit = dmfValidSchemeEntry.getDynamicObject("dmfunit");
                if (!dmfUnitEnable.booleanValue() || dmfUnit == null) continue;
                String entityNumber = dmfUnit.getDynamicObject("entity").getString("id");
                MainEntityType billMainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
                dmfUnit = BusinessDataServiceHelper.loadSingleFromCache((Object)dmfUnit.getPkValue(), (String)dmfUnit.getDataEntityType().getName());
                validations.addAll(this.getValidCondition(dmfUnit, billMainEntityType));
                plugins.addAll(this.getPlugins(dmfUnit, billMainEntityType));
            }
        }
        validateResult.put("conditions", validations);
        validateResult.put("plugins", plugins);
        return validateResult;
    }

    private List<ConditionValidation> getValidCondition(DynamicObject dmfUnit, MainEntityType billMainEntityType) {
        String areaJSON = dmfUnit.getString("areajson_tag");
        if (CommonUtils.isNull((Object)areaJSON)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)areaJSON, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(billMainEntityType, filterCondition);
        String[] filterScripts = filterBuilder.buildFilterScript();
        DynamicObjectCollection validEntitys = dmfUnit.getDynamicObjectCollection("validentity");
        ArrayList<ConditionValidation> conditionValidationList = new ArrayList<ConditionValidation>();
        for (DynamicObject validEntity : validEntitys) {
            boolean validenable = validEntity.getBoolean("validenable");
            if (!validenable) continue;
            String validjson = validEntity.getString("validjson_tag");
            ConditionValidation conditionValidation = DmfVSchemeServiceImpl.getConditionValidation(validjson);
            if (filterScripts != null) {
                PreCondition preCondition = new PreCondition();
                preCondition.setId(System.currentTimeMillis() + "");
                preCondition.setRuleCondition(filterScripts[0]);
                preCondition.setRuleDescription(filterScripts[1]);
                conditionValidation.setPreCondition(preCondition);
            }
            conditionValidationList.add(conditionValidation);
        }
        return conditionValidationList;
    }

    private List<Map<String, Object>> getPlugins(DynamicObject dmfUnit, MainEntityType billMainEntityType) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        DynamicObjectCollection pluginEntryList = dmfUnit.getDynamicObjectCollection("pluginentry");
        if (CommonUtils.isNull((Object)pluginEntryList)) {
            return null;
        }
        String areaJSON = dmfUnit.getString("areajson_tag");
        if (CommonUtils.isNull((Object)areaJSON)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)areaJSON, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(billMainEntityType, filterCondition);
        String[] filterScripts = filterBuilder.buildFilterScript();
        for (DynamicObject pluginEntry : pluginEntryList) {
            boolean pluginenable = pluginEntry.getBoolean("pluginenable");
            String pluginClassUrl = pluginEntry.getString("pluginclassurl");
            if (!pluginenable || pluginClassUrl == null || "".equals(pluginClassUrl)) continue;
            String customparameter = pluginEntry.getString("customparameter");
            HashMap<String, String> plugin = new HashMap<String, String>();
            plugin.put("pluginclassurl", pluginClassUrl);
            plugin.put("precondition", filterScripts[0]);
            plugin.put("customparameter", customparameter);
            result.add(plugin);
        }
        return result;
    }

    private DynamicObject[] getDmfValidScheme(String entity, String operation) {
        QFilter qf3;
        QFilter qf2;
        DynamicObject entityobj = BusinessDataServiceHelper.loadSingleFromCache((Object)entity, (String)"bos_entityobject");
        String inheritPath = MetadataServiceHelper.getDataEntityType((String)entity).getInheritPath();
        inheritPath = inheritPath == null ? entityobj.getString("dentityid") : inheritPath + "," + entityobj.getString("dentityid");
        QFilter qf1 = new QFilter("entity.dentityid", "in", (Object)inheritPath.split(","));
        QFilter[] qfs = new QFilter[]{qf1, qf2 = new QFilter("enable", "=", (Object)Boolean.TRUE), qf3 = new QFilter("entityoperation", "like", (Object)("%," + operation + ",%"))};
        Map dmfValidSchemes = BusinessDataServiceHelper.loadFromCache((String)"msbd_dmfvscheme", (QFilter[])qfs);
        if (!CommonUtils.isNull((Object)dmfValidSchemes)) {
            ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
            for (String s : inheritPath.split(",")) {
                for (DynamicObject dmfValidScheme : dmfValidSchemes.values()) {
                    if (dmfValidScheme.getDynamicObject("entity") == null || !s.equalsIgnoreCase(dmfValidScheme.getDynamicObject("entity").getString("dentityid"))) continue;
                    result.add(dmfValidScheme);
                }
            }
            return result.toArray(new DynamicObject[dmfValidSchemes.size()]);
        }
        return null;
    }

    private static ConditionValidation getConditionValidation(String expressionEntity) {
        ArrayList<IDataEntityType> dTypes = new ArrayList<IDataEntityType>(16);
        dTypes.add(DataEntityType.getDataEntityType(ConditionValidation.class));
        ListDcxmlBinder binder = new ListDcxmlBinder(false, dTypes);
        Map parameter = (Map)SerializationUtils.fromJsonString((String)expressionEntity, Map.class);
        return (ConditionValidation)new DcJsonSerializer((DcBinder)binder).deserializeFromMap(parameter, null);
    }
}

